/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialSCMSource;
import hudson.plugins.mercurial.browser.HgBrowser;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.trait.SCMBuilder;

public class MercurialSCMBuilder<B extends MercurialSCMBuilder<B>>
extends SCMBuilder<B, MercurialSCM> {
    @CheckForNull
    private HgBrowser browser;
    private boolean clean;
    @CheckForNull
    private String credentialsId;
    @CheckForNull
    private String installation;
    @Nonnull
    private String source;

    public MercurialSCMBuilder(@Nonnull SCMHead head, @CheckForNull SCMRevision revision, @Nonnull String source, @CheckForNull String credentialsId) {
        super(MercurialSCM.class, head, revision);
        this.source = source;
        this.credentialsId = credentialsId;
    }

    public final HgBrowser browser() {
        return this.browser;
    }

    public final boolean clean() {
        return this.clean;
    }

    public final String credentialsId() {
        return this.credentialsId;
    }

    public final String installation() {
        return this.installation;
    }

    public final String source() {
        return this.source;
    }

    @Nonnull
    public B withBrowser(HgBrowser browser) {
        this.browser = browser;
        return (B)((Object)this);
    }

    @Nonnull
    public B withClean(boolean clean) {
        this.clean = clean;
        return (B)((Object)this);
    }

    @Nonnull
    public B withCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
        return (B)((Object)this);
    }

    @Nonnull
    public B withInstallation(String installation) {
        this.installation = installation;
        return (B)((Object)this);
    }

    @Nonnull
    public B withSource(String source) {
        this.source = source;
        return (B)((Object)this);
    }

    @Nonnull
    public MercurialSCM build() {
        SCMRevision revision = this.revision();
        MercurialSCM result = new MercurialSCM(this.source());
        if (revision instanceof MercurialSCMSource.MercurialRevision) {
            result.setRevisionType(MercurialSCM.RevisionType.CHANGESET);
            result.setRevision(((MercurialSCMSource.MercurialRevision)revision).getHash());
        } else {
            result.setRevisionType(MercurialSCM.RevisionType.BRANCH);
            result.setRevision(this.head().getName());
        }
        result.setBrowser(this.browser());
        result.setClean(this.clean());
        result.setCredentialsId(this.credentialsId());
        result.setInstallation(this.installation());
        result.setDisableChangeLog(false);
        return result;
    }
}

