/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.mercurial.MercurialCommitPayload;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialSCMSource;
import hudson.plugins.mercurial.MercurialStatus;
import hudson.scm.SCM;
import java.util.Collections;
import java.util.Map;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.apache.commons.io.FilenameUtils;

public class MercurialSCMHeadEvent
extends SCMHeadEvent<MercurialCommitPayload> {
    private final MercurialCommitPayload payload;

    @Deprecated
    public MercurialSCMHeadEvent(SCMEvent.Type type, MercurialCommitPayload payload) {
        super(type, (Object)payload);
        this.payload = payload;
    }

    public MercurialSCMHeadEvent(SCMEvent.Type type, MercurialCommitPayload payload, String origin) {
        super(type, (Object)payload, origin);
        this.payload = payload;
    }

    public boolean isMatch(@NonNull SCMNavigator navigator) {
        return false;
    }

    @NonNull
    public String getSourceName() {
        return FilenameUtils.getBaseName((String)this.payload.getUrl().getPath());
    }

    @NonNull
    public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
        MercurialSCMSource hg;
        String repository;
        if (source instanceof MercurialSCMSource && (repository = (hg = (MercurialSCMSource)source).getSource()) != null && MercurialStatus.looselyMatches(this.payload.getUrl(), repository)) {
            SCMHead head = new SCMHead(((MercurialCommitPayload)this.getPayload()).getBranch());
            MercurialSCMSource.MercurialRevision revision = new MercurialSCMSource.MercurialRevision(head, ((MercurialCommitPayload)this.getPayload()).getChangesetId());
            return Collections.singletonMap(head, revision);
        }
        return Collections.emptyMap();
    }

    public boolean isMatch(@NonNull SCM scm) {
        MercurialSCM hg;
        String repository;
        if (scm instanceof MercurialSCM && (repository = (hg = (MercurialSCM)scm).getSource()) != null && MercurialStatus.looselyMatches(this.payload.getUrl(), repository)) {
            return hg.getRevisionType() == MercurialSCM.RevisionType.BRANCH && this.payload.getBranch().equals(hg.getRevision());
        }
        return false;
    }
}

