/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.Extension;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BitBucket
extends HgBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public BitBucket(String url) throws MalformedURLException {
        super(url);
    }

    @Override
    public URL getChangeSetLink(MercurialChangeSet changeSet) throws IOException {
        this.current = changeSet;
        return new URL(this.getUrl(), "changeset/" + changeSet.getShortNode() + "/");
    }

    @Override
    public URL getFileLink(String path) throws MalformedURLException {
        this.checkCurrentIsNotNull();
        return new URL(this.getUrl(), "src/" + this.current.getShortNode() + "/" + path);
    }

    @Override
    public URL getDiffLink(String path) throws MalformedURLException {
        this.checkCurrentIsNotNull();
        return new URL(this.getUrl(), "changeset/" + this.current.getShortNode() + "/#chg-" + path);
    }

    @Extension
    public static class DescriptorImpl
    extends HgBrowser.HgBrowserDescriptor {
        public String getDisplayName() {
            return "bitbucket";
        }

        @Override
        public FormValidation doCheckUrl(@QueryParameter String url) {
            return this._doCheckUrl(url);
        }

        @Override
        protected FormValidation check(URL url) {
            if (url.toString().matches("https?://bitbucket[.]org/[^/]+/[^/]+/")) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)"Possibly incorrect root URL; expected http://bitbucket.org/USERNAME/REPOS/");
        }
    }
}

