/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.cli.CLIConnectionFactory;
import hudson.cli.CliEntryPoint;
import hudson.cli.CliPort;
import hudson.cli.Connection;
import hudson.cli.FullDuplexHttpStream;
import hudson.cli.PlainCLIProtocol;
import hudson.cli.PrivateKeyProvider;
import hudson.cli.client.Messages;
import hudson.remoting.Channel;
import hudson.remoting.NamingThreadFactory;
import hudson.remoting.PingThread;
import hudson.remoting.Pipe;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.SocketChannelStream;
import hudson.remoting.SocketOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.Signature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;

public class CLI
implements AutoCloseable {
    private final ExecutorService pool;
    private final Channel channel;
    private final CliEntryPoint entryPoint;
    private final boolean ownsPool;
    private final List<Closeable> closables = new ArrayList<Closeable>();
    private final String httpsProxyTunnel;
    private final String authorization;
    static final Logger LOGGER = Logger.getLogger(CLI.class.getName());

    @Deprecated
    public CLI(URL jenkins) throws IOException, InterruptedException {
        this(jenkins, null);
    }

    @Deprecated
    public CLI(URL jenkins, ExecutorService exec) throws IOException, InterruptedException {
        this(jenkins, exec, null);
    }

    @Deprecated
    public CLI(URL jenkins, ExecutorService exec, String httpsProxyTunnel) throws IOException, InterruptedException {
        this(new CLIConnectionFactory().url(jenkins).executorService(exec).httpsProxyTunnel(httpsProxyTunnel));
    }

    @Deprecated
    CLI(CLIConnectionFactory factory) throws IOException, InterruptedException {
        Channel _channel;
        URL jenkins = factory.jenkins;
        this.httpsProxyTunnel = factory.httpsProxyTunnel;
        this.authorization = factory.authorization;
        ExecutorService exec = factory.exec;
        this.ownsPool = exec == null;
        this.pool = exec != null ? exec : Executors.newCachedThreadPool(new NamingThreadFactory(Executors.defaultThreadFactory(), "CLI.pool"));
        try {
            _channel = this.connectViaCliPort(jenkins, this.getCliTcpPort(jenkins));
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to connect via CLI port. Falling back to HTTP", e);
            try {
                _channel = this.connectViaHttp(jenkins);
            }
            catch (IOException e2) {
                e.addSuppressed(e2);
                throw e;
            }
        }
        this.channel = _channel;
        this.entryPoint = (CliEntryPoint)_channel.waitForRemoteProperty(CliEntryPoint.class.getName());
        if (this.entryPoint.protocolVersion() != 1) {
            throw new IOException(Messages.CLI_VersionMismatch());
        }
    }

    @Deprecated
    private Channel connectViaHttp(URL url) throws IOException {
        LOGGER.log(Level.FINE, "Trying to connect to {0} via Remoting over HTTP", url);
        FullDuplexHttpStream con = new FullDuplexHttpStream(url, "cli?remoting=true", this.authorization);
        Channel ch = new Channel("Chunked connection to " + url, this.pool, con.getInputStream(), con.getOutputStream());
        long interval = 15000L;
        long timeout = 11250L;
        new PingThread(ch, 11250L, 15000L){

            @Override
            protected void onDead() {
            }
        }.start();
        return ch;
    }

    @Deprecated
    private Channel connectViaCliPort(URL jenkins, CliPort clip) throws IOException {
        OutputStream out;
        LOGGER.log(Level.FINE, "Trying to connect directly via Remoting over TCP/IP to {0}", clip.endpoint);
        if (this.authorization != null) {
            LOGGER.warning("-auth ignored when using JNLP agent port");
        }
        final Socket s = new Socket();
        s.setKeepAlive(true);
        s.setTcpNoDelay(true);
        if (this.httpsProxyTunnel != null) {
            String[] tokens = this.httpsProxyTunnel.split(":");
            LOGGER.log(Level.FINE, "Using HTTP proxy {0}:{1} to connect to CLI port", new Object[]{tokens[0], tokens[1]});
            s.connect(new InetSocketAddress(tokens[0], Integer.parseInt(tokens[1])));
            PrintStream o = new PrintStream(s.getOutputStream());
            o.print("CONNECT " + clip.endpoint.getHostString() + ":" + clip.endpoint.getPort() + " HTTP/1.0\r\n\r\n");
            ByteArrayOutputStream rsp = new ByteArrayOutputStream();
            while (!rsp.toString("ISO-8859-1").endsWith("\r\n\r\n")) {
                int ch = s.getInputStream().read();
                if (ch < 0) {
                    throw new IOException("Failed to read the HTTP proxy response: " + rsp);
                }
                rsp.write(ch);
            }
            String head = new BufferedReader(new StringReader(rsp.toString("ISO-8859-1"))).readLine();
            if (head == null) {
                throw new IOException("Unexpected empty response");
            }
            if (!head.startsWith("HTTP/1.0 200 ") && !head.startsWith("HTTP/1.1 200 ")) {
                s.close();
                LOGGER.log(Level.SEVERE, "Failed to tunnel the CLI port through the HTTP proxy. Falling back to HTTP.");
                throw new IOException("Failed to establish a connection through HTTP proxy: " + rsp);
            }
            out = new SocketOutputStream(s){

                @Override
                public void close() throws IOException {
                }
            };
        } else {
            s.connect(clip.endpoint, 3000);
            out = SocketChannelStream.out(s);
        }
        this.closables.add(new Closeable(){

            @Override
            public void close() throws IOException {
                s.close();
            }
        });
        Connection c = new Connection(SocketChannelStream.in(s), out);
        switch (clip.version) {
            case 1: {
                DataOutputStream dos = new DataOutputStream(s.getOutputStream());
                dos.writeUTF("Protocol:CLI-connect");
                break;
            }
            case 2: {
                DataInputStream dis = new DataInputStream(s.getInputStream());
                DataOutputStream dos = new DataOutputStream(s.getOutputStream());
                dos.writeUTF("Protocol:CLI2-connect");
                String greeting = dis.readUTF();
                if (!greeting.equals("Welcome")) {
                    throw new IOException("Handshaking failed: " + greeting);
                }
                try {
                    byte[] secret = c.diffieHellman(false).generateSecret();
                    SecretKeySpec sessionKey = new SecretKeySpec(Connection.fold(secret, 16), "AES");
                    c = c.encryptConnection(sessionKey, "AES/CFB8/NoPadding");
                    byte[] signature = c.readByteArray();
                    if (clip.identity != null) {
                        Signature verifier = Signature.getInstance("SHA1withRSA");
                        verifier.initVerify(clip.getIdentity());
                        verifier.update(secret);
                        if (!verifier.verify(signature)) {
                            throw new IOException("Server identity signature validation failed.");
                        }
                    }
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw (IOException)new IOException("Failed to negotiate transport security").initCause(e);
                }
            }
        }
        return new Channel("CLI connection to " + jenkins, this.pool, new BufferedInputStream(c.in), new BufferedOutputStream(c.out));
    }

    @Deprecated
    protected CliPort getCliTcpPort(URL url) throws IOException {
        String p1;
        if (url.getHost() == null || url.getHost().length() == 0) {
            throw new IOException("Invalid URL: " + url);
        }
        URLConnection head = url.openConnection();
        try {
            head.connect();
        }
        catch (IOException e) {
            throw (IOException)new IOException("Failed to connect to " + url).initCause(e);
        }
        String h = head.getHeaderField("X-Jenkins-CLI-Host");
        if (h == null) {
            h = head.getURL().getHost();
        }
        if ((p1 = head.getHeaderField("X-Jenkins-CLI-Port")) == null) {
            p1 = head.getHeaderField("X-Hudson-CLI-Port");
        }
        String p2 = head.getHeaderField("X-Jenkins-CLI2-Port");
        String identity = head.getHeaderField("X-Instance-Identity");
        this.flushURLConnection(head);
        if (p1 == null && p2 == null) {
            CLI.verifyJenkinsConnection(head);
            throw new IOException("No X-Jenkins-CLI2-Port among " + head.getHeaderFields().keySet());
        }
        if (p2 != null) {
            return new CliPort(new InetSocketAddress(h, Integer.parseInt(p2)), identity, 2);
        }
        return new CliPort(new InetSocketAddress(h, Integer.parseInt(p1)), identity, 1);
    }

    static void verifyJenkinsConnection(URLConnection c) throws IOException {
        if (c.getHeaderField("X-Hudson") == null && c.getHeaderField("X-Jenkins") == null) {
            throw new NotTalkingToJenkinsException(c);
        }
    }

    private void flushURLConnection(URLConnection conn) {
        byte[] buf = new byte[1024];
        try {
            InputStream is = conn.getInputStream();
            while (is.read(buf) >= 0) {
            }
            is.close();
        }
        catch (IOException e) {
            try {
                InputStream es = ((HttpURLConnection)conn).getErrorStream();
                if (es != null) {
                    while (es.read(buf) >= 0) {
                    }
                    es.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() throws IOException, InterruptedException {
        this.channel.close();
        this.channel.join();
        if (this.ownsPool) {
            this.pool.shutdown();
        }
        for (Closeable c : this.closables) {
            c.close();
        }
    }

    public int execute(List<String> args, InputStream stdin, OutputStream stdout, OutputStream stderr) {
        return this.entryPoint.main(args, Locale.getDefault(), new RemoteInputStream(stdin), new RemoteOutputStream(stdout), new RemoteOutputStream(stderr));
    }

    public int execute(List<String> args) {
        return this.execute(args, System.in, System.out, System.err);
    }

    public int execute(String ... args) {
        return this.execute(Arrays.asList(args));
    }

    public boolean hasCommand(String name) {
        return this.entryPoint.hasCommand(name);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void upgrade() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (this.execute(Arrays.asList("groovy", "="), new ByteArrayInputStream("hudson.remoting.Channel.current().setRestricted(false)".getBytes()), out, out) != 0) {
            throw new SecurityException(out.toString());
        }
    }

    public static void main(String[] _args) throws Exception {
        try {
            System.exit(CLI._main(_args));
        }
        catch (NotTalkingToJenkinsException ex) {
            System.err.println(ex.getMessage());
            System.exit(3);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * Exception decompiling
     */
    public static int _main(String[] _args) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int plainHttpConnection(String url, List<String> args, CLIConnectionFactory factory) throws IOException, InterruptedException {
        LOGGER.log(Level.FINE, "Trying to connect to {0} via plain protocol over HTTP", url);
        FullDuplexHttpStream streams = new FullDuplexHttpStream(new URL(url), "cli?remoting=false", factory.authorization);
        class ClientSideImpl
        extends PlainCLIProtocol.ClientSide {
            boolean complete;
            int exit = -1;

            ClientSideImpl(InputStream is, OutputStream os) throws IOException {
                super(is, os);
                if (is.read() != 0) {
                    throw new IOException("expected to see initial zero byte; perhaps you are connecting to an old server which does not support -http?");
                }
            }

            @Override
            protected void onExit(int code) {
                this.exit = code;
                this.finished();
            }

            @Override
            protected void onStdout(byte[] chunk) throws IOException {
                System.out.write(chunk);
            }

            @Override
            protected void onStderr(byte[] chunk) throws IOException {
                System.err.write(chunk);
            }

            @Override
            protected void handleClose() {
                this.finished();
            }

            private synchronized void finished() {
                this.complete = true;
                this.notifyAll();
            }
        }
        try (final ClientSideImpl connection = new ClientSideImpl(streams.getInputStream(), streams.getOutputStream());){
            for (String arg : args) {
                connection.sendArg(arg);
            }
            connection.sendEncoding(Charset.defaultCharset().name());
            connection.sendLocale(Locale.getDefault().toString());
            connection.sendStart();
            connection.begin();
            final OutputStream stdin = connection.streamStdin();
            new Thread("input reader"){
                {
                    super(x0);
                }

                @Override
                public void run() {
                    try {
                        int c;
                        while ((c = System.in.read()) != -1) {
                            stdin.write(c);
                        }
                        connection.sendEndStdin();
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }
            }.start();
            new Thread("ping"){
                {
                    super(x0);
                }

                @Override
                public void run() {
                    try {
                        Thread.sleep(10000L);
                        while (!connection.complete) {
                            LOGGER.fine("sending ping");
                            connection.sendEncoding(Charset.defaultCharset().name());
                            Thread.sleep(10000L);
                        }
                    }
                    catch (IOException | InterruptedException x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }
            }.start();
            ClientSideImpl clientSideImpl = connection;
            synchronized (clientSideImpl) {
                while (!connection.complete) {
                    connection.wait();
                }
            }
            int n = connection.exit;
            return n;
        }
    }

    private static String computeVersion() {
        Properties props;
        block5: {
            props = new Properties();
            try {
                InputStream is = CLI.class.getResourceAsStream("/jenkins/cli/jenkins-cli-version.properties");
                if (is == null) break block5;
                try {
                    props.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props.getProperty("version", "?");
    }

    public static KeyPair loadKey(File f, String passwd) throws IOException, GeneralSecurityException {
        return PrivateKeyProvider.loadKey(f, passwd);
    }

    public static KeyPair loadKey(File f) throws IOException, GeneralSecurityException {
        return CLI.loadKey(f, null);
    }

    public static KeyPair loadKey(String pemString, String passwd) throws IOException, GeneralSecurityException {
        return PrivateKeyProvider.loadKey(pemString, passwd);
    }

    public static KeyPair loadKey(String pemString) throws IOException, GeneralSecurityException {
        return CLI.loadKey(pemString, null);
    }

    @Deprecated
    public PublicKey authenticate(Iterable<KeyPair> privateKeys) throws IOException, GeneralSecurityException {
        Pipe c2s = Pipe.createLocalToRemote();
        Pipe s2c = Pipe.createRemoteToLocal();
        this.entryPoint.authenticate("ssh", c2s, s2c);
        try (Connection c = new Connection(s2c.getIn(), c2s.getOut());){
            byte[] sharedSecret = c.diffieHellman(false).generateSecret();
            PublicKey serverIdentity = c.verifyIdentity(sharedSecret);
            for (KeyPair key : privateKeys) {
                c.proveIdentity(sharedSecret, key);
                if (!c.readBoolean()) continue;
                PublicKey publicKey = serverIdentity;
                return publicKey;
            }
            if (privateKeys.iterator().hasNext()) {
                throw new GeneralSecurityException("Authentication failed. No private key accepted.");
            }
            throw new GeneralSecurityException("No private key is available for use in authentication");
        }
    }

    @Deprecated
    public PublicKey authenticate(KeyPair key) throws IOException, GeneralSecurityException {
        return this.authenticate(Collections.singleton(key));
    }

    static String usage() {
        return Messages.CLI_Usage();
    }

    private static void printUsage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.err.println(CLI.usage());
    }

    private static enum Mode {
        HTTP,
        SSH,
        REMOTING;

    }

    static final class NotTalkingToJenkinsException
    extends IOException {
        public NotTalkingToJenkinsException(String s) {
            super(s);
        }

        public NotTalkingToJenkinsException(URLConnection c) {
            super("There's no Jenkins running at " + c.getURL().toString());
        }
    }
}

