/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.nio.file.Path;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.sshd.client.config.keys.ClientIdentityFileWatcher;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.ClientIdentityProvider;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;

public class ClientIdentitiesWatcher
extends AbstractKeyPairProvider
implements KeyPairProvider {
    private final Collection<ClientIdentityProvider> providers;

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, ClientIdentityLoader loader, FilePasswordProvider provider) {
        this(paths, loader, provider, true);
    }

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        this(paths, GenericUtils.supplierOf(Objects.requireNonNull(loader, "No client identity loader")), GenericUtils.supplierOf(Objects.requireNonNull(provider, "No password provider")), strict);
    }

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, Supplier<ClientIdentityLoader> loader, Supplier<FilePasswordProvider> provider) {
        this(paths, loader, provider, true);
    }

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, Supplier<ClientIdentityLoader> loader, Supplier<FilePasswordProvider> provider, boolean strict) {
        this(ClientIdentitiesWatcher.buildProviders(paths, loader, provider, strict));
    }

    public ClientIdentitiesWatcher(Collection<ClientIdentityProvider> providers) {
        this.providers = providers;
    }

    @Override
    public Iterable<KeyPair> loadKeys() {
        return this.loadKeys(null);
    }

    protected Iterable<KeyPair> loadKeys(Predicate<? super KeyPair> filter) {
        return () -> {
            Stream<KeyPair> stream = this.safeMap(GenericUtils.stream(this.providers), this::doGetKeyPair);
            if (filter != null) {
                stream = stream.filter(filter);
            }
            return stream.iterator();
        };
    }

    protected <U, V> Stream<V> safeMap(Stream<U> stream, Function<? super U, ? extends V> mapper) {
        return stream.map(u -> Optional.ofNullable(mapper.apply((Object)u))).filter(Optional::isPresent).map(Optional::get);
    }

    protected KeyPair doGetKeyPair(ClientIdentityProvider p) {
        try {
            KeyPair kp = p.getClientIdentity();
            if (kp == null && this.log.isDebugEnabled()) {
                this.log.debug("loadKeys({}) no key loaded", (Object)p);
            }
            return kp;
        }
        catch (Throwable e) {
            this.log.warn("loadKeys({}) failed ({}) to load key: {}", p, e.getClass().getSimpleName(), e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("loadKeys(" + p + ") key load failure details", e);
            }
            return null;
        }
    }

    public static List<ClientIdentityProvider> buildProviders(Collection<? extends Path> paths, ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        return ClientIdentitiesWatcher.buildProviders(paths, GenericUtils.supplierOf(Objects.requireNonNull(loader, "No client identity loader")), GenericUtils.supplierOf(Objects.requireNonNull(provider, "No password provider")), strict);
    }

    public static List<ClientIdentityProvider> buildProviders(Collection<? extends Path> paths, Supplier<ClientIdentityLoader> loader, Supplier<FilePasswordProvider> provider, boolean strict) {
        if (GenericUtils.isEmpty(paths)) {
            return Collections.emptyList();
        }
        return GenericUtils.map(paths, p -> new ClientIdentityFileWatcher((Path)p, loader, provider, strict));
    }
}

