/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.scp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.scp.AbstractScpClient;
import org.apache.sshd.client.scp.DefaultScpStreamResolver;
import org.apache.sshd.client.scp.ScpClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.util.MockFileSystem;
import org.apache.sshd.common.file.util.MockPath;
import org.apache.sshd.common.scp.ScpFileOpener;
import org.apache.sshd.common.scp.ScpHelper;
import org.apache.sshd.common.scp.ScpLocation;
import org.apache.sshd.common.scp.ScpTimestamp;
import org.apache.sshd.common.scp.ScpTransferEventListener;
import org.apache.sshd.common.scp.helpers.DefaultScpFileOpener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.NoCloseInputStream;

public class DefaultScpClient
extends AbstractScpClient {
    public static final String SCP_PORT_OPTION = "-P";
    protected final ScpFileOpener opener;
    protected final ScpTransferEventListener listener;
    private final ClientSession clientSession;

    public DefaultScpClient(ClientSession clientSession, ScpFileOpener fileOpener, ScpTransferEventListener eventListener) {
        this.clientSession = Objects.requireNonNull(clientSession, "No client session");
        this.opener = fileOpener == null ? DefaultScpFileOpener.INSTANCE : fileOpener;
        this.listener = eventListener == null ? ScpTransferEventListener.EMPTY : eventListener;
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(String remote, OutputStream local) throws IOException {
        String cmd = ScpClient.createReceiveCommand(remote, Collections.emptyList());
        ClientSession session = this.getClientSession();
        ChannelExec channel = this.openCommandChannel(session, cmd);
        try (InputStream invOut = channel.getInvertedOut();
             OutputStream invIn = channel.getInvertedIn();){
            ScpHelper helper = new ScpHelper(session, invOut, invIn, new MockFileSystem(remote), this.opener, this.listener);
            helper.receiveFileStream(local, 8192);
            this.handleCommandExitStatus(cmd, channel);
        }
        finally {
            channel.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void download(String remote, FileSystem fs, Path local, Collection<ScpClient.Option> options) throws IOException {
        String cmd = ScpClient.createReceiveCommand(remote, options);
        ClientSession session = this.getClientSession();
        ChannelExec channel = this.openCommandChannel(session, cmd);
        try (InputStream invOut = channel.getInvertedOut();
             OutputStream invIn = channel.getInvertedIn();){
            ScpHelper helper = new ScpHelper(session, invOut, invIn, fs, this.opener, this.listener);
            helper.receive(local, options.contains((Object)ScpClient.Option.Recursive), options.contains((Object)ScpClient.Option.TargetIsDirectory), options.contains((Object)ScpClient.Option.PreserveAttributes), 8192);
            this.handleCommandExitStatus(cmd, channel);
        }
        finally {
            channel.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(InputStream local, String remote, long size, Collection<PosixFilePermission> perms, ScpTimestamp time) throws IOException {
        int namePos = ValidateUtils.checkNotNullAndNotEmpty(remote, "No remote location specified").lastIndexOf(47);
        String name = namePos < 0 ? remote : ValidateUtils.checkNotNullAndNotEmpty(remote.substring(namePos + 1), "No name value in remote=%s", (Object)remote);
        Set<ScpClient.Option> options = time != null ? EnumSet.of(ScpClient.Option.PreserveAttributes) : Collections.emptySet();
        String cmd = ScpClient.createSendCommand(remote, options);
        ClientSession session = this.getClientSession();
        ChannelExec channel = this.openCommandChannel(session, cmd);
        try (InputStream invOut = channel.getInvertedOut();
             OutputStream invIn = channel.getInvertedIn();){
            ScpHelper helper = new ScpHelper(session, invOut, invIn, new MockFileSystem(remote), this.opener, this.listener);
            MockPath mockPath = new MockPath(remote);
            helper.sendStream(new DefaultScpStreamResolver(name, mockPath, perms, time, size, local, cmd), options.contains((Object)ScpClient.Option.PreserveAttributes), 8192);
            this.handleCommandExitStatus(cmd, channel);
        }
        finally {
            channel.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> void runUpload(String remote, Collection<ScpClient.Option> options, Collection<T> local, AbstractScpClient.ScpOperationExecutor<T> executor) throws IOException {
        local = ValidateUtils.checkNotNullAndNotEmpty(local, "Invalid argument local: %s", local);
        remote = ValidateUtils.checkNotNullAndNotEmpty(remote, "Invalid argument remote: %s", (Object)remote);
        if (local.size() > 1) {
            options = this.addTargetIsDirectory(options);
        }
        String cmd = ScpClient.createSendCommand(remote, options);
        ClientSession session = this.getClientSession();
        ChannelExec channel = this.openCommandChannel(session, cmd);
        try {
            ClientFactoryManager manager = session.getFactoryManager();
            FileSystemFactory factory = manager.getFileSystemFactory();
            FileSystem fs = factory.createFileSystem(session);
            try (InputStream invOut = channel.getInvertedOut();
                 OutputStream invIn = channel.getInvertedIn();){
                ScpHelper helper = new ScpHelper(session, invOut, invIn, fs, this.opener, this.listener);
                executor.execute(helper, local, options);
            }
            catch (Throwable throwable) {
                block37: {
                    try {
                        fs.close();
                    }
                    catch (UnsupportedOperationException e) {
                        if (!this.log.isDebugEnabled()) break block37;
                        this.log.debug("runUpload({}) {} => {} - failed ({}) to close file system={}: {}", session, remote, local, e.getClass().getSimpleName(), fs, e.getMessage());
                    }
                }
                throw throwable;
            }
            try {
                fs.close();
            }
            catch (UnsupportedOperationException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("runUpload({}) {} => {} - failed ({}) to close file system={}: {}", session, remote, local, e.getClass().getSimpleName(), fs, e.getMessage());
                }
            }
            this.handleCommandExitStatus(cmd, channel);
        }
        finally {
            channel.close(false);
        }
    }

    private static boolean showError(PrintStream stderr, String message) {
        stderr.println(message);
        return true;
    }

    private static String[] normalizeCommandArguments(PrintStream stdout, PrintStream stderr, String ... args) {
        int numArgs = GenericUtils.length(args);
        if (numArgs <= 0) {
            return args;
        }
        ArrayList<String> effective = new ArrayList<String>(numArgs);
        boolean error = false;
        for (int index = 0; index < numArgs && !error; ++index) {
            String argName = args[index];
            if (SshClient.isArgumentedOption(SCP_PORT_OPTION, argName)) {
                if (index + 1 >= numArgs) {
                    error = DefaultScpClient.showError(stderr, "option requires an argument: " + argName);
                    break;
                }
                effective.add(argName);
                effective.add(args[++index]);
                continue;
            }
            if ("-r".equals(argName) || "-p".equals(argName) || "-q".equals(argName) || "-C".equals(argName) || "-v".equals(argName) || "-vv".equals(argName) || "-vvv".equals(argName)) {
                effective.add(argName);
                continue;
            }
            if (argName.charAt(0) == '-') {
                error = DefaultScpClient.showError(stderr, "Unknown option: " + argName);
                break;
            }
            if (index + 1 >= numArgs) {
                error = DefaultScpClient.showError(stderr, "Not enough arguments");
                break;
            }
            ScpLocation source = new ScpLocation(argName);
            ScpLocation target = new ScpLocation(args[++index]);
            if (index < numArgs - 1) {
                error = DefaultScpClient.showError(stderr, "Unexpected extra arguments");
                break;
            }
            if (source.isLocal() == target.isLocal()) {
                error = DefaultScpClient.showError(stderr, "Both targets are either remote or local");
                break;
            }
            ScpLocation remote = source.isLocal() ? target : source;
            effective.add(remote.resolveUsername() + "@" + remote.getHost());
            effective.add(source.toString());
            effective.add(target.toString());
            break;
        }
        if (error) {
            return null;
        }
        return effective.toArray(new String[effective.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        final PrintStream stdout = System.out;
        final PrintStream stderr = System.err;
        OutputStream logStream = stdout;
        try (BufferedReader stdin = new BufferedReader(new InputStreamReader((InputStream)new NoCloseInputStream(System.in), Charset.defaultCharset()));){
            ClientSession session;
            args = DefaultScpClient.normalizeCommandArguments(stdout, stderr, args);
            int numArgs = GenericUtils.length(args);
            if (numArgs >= 2) {
                Level level = SshClient.resolveLoggingVerbosity(args, numArgs - 2);
                logStream = SshClient.resolveLoggingTargetStream(stdout, stderr, args, numArgs - 2);
                if (logStream != null) {
                    SshClient.setupLogging(level, stdout, stderr, logStream);
                }
            }
            ClientSession clientSession = session = logStream == null || GenericUtils.isEmpty(args) ? null : SshClient.setupClientSession(SCP_PORT_OPTION, stdin, stdout, stderr, args);
            if (session == null) {
                stderr.println("usage: scp [-P port] [-i identity] [-v[v][v]] [-E logoutput] [-r] [-p] [-q] [-o option=value] [-c cipherlist] [-m maclist] [-w password] [-C] <source> <target>");
                stderr.println();
                stderr.println("Where <source> or <target> are either 'user@host:file' or a local file path");
                stderr.println("NOTE: exactly ONE of the source or target must be remote and the other one local");
                System.exit(-1);
                return;
            }
            try {
                EnumSet<ScpClient.Option> options = EnumSet.noneOf(ScpClient.Option.class);
                boolean quiet = false;
                for (int index = 0; index < numArgs; ++index) {
                    String argName = args[index];
                    if ("-r".equals(argName)) {
                        options.add(ScpClient.Option.Recursive);
                        continue;
                    }
                    if ("-p".equals(argName)) {
                        options.add(ScpClient.Option.PreserveAttributes);
                        continue;
                    }
                    if (!"-q".equals(argName)) continue;
                    quiet = true;
                }
                if (!quiet) {
                    session.setScpTransferEventListener(new ScpTransferEventListener(){

                        @Override
                        public void startFolderEvent(ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms) {
                            this.logEvent("startFolderEvent", op, file, -1L, perms, null);
                        }

                        @Override
                        public void endFolderEvent(ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms, Throwable thrown) {
                            this.logEvent("endFolderEvent", op, file, -1L, perms, thrown);
                        }

                        @Override
                        public void startFileEvent(ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms) {
                            this.logEvent("startFileEvent", op, file, length, perms, null);
                        }

                        @Override
                        public void endFileEvent(ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms, Throwable thrown) {
                            this.logEvent("endFileEvent", op, file, length, perms, thrown);
                        }

                        private void logEvent(String name, ScpTransferEventListener.FileOperation op, Path file, long length, Collection<PosixFilePermission> perms, Throwable thrown) {
                            PrintStream ps = thrown == null ? stdout : stderr;
                            ps.append('\t').append(name).append('[').append(op.name()).append(']').append(' ').append(file.toString());
                            if (length > 0L) {
                                ps.append(' ').append("length=").append(Long.toString(length));
                            }
                            ps.append(' ').append(String.valueOf(perms));
                            if (thrown != null) {
                                ps.append(" - ").append(thrown.getClass().getSimpleName()).append(": ").append(thrown.getMessage());
                            }
                            ps.println();
                        }
                    });
                }
                ScpClient client = session.createScpClient();
                ScpLocation source = new ScpLocation(args[numArgs - 2]);
                ScpLocation target = new ScpLocation(args[numArgs - 1]);
                if (source.isLocal()) {
                    client.upload(source.getPath(), target.getPath(), options);
                } else {
                    client.download(source.getPath(), target.getPath(), options);
                }
            }
            finally {
                session.close();
            }
        }
        finally {
            if (logStream != stdout && logStream != stderr) {
                logStream.close();
            }
        }
    }
}

