/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.root;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.file.root.RootedFileSystem;
import org.apache.sshd.common.file.root.RootedPath;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootedFileSystemProvider
extends FileSystemProvider {
    protected final Logger log;
    private final Map<Path, RootedFileSystem> fileSystems = new HashMap<Path, RootedFileSystem>();

    public RootedFileSystemProvider() {
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public String getScheme() {
        return "root";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        return this.newFileSystem(uri, this.uriToPath(uri), env);
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        return this.getFileSystem(this.uriToPath(uri));
    }

    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        return this.newFileSystem(path, path, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem newFileSystem(Object src, Path path, Map<String, ?> env) throws IOException {
        Path root = RootedFileSystemProvider.ensureDirectory(path).toRealPath(new LinkOption[0]);
        RootedFileSystem rootedFs = null;
        Map<Path, RootedFileSystem> map = this.fileSystems;
        synchronized (map) {
            if (!this.fileSystems.containsKey(root)) {
                rootedFs = new RootedFileSystem(this, path, env);
                this.fileSystems.put(root, rootedFs);
            }
        }
        if (rootedFs == null) {
            throw new FileSystemAlreadyExistsException("newFileSystem(" + src + ") already mapped " + root);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("newFileSystem({}): {}", src, (Object)rootedFs);
        }
        return rootedFs;
    }

    protected Path uriToPath(URI uri) {
        String scheme = uri.getScheme();
        String expected = this.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase(expected)) {
            throw new IllegalArgumentException("URI scheme (" + scheme + ") is not '" + expected + "'");
        }
        String root = uri.getRawSchemeSpecificPart();
        int i = root.indexOf("!/");
        if (i != -1) {
            root = root.substring(0, i);
        }
        try {
            return Paths.get(new URI(root)).toAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(root + ": " + e.getMessage(), e);
        }
    }

    private static Path ensureDirectory(Path path) {
        return IoUtils.ensureDirectory(path, IoUtils.getLinkOptions(true));
    }

    @Override
    public Path getPath(URI uri) {
        String str = uri.getSchemeSpecificPart();
        int i = str.indexOf("!/");
        if (i == -1) {
            throw new IllegalArgumentException("URI: " + uri + " does not contain path info - e.g., root:file://foo/bar!/");
        }
        FileSystem fs = this.getFileSystem(uri);
        String subPath = str.substring(i + 1);
        Path p = fs.getPath(subPath, new String[0]);
        if (this.log.isTraceEnabled()) {
            this.log.trace("getPath({}): {}", (Object)uri, (Object)p);
        }
        return p;
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        return p.newInputStream(r, options);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        return p.newOutputStream(r, options);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        return p.newFileChannel(r, options, attrs);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        return p.newAsynchronousFileChannel(r, options, executor, attrs);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        return p.newByteChannel(r, options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Path r = this.unroot(dir);
        FileSystemProvider p = this.provider(r);
        return p.newDirectoryStream(r, filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        Path r = this.unroot(dir);
        FileSystemProvider p = this.provider(r);
        p.createDirectory(r, attrs);
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        this.createLink(link, target, true, attrs);
    }

    @Override
    public void createLink(Path link, Path existing) throws IOException {
        this.createLink(link, existing, false, new FileAttribute[0]);
    }

    protected void createLink(Path link, Path target, boolean symLink, FileAttribute<?> ... attrs) throws IOException {
        Path l = this.unroot(link);
        Path t = this.unroot(target);
        if (symLink && !target.isAbsolute()) {
            RootedFileSystem rfs = (RootedFileSystem)((RootedPath)target).getFileSystem();
            Path root = rfs.getRoot();
            t = root.relativize(t);
        }
        FileSystemProvider p = this.provider(l);
        if (symLink) {
            p.createSymbolicLink(l, t, attrs);
        } else {
            p.createLink(l, t);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("createLink(symbolic={}) {} => {}", symLink, l, t);
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        Path r = this.unroot(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("delete({}): {}", (Object)path, (Object)r);
        }
        FileSystemProvider p = this.provider(r);
        p.delete(r);
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        Path r = this.unroot(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("deleteIfExists({}): {}", (Object)path, (Object)r);
        }
        FileSystemProvider p = this.provider(r);
        return p.deleteIfExists(r);
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        Path r = this.unroot(link);
        FileSystemProvider p = this.provider(r);
        Path t = p.readSymbolicLink(r);
        Path target = this.root((RootedFileSystem)link.getFileSystem(), t);
        if (this.log.isTraceEnabled()) {
            this.log.trace("readSymbolicLink({})[{}]: {}[{}]", link, r, target, t);
        }
        return target;
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        Path s = this.unroot(source);
        Path t = this.unroot(target);
        if (this.log.isTraceEnabled()) {
            this.log.trace("copy({})[{}]: {}[{}]", source, s, target, t);
        }
        FileSystemProvider p = this.provider(s);
        p.copy(s, t, options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        Path s = this.unroot(source);
        Path t = this.unroot(target);
        if (this.log.isTraceEnabled()) {
            this.log.trace("move({})[{}]: {}[{}]", source, s, target, t);
        }
        FileSystemProvider p = this.provider(s);
        p.move(s, t, options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        Path r = this.unroot(path);
        Path r2 = this.unroot(path2);
        FileSystemProvider p = this.provider(r);
        return p.isSameFile(r, r2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        return p.isHidden(r);
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        RootedFileSystem fileSystem = this.getFileSystem(path);
        Path root = fileSystem.getRoot();
        return Files.getFileStore(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RootedFileSystem getFileSystem(Path path) throws FileSystemNotFoundException {
        Path real = this.unroot(path);
        Path rootInstance = null;
        RootedFileSystem fsInstance = null;
        Map<Path, RootedFileSystem> map = this.fileSystems;
        synchronized (map) {
            for (Map.Entry<Path, RootedFileSystem> fse : this.fileSystems.entrySet()) {
                Path root = fse.getKey();
                RootedFileSystem fs = fse.getValue();
                if (real.equals(root)) {
                    return fs;
                }
                if (!real.startsWith(root) || rootInstance != null && rootInstance.getNameCount() >= root.getNameCount()) continue;
                rootInstance = root;
                fsInstance = fs;
            }
        }
        if (fsInstance == null) {
            throw new FileSystemNotFoundException(path.toString());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("getFileSystem({}): {}", (Object)path, (Object)fsInstance);
        }
        return fsInstance;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        p.checkAccess(r, modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        return p.getFileAttributeView(r, type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        Path r = this.unroot(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("readAttributes({})[{}] type={}", path, r, type.getSimpleName());
        }
        FileSystemProvider p = this.provider(r);
        return p.readAttributes(r, type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        Map<String, Object> attrs = p.readAttributes(r, attributes, options);
        if (this.log.isTraceEnabled()) {
            this.log.trace("readAttributes({})[{}] {}: {}", path, r, attributes, attrs);
        }
        return attrs;
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        Path r = this.unroot(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("setAttribute({})[{}] {}={}", path, r, attribute, value);
        }
        FileSystemProvider p = this.provider(r);
        p.setAttribute(r, attribute, value, options);
    }

    protected FileSystemProvider provider(Path path) {
        FileSystem fs = path.getFileSystem();
        return fs.provider();
    }

    protected Path root(RootedFileSystem rfs, Path nat) {
        if (nat.isAbsolute()) {
            Path root = rfs.getRoot();
            Path rel = root.relativize(nat);
            return rfs.getPath("/" + rel.toString(), new String[0]);
        }
        return rfs.getPath(nat.toString(), new String[0]);
    }

    protected Path unroot(Path path) {
        Objects.requireNonNull(path, "No path to unroot");
        if (!(path instanceof RootedPath)) {
            throw new ProviderMismatchException("unroot(" + path + ") is not a " + RootedPath.class.getSimpleName() + " but rather a " + path.getClass().getSimpleName());
        }
        return this.resolveLocalPath((RootedPath)path);
    }

    protected Path resolveLocalPath(RootedPath path) {
        RootedPath absPath = (RootedPath)Objects.requireNonNull(path, "No rooted path to resolve").toAbsolutePath();
        RootedFileSystem rfs = (RootedFileSystem)absPath.getFileSystem();
        Path root = rfs.getRoot();
        FileSystem lfs = root.getFileSystem();
        String rSep = ValidateUtils.checkNotNullAndNotEmpty(rfs.getSeparator(), "No rooted file system separator");
        ValidateUtils.checkTrue(rSep.length() == 1, "Bad rooted file system separator: %s", (Object)rSep);
        char rootedSeparator = rSep.charAt(0);
        String lSep = ValidateUtils.checkNotNullAndNotEmpty(lfs.getSeparator(), "No local file system separator");
        ValidateUtils.checkTrue(lSep.length() == 1, "Bad local file system separator: %s", (Object)lSep);
        char localSeparator = lSep.charAt(0);
        String r = absPath.toString();
        String subPath = r.substring(1);
        if (rootedSeparator != localSeparator) {
            subPath = subPath.replace(rootedSeparator, localSeparator);
        }
        Path resolved = root.resolve(subPath);
        resolved = resolved.normalize();
        resolved = resolved.toAbsolutePath();
        if (this.log.isTraceEnabled()) {
            this.log.trace("resolveLocalPath({}): {}", (Object)absPath, (Object)resolved);
        }
        if (!resolved.startsWith(root)) {
            throw new InvalidPathException(r, "Not under root");
        }
        return resolved;
    }
}

