/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.channel.throttle.ChannelStreamPacketWriterResolver;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.compression.CompressionInformation;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.future.DefaultKeyExchangeFuture;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.AbstractKexFactoryManager;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.mac.MacInformation;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.SessionWorkBuffer;
import org.apache.sshd.common.session.UnknownChannelReferenceHandler;
import org.apache.sshd.common.session.helpers.PendingWriteFuture;
import org.apache.sshd.common.session.helpers.ReservedSessionMessagesHandlerAdapter;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Invoker;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public abstract class AbstractSession
extends AbstractKexFactoryManager
implements Session {
    public static final String SESSION = "org.apache.sshd.session";
    protected final boolean isServer;
    protected final IoSession ioSession;
    protected final Random random;
    protected boolean authed;
    protected String username;
    protected final Collection<SessionListener> sessionListeners = new CopyOnWriteArraySet<SessionListener>();
    protected final SessionListener sessionListenerProxy;
    protected final Collection<ChannelListener> channelListeners = new CopyOnWriteArraySet<ChannelListener>();
    protected final ChannelListener channelListenerProxy;
    protected final Collection<PortForwardingEventListener> tunnelListeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    protected final PortForwardingEventListener tunnelListenerProxy;
    protected byte[] sessionId;
    protected String serverVersion;
    protected String clientVersion;
    protected final Map<KexProposalOption, String> serverProposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
    protected final Map<KexProposalOption, String> clientProposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
    protected final Map<KexProposalOption, String> negotiationResult = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
    protected byte[] i_c;
    protected byte[] i_s;
    protected KeyExchange kex;
    protected Boolean firstKexPacketFollows;
    protected final AtomicReference<KexState> kexState = new AtomicReference<KexState>(KexState.UNKNOWN);
    protected final AtomicReference<DefaultKeyExchangeFuture> kexFutureHolder = new AtomicReference<Object>(null);
    protected Cipher outCipher;
    protected Cipher inCipher;
    protected int outCipherSize = 8;
    protected int inCipherSize = 8;
    protected Mac outMac;
    protected Mac inMac;
    protected byte[] inMacResult;
    protected Compression outCompression;
    protected Compression inCompression;
    protected long seqi;
    protected long seqo;
    protected SessionWorkBuffer uncompressBuffer;
    protected final SessionWorkBuffer decoderBuffer;
    protected int decoderState;
    protected int decoderLength;
    protected final Object encodeLock = new Object();
    protected final Object decodeLock = new Object();
    protected final Object requestLock = new Object();
    protected long authTimeoutStart = System.currentTimeMillis();
    protected long idleTimeoutStart = System.currentTimeMillis();
    protected final AtomicReference<Session.TimeoutStatus> timeoutStatus = new AtomicReference<Session.TimeoutStatus>(Session.TimeoutStatus.NoTimeout);
    protected final AtomicLong inPacketsCount = new AtomicLong(0L);
    protected final AtomicLong outPacketsCount = new AtomicLong(0L);
    protected final AtomicLong inBytesCount = new AtomicLong(0L);
    protected final AtomicLong outBytesCount = new AtomicLong(0L);
    protected final AtomicLong inBlocksCount = new AtomicLong(0L);
    protected final AtomicLong outBlocksCount = new AtomicLong(0L);
    protected final AtomicLong lastKeyTimeValue = new AtomicLong(0L);
    protected long maxRekyPackets = 0x80000000L;
    protected long maxRekeyBytes = 0x40000000L;
    protected long maxRekeyInterval = 3600000L;
    protected final Queue<PendingWriteFuture> pendingPackets = new LinkedList<PendingWriteFuture>();
    protected Service currentService;
    protected int ignorePacketDataLength = 16;
    protected long ignorePacketsFrequency = 1024L;
    protected int ignorePacketsVariance = 32;
    protected final AtomicLong maxRekeyBlocks = new AtomicLong(0x4000000L);
    protected final AtomicLong ignorePacketsCount = new AtomicLong(1024L);
    private final FactoryManager factoryManager;
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final AtomicReference<Object> requestResult = new AtomicReference();
    private final Map<AttributeStore.AttributeKey<?>, Object> attributes = new ConcurrentHashMap();
    private ReservedSessionMessagesHandler reservedSessionMessagesHandler;
    private ChannelStreamPacketWriterResolver channelStreamPacketWriterResolver;
    private UnknownChannelReferenceHandler unknownChannelReferenceHandler;

    protected AbstractSession(boolean isServer, FactoryManager factoryManager, IoSession ioSession) {
        super(Objects.requireNonNull(factoryManager, "No factory manager provided"));
        this.isServer = isServer;
        this.factoryManager = factoryManager;
        this.ioSession = ioSession;
        this.decoderBuffer = new SessionWorkBuffer(this);
        AbstractSession.attachSession(ioSession, this);
        Factory<Random> factory = ValidateUtils.checkNotNull(factoryManager.getRandomFactory(), "No random factory for %s", (Object)ioSession);
        this.random = ValidateUtils.checkNotNull(factory.create(), "No randomizer instance for %s", (Object)ioSession);
        this.refreshConfiguration();
        ClassLoader loader = this.getClass().getClassLoader();
        this.sessionListenerProxy = EventListenerUtils.proxyWrapper(SessionListener.class, loader, this.sessionListeners);
        this.channelListenerProxy = EventListenerUtils.proxyWrapper(ChannelListener.class, loader, this.channelListeners);
        this.tunnelListenerProxy = EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, loader, this.tunnelListeners);
    }

    protected void signalSessionCreated(IoSession ioSession) throws Exception {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalSessionCreated((SessionListener)l);
                return null;
            });
        }
        catch (Throwable err) {
            Throwable e = GenericUtils.peelException(err);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed ({}) to announce session={} created: {}", e.getClass().getSimpleName(), ioSession, e.getMessage());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Session=" + ioSession + " creation failure details", e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeSshException(e);
        }
    }

    protected void signalSessionCreated(SessionListener listener) {
        if (listener == null) {
            return;
        }
        listener.sessionCreated(this);
    }

    public static AbstractSession getSession(IoSession ioSession) {
        return AbstractSession.getSession(ioSession, false);
    }

    public static AbstractSession getSession(IoSession ioSession, boolean allowNull) {
        AbstractSession session = (AbstractSession)ioSession.getAttribute(SESSION);
        if (session == null && !allowNull) {
            throw new IllegalStateException("No session available");
        }
        return session;
    }

    public static void attachSession(IoSession ioSession, AbstractSession session) {
        Objects.requireNonNull(ioSession, "No I/O session").setAttribute(SESSION, Objects.requireNonNull(session, "No SSH session"));
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public KeyExchange getKex() {
        return this.kex;
    }

    @Override
    public byte[] getSessionId() {
        return NumberUtils.isEmpty(this.sessionId) ? this.sessionId : (byte[])this.sessionId.clone();
    }

    @Override
    public IoSession getIoSession() {
        return this.ioSession;
    }

    protected SocketAddress resolvePeerAddress(SocketAddress knownAddress) {
        if (knownAddress != null) {
            return knownAddress;
        }
        IoSession s = this.getIoSession();
        return s == null ? null : s.getRemoteAddress();
    }

    @Override
    public FactoryManager getFactoryManager() {
        return this.factoryManager;
    }

    @Override
    public PropertyResolver getParentPropertyResolver() {
        return this.getFactoryManager();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public UnknownChannelReferenceHandler getUnknownChannelReferenceHandler() {
        return this.unknownChannelReferenceHandler;
    }

    @Override
    public void setUnknownChannelReferenceHandler(UnknownChannelReferenceHandler unknownChannelReferenceHandler) {
        this.unknownChannelReferenceHandler = unknownChannelReferenceHandler;
    }

    @Override
    public UnknownChannelReferenceHandler resolveUnknownChannelReferenceHandler() {
        UnknownChannelReferenceHandler handler = this.getUnknownChannelReferenceHandler();
        if (handler != null) {
            return handler;
        }
        FactoryManager mgr = this.getFactoryManager();
        return mgr == null ? null : mgr.resolveUnknownChannelReferenceHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNegotiatedKexParameter(KexProposalOption paramType) {
        if (paramType == null) {
            return null;
        }
        Map<KexProposalOption, String> map = this.negotiationResult;
        synchronized (map) {
            return this.negotiationResult.get((Object)paramType);
        }
    }

    @Override
    public CipherInformation getCipherInformation(boolean incoming) {
        return incoming ? this.inCipher : this.outCipher;
    }

    @Override
    public CompressionInformation getCompressionInformation(boolean incoming) {
        return incoming ? this.inCompression : this.outCompression;
    }

    @Override
    public MacInformation getMacInformation(boolean incoming) {
        return incoming ? this.inMac : this.outMac;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authed;
    }

    @Override
    public void setAuthenticated() throws IOException {
        this.authed = true;
        this.signalSessionEvent(SessionListener.Event.Authenticated);
    }

    @Override
    public ChannelStreamPacketWriterResolver getChannelStreamPacketWriterResolver() {
        return this.channelStreamPacketWriterResolver;
    }

    @Override
    public void setChannelStreamPacketWriterResolver(ChannelStreamPacketWriterResolver resolver) {
        this.channelStreamPacketWriterResolver = resolver;
    }

    @Override
    public ChannelStreamPacketWriterResolver resolveChannelStreamPacketWriterResolver() {
        ChannelStreamPacketWriterResolver resolver = this.getChannelStreamPacketWriterResolver();
        if (resolver != null) {
            return resolver;
        }
        FactoryManager manager = this.getFactoryManager();
        return manager.resolveChannelStreamPacketWriterResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(Readable buffer) throws Exception {
        Object object = this.decodeLock;
        synchronized (object) {
            this.decoderBuffer.putBuffer(buffer);
            if (this.clientVersion == null || this.serverVersion == null) {
                if (this.readIdentification(this.decoderBuffer)) {
                    this.decoderBuffer.compact();
                } else {
                    return;
                }
            }
            this.decode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshConfiguration() {
        Random random = this.random;
        synchronized (random) {
            this.maxRekeyBytes = this.getLongProperty("rekey-bytes-limit", this.maxRekeyBytes);
            this.maxRekeyInterval = this.getLongProperty("rekey-time-limit", this.maxRekeyInterval);
            this.maxRekyPackets = this.getLongProperty("rekey-packets-limit", this.maxRekyPackets);
            this.ignorePacketDataLength = this.getIntProperty("ignore-message-size", 16);
            this.ignorePacketsFrequency = this.getLongProperty("ignore-message-frequency", 1024L);
            this.ignorePacketsVariance = this.getIntProperty("ignore-message-variance", 32);
            if ((long)this.ignorePacketsVariance >= this.ignorePacketsFrequency) {
                this.ignorePacketsVariance = 0;
            }
            this.ignorePacketsCount.set(this.calculateNextIgnorePacketCount(this.random, this.ignorePacketsFrequency, this.ignorePacketsVariance));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(Buffer buffer) throws Exception {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.doHandleMessage(buffer);
            }
        }
        catch (Throwable e) {
            DefaultKeyExchangeFuture kexFuture = this.kexFutureHolder.get();
            if (kexFuture != null) {
                DefaultKeyExchangeFuture defaultKeyExchangeFuture = kexFuture;
                synchronized (defaultKeyExchangeFuture) {
                    Object value = kexFuture.getValue();
                    if (value == null) {
                        kexFuture.setValue(e);
                    }
                }
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeSshException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void doHandleMessage(Buffer buffer) throws Exception {
        cmd = buffer.getUByte();
        if (this.log.isTraceEnabled()) {
            this.log.trace("doHandleMessage({}) process {}", (Object)this, (Object)SshConstants.getCommandMessageName(cmd));
        }
        switch (cmd) {
            case 1: {
                this.handleDisconnect(buffer);
                break;
            }
            case 2: {
                this.handleIgnore(buffer);
                break;
            }
            case 3: {
                this.handleUnimplemented(buffer);
                break;
            }
            case 4: {
                this.handleDebug(buffer);
                break;
            }
            case 5: {
                this.handleServiceRequest(buffer);
                break;
            }
            case 6: {
                this.handleServiceAccept(buffer);
                break;
            }
            case 20: {
                this.handleKexInit(buffer);
                break;
            }
            case 21: {
                this.handleNewKeys(cmd, buffer);
                break;
            }
            default: {
                if (cmd < 30 || cmd > 49) ** GOTO lbl41
                if (this.firstKexPacketFollows != null) {
                    try {
                        if (!this.handleFirstKexPacketFollows(cmd, buffer, this.firstKexPacketFollows)) {
                            break;
                        }
                    }
                    finally {
                        this.firstKexPacketFollows = null;
                    }
                }
                this.handleKexMessage(cmd, buffer);
                break;
lbl41:
                // 1 sources

                if (this.currentService != null) {
                    this.currentService.process(cmd, buffer);
                    this.resetIdleTimeout();
                    break;
                }
                throw new IllegalStateException("Unsupported command " + SshConstants.getCommandMessageName(cmd));
            }
        }
        this.checkRekey();
    }

    protected boolean handleFirstKexPacketFollows(int cmd, Buffer buffer, boolean followFlag) {
        if (!followFlag) {
            return true;
        }
        for (KexProposalOption option : new KexProposalOption[]{KexProposalOption.ALGORITHMS, KexProposalOption.SERVERKEYS}) {
            AbstractMap.SimpleImmutableEntry<String, String> result = this.comparePreferredKexProposalOption(option);
            if (result == null) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleFirstKexPacketFollows({})[{}] 1st follow KEX packet {} option mismatch: client={}, server={}", new Object[]{this, SshConstants.getCommandMessageName(cmd), option, result.getKey(), result.getValue()});
            }
            return false;
        }
        return true;
    }

    protected AbstractMap.SimpleImmutableEntry<String, String> comparePreferredKexProposalOption(KexProposalOption option) {
        String[] serverPreferences;
        String serverValue;
        String[] clientPreferences = GenericUtils.split(this.clientProposal.get((Object)option), ',');
        String clientValue = clientPreferences[0];
        return clientValue.equals(serverValue = (serverPreferences = GenericUtils.split(this.serverProposal.get((Object)option), ','))[0]) ? null : new AbstractMap.SimpleImmutableEntry<String, String>(clientValue, serverValue);
    }

    protected void handleKexMessage(int cmd, Buffer buffer) throws Exception {
        this.validateKexState(cmd, KexState.RUN);
        if (this.kex.next(cmd, buffer)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleKexMessage({})[{}] KEX processing complete after cmd={}", this, this.kex.getName(), cmd);
            }
            this.checkKeys();
            this.sendNewKeys();
            this.kexState.set(KexState.KEYS);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("handleKexMessage({})[{}] more KEX packets expected after cmd={}", this, this.kex.getName(), cmd);
        }
    }

    @Override
    public IoWriteFuture sendIgnoreMessage(byte ... data) throws IOException {
        data = data == null ? GenericUtils.EMPTY_BYTE_ARRAY : data;
        Buffer buffer = this.createBuffer((byte)2, data.length + 8);
        buffer.putBytes(data);
        return this.writePacket(buffer);
    }

    protected void handleIgnore(Buffer buffer) throws Exception {
        if (!buffer.isValidMessageStructure(byte[].class)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleIgnore({}) ignore malformed message", (Object)this);
            }
            return;
        }
        this.resetIdleTimeout();
        ReservedSessionMessagesHandler handler = this.resolveReservedSessionMessagesHandler();
        handler.handleIgnoreMessage(this, buffer);
    }

    protected void handleUnimplemented(Buffer buffer) throws Exception {
        if (!buffer.isValidMessageStructure(Integer.TYPE)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleUnimplemented({}) ignore malformed message", (Object)this);
            }
            return;
        }
        this.resetIdleTimeout();
        ReservedSessionMessagesHandler handler = this.resolveReservedSessionMessagesHandler();
        handler.handleUnimplementedMessage(this, buffer);
    }

    @Override
    public IoWriteFuture sendDebugMessage(boolean display, Object msg, String lang) throws IOException {
        String text = Objects.toString(msg, "");
        lang = lang == null ? "" : lang;
        Buffer buffer = this.createBuffer((byte)4, text.length() + lang.length() + 32);
        buffer.putBoolean(display);
        buffer.putString(text);
        buffer.putString(lang);
        return this.writePacket(buffer);
    }

    protected void handleDebug(Buffer buffer) throws Exception {
        if (!buffer.isValidMessageStructure(Boolean.TYPE, String.class, String.class)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleDebug({}) ignore malformed message", (Object)this);
            }
            return;
        }
        this.resetIdleTimeout();
        ReservedSessionMessagesHandler handler = this.resolveReservedSessionMessagesHandler();
        handler.handleDebugMessage(this, buffer);
    }

    protected ReservedSessionMessagesHandler resolveReservedSessionMessagesHandler() {
        ReservedSessionMessagesHandler handler = this.getReservedSessionMessagesHandler();
        return handler == null ? ReservedSessionMessagesHandlerAdapter.DEFAULT : handler;
    }

    protected void handleDisconnect(Buffer buffer) throws Exception {
        int code = buffer.getInt();
        String message = buffer.getString();
        String languageTag = buffer.available() > 0 ? buffer.getString() : "";
        this.handleDisconnect(code, message, languageTag, buffer);
    }

    protected void handleDisconnect(int code, String msg, String lang, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleDisconnect({}) SSH_MSG_DISCONNECT reason={}, [lang={}] msg={}", this, SshConstants.getDisconnectReasonName(code), lang, msg);
        }
        this.close(true);
    }

    protected void handleServiceRequest(Buffer buffer) throws Exception {
        String serviceName = buffer.getString();
        this.handleServiceRequest(serviceName, buffer);
    }

    protected boolean handleServiceRequest(String serviceName, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleServiceRequest({}) SSH_MSG_SERVICE_REQUEST '{}'", (Object)this, (Object)serviceName);
        }
        this.validateKexState(5, KexState.DONE);
        try {
            this.startService(serviceName);
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleServiceRequest({}) Service {} rejected: {} = {}", this, serviceName, e.getClass().getSimpleName(), e.getMessage());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleServiceRequest(" + this + ") service=" + serviceName + " rejection details", e);
            }
            this.disconnect(7, "Bad service request: " + serviceName);
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleServiceRequest({}) Accepted service {}", (Object)this, (Object)serviceName);
        }
        Buffer response = this.createBuffer((byte)6, 8 + GenericUtils.length(serviceName));
        response.putString(serviceName);
        this.writePacket(response);
        return true;
    }

    protected void handleServiceAccept(Buffer buffer) throws Exception {
        this.handleServiceAccept(buffer.getString(), buffer);
    }

    protected void handleServiceAccept(String serviceName, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleServiceAccept({}) SSH_MSG_SERVICE_ACCEPT service={}", (Object)this, (Object)serviceName);
        }
        this.validateKexState(6, KexState.DONE);
    }

    protected void handleKexInit(Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleKexInit({}) SSH_MSG_KEXINIT", (Object)this);
        }
        this.receiveKexInit(buffer);
        if (this.kexState.compareAndSet(KexState.DONE, KexState.RUN)) {
            this.sendKexInit();
        } else if (!this.kexState.compareAndSet(KexState.INIT, KexState.RUN)) {
            throw new IllegalStateException("Received SSH_MSG_KEXINIT while key exchange is running");
        }
        Map<KexProposalOption, String> result = this.negotiate();
        String kexAlgorithm = result.get((Object)KexProposalOption.ALGORITHMS);
        this.kex = ValidateUtils.checkNotNull(NamedFactory.create(this.getKeyExchangeFactories(), kexAlgorithm), "Unknown negotiated KEX algorithm: %s", (Object)kexAlgorithm);
        this.kex.init(this, this.serverVersion.getBytes(StandardCharsets.UTF_8), this.clientVersion.getBytes(StandardCharsets.UTF_8), this.i_s, this.i_c);
        this.signalSessionEvent(SessionListener.Event.KexCompleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewKeys(int cmd, Buffer buffer) throws Exception {
        List<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>> pendingWrites;
        Object value;
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleNewKeys({}) SSH_MSG_NEWKEYS command={}", (Object)this, (Object)SshConstants.getCommandMessageName(cmd));
        }
        this.validateKexState(cmd, KexState.KEYS);
        this.receiveNewKeys();
        DefaultKeyExchangeFuture kexFuture = this.kexFutureHolder.get();
        if (kexFuture != null) {
            DefaultKeyExchangeFuture defaultKeyExchangeFuture = kexFuture;
            synchronized (defaultKeyExchangeFuture) {
                value = kexFuture.getValue();
                if (value == null) {
                    kexFuture.setValue(Boolean.TRUE);
                }
            }
        }
        this.signalSessionEvent(SessionListener.Event.KeyEstablished);
        value = this.pendingPackets;
        synchronized (value) {
            pendingWrites = this.sendPendingPackets(this.pendingPackets);
            this.kexState.set(KexState.DONE);
        }
        int pendingCount = pendingWrites.size();
        if (pendingCount > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleNewKeys({}) sent {} pending packets", (Object)this, (Object)pendingCount);
            }
            for (Map.Entry entry : pendingWrites) {
                SshFutureListener listener = (SshFutureListener)entry.getKey();
                IoWriteFuture future = (IoWriteFuture)entry.getValue();
                if (listener == null) continue;
                future.addListener(listener);
            }
        }
        Iterator iterator = this.lock;
        synchronized (iterator) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>> sendPendingPackets(Queue<PendingWriteFuture> packetsQueue) throws IOException {
        if (GenericUtils.isEmpty(packetsQueue)) {
            return Collections.emptyList();
        }
        int numPending = packetsQueue.size();
        ArrayList<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>> pendingWrites = new ArrayList<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>>(numPending);
        Object object = this.encodeLock;
        synchronized (object) {
            PendingWriteFuture future = this.pendingPackets.poll();
            while (future != null) {
                IoWriteFuture writeFuture = this.doWritePacket(future.getBuffer());
                pendingWrites.add(new AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>(future, writeFuture));
                future = this.pendingPackets.poll();
            }
        }
        return pendingWrites;
    }

    protected void validateKexState(int cmd, KexState expected) {
        KexState actual = this.kexState.get();
        if (!expected.equals((Object)actual)) {
            throw new IllegalStateException("Received KEX command=" + SshConstants.getCommandMessageName(cmd) + " while in state=" + (Object)((Object)actual) + " instead of " + (Object)((Object)expected));
        }
    }

    @Override
    public void exceptionCaught(Throwable t) {
        int code;
        AbstractCloseable.State curState = (AbstractCloseable.State)((Object)this.state.get());
        if (!AbstractCloseable.State.Opened.equals((Object)curState) && !AbstractCloseable.State.Graceful.equals((Object)curState)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("exceptionCaught({}) ignore {} due to state={}, message='{}'", new Object[]{this, t.getClass().getSimpleName(), curState, t.getMessage()});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("exceptionCaught(" + this + ")[state=" + (Object)((Object)curState) + "] ignored exception details", t);
            }
            return;
        }
        this.log.warn("exceptionCaught({})[state={}] {}: {}", new Object[]{this, curState, t.getClass().getSimpleName(), t.getMessage()});
        if (this.log.isDebugEnabled()) {
            this.log.debug("exceptionCaught(" + this + ")[state=" + (Object)((Object)curState) + "] details", t);
        }
        this.signalExceptionCaught(t);
        if (AbstractCloseable.State.Opened.equals((Object)curState) && t instanceof SshException && (code = ((SshException)t).getDisconnectCode()) > 0) {
            block8: {
                try {
                    this.disconnect(code, t.getMessage());
                }
                catch (Throwable t2) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("exceptionCaught({}) {} while disconnect with code={}: {}", this, t2.getClass().getSimpleName(), SshConstants.getDisconnectReasonName(code), t2.getMessage());
                    }
                    if (!this.log.isTraceEnabled()) break block8;
                    this.log.trace("exceptionCaught(" + this + ")[code=" + SshConstants.getDisconnectReasonName(code) + "] disconnect exception details", t2);
                }
            }
            return;
        }
        this.close(true);
    }

    protected void signalExceptionCaught(Throwable t) {
        block4: {
            try {
                this.invokeSessionSignaller(l -> {
                    this.signalExceptionCaught((SessionListener)l, t);
                    return null;
                });
            }
            catch (Throwable err) {
                Throwable[] suppressed;
                Throwable e = GenericUtils.peelException(err);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("exceptionCaught(" + this + ") signal session exception details", e);
                }
                if (!this.log.isTraceEnabled() || GenericUtils.length(suppressed = e.getSuppressed()) <= 0) break block4;
                for (Throwable s : suppressed) {
                    this.log.trace("exceptionCaught(" + this + ") suppressed session exception signalling", s);
                }
            }
        }
    }

    protected void signalExceptionCaught(SessionListener listener, Throwable t) {
        if (listener == null) {
            return;
        }
        listener.sessionException(this, t);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().parallel(this.toString(), this.getServices()).close(this.ioSession).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preClose() {
        Object object;
        DefaultKeyExchangeFuture kexFuture = this.kexFutureHolder.get();
        if (kexFuture != null) {
            object = kexFuture;
            synchronized (object) {
                Object value = kexFuture.getValue();
                if (value == null) {
                    kexFuture.setValue(new SshException("Session closing while KEX in progress"));
                }
            }
        }
        object = this.requestResult;
        synchronized (object) {
            this.requestResult.set(GenericUtils.NULL);
            this.requestResult.notifyAll();
        }
        try {
            this.signalSessionClosed();
        }
        finally {
            this.sessionListeners.clear();
            this.channelListeners.clear();
            this.tunnelListeners.clear();
        }
        super.preClose();
    }

    protected void signalSessionClosed() {
        block4: {
            try {
                this.invokeSessionSignaller(l -> {
                    this.signalSessionClosed((SessionListener)l);
                    return null;
                });
            }
            catch (Throwable err) {
                Throwable[] suppressed;
                Throwable e = GenericUtils.peelException(err);
                this.log.warn("signalSessionClosed({}) {} while signal session closed: {}", this, e.getClass().getSimpleName(), e.getMessage());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("signalSessionClosed(" + this + ") signal session closed exception details", e);
                }
                if (!this.log.isTraceEnabled() || GenericUtils.length(suppressed = e.getSuppressed()) <= 0) break block4;
                for (Throwable s : suppressed) {
                    this.log.trace("signalSessionClosed(" + this + ") suppressed session closed signalling", s);
                }
            }
        }
    }

    protected void signalSessionClosed(SessionListener listener) {
        if (listener == null) {
            return;
        }
        listener.sessionClosed(this);
    }

    protected List<Service> getServices() {
        return this.currentService != null ? Collections.singletonList(this.currentService) : Collections.emptyList();
    }

    @Override
    public <T extends Service> T getService(Class<T> clazz) {
        List<Service> registeredServices = this.getServices();
        ValidateUtils.checkState(GenericUtils.isNotEmpty(registeredServices), "No registered services to look for %s", (Object)clazz.getSimpleName());
        for (Service s : registeredServices) {
            if (!clazz.isInstance(s)) continue;
            return (T)((Service)clazz.cast(s));
        }
        throw new IllegalStateException("Attempted to access unknown service " + clazz.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoWriteFuture writePacket(Buffer buffer) throws IOException {
        byte cmd;
        if (!KexState.DONE.equals((Object)this.kexState.get()) && (cmd = buffer.array()[buffer.rpos()]) > 49) {
            String cmdName = SshConstants.getCommandMessageName(cmd & 0xFF);
            Queue<PendingWriteFuture> queue = this.pendingPackets;
            synchronized (queue) {
                if (!KexState.DONE.equals((Object)this.kexState.get())) {
                    if (this.pendingPackets.isEmpty()) {
                        this.log.debug("writePacket({})[{}] Start flagging packets as pending until key exchange is done", (Object)this, (Object)cmdName);
                    }
                    PendingWriteFuture future = new PendingWriteFuture((Object)cmdName, buffer);
                    this.pendingPackets.add(future);
                    return future;
                }
            }
        }
        try {
            IoWriteFuture ioWriteFuture = this.doWritePacket(buffer);
            return ioWriteFuture;
        }
        finally {
            this.resetIdleTimeout();
            this.checkRekey();
        }
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer, long timeout, TimeUnit unit) throws IOException {
        IoWriteFuture writeFuture = this.writePacket(buffer);
        DefaultSshFuture future = (DefaultSshFuture)((Object)writeFuture);
        ScheduledExecutorService executor = this.factoryManager.getScheduledExecutorService();
        ScheduledFuture<?> sched = executor.schedule(() -> {
            TimeoutException t = new TimeoutException("Timeout writing packet: " + timeout + " " + (Object)((Object)unit));
            if (this.log.isDebugEnabled()) {
                this.log.debug("writePacket({}): {}", (Object)this, (Object)t.getMessage());
            }
            future.setValue(t);
        }, timeout, unit);
        future.addListener(f -> sched.cancel(false));
        return writeFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IoWriteFuture doWritePacket(Buffer buffer) throws IOException {
        IoWriteFuture future;
        Buffer ignoreBuf = null;
        int ignoreDataLen = this.resolveIgnoreBufferDataLength();
        if (ignoreDataLen > 0) {
            ignoreBuf = this.createBuffer((byte)2, ignoreDataLen + 8);
            ignoreBuf.putInt(ignoreDataLen);
            int wpos = ignoreBuf.wpos();
            Random random = this.random;
            synchronized (random) {
                this.random.fill(ignoreBuf.array(), wpos, ignoreDataLen);
            }
            ignoreBuf.wpos(wpos + ignoreDataLen);
            if (this.log.isDebugEnabled()) {
                this.log.debug("doWritePacket({}) append SSH_MSG_IGNORE message", (Object)this);
            }
        }
        int curPos = buffer.rpos();
        byte[] data = buffer.array();
        int cmd = data[curPos] & 0xFF;
        buffer = this.validateTargetBuffer(cmd, buffer);
        Object object = this.encodeLock;
        synchronized (object) {
            if (ignoreBuf != null) {
                ignoreBuf = this.encode(ignoreBuf);
                this.ioSession.writePacket(ignoreBuf);
            }
            buffer = this.encode(buffer);
            future = this.ioSession.writePacket(buffer);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int resolveIgnoreBufferDataLength() {
        if (this.ignorePacketDataLength <= 0 || this.ignorePacketsFrequency <= 0L || this.ignorePacketsVariance < 0) {
            return 0;
        }
        long count = this.ignorePacketsCount.decrementAndGet();
        if (count > 0L) {
            return 0;
        }
        Random random = this.random;
        synchronized (random) {
            this.ignorePacketsCount.set(this.calculateNextIgnorePacketCount(this.random, this.ignorePacketsFrequency, this.ignorePacketsVariance));
            return this.ignorePacketDataLength + this.random.random(this.ignorePacketDataLength);
        }
    }

    protected long calculateNextIgnorePacketCount(Random r, long freq, int variance) {
        long count;
        if (freq <= 0L || variance < 0) {
            return -1L;
        }
        if (variance == 0) {
            return freq;
        }
        int extra = r.random(variance < 0 ? 0 - variance : variance);
        long l = count = variance < 0 ? freq - (long)extra : freq + (long)extra;
        if (this.log.isTraceEnabled()) {
            this.log.trace("calculateNextIgnorePacketCount({}) count={}", (Object)this, (Object)count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer request(String request, Buffer buffer, long timeout, TimeUnit unit) throws IOException {
        Object result;
        ValidateUtils.checkTrue(timeout > 0L, "Non-positive timeout requested: %d", timeout);
        long maxWaitMillis = TimeUnit.MILLISECONDS.convert(timeout, unit);
        if (maxWaitMillis <= 0L) {
            throw new IllegalArgumentException("Requested timeout for " + request + " below 1 msec: " + timeout + " " + (Object)((Object)unit));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("request({}) request={}, timeout={} {}", new Object[]{this, request, timeout, unit});
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        Object object = this.requestLock;
        synchronized (object) {
            try {
                this.writePacket(buffer);
                AtomicReference<Object> atomicReference = this.requestResult;
                synchronized (atomicReference) {
                    while (this.isOpen() && maxWaitMillis > 0L && this.requestResult.get() == null) {
                        if (traceEnabled) {
                            this.log.trace("request({})[{}] remaining wait={}", this, request, maxWaitMillis);
                        }
                        long waitStart = System.nanoTime();
                        this.requestResult.wait(maxWaitMillis);
                        long waitEnd = System.nanoTime();
                        long waitDuration = waitEnd - waitStart;
                        long waitMillis = TimeUnit.NANOSECONDS.toMillis(waitDuration);
                        if (waitMillis > 0L) {
                            maxWaitMillis -= waitMillis;
                            continue;
                        }
                        --maxWaitMillis;
                    }
                    result = this.requestResult.getAndSet(null);
                }
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted while waiting for request=" + request + " result").initCause(e);
            }
        }
        if (!this.isOpen()) {
            throw new IOException("Session is closed or closing while awaiting reply for request=" + request);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("request({}) request={}, timeout={} {}, result received={}", new Object[]{this, request, timeout, unit, result != null});
        }
        if (result == null) {
            throw new SocketTimeoutException("No response received after " + timeout + " " + (Object)((Object)unit) + " for request=" + request);
        }
        if (result instanceof Buffer) {
            return result;
        }
        return null;
    }

    @Override
    public Buffer createBuffer(byte cmd) {
        return this.createBuffer(cmd, 0);
    }

    @Override
    public Buffer createBuffer(byte cmd, int len) {
        if (len <= 0) {
            return this.prepareBuffer(cmd, new ByteArrayBuffer());
        }
        int bsize = this.outCipherSize;
        int pad = -(len += 5) & bsize - 1;
        if (pad < bsize) {
            pad += bsize;
        }
        len = len + pad - 4;
        if (this.outMac != null) {
            len += this.outMac.getBlockSize();
        }
        return this.prepareBuffer(cmd, new ByteArrayBuffer(new byte[len + 8], false));
    }

    @Override
    public Buffer prepareBuffer(byte cmd, Buffer buffer) {
        buffer = this.validateTargetBuffer(cmd & 0xFF, buffer);
        buffer.rpos(5);
        buffer.wpos(5);
        buffer.putByte(cmd);
        return buffer;
    }

    protected <B extends Buffer> B validateTargetBuffer(int cmd, B buffer) {
        ValidateUtils.checkNotNull(buffer, "No target buffer to examine for command=%d", cmd);
        ValidateUtils.checkTrue(buffer != this.decoderBuffer, "Not allowed to use the internal decoder buffer for command=%d", cmd);
        ValidateUtils.checkTrue(buffer != this.uncompressBuffer, "Not allowed to use the internal uncompress buffer for command=%d", cmd);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer encode(Buffer buffer) throws IOException {
        try {
            int curPos = buffer.rpos();
            if (curPos < 5) {
                byte[] data = buffer.array();
                int cmd = data[curPos] & 0xFF;
                this.log.warn("encode({}) command={} performance cost: available buffer packet header length ({}) below min. required ({})", this, SshConstants.getCommandMessageName(cmd), curPos, 5);
                ByteArrayBuffer nb = new ByteArrayBuffer(buffer.available() + 64, false);
                ((Buffer)nb).wpos(5);
                nb.putBuffer(buffer);
                buffer = nb;
                curPos = buffer.rpos();
            }
            int len = buffer.available();
            int off = curPos - 5;
            if (this.log.isTraceEnabled()) {
                buffer.dumpHex(this.getSimplifiedLogger(), "encode(" + this + ") packet #" + this.seqo, this);
            }
            if (this.outCompression != null && this.outCompression.isCompressionExecuted() && (this.authed || !this.outCompression.isDelayed())) {
                this.outCompression.compress(buffer);
                len = buffer.available();
            }
            int bsize = this.outCipherSize;
            int oldLen = len;
            int pad = -(len += 5) & bsize - 1;
            if (pad < bsize) {
                pad += bsize;
            }
            len = len + pad - 4;
            buffer.wpos(off);
            buffer.putInt(len);
            buffer.putByte((byte)pad);
            buffer.wpos(off + oldLen + 5 + pad);
            Random random = this.random;
            synchronized (random) {
                this.random.fill(buffer.array(), buffer.wpos() - pad, pad);
            }
            if (this.outMac != null) {
                int macSize = this.outMac.getBlockSize();
                int l = buffer.wpos();
                buffer.wpos(l + macSize);
                this.outMac.updateUInt(this.seqo);
                this.outMac.update(buffer.array(), off, l);
                this.outMac.doFinal(buffer.array(), l);
            }
            if (this.outCipher != null) {
                this.outCipher.update(buffer.array(), off, len + 4);
                int blocksCount = (len + 4) / this.outCipher.getBlockSize();
                this.outBlocksCount.addAndGet(Math.max(1, blocksCount));
            }
            this.seqo = this.seqo + 1L & 0xFFFFFFFFL;
            this.outPacketsCount.incrementAndGet();
            this.outBytesCount.addAndGet(len);
            buffer.rpos(off);
            return buffer;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    protected void decode() throws Exception {
        while (true) {
            SessionWorkBuffer packet;
            int macSize;
            if (this.decoderState == 0) {
                assert (this.decoderBuffer.rpos() == 0);
                if (this.decoderBuffer.available() <= this.inCipherSize) break;
                if (this.inCipher != null) {
                    this.inCipher.update(this.decoderBuffer.array(), 0, this.inCipherSize);
                    int blocksCount = this.inCipherSize / this.inCipher.getBlockSize();
                    this.inBlocksCount.addAndGet(Math.max(1, blocksCount));
                }
                this.decoderLength = this.decoderBuffer.getInt();
                if (this.decoderLength < 5 || this.decoderLength > 262144) {
                    this.log.warn("decode({}) Error decoding packet(invalid length): {}", (Object)this, (Object)this.decoderLength);
                    this.decoderBuffer.dumpHex(this.getSimplifiedLogger(), "decode(" + this + ") invalid length packet", this);
                    throw new SshException(2, "Invalid packet length: " + this.decoderLength);
                }
                this.decoderState = 1;
                continue;
            }
            if (this.decoderState != 1) continue;
            assert (this.decoderBuffer.rpos() == 4);
            int n = macSize = this.inMac != null ? this.inMac.getBlockSize() : 0;
            if (this.decoderBuffer.available() < this.decoderLength + macSize) break;
            byte[] data = this.decoderBuffer.array();
            if (this.inCipher != null) {
                int updateLen = this.decoderLength + 4 - this.inCipherSize;
                this.inCipher.update(data, this.inCipherSize, updateLen);
                int blocksCount = updateLen / this.inCipher.getBlockSize();
                this.inBlocksCount.addAndGet(Math.max(1, blocksCount));
            }
            if (this.inMac != null) {
                this.inMac.updateUInt(this.seqi);
                this.inMac.update(data, 0, this.decoderLength + 4);
                this.inMac.doFinal(this.inMacResult, 0);
                if (!BufferUtils.equals(this.inMacResult, 0, data, this.decoderLength + 4, macSize)) {
                    throw new SshException(5, "MAC Error");
                }
            }
            this.seqi = this.seqi + 1L & 0xFFFFFFFFL;
            int pad = this.decoderBuffer.getUByte();
            int wpos = this.decoderBuffer.wpos();
            if (this.inCompression != null && this.inCompression.isCompressionExecuted() && (this.authed || !this.inCompression.isDelayed())) {
                if (this.uncompressBuffer == null) {
                    this.uncompressBuffer = new SessionWorkBuffer(this);
                } else {
                    this.uncompressBuffer.forceClear(true);
                }
                this.decoderBuffer.wpos(this.decoderBuffer.rpos() + this.decoderLength - 1 - pad);
                this.inCompression.uncompress(this.decoderBuffer, this.uncompressBuffer);
                packet = this.uncompressBuffer;
            } else {
                this.decoderBuffer.wpos(this.decoderLength + 4 - pad);
                packet = this.decoderBuffer;
            }
            if (this.log.isTraceEnabled()) {
                packet.dumpHex(this.getSimplifiedLogger(), "decode(" + this + ") packet #" + this.seqi, this);
            }
            this.inPacketsCount.incrementAndGet();
            this.inBytesCount.addAndGet(packet.available());
            this.handleMessage(packet);
            this.decoderBuffer.rpos(this.decoderLength + 4 + macSize);
            this.decoderBuffer.wpos(wpos);
            this.decoderBuffer.compact();
            this.decoderState = 0;
        }
    }

    protected String resolveIdentificationString(String configPropName) {
        FactoryManager manager = this.getFactoryManager();
        String ident = manager.getString(configPropName);
        return "SSH-2.0-" + (GenericUtils.isEmpty(ident) ? manager.getVersion() : ident);
    }

    protected IoWriteFuture sendIdentification(String ident) throws IOException {
        byte[] data = (ident + "\r\n").getBytes(StandardCharsets.UTF_8);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendIdentification({}): {}", (Object)this, (Object)ident.replace('\r', '|').replace('\n', '|'));
        }
        return this.ioSession.writePacket(new ByteArrayBuffer(data));
    }

    protected abstract boolean readIdentification(Buffer var1) throws IOException;

    protected List<String> doReadIdentification(Buffer buffer, boolean server) {
        int maxIdentSize = PropertyResolverUtils.getIntProperty(this, "max-identification-size", 16384);
        ArrayList<String> ident = null;
        int rpos = buffer.rpos();
        byte[] data = new byte[256];
        do {
            int pos = 0;
            boolean needLf = false;
            while (true) {
                if (buffer.available() == 0) {
                    buffer.rpos(rpos);
                    return null;
                }
                byte b = buffer.getByte();
                if (b == 0) {
                    throw new IllegalStateException("Incorrect identification (null characters not allowed) -  at line " + (GenericUtils.size(ident) + 1) + " character #" + (pos + 1) + " after '" + new String(data, 0, pos, StandardCharsets.UTF_8) + "'");
                }
                if (b == 13) {
                    needLf = true;
                    continue;
                }
                if (b == 10) break;
                if (needLf) {
                    throw new IllegalStateException("Incorrect identification (bad line ending)  at line " + (GenericUtils.size(ident) + 1) + ": " + new String(data, 0, pos, StandardCharsets.UTF_8));
                }
                if (pos >= data.length) {
                    throw new IllegalStateException("Incorrect identification (line too long):  at line " + (GenericUtils.size(ident) + 1) + ": " + new String(data, 0, pos, StandardCharsets.UTF_8));
                }
                data[pos++] = b;
            }
            String str = new String(data, 0, pos, StandardCharsets.UTF_8);
            if (this.log.isDebugEnabled()) {
                this.log.debug("doReadIdentification({}) line='{}'", (Object)this, (Object)str);
            }
            if (ident == null) {
                ident = new ArrayList<String>();
            }
            ident.add(str);
            if (!server && !str.startsWith("SSH-")) continue;
            return ident;
        } while (buffer.rpos() <= maxIdentSize);
        throw new IllegalStateException("Incorrect identification (too many header lines): size > " + maxIdentSize);
    }

    protected Map<KexProposalOption, String> createProposal(String hostKeyTypes) {
        EnumMap<KexProposalOption, String> proposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
        proposal.put(KexProposalOption.ALGORITHMS, NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getKeyExchangeFactories(), "No KEX factories", new Object[0])));
        proposal.put(KexProposalOption.SERVERKEYS, hostKeyTypes);
        String ciphers = NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getCipherFactories(), "No cipher factories", new Object[0]));
        proposal.put(KexProposalOption.S2CENC, ciphers);
        proposal.put(KexProposalOption.C2SENC, ciphers);
        String macs = NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getMacFactories(), "No MAC factories", new Object[0]));
        proposal.put(KexProposalOption.S2CMAC, macs);
        proposal.put(KexProposalOption.C2SMAC, macs);
        String compressions = NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getCompressionFactories(), "No compression factories", new Object[0]));
        proposal.put(KexProposalOption.S2CCOMP, compressions);
        proposal.put(KexProposalOption.C2SCOMP, compressions);
        proposal.put(KexProposalOption.S2CLANG, "");
        proposal.put(KexProposalOption.C2SLANG, "");
        return proposal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendKexInit(Map<KexProposalOption, String> proposal) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendKexInit({}) Send SSH_MSG_KEXINIT", (Object)this);
        }
        Buffer buffer = this.createBuffer((byte)20);
        int p = buffer.wpos();
        buffer.wpos(p + 16);
        Random random = this.random;
        synchronized (random) {
            this.random.fill(buffer.array(), p, 16);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendKexInit({}) cookie={}", (Object)this, (Object)BufferUtils.toHex(buffer.array(), p, 16, ':'));
        }
        for (KexProposalOption paramType : KexProposalOption.VALUES) {
            String s = proposal.get((Object)paramType);
            if (this.log.isTraceEnabled()) {
                this.log.trace("sendKexInit({})[{}] {}", this, paramType.getDescription(), s);
            }
            buffer.putString(GenericUtils.trimToEmpty(s));
        }
        buffer.putBoolean(false);
        buffer.putInt(0L);
        byte[] data = buffer.getCompactData();
        this.writePacket(buffer);
        return data;
    }

    protected byte[] receiveKexInit(Buffer buffer, Map<KexProposalOption, String> proposal) {
        long reserved;
        byte[] d = buffer.array();
        byte[] data = new byte[buffer.available() + 1];
        data[0] = 20;
        int size = 6;
        int cookieStartPos = buffer.rpos();
        System.arraycopy(d, cookieStartPos, data, 1, data.length - 1);
        buffer.rpos(cookieStartPos + 16);
        size += 16;
        if (this.log.isTraceEnabled()) {
            this.log.trace("receiveKexInit({}) cookie={}", (Object)this, (Object)BufferUtils.toHex(d, cookieStartPos, 16, ':'));
        }
        for (KexProposalOption paramType : KexProposalOption.VALUES) {
            int lastPos = buffer.rpos();
            String value = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("receiveKexInit({})[{}] {}", this, paramType.getDescription(), value);
            }
            int curPos = buffer.rpos();
            int readLen = curPos - lastPos;
            proposal.put(paramType, value);
            size += readLen;
        }
        this.firstKexPacketFollows = buffer.getBoolean();
        if (this.log.isTraceEnabled()) {
            this.log.trace("receiveKexInit({}) first kex packet follows: {}", (Object)this, (Object)this.firstKexPacketFollows);
        }
        if ((reserved = buffer.getUInt()) != 0L && this.log.isTraceEnabled()) {
            this.log.trace("receiveKexInit({}) non-zero reserved value: {}", (Object)this, (Object)reserved);
        }
        byte[] dataShrinked = new byte[size];
        System.arraycopy(data, 0, dataShrinked, 0, size);
        return dataShrinked;
    }

    protected IoWriteFuture sendNewKeys() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendNewKeys({}) Send SSH_MSG_NEWKEYS", (Object)this);
        }
        Buffer buffer = this.createBuffer((byte)21, 8);
        return this.writePacket(buffer);
    }

    protected void receiveNewKeys() throws Exception {
        int j;
        byte[] k = this.kex.getK();
        byte[] h = this.kex.getH();
        Digest hash = this.kex.getHash();
        if (this.sessionId == null) {
            this.sessionId = (byte[])h.clone();
            if (this.log.isDebugEnabled()) {
                this.log.debug("receiveNewKeys({}) session ID={}", (Object)this, (Object)BufferUtils.toHex(':', this.sessionId));
            }
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putMPInt(k);
        buffer.putRawBytes(h);
        ((Buffer)buffer).putByte((byte)65);
        buffer.putRawBytes(this.sessionId);
        int pos = buffer.available();
        byte[] buf = ((Buffer)buffer).array();
        hash.update(buf, 0, pos);
        byte[] iv_c2s = hash.digest();
        int n = j = pos - this.sessionId.length - 1;
        buf[n] = (byte)(buf[n] + 1);
        hash.update(buf, 0, pos);
        byte[] iv_s2c = hash.digest();
        int n2 = j;
        buf[n2] = (byte)(buf[n2] + 1);
        hash.update(buf, 0, pos);
        byte[] e_c2s = hash.digest();
        int n3 = j;
        buf[n3] = (byte)(buf[n3] + 1);
        hash.update(buf, 0, pos);
        byte[] e_s2c = hash.digest();
        int n4 = j;
        buf[n4] = (byte)(buf[n4] + 1);
        hash.update(buf, 0, pos);
        byte[] mac_c2s = hash.digest();
        int n5 = j;
        buf[n5] = (byte)(buf[n5] + 1);
        hash.update(buf, 0, pos);
        byte[] mac_s2c = hash.digest();
        String value = this.getNegotiatedKexParameter(KexProposalOption.S2CENC);
        Cipher s2ccipher = ValidateUtils.checkNotNull(NamedFactory.create(this.getCipherFactories(), value), "Unknown s2c cipher: %s", (Object)value);
        e_s2c = this.resizeKey(e_s2c, s2ccipher.getBlockSize(), hash, k, h);
        s2ccipher.init(this.isServer ? Cipher.Mode.Encrypt : Cipher.Mode.Decrypt, e_s2c, iv_s2c);
        value = this.getNegotiatedKexParameter(KexProposalOption.S2CMAC);
        Mac s2cmac = NamedFactory.create(this.getMacFactories(), value);
        if (s2cmac == null) {
            throw new SshException(5, "Unknown s2c MAC: " + value);
        }
        mac_s2c = this.resizeKey(mac_s2c, s2cmac.getBlockSize(), hash, k, h);
        s2cmac.init(mac_s2c);
        value = this.getNegotiatedKexParameter(KexProposalOption.S2CCOMP);
        Compression s2ccomp = NamedFactory.create(this.getCompressionFactories(), value);
        if (s2ccomp == null) {
            throw new SshException(6, "Unknown s2c compression: " + value);
        }
        value = this.getNegotiatedKexParameter(KexProposalOption.C2SENC);
        Cipher c2scipher = ValidateUtils.checkNotNull(NamedFactory.create(this.getCipherFactories(), value), "Unknown c2s cipher: %s", (Object)value);
        e_c2s = this.resizeKey(e_c2s, c2scipher.getBlockSize(), hash, k, h);
        c2scipher.init(this.isServer ? Cipher.Mode.Decrypt : Cipher.Mode.Encrypt, e_c2s, iv_c2s);
        value = this.getNegotiatedKexParameter(KexProposalOption.C2SMAC);
        Mac c2smac = NamedFactory.create(this.getMacFactories(), value);
        if (c2smac == null) {
            throw new SshException(5, "Unknown c2s MAC: " + value);
        }
        mac_c2s = this.resizeKey(mac_c2s, c2smac.getBlockSize(), hash, k, h);
        c2smac.init(mac_c2s);
        value = this.getNegotiatedKexParameter(KexProposalOption.C2SCOMP);
        Compression c2scomp = NamedFactory.create(this.getCompressionFactories(), value);
        if (c2scomp == null) {
            throw new SshException(6, "Unknown c2s compression: " + value);
        }
        if (this.isServer) {
            this.outCipher = s2ccipher;
            this.outMac = s2cmac;
            this.outCompression = s2ccomp;
            this.inCipher = c2scipher;
            this.inMac = c2smac;
            this.inCompression = c2scomp;
        } else {
            this.outCipher = c2scipher;
            this.outMac = c2smac;
            this.outCompression = c2scomp;
            this.inCipher = s2ccipher;
            this.inMac = s2cmac;
            this.inCompression = s2ccomp;
        }
        this.outCipherSize = this.outCipher.getIVSize();
        this.outCompression.init(Compression.Type.Deflater, -1);
        this.inCipherSize = this.inCipher.getIVSize();
        this.inMacResult = new byte[this.inMac.getBlockSize()];
        this.inCompression.init(Compression.Type.Inflater, -1);
        int inBlockSize = this.inCipher.getBlockSize();
        int outBlockSize = this.outCipher.getBlockSize();
        int avgCipherBlockSize = Math.min(inBlockSize, outBlockSize);
        long recommendedByteRekeyBlocks = 1L << Math.min(avgCipherBlockSize * 8 / 4, 63);
        this.maxRekeyBlocks.set(this.getLongProperty("rekey-blocks-limit", recommendedByteRekeyBlocks));
        if (this.log.isDebugEnabled()) {
            this.log.debug("receiveNewKeys({}) inCipher={}, outCipher={}, recommended blocks limit={}, actual={}", this, this.inCipher, this.outCipher, recommendedByteRekeyBlocks, this.maxRekeyBlocks);
        }
        this.inBytesCount.set(0L);
        this.outBytesCount.set(0L);
        this.inPacketsCount.set(0L);
        this.outPacketsCount.set(0L);
        this.inBlocksCount.set(0L);
        this.outBlocksCount.set(0L);
        this.lastKeyTimeValue.set(System.currentTimeMillis());
        this.firstKexPacketFollows = null;
    }

    protected byte[] resizeKey(byte[] e, int blockSize, Digest hash, byte[] k, byte[] h) throws Exception {
        Buffer buffer = null;
        while (blockSize > e.length) {
            if (buffer == null) {
                buffer = new ByteArrayBuffer();
            }
            buffer.putMPInt(k);
            buffer.putRawBytes(h);
            buffer.putRawBytes(e);
            hash.update(buffer.array(), 0, buffer.available());
            byte[] foo = hash.digest();
            byte[] bar = new byte[e.length + foo.length];
            System.arraycopy(e, 0, bar, 0, e.length);
            System.arraycopy(foo, 0, bar, e.length, foo.length);
            e = bar;
            buffer = BufferUtils.clear(buffer);
        }
        return e;
    }

    @Override
    public void disconnect(int reason, String msg) throws IOException {
        this.log.info("Disconnecting({}): {} - {}", this, SshConstants.getDisconnectReasonName(reason), msg);
        Buffer buffer = this.createBuffer((byte)1, msg.length() + 16);
        buffer.putInt(reason);
        buffer.putString(msg);
        buffer.putString("");
        long disconnectTimeoutMs = this.getLongProperty("disconnect-timeout", FactoryManager.DEFAULT_DISCONNECT_TIMEOUT);
        this.writePacket(buffer, disconnectTimeoutMs, TimeUnit.MILLISECONDS).addListener(future -> {
            Throwable t = future.getException();
            if (this.log.isDebugEnabled()) {
                if (t == null) {
                    this.log.debug("disconnect({}) operation successfully completed for reason={} [{}]", this, SshConstants.getDisconnectReasonName(reason), msg);
                } else {
                    this.log.debug("disconnect({}) operation failed ({}) for reason={} [{}]: {}", this, t.getClass().getSimpleName(), SshConstants.getDisconnectReasonName(reason), msg, t.getMessage());
                }
            }
            if (t != null && this.log.isTraceEnabled()) {
                this.log.trace("disconnect(" + this + ") reason=" + SshConstants.getDisconnectReasonName(reason) + " failure details", t);
            }
            this.close(true);
        });
    }

    protected IoWriteFuture notImplemented() throws IOException {
        return this.sendNotImplemented(this.seqi - 1L);
    }

    protected IoWriteFuture sendNotImplemented(long seqNoValue) throws IOException {
        Buffer buffer = this.createBuffer((byte)3, 8);
        buffer.putInt(seqNoValue);
        return this.writePacket(buffer);
    }

    protected Map<KexProposalOption, String> negotiate() {
        Map<KexProposalOption, String> c2sOptions = Collections.unmodifiableMap(this.clientProposal);
        Map<KexProposalOption, String> s2cOptions = Collections.unmodifiableMap(this.serverProposal);
        this.signalNegotiationStart(c2sOptions, s2cOptions);
        EnumMap<KexProposalOption, String> guess = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
        Map<KexProposalOption, String> negotiatedGuess = Collections.unmodifiableMap(guess);
        try {
            for (KexProposalOption paramType : KexProposalOption.VALUES) {
                String value;
                String clientParamValue = c2sOptions.get((Object)paramType);
                String serverParamValue = s2cOptions.get((Object)paramType);
                String[] c = GenericUtils.split(clientParamValue, ',');
                String[] s = GenericUtils.split(serverParamValue, ',');
                for (String ci : c) {
                    String value2;
                    for (String si : s) {
                        if (!ci.equals(si)) continue;
                        guess.put(paramType, ci);
                        break;
                    }
                    if ((value2 = (String)guess.get((Object)paramType)) != null) break;
                }
                if ((value = (String)guess.get((Object)paramType)) == null) {
                    String message = "Unable to negotiate key exchange for " + paramType.getDescription() + " (client: " + clientParamValue + " / server: " + serverParamValue + ")";
                    if (KexProposalOption.S2CLANG.equals((Object)paramType) || KexProposalOption.C2SLANG.equals((Object)paramType)) {
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.trace("negotiate({}) {}", (Object)this, (Object)message);
                        continue;
                    }
                    throw new IllegalStateException(message);
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("negotiate(" + this + ")[" + paramType.getDescription() + "] guess=" + value + " (client: " + clientParamValue + " / server: " + serverParamValue + ")");
            }
        }
        catch (Error | RuntimeException e) {
            this.signalNegotiationEnd(c2sOptions, s2cOptions, negotiatedGuess, e);
            throw e;
        }
        this.signalNegotiationEnd(c2sOptions, s2cOptions, negotiatedGuess, null);
        return this.setNegotiationResult(guess);
    }

    protected void signalNegotiationStart(Map<KexProposalOption, String> c2sOptions, Map<KexProposalOption, String> s2cOptions) {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalNegotiationStart((SessionListener)l, c2sOptions, s2cOptions);
                return null;
            });
        }
        catch (Throwable err) {
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof Error) {
                throw (Error)err;
            }
            throw new RuntimeException(err);
        }
    }

    protected void signalNegotiationStart(SessionListener listener, Map<KexProposalOption, String> c2sOptions, Map<KexProposalOption, String> s2cOptions) {
        if (listener == null) {
            return;
        }
        listener.sessionNegotiationStart(this, c2sOptions, s2cOptions);
    }

    protected void signalNegotiationEnd(Map<KexProposalOption, String> c2sOptions, Map<KexProposalOption, String> s2cOptions, Map<KexProposalOption, String> negotiatedGuess, Throwable reason) {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalNegotiationEnd((SessionListener)l, c2sOptions, s2cOptions, negotiatedGuess, reason);
                return null;
            });
        }
        catch (Throwable err) {
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof Error) {
                throw (Error)err;
            }
            throw new RuntimeException(err);
        }
    }

    protected void signalNegotiationEnd(SessionListener listener, Map<KexProposalOption, String> c2sOptions, Map<KexProposalOption, String> s2cOptions, Map<KexProposalOption, String> negotiatedGuess, Throwable reason) {
        if (listener == null) {
            return;
        }
        listener.sessionNegotiationEnd(this, c2sOptions, s2cOptions, negotiatedGuess, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<KexProposalOption, String> setNegotiationResult(Map<KexProposalOption, String> guess) {
        Map<KexProposalOption, String> map = this.negotiationResult;
        synchronized (map) {
            if (!this.negotiationResult.isEmpty()) {
                this.negotiationResult.clear();
            }
            this.negotiationResult.putAll(guess);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setNegotiationResult({}) Kex: server->client {} {} {}", this, guess.get((Object)KexProposalOption.S2CENC), guess.get((Object)KexProposalOption.S2CMAC), guess.get((Object)KexProposalOption.S2CCOMP));
            this.log.debug("setNegotiationResult({}) Kex: client->server {} {} {}", this, guess.get((Object)KexProposalOption.C2SENC), guess.get((Object)KexProposalOption.C2SMAC), guess.get((Object)KexProposalOption.C2SCOMP));
        }
        return guess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestSuccess(Buffer buffer) throws Exception {
        ByteArrayBuffer resultBuf = ByteArrayBuffer.getCompactClone(buffer.array(), buffer.rpos(), buffer.available());
        AtomicReference<Object> atomicReference = this.requestResult;
        synchronized (atomicReference) {
            this.requestResult.set(resultBuf);
            this.resetIdleTimeout();
            this.requestResult.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestFailure(Buffer buffer) throws Exception {
        AtomicReference<Object> atomicReference = this.requestResult;
        synchronized (atomicReference) {
            this.requestResult.set(GenericUtils.NULL);
            this.resetIdleTimeout();
            this.requestResult.notifyAll();
        }
    }

    @Override
    public <T> T getAttribute(AttributeStore.AttributeKey<T> key) {
        return (T)this.attributes.get(Objects.requireNonNull(key, "No key"));
    }

    @Override
    public <T> T setAttribute(AttributeStore.AttributeKey<T> key, T value) {
        return (T)this.attributes.put(Objects.requireNonNull(key, "No key"), Objects.requireNonNull(value, "No value"));
    }

    @Override
    public <T> T removeAttribute(AttributeStore.AttributeKey<T> key) {
        return (T)this.attributes.remove(Objects.requireNonNull(key, "No key"));
    }

    @Override
    public <T> T resolveAttribute(AttributeStore.AttributeKey<T> key) {
        return AttributeStore.resolveAttribute(this, key);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    public Object getLock() {
        return this.lock;
    }

    @Override
    public ReservedSessionMessagesHandler getReservedSessionMessagesHandler() {
        return this.resolveEffectiveProvider(ReservedSessionMessagesHandler.class, this.reservedSessionMessagesHandler, this.getFactoryManager().getReservedSessionMessagesHandler());
    }

    @Override
    public void setReservedSessionMessagesHandler(ReservedSessionMessagesHandler handler) {
        this.reservedSessionMessagesHandler = handler;
    }

    @Override
    public void addSessionListener(SessionListener listener) {
        SessionListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addSessionListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.sessionListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addSessionListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addSessionListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removeSessionListener(SessionListener listener) {
        if (listener == null) {
            return;
        }
        SessionListener.validateListener(listener);
        if (this.sessionListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeSessionListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeSessionListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public SessionListener getSessionListenerProxy() {
        return this.sessionListenerProxy;
    }

    @Override
    public void addChannelListener(ChannelListener listener) {
        ChannelListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addChannelListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.channelListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addChannelListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addChannelListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removeChannelListener(ChannelListener listener) {
        if (listener == null) {
            return;
        }
        ChannelListener.validateListener(listener);
        if (this.channelListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeChannelListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeChannelListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public ChannelListener getChannelListenerProxy() {
        return this.channelListenerProxy;
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.tunnelListenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        PortForwardingEventListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addPortForwardingEventListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.tunnelListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addPortForwardingEventListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addPortForwardingEventListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        PortForwardingEventListener.validateListener(listener);
        if (this.tunnelListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removePortForwardingEventListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removePortForwardingEventListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    protected void signalSessionEvent(SessionListener.Event event) throws IOException {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalSessionEvent((SessionListener)l, event);
                return null;
            });
        }
        catch (Throwable err) {
            Throwable t = GenericUtils.peelException(err);
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendSessionEvent({})[{}] failed ({}) to inform listeners: {}", new Object[]{this, event, t.getClass().getSimpleName(), t.getMessage()});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("sendSessionEvent(" + this + ")[" + (Object)((Object)event) + "] listener inform details", t);
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to send session event: " + t.getMessage(), t);
        }
    }

    protected void signalSessionEvent(SessionListener listener, SessionListener.Event event) throws IOException {
        if (listener == null) {
            return;
        }
        listener.sessionEvent(this, event);
    }

    protected void invokeSessionSignaller(Invoker<SessionListener, Void> invoker) throws Throwable {
        FactoryManager manager = this.getFactoryManager();
        SessionListener[] listeners = new SessionListener[]{manager == null ? null : manager.getSessionListenerProxy(), this.getSessionListenerProxy()};
        Throwable err = null;
        for (SessionListener l : listeners) {
            if (l == null) continue;
            try {
                invoker.invoke(l);
            }
            catch (Throwable t) {
                err = GenericUtils.accumulateException(err, t);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    @Override
    public KeyExchangeFuture reExchangeKeys() throws IOException {
        this.requestNewKeysExchange();
        return ValidateUtils.checkNotNull(this.kexFutureHolder.get(), "No current KEX future on state=%s", (Object)this.kexState.get());
    }

    protected KeyExchangeFuture checkRekey() throws IOException {
        return this.isRekeyRequired() ? this.requestNewKeysExchange() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyExchangeFuture requestNewKeysExchange() throws IOException {
        if (!this.kexState.compareAndSet(KexState.DONE, KexState.INIT)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("requestNewKeysExchange({}) KEX state not DONE: {}", (Object)this, (Object)this.kexState.get());
            }
            return null;
        }
        this.log.info("requestNewKeysExchange({}) Initiating key re-exchange", (Object)this);
        this.sendKexInit();
        DefaultKeyExchangeFuture newFuture = new DefaultKeyExchangeFuture(this.toString(), null);
        DefaultKeyExchangeFuture kexFuture = this.kexFutureHolder.getAndSet(newFuture);
        if (kexFuture != null) {
            DefaultKeyExchangeFuture defaultKeyExchangeFuture = kexFuture;
            synchronized (defaultKeyExchangeFuture) {
                Object value = kexFuture.getValue();
                if (value == null) {
                    kexFuture.setValue(new SshException("New KEX started while previous one still ongoing"));
                }
            }
        }
        return newFuture;
    }

    protected boolean isRekeyRequired() {
        if (!this.isOpen() || this.isClosing() || this.isClosed()) {
            return false;
        }
        KexState curState = this.kexState.get();
        if (!KexState.DONE.equals((Object)curState)) {
            return false;
        }
        return this.isRekeyTimeIntervalExceeded() || this.isRekeyPacketCountsExceeded() || this.isRekeyBlocksCountExceeded() || this.isRekeyDataSizeExceeded();
    }

    protected boolean isRekeyTimeIntervalExceeded() {
        boolean rekey;
        if (this.maxRekeyInterval <= 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        long rekeyDiff = now - this.lastKeyTimeValue.get();
        boolean bl = rekey = rekeyDiff > this.maxRekeyInterval;
        if (rekey && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyTimeIntervalExceeded({}) re-keying: last={}, now={}, diff={}, max={}", this, new Date(this.lastKeyTimeValue.get()), new Date(now), rekeyDiff, this.maxRekeyInterval);
        }
        return rekey;
    }

    protected boolean isRekeyPacketCountsExceeded() {
        boolean rekey;
        if (this.maxRekyPackets <= 0L) {
            return false;
        }
        boolean bl = rekey = this.inPacketsCount.get() > this.maxRekyPackets || this.outPacketsCount.get() > this.maxRekyPackets;
        if (rekey && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyPacketCountsExceeded({}) re-keying: in={}, out={}, max={}", this, this.inPacketsCount, this.outPacketsCount, this.maxRekyPackets);
        }
        return rekey;
    }

    protected boolean isRekeyDataSizeExceeded() {
        boolean rekey;
        if (this.maxRekeyBytes <= 0L) {
            return false;
        }
        boolean bl = rekey = this.inBytesCount.get() > this.maxRekeyBytes || this.outBytesCount.get() > this.maxRekeyBytes;
        if (rekey && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyDataSizeExceeded({}) re-keying: in={}, out={}, max={}", this, this.inBytesCount, this.outBytesCount, this.maxRekeyBytes);
        }
        return rekey;
    }

    protected boolean isRekeyBlocksCountExceeded() {
        boolean rekey;
        long maxBlocks = this.maxRekeyBlocks.get();
        if (maxBlocks <= 0L) {
            return false;
        }
        boolean bl = rekey = this.inBlocksCount.get() > maxBlocks || this.outBlocksCount.get() > maxBlocks;
        if (rekey && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyBlocksCountExceeded({}) re-keying: in={}, out={}, max={}", this, this.inBlocksCount, this.outBlocksCount, maxBlocks);
        }
        return rekey;
    }

    protected byte[] sendKexInit() throws IOException {
        String resolvedAlgorithms = this.resolveAvailableSignaturesProposal();
        if (GenericUtils.isEmpty(resolvedAlgorithms)) {
            throw new SshException(9, "sendKexInit() no resolved signatures available");
        }
        Map<KexProposalOption, String> proposal = this.createProposal(resolvedAlgorithms);
        byte[] seed = this.sendKexInit(proposal);
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendKexInit({}) proposal={} seed: {}", this, proposal, BufferUtils.toHex(':', seed));
        }
        this.setKexSeed(seed);
        return seed;
    }

    protected abstract void setKexSeed(byte ... var1);

    protected String resolveAvailableSignaturesProposal() {
        return this.resolveAvailableSignaturesProposal(this.getFactoryManager());
    }

    protected abstract String resolveAvailableSignaturesProposal(FactoryManager var1);

    protected abstract void checkKeys() throws IOException;

    protected void receiveKexInit(Buffer buffer) throws IOException {
        EnumMap<KexProposalOption, String> proposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
        byte[] seed = this.receiveKexInit(buffer, proposal);
        this.receiveKexInit(proposal, seed);
    }

    protected abstract void receiveKexInit(Map<KexProposalOption, String> var1, byte[] var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<KexProposalOption, String> mergeProposals(Map<KexProposalOption, String> current, Map<KexProposalOption, String> proposal) {
        if (current == proposal) {
            return proposal;
        }
        Map<KexProposalOption, String> map = current;
        synchronized (map) {
            if (!current.isEmpty()) {
                current.clear();
            }
            if (GenericUtils.isEmpty(proposal)) {
                return proposal;
            }
            current.putAll(proposal);
        }
        return proposal;
    }

    protected void checkForTimeouts() throws IOException {
        Session.TimeoutStatus status;
        if ((!this.isOpen() || this.isClosing() || this.isClosed()) && this.log.isDebugEnabled()) {
            this.log.debug("checkForTimeouts({}) session closing", (Object)this);
            return;
        }
        long now = System.currentTimeMillis();
        AbstractMap.SimpleImmutableEntry<Session.TimeoutStatus, String> result = this.checkAuthenticationTimeout(now, this.getAuthTimeout());
        if (result == null) {
            result = this.checkIdleTimeout(now, this.getIdleTimeout());
        }
        Session.TimeoutStatus timeoutStatus = status = result == null ? Session.TimeoutStatus.NoTimeout : (Session.TimeoutStatus)((Object)result.getKey());
        if (status == null || Session.TimeoutStatus.NoTimeout.equals((Object)status)) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("checkForTimeouts({}) disconnect - reason={}", (Object)this, (Object)status);
        }
        this.timeoutStatus.set(status);
        this.disconnect(2, (String)result.getValue());
    }

    protected AbstractMap.SimpleImmutableEntry<Session.TimeoutStatus, String> checkAuthenticationTimeout(long now, long authTimeoutMs) {
        long authDiff = now - this.authTimeoutStart;
        if (!this.authed && authTimeoutMs > 0L && authDiff > authTimeoutMs) {
            return new AbstractMap.SimpleImmutableEntry<Session.TimeoutStatus, String>(Session.TimeoutStatus.AuthTimeout, "Session has timed out waiting for authentication after " + authTimeoutMs + " ms.");
        }
        return null;
    }

    protected AbstractMap.SimpleImmutableEntry<Session.TimeoutStatus, String> checkIdleTimeout(long now, long idleTimeoutMs) {
        long idleDiff = now - this.idleTimeoutStart;
        if (idleTimeoutMs > 0L && idleDiff > idleTimeoutMs) {
            return new AbstractMap.SimpleImmutableEntry<Session.TimeoutStatus, String>(Session.TimeoutStatus.IdleTimeout, "User session has timed out idling after " + idleTimeoutMs + " ms.");
        }
        return null;
    }

    @Override
    public void resetIdleTimeout() {
        this.idleTimeoutStart = System.currentTimeMillis();
    }

    @Override
    public Session.TimeoutStatus getTimeoutStatus() {
        return this.timeoutStatus.get();
    }

    @Override
    public long getAuthTimeout() {
        return this.getLongProperty("auth-timeout", FactoryManager.DEFAULT_AUTH_TIMEOUT);
    }

    @Override
    public long getIdleTimeout() {
        return this.getLongProperty("idle-timeout", FactoryManager.DEFAULT_IDLE_TIMEOUT);
    }

    public String toString() {
        IoSession ioSession = this.getIoSession();
        SocketAddress peerAddress = ioSession == null ? null : ioSession.getRemoteAddress();
        return this.getClass().getSimpleName() + "[" + this.getUsername() + "@" + peerAddress + "]";
    }
}

