/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class ReservedSessionMessagesHandlerAdapter
extends AbstractLoggingBean
implements ReservedSessionMessagesHandler {
    public static final ReservedSessionMessagesHandlerAdapter DEFAULT = new ReservedSessionMessagesHandlerAdapter();

    @Override
    public void handleIgnoreMessage(Session session, Buffer buffer) throws Exception {
        this.handleIgnoreMessage(session, buffer.getBytes(), buffer);
    }

    public void handleIgnoreMessage(Session session, byte[] data, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleIgnoreMessage({}) SSH_MSG_IGNORE", (Object)session);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("handleIgnoreMessage({}) data: {}", (Object)session, (Object)BufferUtils.toHex(data));
        }
    }

    @Override
    public void handleDebugMessage(Session session, Buffer buffer) throws Exception {
        this.handleDebugMessage(session, buffer.getBoolean(), buffer.getString(), buffer.getString(), buffer);
    }

    public void handleDebugMessage(Session session, boolean display, String msg, String lang, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleDebugMessage({}) SSH_MSG_DEBUG (display={}) [lang={}] '{}'", session, display, lang, msg);
        }
    }

    @Override
    public void handleUnimplementedMessage(Session session, Buffer buffer) throws Exception {
        this.handleUnimplementedMessage(session, buffer, buffer.getUInt());
    }

    public void handleUnimplementedMessage(Session session, Buffer buffer, long seqNo) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleUnimplementedMessage({}) SSH_MSG_UNIMPLEMENTED - seqNo={}", (Object)session, (Object)seqNo);
        }
    }
}

