/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.kex;

import java.security.KeyPair;
import java.util.Objects;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.kex.AbstractDHServerKeyExchange;
import org.apache.sshd.server.session.ServerSession;

public class DHGServer
extends AbstractDHServerKeyExchange {
    protected final DHFactory factory;
    protected AbstractDH dh;

    protected DHGServer(DHFactory factory) {
        this.factory = Objects.requireNonNull(factory, "No factory");
    }

    @Override
    public final String getName() {
        return this.factory.getName();
    }

    public static KeyExchangeFactory newFactory(final DHFactory factory) {
        return new KeyExchangeFactory(){

            @Override
            public KeyExchange create() {
                return new DHGServer(factory);
            }

            @Override
            public String getName() {
                return factory.getName();
            }

            public String toString() {
                return NamedFactory.class.getSimpleName() + "<" + KeyExchange.class.getSimpleName() + ">[" + this.getName() + "]";
            }
        };
    }

    @Override
    public void init(Session s, byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        super.init(s, v_s, v_c, i_s, i_c);
        this.dh = this.factory.create(new Object[0]);
        this.hash = this.dh.getHash();
        this.hash.init();
        this.f = this.dh.getE();
    }

    @Override
    public boolean next(int cmd, Buffer buffer) throws Exception {
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("next({})[{}] process command={}", this, session, KeyExchange.getSimpleKexOpcodeName(cmd));
        }
        if (cmd != 30) {
            throw new SshException(3, "Protocol error: expected packet SSH_MSG_KEXDH_INIT, got " + KeyExchange.getSimpleKexOpcodeName(cmd));
        }
        this.e = buffer.getMPIntAsBytes();
        this.dh.setF(this.e);
        this.k = this.dh.getK();
        KeyPair kp = Objects.requireNonNull(session.getHostKey(), "No server key pair available");
        String algo = session.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
        Signature sig = ValidateUtils.checkNotNull(NamedFactory.create(session.getSignatureFactories(), algo), "Unknown negotiated server keys: %s", (Object)algo);
        sig.initSigner(kp.getPrivate());
        buffer = new ByteArrayBuffer();
        buffer.putRawPublicKey(kp.getPublic());
        byte[] k_s = buffer.getCompactData();
        buffer.clear();
        buffer.putBytes(this.v_c);
        buffer.putBytes(this.v_s);
        buffer.putBytes(this.i_c);
        buffer.putBytes(this.i_s);
        buffer.putBytes(k_s);
        buffer.putMPInt(this.e);
        buffer.putMPInt(this.f);
        buffer.putMPInt(this.k);
        this.hash.update(buffer.array(), 0, buffer.available());
        this.h = this.hash.digest();
        sig.update(this.h);
        buffer.clear();
        buffer.putString(algo);
        byte[] sigBytes = sig.sign();
        buffer.putBytes(sigBytes);
        byte[] sigH = buffer.getCompactData();
        if (this.log.isTraceEnabled()) {
            this.log.trace("next({})[{}][K_S]:  {}", this, session, BufferUtils.toHex(k_s));
            this.log.trace("next({})[{}][f]:    {}", this, session, BufferUtils.toHex(this.f));
            this.log.trace("next({})[{}][sigH]: {}", this, session, BufferUtils.toHex(sigH));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("next({})[{}] Send SSH_MSG_KEXDH_REPLY", (Object)this, (Object)session);
        }
        buffer = session.prepareBuffer((byte)31, BufferUtils.clear(buffer));
        buffer.putBytes(k_s);
        buffer.putBytes(this.f);
        buffer.putBytes(sigH);
        session.writePacket(buffer);
        return true;
    }
}

