/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.security.Principal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.IntUnaryOperator;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.VersionProperties;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.subsystem.sftp.SftpConstants;
import org.apache.sshd.common.subsystem.sftp.SftpException;
import org.apache.sshd.common.subsystem.sftp.SftpHelper;
import org.apache.sshd.common.subsystem.sftp.extensions.AclSupportedParser;
import org.apache.sshd.common.subsystem.sftp.extensions.SpaceAvailableExtensionInfo;
import org.apache.sshd.common.subsystem.sftp.extensions.openssh.AbstractOpenSSHExtensionParser;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.io.FileInfoExtractor;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.DirectoryHandle;
import org.apache.sshd.server.subsystem.sftp.Handle;
import org.apache.sshd.server.subsystem.sftp.InvalidHandleException;
import org.apache.sshd.server.subsystem.sftp.SftpErrorStatusDataHandler;
import org.apache.sshd.server.subsystem.sftp.SftpEventListener;
import org.apache.sshd.server.subsystem.sftp.SftpEventListenerManager;
import org.apache.sshd.server.subsystem.sftp.SftpFileSystemAccessor;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemEnvironment;
import org.apache.sshd.server.subsystem.sftp.UnsupportedAttributePolicy;

public abstract class AbstractSftpSubsystemHelper
extends AbstractLoggingBean
implements SftpEventListenerManager,
SftpSubsystemEnvironment {
    public static final String AUTO_FOLLOW_LINKS = "sftp-auto-follow-links";
    public static final boolean DEFAULT_AUTO_FOLLOW_LINKS = true;
    public static final String CLIENT_EXTENSIONS_PROP = "sftp-client-extensions";
    public static final Map<String, OptionalFeature> DEFAULT_SUPPORTED_CLIENT_EXTENSIONS = GenericUtils.mapBuilder().put("version-select", OptionalFeature.TRUE).put("copy-file", OptionalFeature.TRUE).put("md5-hash", BuiltinDigests.md5).put("md5-hash-handle", BuiltinDigests.md5).put("check-file-handle", OptionalFeature.any(BuiltinDigests.VALUES)).put("check-file-name", OptionalFeature.any(BuiltinDigests.VALUES)).put("copy-data", OptionalFeature.TRUE).put("space-available", OptionalFeature.TRUE).immutable();
    public static final String OPENSSH_EXTENSIONS_PROP = "sftp-openssh-extensions";
    public static final List<AbstractOpenSSHExtensionParser.OpenSSHExtension> DEFAULT_OPEN_SSH_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(new AbstractOpenSSHExtensionParser.OpenSSHExtension("fsync@openssh.com", "1"), new AbstractOpenSSHExtensionParser.OpenSSHExtension("hardlink@openssh.com", "1")));
    public static final List<String> DEFAULT_OPEN_SSH_EXTENSIONS_NAMES = Collections.unmodifiableList(NamedResource.getNameList(DEFAULT_OPEN_SSH_EXTENSIONS));
    public static final String ACL_SUPPORTED_MASK_PROP = "sftp-acl-supported-mask";
    public static final Set<Integer> DEFAULT_ACL_SUPPORTED_MASK = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(1, 2, 4, 8)));
    public static final String NEWLINE_VALUE = "sftp-newline";
    public static final String MAX_READDATA_PACKET_LENGTH_PROP = "sftp-max-readdata-packet-length";
    public static final int DEFAULT_MAX_READDATA_PACKET_LENGTH = 64512;
    private final UnsupportedAttributePolicy unsupportedAttributePolicy;
    private final Collection<SftpEventListener> sftpEventListeners = new CopyOnWriteArraySet<SftpEventListener>();
    private final SftpEventListener sftpEventListenerProxy;
    private final SftpFileSystemAccessor fileSystemAccessor;
    private final SftpErrorStatusDataHandler errorStatusDataHandler;

    protected AbstractSftpSubsystemHelper(UnsupportedAttributePolicy policy, SftpFileSystemAccessor accessor, SftpErrorStatusDataHandler handler) {
        this.unsupportedAttributePolicy = Objects.requireNonNull(policy, "No unsupported attribute policy provided");
        this.fileSystemAccessor = Objects.requireNonNull(accessor, "No file system accessor");
        this.sftpEventListenerProxy = EventListenerUtils.proxyWrapper(SftpEventListener.class, this.getClass().getClassLoader(), this.sftpEventListeners);
        this.errorStatusDataHandler = Objects.requireNonNull(handler, "No error status data handler");
    }

    @Override
    public UnsupportedAttributePolicy getUnsupportedAttributePolicy() {
        return this.unsupportedAttributePolicy;
    }

    @Override
    public SftpFileSystemAccessor getFileSystemAccessor() {
        return this.fileSystemAccessor;
    }

    @Override
    public SftpEventListener getSftpEventListenerProxy() {
        return this.sftpEventListenerProxy;
    }

    @Override
    public boolean addSftpEventListener(SftpEventListener listener) {
        return this.sftpEventListeners.add(SftpEventListener.validateListener(listener));
    }

    @Override
    public boolean removeSftpEventListener(SftpEventListener listener) {
        if (listener == null) {
            return false;
        }
        return this.sftpEventListeners.remove(SftpEventListener.validateListener(listener));
    }

    public SftpErrorStatusDataHandler getErrorStatusDataHandler() {
        return this.errorStatusDataHandler;
    }

    protected abstract void process(Buffer var1) throws IOException;

    protected Boolean validateProposedVersion(Buffer buffer, int id, String proposed) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("validateProposedVersion({})[id={}] SSH_FXP_EXTENDED(version-select) (version={})", this.getServerSession(), id, proposed);
        }
        if (GenericUtils.length(proposed) != 1) {
            return Boolean.FALSE;
        }
        char digit = proposed.charAt(0);
        if (digit < '0' || digit > '9') {
            return Boolean.FALSE;
        }
        int value = digit - 48;
        String all = this.checkVersionCompatibility(buffer, id, value, 4);
        if (GenericUtils.isEmpty(all)) {
            return null;
        }
        return Boolean.TRUE;
    }

    protected String checkVersionCompatibility(Buffer buffer, int id, int proposed, int failureOpcode) throws IOException {
        int low = 3;
        int hig = 6;
        String available = SftpSubsystemEnvironment.ALL_SFTP_IMPL;
        ServerSession session = this.getServerSession();
        Integer sftpVersion = session.getInteger("sftp-version");
        if (sftpVersion != null) {
            int forcedValue = sftpVersion;
            if (forcedValue < 3 || forcedValue > 6) {
                throw new IllegalStateException("Forced SFTP version (" + sftpVersion + ") not within supported values: " + available);
            }
            low = hig = sftpVersion.intValue();
            available = sftpVersion.toString();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("checkVersionCompatibility({})[id={}] - proposed={}, available={}", this.getServerSession(), id, proposed, available);
        }
        if (proposed < low || proposed > hig) {
            this.sendStatus(BufferUtils.clear(buffer), id, failureOpcode, "Proposed version (" + proposed + ") not in supported range: " + available);
            return null;
        }
        return available;
    }

    protected void doOpen(Buffer buffer, int id) throws IOException {
        String handle;
        int pflags;
        String path = buffer.getString();
        int access = 0;
        int version = this.getVersion();
        if (version >= 5 && (access = buffer.getInt()) == 0) {
            access = 129;
        }
        if ((pflags = buffer.getInt()) == 0) {
            pflags = 1;
        }
        if (version < 5) {
            int flags = pflags;
            pflags = 0;
            switch (flags & 3) {
                case 1: {
                    access |= 0x81;
                    break;
                }
                case 2: {
                    access |= 0x102;
                    break;
                }
                default: {
                    access |= 0x81;
                    access |= 0x102;
                }
            }
            if ((flags & 4) != 0) {
                access |= 4;
                pflags |= 0x18;
            }
            pflags = (flags & 8) != 0 ? ((flags & 0x20) != 0 ? (pflags |= 0) : ((flags & 0x10) != 0 ? (pflags |= 1) : (pflags |= 3))) : ((flags & 0x10) != 0 ? (pflags |= 4) : (pflags |= 2));
        }
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            handle = this.doOpen(id, path, pflags, access, attrs);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 3, path);
            return;
        }
        this.sendHandle(BufferUtils.clear(buffer), id, handle);
    }

    protected abstract String doOpen(int var1, String var2, int var3, int var4, Map<String, Object> var5) throws IOException;

    protected void doClose(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        try {
            this.doClose(id, handle);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 4, handle);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "", "");
    }

    protected abstract void doClose(int var1, String var2) throws IOException;

    protected void doRead(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long offset = buffer.getLong();
        int requestedLength = buffer.getInt();
        ServerSession serverSession = this.getServerSession();
        int maxAllowed = serverSession.getIntProperty(MAX_READDATA_PACKET_LENGTH_PROP, 64512);
        int readLen = Math.min(requestedLength, maxAllowed);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doRead({})[id={}]({})[offset={}] - req={}, max={}, effective={}", serverSession, id, handle, offset, requestedLength, maxAllowed, readLen);
        }
        try {
            ValidateUtils.checkTrue(readLen >= 0, "Illegal requested read length: %d", readLen);
            buffer.clear();
            buffer.ensureCapacity(readLen + 64, IntUnaryOperator.identity());
            buffer.putByte((byte)103);
            buffer.putInt(id);
            int lenPos = buffer.wpos();
            buffer.putInt(0L);
            int startPos = buffer.wpos();
            int len = this.doRead(id, handle, offset, readLen, buffer.array(), startPos);
            if (len < 0) {
                throw new EOFException("Unable to read " + readLen + " bytes from offset=" + offset + " of " + handle);
            }
            buffer.wpos(startPos + len);
            BufferUtils.updateLengthPlaceholder(buffer, lenPos, len);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 5, handle, offset, requestedLength);
            return;
        }
        this.send(buffer);
    }

    protected abstract int doRead(int var1, String var2, long var3, int var5, byte[] var6, int var7) throws IOException;

    protected void doWrite(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long offset = buffer.getLong();
        int length = buffer.getInt();
        try {
            this.doWrite(id, handle, offset, length, buffer.array(), buffer.rpos(), buffer.available());
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 6, handle, offset, length);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected abstract void doWrite(int var1, String var2, long var3, int var5, byte[] var6, int var7, int var8) throws IOException;

    protected void doLStat(Buffer buffer, int id) throws IOException {
        Map<String, Object> attrs;
        String path = buffer.getString();
        int flags = 65535;
        int version = this.getVersion();
        if (version >= 4) {
            flags = buffer.getInt();
        }
        try {
            attrs = this.doLStat(id, path, flags);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 7, path, flags);
            return;
        }
        this.sendAttrs(BufferUtils.clear(buffer), id, attrs);
    }

    protected Map<String, Object> doLStat(int id, String path, int flags) throws IOException {
        Path p = this.resolveFile(path);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doLStat({})[id={}] SSH_FXP_LSTAT (path={}[{}], flags=0x{})", this.getServerSession(), id, path, p, Integer.toHexString(flags));
        }
        return this.resolveFileAttributes(p, flags, IoUtils.getLinkOptions(false));
    }

    protected void doSetStat(Buffer buffer, int id) throws IOException {
        String path = buffer.getString();
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            this.doSetStat(id, path, attrs);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 9, path);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doSetStat(int id, String path, Map<String, ?> attrs) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doSetStat({})[id={}] SSH_FXP_SETSTAT (path={}, attrs={})", this.getServerSession(), id, path, attrs);
        }
        Path p = this.resolveFile(path);
        this.doSetAttributes(p, attrs);
    }

    protected void doFStat(Buffer buffer, int id) throws IOException {
        Map<String, Object> attrs;
        String handle = buffer.getString();
        int flags = 65535;
        int version = this.getVersion();
        if (version >= 4) {
            flags = buffer.getInt();
        }
        try {
            attrs = this.doFStat(id, handle, flags);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 8, handle, flags);
            return;
        }
        this.sendAttrs(BufferUtils.clear(buffer), id, attrs);
    }

    protected abstract Map<String, Object> doFStat(int var1, String var2, int var3) throws IOException;

    protected void doFSetStat(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            this.doFSetStat(id, handle, attrs);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 10, handle, attrs);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected abstract void doFSetStat(int var1, String var2, Map<String, ?> var3) throws IOException;

    protected void doOpenDir(Buffer buffer, int id) throws IOException {
        String handle;
        String path = buffer.getString();
        try {
            Path p = this.resolveNormalizedLocation(path);
            if (this.log.isDebugEnabled()) {
                this.log.debug("doOpenDir({})[id={}] SSH_FXP_OPENDIR (path={})[{}]", this.getServerSession(), id, path, p);
            }
            LinkOption[] options = this.getPathResolutionLinkOption(11, "", p);
            handle = this.doOpenDir(id, path, p, options);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 11, path);
            return;
        }
        this.sendHandle(BufferUtils.clear(buffer), id, handle);
    }

    protected abstract String doOpenDir(int var1, String var2, Path var3, LinkOption ... var4) throws IOException;

    protected abstract void doReadDir(Buffer var1, int var2) throws IOException;

    protected void doLink(Buffer buffer, int id) throws IOException {
        String targetPath = buffer.getString();
        String linkPath = buffer.getString();
        boolean symLink = buffer.getBoolean();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doLink({})[id={}] SSH_FXP_LINK linkpath={}, targetpath={}, symlink={}", this.getServerSession(), id, linkPath, targetPath, symLink);
            }
            this.doLink(id, targetPath, linkPath, symLink);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 21, targetPath, linkPath, symLink);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doLink(int id, String targetPath, String linkPath, boolean symLink) throws IOException {
        this.createLink(id, targetPath, linkPath, symLink);
    }

    protected void doSymLink(Buffer buffer, int id) throws IOException {
        String targetPath = buffer.getString();
        String linkPath = buffer.getString();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doSymLink({})[id={}] SSH_FXP_SYMLINK linkpath={}, targetpath={}", this.getServerSession(), id, targetPath, linkPath);
            }
            this.doSymLink(id, targetPath, linkPath);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 20, targetPath, linkPath);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doSymLink(int id, String targetPath, String linkPath) throws IOException {
        this.createLink(id, targetPath, linkPath, true);
    }

    protected abstract void createLink(int var1, String var2, String var3, boolean var4) throws IOException;

    protected void doOpenSSHHardLink(Buffer buffer, int id) throws IOException {
        String srcFile = buffer.getString();
        String dstFile = buffer.getString();
        try {
            this.doOpenSSHHardLink(id, srcFile, dstFile);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 200, "hardlink@openssh.com", srcFile, dstFile);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doOpenSSHHardLink(int id, String srcFile, String dstFile) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpenSSHHardLink({})[id={}] SSH_FXP_EXTENDED[{}] (src={}, dst={})", this.getServerSession(), id, "hardlink@openssh.com", srcFile, dstFile);
        }
        this.createLink(id, srcFile, dstFile, false);
    }

    protected void doSpaceAvailable(Buffer buffer, int id) throws IOException {
        SpaceAvailableExtensionInfo info;
        String path = buffer.getString();
        try {
            info = this.doSpaceAvailable(id, path);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 200, "space-available", path);
            return;
        }
        buffer.clear();
        buffer.putByte((byte)-55);
        buffer.putInt(id);
        SpaceAvailableExtensionInfo.encode(buffer, info);
        this.send(buffer);
    }

    protected SpaceAvailableExtensionInfo doSpaceAvailable(int id, String path) throws IOException {
        Path nrm = this.resolveNormalizedLocation(path);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doSpaceAvailable({})[id={}] path={}[{}]", this.getServerSession(), id, path, nrm);
        }
        FileStore store = Files.getFileStore(nrm);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doSpaceAvailable({})[id={}] path={}[{}] - {}[{}]", this.getServerSession(), id, path, nrm, store.name(), store.type());
        }
        return new SpaceAvailableExtensionInfo(store);
    }

    protected void doTextSeek(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long line = buffer.getLong();
        try {
            this.doTextSeek(id, handle, line);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 200, "text-seek", handle, line);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected abstract void doTextSeek(int var1, String var2, long var3) throws IOException;

    protected void doOpenSSHFsync(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        try {
            this.doOpenSSHFsync(id, handle);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 200, "fsync@openssh.com", handle);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected abstract void doOpenSSHFsync(int var1, String var2) throws IOException;

    protected void doCheckFileHash(Buffer buffer, int id, String targetType) throws IOException {
        String target = buffer.getString();
        String algList = buffer.getString();
        String[] algos = GenericUtils.split(algList, ',');
        long startOffset = buffer.getLong();
        long length = buffer.getLong();
        int blockSize = buffer.getInt();
        try {
            buffer.clear();
            buffer.putByte((byte)-55);
            buffer.putInt(id);
            buffer.putString("check-file");
            this.doCheckFileHash(id, targetType, target, Arrays.asList(algos), startOffset, length, blockSize, buffer);
        }
        catch (Exception e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 200, targetType, target, algList, startOffset, length, blockSize);
            return;
        }
        this.send(buffer);
    }

    protected void doCheckFileHash(int id, Path file, NamedFactory<? extends Digest> factory, long startOffset, long length, int blockSize, Buffer buffer) throws Exception {
        block23: {
            ValidateUtils.checkTrue(startOffset >= 0L, "Invalid start offset: %d", startOffset);
            ValidateUtils.checkTrue(length >= 0L, "Invalid length: %d", length);
            ValidateUtils.checkTrue(blockSize == 0 || blockSize >= 256, "Invalid block size: %d", blockSize);
            Objects.requireNonNull(factory, "No digest factory provided");
            buffer.putString(factory.getName());
            long effectiveLength = length;
            long totalLength = Files.size(file);
            if (effectiveLength == 0L) {
                effectiveLength = totalLength - startOffset;
            } else {
                long maxRead = startOffset + length;
                if (maxRead > totalLength) {
                    effectiveLength = totalLength - startOffset;
                }
            }
            ValidateUtils.checkTrue(effectiveLength > 0L, "Non-positive effective hash data length: %d", effectiveLength);
            byte[] digestBuf = blockSize == 0 ? new byte[Math.min((int)effectiveLength, 8192)] : new byte[Math.min((int)effectiveLength, blockSize)];
            ByteBuffer wb = ByteBuffer.wrap(digestBuf);
            SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
            try (SeekableByteChannel channel = accessor.openFile(this.getServerSession(), this, file, "", Collections.emptySet(), new FileAttribute[0]);){
                channel.position(startOffset);
                Digest digest = (Digest)factory.create();
                digest.init();
                if (blockSize == 0) {
                    while (effectiveLength > 0L) {
                        int remainLen = Math.min(digestBuf.length, (int)effectiveLength);
                        ByteBuffer bb = wb;
                        if (remainLen < digestBuf.length) {
                            bb = ByteBuffer.wrap(digestBuf, 0, remainLen);
                        }
                        bb.clear();
                        int readLen = channel.read(bb);
                        if (readLen < 0) break;
                        effectiveLength -= (long)readLen;
                        digest.update(digestBuf, 0, readLen);
                    }
                    byte[] hashValue = digest.digest();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("doCheckFileHash({})[{}] offset={}, length={} - algo={}, hash={}", this.getServerSession(), file, startOffset, length, digest.getAlgorithm(), BufferUtils.toHex(':', hashValue));
                    }
                    buffer.putBytes(hashValue);
                    break block23;
                }
                int count = 0;
                while (effectiveLength > 0L) {
                    int remainLen = Math.min(digestBuf.length, (int)effectiveLength);
                    ByteBuffer bb = wb;
                    if (remainLen < digestBuf.length) {
                        bb = ByteBuffer.wrap(digestBuf, 0, remainLen);
                    }
                    bb.clear();
                    int readLen = channel.read(bb);
                    if (readLen < 0) {
                        break;
                    }
                    effectiveLength -= (long)readLen;
                    digest.update(digestBuf, 0, readLen);
                    byte[] hashValue = digest.digest();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("doCheckFileHash({})({})[{}] offset={}, length={} - algo={}, hash={}", this.getServerSession(), file, count, startOffset, length, digest.getAlgorithm(), BufferUtils.toHex(':', hashValue));
                    }
                    buffer.putBytes(hashValue);
                    ++count;
                }
            }
        }
    }

    protected void doMD5Hash(Buffer buffer, int id, String targetType) throws IOException {
        byte[] hashValue;
        String target = buffer.getString();
        long startOffset = buffer.getLong();
        long length = buffer.getLong();
        byte[] quickCheckHash = buffer.getBytes();
        try {
            hashValue = this.doMD5Hash(id, targetType, target, startOffset, length, quickCheckHash);
            if (this.log.isTraceEnabled()) {
                this.log.trace("doMD5Hash({})({})[{}] offset={}, length={}, quick-hash={} - hash={}", this.getServerSession(), targetType, target, startOffset, length, BufferUtils.toHex(':', quickCheckHash), BufferUtils.toHex(':', hashValue));
            }
        }
        catch (Exception e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 200, targetType, target, startOffset, length, quickCheckHash);
            return;
        }
        buffer.clear();
        buffer.putByte((byte)-55);
        buffer.putInt(id);
        buffer.putString(targetType);
        buffer.putBytes(hashValue);
        this.send(buffer);
    }

    protected abstract byte[] doMD5Hash(int var1, String var2, String var3, long var4, long var6, byte[] var8) throws Exception;

    protected byte[] doMD5Hash(int id, Path path, long startOffset, long length, byte[] quickCheckHash) throws Exception {
        ValidateUtils.checkTrue(startOffset >= 0L, "Invalid start offset: %d", startOffset);
        ValidateUtils.checkTrue(length > 0L, "Invalid length: %d", length);
        if (!BuiltinDigests.md5.isSupported()) {
            throw new UnsupportedOperationException(BuiltinDigests.md5.getAlgorithm() + " hash not supported");
        }
        Digest digest = BuiltinDigests.md5.create();
        digest.init();
        long effectiveLength = length;
        byte[] digestBuf = new byte[(int)Math.min(effectiveLength, 2048L)];
        ByteBuffer wb = ByteBuffer.wrap(digestBuf);
        boolean hashMatches = false;
        byte[] hashValue = null;
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        try (SeekableByteChannel channel = accessor.openFile(this.getServerSession(), this, path, null, EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);){
            channel.position(startOffset);
            if (NumberUtils.length(quickCheckHash) <= 0) {
                hashMatches = true;
            } else {
                int readLen = channel.read(wb);
                if (readLen < 0) {
                    throw new EOFException("EOF while read initial buffer from " + path);
                }
                effectiveLength -= (long)readLen;
                digest.update(digestBuf, 0, readLen);
                hashValue = digest.digest();
                hashMatches = Arrays.equals(quickCheckHash, hashValue);
                if (hashMatches) {
                    if (effectiveLength > 0L) {
                        digest = BuiltinDigests.md5.create();
                        digest.init();
                        digest.update(digestBuf, 0, readLen);
                        hashValue = null;
                    }
                } else if (this.log.isTraceEnabled()) {
                    this.log.trace("doMD5Hash({})({}) offset={}, length={} - quick-hash mismatched expected={}, actual={}", this.getServerSession(), path, startOffset, length, BufferUtils.toHex(':', quickCheckHash), BufferUtils.toHex(':', hashValue));
                }
            }
            if (hashMatches) {
                while (effectiveLength > 0L) {
                    int remainLen = Math.min(digestBuf.length, (int)effectiveLength);
                    ByteBuffer bb = wb;
                    if (remainLen < digestBuf.length) {
                        bb = ByteBuffer.wrap(digestBuf, 0, remainLen);
                    }
                    bb.clear();
                    int readLen = channel.read(bb);
                    if (readLen < 0) break;
                    effectiveLength -= (long)readLen;
                    digest.update(digestBuf, 0, readLen);
                }
                if (hashValue == null) {
                    hashValue = digest.digest();
                }
            } else {
                hashValue = GenericUtils.EMPTY_BYTE_ARRAY;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("doMD5Hash({})({}) offset={}, length={} - matches={}, quick={} hash={}", this.getServerSession(), path, startOffset, length, hashMatches, BufferUtils.toHex(':', quickCheckHash), BufferUtils.toHex(':', hashValue));
        }
        return hashValue;
    }

    protected abstract void doCheckFileHash(int var1, String var2, String var3, Collection<String> var4, long var5, long var7, int var9, Buffer var10) throws Exception;

    protected void doReadLink(Buffer buffer, int id) throws IOException {
        String l;
        String path = buffer.getString();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doReadLink({})[id={}] SSH_FXP_READLINK path={}", this.getServerSession(), id, path);
            }
            l = this.doReadLink(id, path);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 19, path);
            return;
        }
        this.sendLink(BufferUtils.clear(buffer), id, l);
    }

    protected String doReadLink(int id, String path) throws IOException {
        Path f = this.resolveFile(path);
        Path t = Files.readSymbolicLink(f);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doReadLink({})[id={}] path={}[{}]: {}", this.getServerSession(), id, path, f, t);
        }
        return t.toString();
    }

    protected void doRename(Buffer buffer, int id) throws IOException {
        String oldPath = buffer.getString();
        String newPath = buffer.getString();
        int flags = 0;
        int version = this.getVersion();
        if (version >= 5) {
            flags = buffer.getInt();
        }
        try {
            this.doRename(id, oldPath, newPath, flags);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 18, oldPath, newPath, flags);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doRename(int id, String oldPath, String newPath, int flags) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doRename({})[id={}] SSH_FXP_RENAME (oldPath={}, newPath={}, flags=0x{})", this.getServerSession(), id, oldPath, newPath, Integer.toHexString(flags));
        }
        List<CopyOption> opts = Collections.emptyList();
        if (flags != 0) {
            opts = new ArrayList();
            if ((flags & 2) == 2) {
                opts.add(StandardCopyOption.ATOMIC_MOVE);
            }
            if ((flags & 1) == 1) {
                opts.add(StandardCopyOption.REPLACE_EXISTING);
            }
        }
        this.doRename(id, oldPath, newPath, opts);
    }

    protected void doRename(int id, String oldPath, String newPath, Collection<CopyOption> opts) throws IOException {
        Path o = this.resolveFile(oldPath);
        Path n = this.resolveFile(newPath);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session = this.getServerSession();
        listener.moving(session, o, n, opts);
        try {
            Files.move(o, n, GenericUtils.isEmpty(opts) ? IoUtils.EMPTY_COPY_OPTIONS : opts.toArray(new CopyOption[opts.size()]));
        }
        catch (IOException | RuntimeException e) {
            listener.moved(session, o, n, opts, e);
            throw e;
        }
        listener.moved(session, o, n, opts, null);
    }

    protected void doCopyData(Buffer buffer, int id) throws IOException {
        String readHandle = buffer.getString();
        long readOffset = buffer.getLong();
        long readLength = buffer.getLong();
        String writeHandle = buffer.getString();
        long writeOffset = buffer.getLong();
        try {
            this.doCopyData(id, readHandle, readOffset, readLength, writeHandle, writeOffset);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 200, "copy-data", readHandle, readOffset, readLength, writeHandle, writeOffset);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected abstract void doCopyData(int var1, String var2, long var3, long var5, String var7, long var8) throws IOException;

    protected void doCopyFile(Buffer buffer, int id) throws IOException {
        String srcFile = buffer.getString();
        String dstFile = buffer.getString();
        boolean overwriteDestination = buffer.getBoolean();
        try {
            this.doCopyFile(id, srcFile, dstFile, overwriteDestination);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 200, "copy-file", srcFile, dstFile, overwriteDestination);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doCopyFile(int id, String srcFile, String dstFile, boolean overwriteDestination) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doCopyFile({})[id={}] SSH_FXP_EXTENDED[{}] (src={}, dst={}, overwrite=0x{})", this.getServerSession(), id, "copy-file", srcFile, dstFile, overwriteDestination);
        }
        this.doCopyFile(id, srcFile, dstFile, overwriteDestination ? Collections.singletonList(StandardCopyOption.REPLACE_EXISTING) : Collections.emptyList());
    }

    protected void doCopyFile(int id, String srcFile, String dstFile, Collection<CopyOption> opts) throws IOException {
        Path src = this.resolveFile(srcFile);
        Path dst = this.resolveFile(dstFile);
        Files.copy(src, dst, GenericUtils.isEmpty(opts) ? IoUtils.EMPTY_COPY_OPTIONS : opts.toArray(new CopyOption[opts.size()]));
    }

    protected void doBlock(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long offset = buffer.getLong();
        long length = buffer.getLong();
        int mask = buffer.getInt();
        try {
            this.doBlock(id, handle, offset, length, mask);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 22, handle, offset, length, mask);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected abstract void doBlock(int var1, String var2, long var3, long var5, int var7) throws IOException;

    protected void doUnblock(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long offset = buffer.getLong();
        long length = buffer.getLong();
        try {
            this.doUnblock(id, handle, offset, length);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 23, handle, offset, length);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected abstract void doUnblock(int var1, String var2, long var3, long var5) throws IOException;

    protected void doStat(Buffer buffer, int id) throws IOException {
        Map<String, Object> attrs;
        String path = buffer.getString();
        int flags = 65535;
        int version = this.getVersion();
        if (version >= 4) {
            flags = buffer.getInt();
        }
        try {
            attrs = this.doStat(id, path, flags);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 17, path, flags);
            return;
        }
        this.sendAttrs(BufferUtils.clear(buffer), id, attrs);
    }

    protected Map<String, Object> doStat(int id, String path, int flags) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doStat({})[id={}] SSH_FXP_STAT (path={}, flags=0x{})", this.getServerSession(), id, path, Integer.toHexString(flags));
        }
        Path p = this.resolveFile(path);
        return this.resolveFileAttributes(p, flags, IoUtils.getLinkOptions(true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRealPath(Buffer buffer, int id) throws IOException {
        AbstractMap.SimpleImmutableEntry<Path, Boolean> result;
        String path = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doRealPath({})[id={}] SSH_FXP_REALPATH (path={})", this.getServerSession(), id, path);
        }
        if (GenericUtils.isEmpty(path = GenericUtils.trimToEmpty(path))) {
            path = ".";
        }
        Map attrs = Collections.emptyMap();
        try {
            int version = this.getVersion();
            if (version < 6) {
                Path p = this.resolveFile(path);
                LinkOption[] options = this.getPathResolutionLinkOption(16, "", p);
                result = this.doRealPathV345(id, path, p, options);
            } else {
                int control = 1;
                if (buffer.available() > 0) {
                    control = buffer.getUByte();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("doRealPath({}) - control=0x{} for path={}", this.getServerSession(), Integer.toHexString(control), path);
                    }
                }
                LinkedList<String> extraPaths = new LinkedList<String>();
                while (buffer.available() > 0) {
                    extraPaths.add(buffer.getString());
                }
                Path p = this.resolveFile(path);
                LinkOption[] options = this.getPathResolutionLinkOption(16, "", p);
                result = this.doRealPathV6(id, path, extraPaths, p, options);
                p = (Path)result.getKey();
                options = this.getPathResolutionLinkOption(16, "", p);
                Boolean status = (Boolean)result.getValue();
                switch (control) {
                    case 2: {
                        if (status == null) {
                            attrs = this.handleUnknownStatusFileAttributes(p, 65535, options);
                            break;
                        }
                        if (status.booleanValue()) {
                            try {
                                attrs = this.getAttributes(p, options);
                            }
                            catch (IOException e) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("doRealPath({}) - failed ({}) to retrieve attributes of {}: {}", this.getServerSession(), e.getClass().getSimpleName(), p, e.getMessage());
                                }
                                if (!this.log.isTraceEnabled()) break;
                                this.log.trace("doRealPath(" + this.getServerSession() + ")[" + p + "] attributes retrieval failure details", e);
                            }
                            break;
                        }
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug("doRealPath({}) - dummy attributes for non-existing file: {}", (Object)this.getServerSession(), (Object)p);
                        break;
                    }
                    case 3: {
                        if (status == null) {
                            attrs = this.handleUnknownStatusFileAttributes(p, 65535, options);
                            break;
                        }
                        if (!status.booleanValue()) {
                            throw new NoSuchFileException(p.toString(), p.toString(), "Real path N/A for target");
                        }
                        attrs = this.getAttributes(p, options);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.log.warn("doRealPath({}) unknown control value 0x{} for path={}", this.getServerSession(), Integer.toHexString(control), p);
                        break;
                    }
                }
            }
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 16, path);
            return;
        }
        this.sendPath(BufferUtils.clear(buffer), id, (Path)result.getKey(), attrs);
    }

    protected AbstractMap.SimpleImmutableEntry<Path, Boolean> doRealPathV6(int id, String path, Collection<String> extraPaths, Path p, LinkOption ... options) throws IOException {
        int numExtra = GenericUtils.size(extraPaths);
        if (numExtra > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doRealPathV6({})[id={}] path={}, extra={}", this.getServerSession(), id, path, extraPaths);
            }
            StringBuilder sb = new StringBuilder(GenericUtils.length(path) + numExtra * 8);
            sb.append(path);
            for (String p2 : extraPaths) {
                p = p.resolve(p2);
                options = this.getPathResolutionLinkOption(16, "", p);
                sb.append('/').append(p2);
            }
            path = sb.toString();
        }
        return this.validateRealPath(id, path, p, options);
    }

    protected AbstractMap.SimpleImmutableEntry<Path, Boolean> doRealPathV345(int id, String path, Path p, LinkOption ... options) throws IOException {
        return this.validateRealPath(id, path, p, options);
    }

    protected AbstractMap.SimpleImmutableEntry<Path, Boolean> validateRealPath(int id, String path, Path f, LinkOption ... options) throws IOException {
        Path p = this.normalize(f);
        Boolean status = IoUtils.checkFileExists(p, options);
        return new AbstractMap.SimpleImmutableEntry<Path, Boolean>(p, status);
    }

    protected void doRemoveDirectory(Buffer buffer, int id) throws IOException {
        String path = buffer.getString();
        try {
            this.doRemoveDirectory(id, path, IoUtils.getLinkOptions(false));
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 15, path);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doRemoveDirectory(int id, String path, LinkOption ... options) throws IOException {
        Path p = this.resolveFile(path);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doRemoveDirectory({})[id={}] SSH_FXP_RMDIR (path={})[{}]", this.getServerSession(), id, path, p);
        }
        if (!Files.isDirectory(p, options)) {
            throw new NotDirectoryException(p.toString());
        }
        this.doRemove(id, p);
    }

    protected void doRemove(int id, Path p) throws IOException {
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session = this.getServerSession();
        listener.removing(session, p);
        try {
            Files.delete(p);
        }
        catch (IOException | RuntimeException e) {
            listener.removed(session, p, e);
            throw e;
        }
        listener.removed(session, p, null);
    }

    protected void doMakeDirectory(Buffer buffer, int id) throws IOException {
        String path = buffer.getString();
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            this.doMakeDirectory(id, path, attrs, IoUtils.getLinkOptions(false));
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 14, path, attrs);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doMakeDirectory(int id, String path, Map<String, ?> attrs, LinkOption ... options) throws IOException {
        Boolean status;
        Path p = this.resolveFile(path);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doMakeDirectory({})[id={}] SSH_FXP_MKDIR (path={}[{}], attrs={})", this.getServerSession(), id, path, p, attrs);
        }
        if ((status = IoUtils.checkFileExists(p, options)) == null) {
            throw new AccessDeniedException(p.toString(), p.toString(), "Cannot validate make-directory existence");
        }
        if (status.booleanValue()) {
            if (Files.isDirectory(p, options)) {
                throw new FileAlreadyExistsException(p.toString(), p.toString(), "Target directory already exists");
            }
            throw new FileAlreadyExistsException(p.toString(), p.toString(), "Already exists as a file");
        }
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session = this.getServerSession();
        listener.creating(session, p, attrs);
        try {
            Files.createDirectory(p, new FileAttribute[0]);
            this.doSetAttributes(p, attrs);
        }
        catch (IOException | RuntimeException e) {
            listener.created(session, p, attrs, e);
            throw e;
        }
        listener.created(session, p, attrs, null);
    }

    protected void doRemove(Buffer buffer, int id) throws IOException {
        String path = buffer.getString();
        try {
            this.doRemove(id, path, IoUtils.getLinkOptions(false));
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 13, path);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doRemove(int id, String path, LinkOption ... options) throws IOException {
        Boolean status;
        Path p = this.resolveFile(path);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doRemove({})[id={}] SSH_FXP_REMOVE (path={}[{}])", this.getServerSession(), id, path, p);
        }
        if ((status = IoUtils.checkFileExists(p, options)) == null) {
            throw new AccessDeniedException(p.toString(), p.toString(), "Cannot determine existence of remove candidate");
        }
        if (!status.booleanValue()) {
            throw new NoSuchFileException(p.toString(), p.toString(), "Removal candidate not found");
        }
        if (Files.isDirectory(p, options)) {
            throw new SftpException(24, p.toString() + " is a folder");
        }
        this.doRemove(id, p);
    }

    protected void doExtended(Buffer buffer, int id) throws IOException {
        this.executeExtendedCommand(buffer, id, buffer.getString());
    }

    protected abstract void executeExtendedCommand(Buffer var1, int var2, String var3) throws IOException;

    protected void appendExtensions(Buffer buffer, String supportedVersions) {
        ArrayList<String> extras;
        this.appendVersionsExtension(buffer, supportedVersions);
        this.appendNewlineExtension(buffer, this.resolveNewlineValue(this.getServerSession()));
        this.appendVendorIdExtension(buffer, VersionProperties.getVersionProperties());
        this.appendOpenSSHExtensions(buffer);
        this.appendAclSupportedExtension(buffer);
        Map<String, OptionalFeature> extensions = this.getSupportedClientExtensions();
        int numExtensions = GenericUtils.size(extensions);
        ArrayList<String> arrayList = extras = numExtensions <= 0 ? Collections.emptyList() : new ArrayList<String>(numExtensions);
        if (numExtensions > 0) {
            ServerSession session = this.getServerSession();
            extensions.forEach((name, f) -> {
                if (!f.isSupported()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("appendExtensions({}) skip unsupported extension={}", (Object)session, name);
                    }
                    return;
                }
                extras.add((String)name);
            });
        }
        this.appendSupportedExtension(buffer, extras);
        this.appendSupported2Extension(buffer, extras);
    }

    protected int appendAclSupportedExtension(Buffer buffer) {
        ServerSession session = this.getServerSession();
        Collection<Integer> maskValues = this.resolveAclSupportedCapabilities(session);
        int mask = AclSupportedParser.AclCapabilities.constructAclCapabilities(maskValues);
        if (mask != 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("appendAclSupportedExtension({}) capabilities={}", (Object)session, (Object)AclSupportedParser.AclCapabilities.decodeAclCapabilities(mask));
            }
            buffer.putString("acl-supported");
            int lenPos = buffer.wpos();
            buffer.putInt(0L);
            buffer.putInt(mask);
            BufferUtils.updateLengthPlaceholder(buffer, lenPos);
        }
        return mask;
    }

    protected Collection<Integer> resolveAclSupportedCapabilities(ServerSession session) {
        String override = session.getString(ACL_SUPPORTED_MASK_PROP);
        if (override == null) {
            return DEFAULT_ACL_SUPPORTED_MASK;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveAclSupportedCapabilities({}) override='{}'", (Object)session, (Object)override);
        }
        if (override.length() == 0) {
            return Collections.emptySet();
        }
        String[] names = GenericUtils.split(override, ',');
        HashSet<Integer> maskValues = new HashSet<Integer>(names.length);
        for (String n : names) {
            Integer v = ValidateUtils.checkNotNull(AclSupportedParser.AclCapabilities.getAclCapabilityValue(n), "Unknown ACL capability: %s", (Object)n);
            maskValues.add(v);
        }
        return maskValues;
    }

    protected List<AbstractOpenSSHExtensionParser.OpenSSHExtension> appendOpenSSHExtensions(Buffer buffer) {
        List<AbstractOpenSSHExtensionParser.OpenSSHExtension> extList = this.resolveOpenSSHExtensions(this.getServerSession());
        if (GenericUtils.isEmpty(extList)) {
            return extList;
        }
        for (AbstractOpenSSHExtensionParser.OpenSSHExtension ext : extList) {
            buffer.putString(ext.getName());
            buffer.putString(ext.getVersion());
        }
        return extList;
    }

    protected List<AbstractOpenSSHExtensionParser.OpenSSHExtension> resolveOpenSSHExtensions(ServerSession session) {
        String[] pairs;
        int numExts;
        String value = session.getString(OPENSSH_EXTENSIONS_PROP);
        if (value == null) {
            return DEFAULT_OPEN_SSH_EXTENSIONS;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveOpenSSHExtensions({}) override='{}'", (Object)session, (Object)value);
        }
        if ((numExts = GenericUtils.length(pairs = GenericUtils.split(value, ','))) <= 0) {
            return Collections.emptyList();
        }
        ArrayList<AbstractOpenSSHExtensionParser.OpenSSHExtension> extList = new ArrayList<AbstractOpenSSHExtensionParser.OpenSSHExtension>(numExts);
        for (String nvp : pairs) {
            if (GenericUtils.isEmpty(nvp = GenericUtils.trimToEmpty(nvp))) continue;
            int pos = nvp.indexOf(61);
            ValidateUtils.checkTrue(pos > 0 && pos < nvp.length() - 1, "Malformed OpenSSH extension spec: %s", (Object)nvp);
            String name = GenericUtils.trimToEmpty(nvp.substring(0, pos));
            String version = GenericUtils.trimToEmpty(nvp.substring(pos + 1));
            extList.add(new AbstractOpenSSHExtensionParser.OpenSSHExtension(name, ValidateUtils.checkNotNullAndNotEmpty(version, "No version specified for OpenSSH extension %s", (Object)name)));
        }
        return extList;
    }

    protected Map<String, OptionalFeature> getSupportedClientExtensions() {
        ServerSession session = this.getServerSession();
        String value = session.getString(CLIENT_EXTENSIONS_PROP);
        if (value == null) {
            return DEFAULT_SUPPORTED_CLIENT_EXTENSIONS;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("getSupportedClientExtensions({}) override='{}'", (Object)session, (Object)value);
        }
        if (value.length() <= 0) {
            return Collections.emptyMap();
        }
        if (value.indexOf(44) <= 0) {
            return Collections.singletonMap(value, OptionalFeature.TRUE);
        }
        String[] comps = GenericUtils.split(value, ',');
        LinkedHashMap<String, OptionalFeature> result = new LinkedHashMap<String, OptionalFeature>(comps.length);
        for (String c : comps) {
            result.put(c, OptionalFeature.TRUE);
        }
        return result;
    }

    protected void appendVersionsExtension(Buffer buffer, String value) {
        if (GenericUtils.isEmpty(value)) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("appendVersionsExtension({}) value={}", (Object)this.getServerSession(), (Object)value);
        }
        buffer.putString("versions");
        buffer.putString(value);
    }

    protected void appendNewlineExtension(Buffer buffer, String value) {
        if (GenericUtils.isEmpty(value)) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("appendNewlineExtension({}) value={}", (Object)this.getServerSession(), (Object)BufferUtils.toHex(':', value.getBytes(StandardCharsets.UTF_8)));
        }
        buffer.putString("newline");
        buffer.putString(value);
    }

    protected String resolveNewlineValue(ServerSession session) {
        String value = session.getString(NEWLINE_VALUE);
        if (value == null) {
            return IoUtils.EOL;
        }
        return value;
    }

    protected void appendVendorIdExtension(Buffer buffer, Map<String, ?> versionProperties) {
        if (GenericUtils.isEmpty(versionProperties)) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("appendVendorIdExtension({}): {}", (Object)this.getServerSession(), (Object)versionProperties);
        }
        buffer.putString("vendor-id");
        PropertyResolver resolver = PropertyResolverUtils.toPropertyResolver(Collections.unmodifiableMap(versionProperties));
        int lenPos = buffer.wpos();
        buffer.putInt(0L);
        buffer.putString(resolver.getStringProperty("groupId", this.getClass().getPackage().getName()));
        buffer.putString(resolver.getStringProperty("artifactId", this.getClass().getSimpleName()));
        buffer.putString(resolver.getStringProperty("version", "SSHD-UNKNOWN"));
        buffer.putLong(0L);
        BufferUtils.updateLengthPlaceholder(buffer, lenPos);
    }

    protected void appendSupportedExtension(Buffer buffer, Collection<String> extras) {
        buffer.putString("supported");
        int lenPos = buffer.wpos();
        buffer.putInt(0L);
        buffer.putInt(701L);
        buffer.putInt(0L);
        buffer.putInt(63L);
        buffer.putInt(0L);
        buffer.putInt(0L);
        buffer.putStringList(extras, false);
        BufferUtils.updateLengthPlaceholder(buffer, lenPos);
    }

    protected void appendSupported2Extension(Buffer buffer, Collection<String> extras) {
        buffer.putString("supported2");
        int lenPos = buffer.wpos();
        buffer.putInt(0L);
        buffer.putInt(701L);
        buffer.putInt(0L);
        buffer.putInt(15L);
        buffer.putInt(0L);
        buffer.putInt(0L);
        buffer.putShort(0);
        buffer.putShort(0);
        buffer.putStringList(Collections.emptyList(), true);
        buffer.putStringList(extras, true);
        BufferUtils.updateLengthPlaceholder(buffer, lenPos);
    }

    protected void sendHandle(Buffer buffer, int id, String handle) throws IOException {
        buffer.putByte((byte)102);
        buffer.putInt(id);
        buffer.putString(handle);
        this.send(buffer);
    }

    protected void sendAttrs(Buffer buffer, int id, Map<String, ?> attributes) throws IOException {
        buffer.putByte((byte)105);
        buffer.putInt(id);
        this.writeAttrs(buffer, attributes);
        this.send(buffer);
    }

    protected void sendLink(Buffer buffer, int id, String link) throws IOException {
        String unixPath = link.replace(File.separatorChar, '/');
        String normalizedPath = SelectorUtils.normalizePath(unixPath, "/");
        buffer.putByte((byte)104);
        buffer.putInt(id);
        buffer.putInt(1L);
        buffer.putString(normalizedPath);
        Map attrs = Collections.emptyMap();
        int version = this.getVersion();
        if (version == 3) {
            buffer.putString(SftpHelper.getLongName(normalizedPath, attrs));
        }
        this.writeAttrs(buffer, attrs);
        SftpHelper.indicateEndOfNamesList(buffer, this.getVersion(), this.getServerSession());
        this.send(buffer);
    }

    protected void sendPath(Buffer buffer, int id, Path f, Map<String, ?> attrs) throws IOException {
        buffer.putByte((byte)104);
        buffer.putInt(id);
        buffer.putInt(1L);
        String originalPath = f.toString();
        String unixPath = originalPath.replace(File.separatorChar, '/');
        String normalizedPath = SelectorUtils.normalizePath(unixPath, "/");
        if (normalizedPath.length() == 0) {
            normalizedPath = "/";
        }
        buffer.putString(normalizedPath);
        int version = this.getVersion();
        if (version == 3) {
            f = this.resolveFile(normalizedPath);
            buffer.putString(this.getLongName(f, this.getShortName(f), attrs));
        }
        this.writeAttrs(buffer, attrs);
        SftpHelper.indicateEndOfNamesList(buffer, this.getVersion(), this.getServerSession());
        this.send(buffer);
    }

    protected int doReadDir(int id, String handle, DirectoryHandle dir, Buffer buffer, int maxSize, LinkOption ... options) throws IOException {
        int nb = 0;
        TreeMap<String, Path> entries = new TreeMap<String, Path>(Comparator.naturalOrder());
        while ((dir.isSendDot() || dir.isSendDotDot() || dir.hasNext()) && buffer.wpos() < maxSize) {
            if (dir.isSendDot()) {
                this.writeDirEntry(id, dir, entries, buffer, nb, dir.getFile(), ".", options);
                dir.markDotSent();
            } else if (dir.isSendDotDot()) {
                Path dirPath = dir.getFile();
                this.writeDirEntry(id, dir, entries, buffer, nb, dirPath.getParent(), "..", options);
                dir.markDotDotSent();
            } else {
                Path f = dir.next();
                this.writeDirEntry(id, dir, entries, buffer, nb, f, this.getShortName(f), options);
            }
            ++nb;
        }
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.read(this.getServerSession(), handle, dir, entries);
        return nb;
    }

    protected void writeDirEntry(int id, DirectoryHandle dir, Map<String, Path> entries, Buffer buffer, int index, Path f, String shortName, LinkOption ... options) throws IOException {
        NavigableMap<String, Object> attrs = this.resolveFileAttributes(f, 65535, options);
        entries.put(shortName, f);
        buffer.putString(shortName);
        int version = this.getVersion();
        if (version == 3) {
            String longName = this.getLongName(f, shortName, options);
            buffer.putString(longName);
            if (this.log.isTraceEnabled()) {
                this.log.trace("writeDirEntry(" + this.getServerSession() + ") id=" + id + ")[" + index + "] - " + shortName + " [" + longName + "]: " + attrs);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("writeDirEntry(" + this.getServerSession() + "(id=" + id + ")[" + index + "] - " + shortName + ": " + attrs);
        }
        this.writeAttrs(buffer, attrs);
    }

    protected String getLongName(Path f, String shortName, LinkOption ... options) throws IOException {
        return this.getLongName(f, shortName, true, options);
    }

    protected String getLongName(Path f, String shortName, boolean sendAttrs, LinkOption ... options) throws IOException {
        Map<Object, Object> attributes = sendAttrs ? this.getAttributes(f, options) : Collections.emptyMap();
        return this.getLongName(f, shortName, attributes);
    }

    protected String getLongName(Path f, String shortName, Map<String, ?> attributes) throws IOException {
        return SftpHelper.getLongName(shortName, attributes);
    }

    protected String getShortName(Path f) throws IOException {
        Path nrm = this.normalize(f);
        int count = nrm.getNameCount();
        if (OsUtils.isUNIX()) {
            Path name = f.getFileName();
            if (name == null) {
                Path p = this.resolveFile(".");
                name = p.getFileName();
            }
            if (name == null && count > 0) {
                name = nrm.getFileName();
            }
            if (name != null) {
                return name.toString();
            }
            return nrm.toString();
        }
        if (count > 0) {
            Path name = nrm.getFileName();
            return name.toString();
        }
        return nrm.toString().replace(File.separatorChar, '/');
    }

    protected NavigableMap<String, Object> resolveFileAttributes(Path file, int flags, LinkOption ... options) throws IOException {
        Boolean status = IoUtils.checkFileExists(file, options);
        if (status == null) {
            return this.handleUnknownStatusFileAttributes(file, flags, options);
        }
        if (!status.booleanValue()) {
            throw new NoSuchFileException(file.toString(), file.toString(), "Attributes N/A for target");
        }
        return this.getAttributes(file, flags, options);
    }

    protected void writeAttrs(Buffer buffer, Map<String, ?> attributes) throws IOException {
        SftpHelper.writeAttrs(buffer, this.getVersion(), attributes);
    }

    protected NavigableMap<String, Object> getAttributes(Path file, LinkOption ... options) throws IOException {
        return this.getAttributes(file, 65535, options);
    }

    protected NavigableMap<String, Object> handleUnknownStatusFileAttributes(Path file, int flags, LinkOption ... options) throws IOException {
        UnsupportedAttributePolicy unsupportedAttributePolicy = this.getUnsupportedAttributePolicy();
        switch (unsupportedAttributePolicy) {
            case Ignore: {
                break;
            }
            case ThrowException: {
                throw new AccessDeniedException(file.toString(), file.toString(), "Cannot determine existence for attributes of target");
            }
            case Warn: {
                this.log.warn("handleUnknownStatusFileAttributes(" + this.getServerSession() + ")[" + file + "] cannot determine existence");
                break;
            }
            default: {
                this.log.warn("handleUnknownStatusFileAttributes(" + this.getServerSession() + ")[" + file + "] unknown policy: " + (Object)((Object)unsupportedAttributePolicy));
            }
        }
        return this.getAttributes(file, flags, options);
    }

    protected NavigableMap<String, Object> getAttributes(Path file, int flags, LinkOption ... options) throws IOException {
        FileSystem fs = file.getFileSystem();
        Set<String> supportedViews = fs.supportedFileAttributeViews();
        TreeMap<String, Object> attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        List<Object> views = GenericUtils.isEmpty(supportedViews) ? Collections.emptyList() : (supportedViews.contains("unix") ? SftpFileSystemAccessor.DEFAULT_UNIX_VIEW : GenericUtils.map(supportedViews, v -> v + ":*"));
        for (String v2 : views) {
            NavigableMap<String, Object> ta = this.readFileAttributes(file, v2, options);
            if (!GenericUtils.isNotEmpty(ta)) continue;
            attrs.putAll(ta);
        }
        NavigableMap<String, Object> completions = this.resolveMissingFileAttributes(file, flags, attrs, options);
        if (GenericUtils.isNotEmpty(completions)) {
            attrs.putAll(completions);
        }
        return attrs;
    }

    protected NavigableMap<String, Object> resolveMissingFileAttributes(Path file, int flags, Map<String, Object> current, LinkOption ... options) throws IOException {
        TreeMap<String, Object> attrs = null;
        for (Map.Entry<String, FileInfoExtractor<?>> re : SftpFileSystemAccessor.FILEATTRS_RESOLVERS.entrySet()) {
            String name = re.getKey();
            Object value = GenericUtils.isEmpty(current) ? null : current.get(name);
            FileInfoExtractor<?> x = re.getValue();
            try {
                Object resolved = this.resolveMissingFileAttributeValue(file, name, value, x, options);
                if (Objects.equals(resolved, value)) continue;
                if (attrs == null) {
                    attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                }
                attrs.put(name, resolved);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("resolveMissingFileAttributes({})[{}[{}]] replace {} with {}", this.getServerSession(), file, name, value, resolved);
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("resolveMissingFileAttributes({})[{}[{}]] failed ({}) to resolve missing value: {}", this.getServerSession(), file, name, e.getClass().getSimpleName(), e.getMessage());
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("resolveMissingFileAttributes(" + this.getServerSession() + ")[" + file + "[" + name + "]] missing value resolution failure details", e);
            }
        }
        if (attrs == null) {
            return Collections.emptyNavigableMap();
        }
        return attrs;
    }

    protected Object resolveMissingFileAttributeValue(Path file, String name, Object value, FileInfoExtractor<?> x, LinkOption ... options) throws IOException {
        if (value != null) {
            return value;
        }
        return x.infoOf(file, options);
    }

    protected NavigableMap<String, Object> addMissingAttribute(Path file, NavigableMap<String, Object> current, String name, FileInfoExtractor<?> x, LinkOption ... options) throws IOException {
        Object value;
        Object v = value = GenericUtils.isEmpty(current) ? null : (Object)current.get(name);
        if (value != null) {
            return current;
        }
        value = x.infoOf(file, options);
        if (value == null) {
            return current;
        }
        if (current == null) {
            current = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        }
        current.put(name, value);
        return current;
    }

    protected NavigableMap<String, Object> readFileAttributes(Path file, String view, LinkOption ... options) throws IOException {
        try {
            Map<String, Object> attrs = Files.readAttributes(file, view, options);
            if (GenericUtils.isEmpty(attrs)) {
                return Collections.emptyNavigableMap();
            }
            TreeMap<String, Object> sorted = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            sorted.putAll(attrs);
            return sorted;
        }
        catch (IOException e) {
            return this.handleReadFileAttributesException(file, view, options, e);
        }
    }

    protected NavigableMap<String, Object> handleReadFileAttributesException(Path file, String view, LinkOption[] options, IOException e) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("handleReadFileAttributesException(" + file + ")[" + view + "] details", e);
        }
        UnsupportedAttributePolicy unsupportedAttributePolicy = this.getUnsupportedAttributePolicy();
        switch (unsupportedAttributePolicy) {
            case Ignore: {
                break;
            }
            case Warn: {
                this.log.warn("handleReadFileAttributesException(" + file + ")[" + view + "] " + e.getClass().getSimpleName() + ": " + e.getMessage());
                break;
            }
            case ThrowException: {
                throw e;
            }
            default: {
                this.log.warn("handleReadFileAttributesException(" + file + ")[" + view + "] Unknown policy (" + (Object)((Object)unsupportedAttributePolicy) + ") for " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
        return Collections.emptyNavigableMap();
    }

    protected void doSetAttributes(Path file, Map<String, ?> attributes) throws IOException {
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session = this.getServerSession();
        listener.modifyingAttributes(session, file, attributes);
        try {
            this.setFileAttributes(file, attributes, IoUtils.getLinkOptions(false));
        }
        catch (IOException | RuntimeException e) {
            listener.modifiedAttributes(session, file, attributes, e);
            throw e;
        }
        listener.modifiedAttributes(session, file, attributes, null);
    }

    protected LinkOption[] getPathResolutionLinkOption(int cmd, String extension, Path path) throws IOException {
        ServerSession session = this.getServerSession();
        boolean followLinks = PropertyResolverUtils.getBooleanProperty(session, AUTO_FOLLOW_LINKS, true);
        return IoUtils.getLinkOptions(followLinks);
    }

    protected void setFileAttributes(Path file, Map<String, ?> attributes, LinkOption ... options) throws IOException {
        TreeSet<String> unsupported = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        block37: for (Map.Entry<String, ?> ae : attributes.entrySet()) {
            String attribute = ae.getKey();
            Object value = ae.getValue();
            String view = null;
            switch (attribute) {
                case "size": {
                    long newSize = ((Number)value).longValue();
                    SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
                    SeekableByteChannel channel = accessor.openFile(this.getServerSession(), this, file, null, EnumSet.of(StandardOpenOption.WRITE), new FileAttribute[0]);
                    Throwable throwable = null;
                    try {
                        channel.truncate(newSize);
                        continue block37;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (channel == null) continue block37;
                        if (throwable != null) {
                            try {
                                channel.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue block37;
                        }
                        channel.close();
                        continue block37;
                    }
                }
                case "uid": {
                    view = "unix";
                    break;
                }
                case "gid": {
                    view = "unix";
                    break;
                }
                case "owner": {
                    view = "posix";
                    value = this.toUser(file, (UserPrincipal)value);
                    break;
                }
                case "group": {
                    view = "posix";
                    value = this.toGroup(file, (GroupPrincipal)value);
                    break;
                }
                case "permissions": {
                    view = "posix";
                    break;
                }
                case "acl": {
                    view = "acl";
                    break;
                }
                case "creationTime": {
                    view = "basic";
                    break;
                }
                case "lastModifiedTime": {
                    view = "basic";
                    break;
                }
                case "lastAccessTime": {
                    view = "basic";
                    break;
                }
                case "extended": {
                    view = "extended";
                    break;
                }
            }
            if (GenericUtils.length(view) <= 0 || value == null) continue;
            try {
                this.setFileAttribute(file, view, attribute, value, options);
            }
            catch (Exception e) {
                this.handleSetFileAttributeFailure(file, view, attribute, value, unsupported, e);
            }
        }
        this.handleUnsupportedAttributes(unsupported);
    }

    protected void handleSetFileAttributeFailure(Path file, String view, String attribute, Object value, Collection<String> unsupported, Exception e) throws IOException {
        if (e instanceof UnsupportedOperationException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleSetFileAttributeFailure({})[{}] {}:{}={} unsupported: {}", this.getServerSession(), file, view, attribute, value, e.getMessage());
            }
        } else {
            this.log.warn("handleSetFileAttributeFailure({})[{}] {}:{}={} - failed ({}) to set: {}", this.getServerSession(), file, view, attribute, value, e.getClass().getSimpleName(), e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleSetFileAttributeFailure(" + this.getServerSession() + ")[" + file + "] " + view + ":" + attribute + "=" + value + " failure details", e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        unsupported.add(attribute);
    }

    protected void setFileAttribute(Path file, String view, String attribute, Object value, LinkOption ... options) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("setFileAttribute({})[{}] {}:{}={}", this.getServerSession(), file, view, attribute, value);
        }
        if ("acl".equalsIgnoreCase(attribute) && "acl".equalsIgnoreCase(view)) {
            List acl = (List)value;
            this.setFileAccessControl(file, acl, options);
        } else if ("permissions".equalsIgnoreCase(attribute)) {
            Set perms = (Set)value;
            this.setFilePermissions(file, perms, options);
        } else if ("owner".equalsIgnoreCase(attribute) || "group".equalsIgnoreCase(attribute)) {
            this.setFileOwnership(file, attribute, (Principal)value, options);
        } else if ("creationTime".equalsIgnoreCase(attribute) || "lastModifiedTime".equalsIgnoreCase(attribute) || "lastAccessTime".equalsIgnoreCase(attribute)) {
            this.setFileTime(file, view, attribute, (FileTime)value, options);
        } else if ("extended".equalsIgnoreCase(view) && "extended".equalsIgnoreCase(attribute)) {
            Map extensions = (Map)value;
            this.setFileExtensions(file, extensions, options);
        } else {
            Files.setAttribute(file, view + ":" + attribute, value, options);
        }
    }

    protected void setFileTime(Path file, String view, String attribute, FileTime value, LinkOption ... options) throws IOException {
        if (value == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setFileTime({})[{}] {}:{}={}", this.getServerSession(), file, view, attribute, value);
        }
        Files.setAttribute(file, view + ":" + attribute, value, options);
    }

    protected void setFileOwnership(Path file, String attribute, Principal value, LinkOption ... options) throws IOException {
        if (value == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setFileOwnership({})[{}] {}={}", this.getServerSession(), file, attribute, value);
        }
        if ("owner".equalsIgnoreCase(attribute)) {
            FileOwnerAttributeView view = Files.getFileAttributeView(file, FileOwnerAttributeView.class, options);
            if (view == null) {
                throw new UnsupportedOperationException("Owner view not supported for " + file);
            }
            if (!(value instanceof UserPrincipal)) {
                throw new StreamCorruptedException("Owner is not " + UserPrincipal.class.getSimpleName() + ": " + value.getClass().getSimpleName());
            }
            view.setOwner((UserPrincipal)value);
        } else if ("group".equalsIgnoreCase(attribute)) {
            PosixFileAttributeView view = Files.getFileAttributeView(file, PosixFileAttributeView.class, options);
            if (view == null) {
                throw new UnsupportedOperationException("POSIX view not supported");
            }
            if (!(value instanceof GroupPrincipal)) {
                throw new StreamCorruptedException("Group is not " + GroupPrincipal.class.getSimpleName() + ": " + value.getClass().getSimpleName());
            }
            view.setGroup((GroupPrincipal)value);
        } else {
            throw new UnsupportedOperationException("Unknown ownership attribute: " + attribute);
        }
    }

    protected void setFileExtensions(Path file, Map<String, byte[]> extensions, LinkOption ... options) throws IOException {
        if (GenericUtils.isEmpty(extensions)) {
            return;
        }
        int version = this.getVersion();
        if (version < 6) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("setFileExtensions({})[{}]: {}", this.getServerSession(), file, extensions);
            }
        } else {
            throw new UnsupportedOperationException("File extensions not supported");
        }
    }

    protected void setFilePermissions(Path file, Set<PosixFilePermission> perms, LinkOption ... options) throws IOException {
        if (OsUtils.isWin32()) {
            IoUtils.setPermissionsToFile(file.toFile(), perms);
            return;
        }
        PosixFileAttributeView view = Files.getFileAttributeView(file, PosixFileAttributeView.class, options);
        if (view == null) {
            throw new UnsupportedOperationException("POSIX view not supported for " + file);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("setFilePermissions({})[{}] {}", this.getServerSession(), file, perms);
        }
        view.setPermissions(perms);
    }

    protected void setFileAccessControl(Path file, List<AclEntry> acl, LinkOption ... options) throws IOException {
        AclFileAttributeView view = Files.getFileAttributeView(file, AclFileAttributeView.class, options);
        if (view == null) {
            throw new UnsupportedOperationException("ACL view not supported for " + file);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("setFileAccessControl({})[{}] {}", this.getServerSession(), file, acl);
        }
        view.setAcl(acl);
    }

    protected void handleUnsupportedAttributes(Collection<String> attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        String attrsList = GenericUtils.join(attributes, ',');
        UnsupportedAttributePolicy unsupportedAttributePolicy = this.getUnsupportedAttributePolicy();
        switch (unsupportedAttributePolicy) {
            case Ignore: {
                break;
            }
            case Warn: {
                this.log.warn("Unsupported attributes: " + attrsList);
                break;
            }
            case ThrowException: {
                throw new UnsupportedOperationException("Unsupported attributes: " + attrsList);
            }
            default: {
                this.log.warn("Unknown policy for attributes=" + attrsList + ": " + (Object)((Object)unsupportedAttributePolicy));
            }
        }
    }

    protected GroupPrincipal toGroup(Path file, GroupPrincipal name) throws IOException {
        String groupName = name.toString();
        FileSystem fileSystem = file.getFileSystem();
        UserPrincipalLookupService lookupService = fileSystem.getUserPrincipalLookupService();
        try {
            if (lookupService == null) {
                throw new UserPrincipalNotFoundException(groupName);
            }
            return lookupService.lookupPrincipalByGroupName(groupName);
        }
        catch (IOException e) {
            this.handleUserPrincipalLookupServiceException(GroupPrincipal.class, groupName, e);
            return null;
        }
    }

    protected UserPrincipal toUser(Path file, UserPrincipal name) throws IOException {
        String username = name.toString();
        FileSystem fileSystem = file.getFileSystem();
        UserPrincipalLookupService lookupService = fileSystem.getUserPrincipalLookupService();
        try {
            if (lookupService == null) {
                throw new UserPrincipalNotFoundException(username);
            }
            return lookupService.lookupPrincipalByName(username);
        }
        catch (IOException e) {
            this.handleUserPrincipalLookupServiceException(UserPrincipal.class, username, e);
            return null;
        }
    }

    protected void handleUserPrincipalLookupServiceException(Class<? extends Principal> principalType, String name, IOException e) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("handleUserPrincipalLookupServiceException(" + principalType.getSimpleName() + "[" + name + "]) details", e);
        }
        UnsupportedAttributePolicy unsupportedAttributePolicy = this.getUnsupportedAttributePolicy();
        switch (unsupportedAttributePolicy) {
            case Ignore: {
                break;
            }
            case Warn: {
                this.log.warn("handleUserPrincipalLookupServiceException(" + principalType.getSimpleName() + "[" + name + "]) failed (" + e.getClass().getSimpleName() + "): " + e.getMessage());
                break;
            }
            case ThrowException: {
                throw e;
            }
            default: {
                this.log.warn("Unknown policy for principal=" + principalType.getSimpleName() + "[" + name + "]: " + (Object)((Object)unsupportedAttributePolicy));
            }
        }
    }

    protected Map<String, Object> readAttrs(Buffer buffer) throws IOException {
        return SftpHelper.readAttrs(buffer, this.getVersion());
    }

    protected <H extends Handle> H validateHandle(String handle, Handle h, Class<H> type) throws IOException {
        if (h == null) {
            throw new NoSuchFileException(handle, handle, "No such current handle");
        }
        Class<?> t = h.getClass();
        if (!type.isAssignableFrom(t)) {
            throw new InvalidHandleException(handle, h, type);
        }
        return (H)((Handle)type.cast(h));
    }

    protected void sendStatus(Buffer buffer, int id, Throwable e, int cmd, Object ... args) throws IOException {
        SftpErrorStatusDataHandler handler = this.getErrorStatusDataHandler();
        int subStatus = handler.resolveSubStatus(this, id, e, cmd, args);
        String message = handler.resolveErrorMessage(this, id, e, subStatus, cmd, args);
        String lang = handler.resolveErrorLanguage(this, id, e, subStatus, cmd, args);
        this.sendStatus(buffer, id, subStatus, message, lang);
    }

    protected void sendStatus(Buffer buffer, int id, int substatus, String msg) throws IOException {
        this.sendStatus(buffer, id, substatus, msg != null ? msg : "", "");
    }

    protected void sendStatus(Buffer buffer, int id, int substatus, String msg, String lang) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doSendStatus({})[id={}] SSH_FXP_STATUS (substatus={}, lang={}, msg={})", this.getServerSession(), id, SftpConstants.getStatusName(substatus), lang, msg);
        }
        buffer.putByte((byte)101);
        buffer.putInt(id);
        buffer.putInt(substatus);
        buffer.putString(msg);
        buffer.putString(lang);
        this.send(buffer);
    }

    protected abstract void send(Buffer var1) throws IOException;

    protected Path resolveNormalizedLocation(String remotePath) throws IOException, InvalidPathException {
        Path resolvedPath = this.resolveFile(remotePath);
        return this.normalize(resolvedPath);
    }

    protected Path normalize(Path f) {
        if (f == null) {
            return null;
        }
        Path abs = f.isAbsolute() ? f : f.toAbsolutePath();
        return abs.normalize();
    }

    protected Path resolveFile(String remotePath) throws IOException, InvalidPathException {
        Path defaultDir = this.getDefaultDirectory();
        String path = SelectorUtils.translateToLocalFileSystemPath(remotePath, '/', defaultDir.getFileSystem());
        Path p = defaultDir.resolve(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("resolveFile({}) {} => {}", this.getServerSession(), remotePath, p);
        }
        return p;
    }
}

