/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import hudson.remoting.Channel;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.remoting.engine.JnlpClientDatabase;
import org.jenkinsci.remoting.engine.JnlpConnectionState;
import org.jenkinsci.remoting.engine.JnlpConnectionStateListener;

public abstract class JnlpProtocolHandler<STATE extends JnlpConnectionState> {
    @CheckForNull
    private final JnlpClientDatabase clientDatabase;
    private final boolean preferNio;

    JnlpProtocolHandler(@Nullable JnlpClientDatabase clientDatabase, boolean preferNio) {
        this.clientDatabase = clientDatabase;
        this.preferNio = preferNio;
    }

    @CheckForNull
    public JnlpClientDatabase getClientDatabase() {
        return this.clientDatabase;
    }

    public boolean isPreferNio() {
        return this.preferNio;
    }

    public abstract String getName();

    public boolean isEnabled() {
        return !Boolean.getBoolean("org.jenkinsci.remoting.engine." + this.getClass().getSimpleName().replace("Handler", ".disabled"));
    }

    @Nonnull
    protected abstract STATE createConnectionState(@Nonnull Socket var1, @Nonnull List<? extends JnlpConnectionStateListener> var2) throws IOException;

    @Nonnull
    public final Future<Channel> handle(@Nonnull Socket socket, @Nonnull Map<String, String> headers, JnlpConnectionStateListener ... listeners) throws IOException {
        return this.handle(socket, headers, Arrays.asList(listeners));
    }

    @Nonnull
    public abstract Future<Channel> handle(@Nonnull Socket var1, @Nonnull Map<String, String> var2, @Nonnull List<? extends JnlpConnectionStateListener> var3) throws IOException;

    @Nonnull
    public final Future<Channel> connect(@Nonnull Socket socket, @Nonnull Map<String, String> headers, JnlpConnectionStateListener ... listeners) throws IOException {
        return this.connect(socket, headers, Arrays.asList(listeners));
    }

    @Nonnull
    public abstract Future<Channel> connect(@Nonnull Socket var1, @Nonnull Map<String, String> var2, @Nonnull List<? extends JnlpConnectionStateListener> var3) throws IOException;
}

