/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.nio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;

public class SelectableFileChannelFactory {
    private static boolean warned = false;
    private static final Logger LOGGER = Logger.getLogger(SelectableFileChannelFactory.class.getName());

    @CheckForNull
    protected FileInputStream unwrap(InputStream i) {
        if (i instanceof BufferedInputStream) {
            try {
                Field $in = FilterInputStream.class.getDeclaredField("in");
                $in.setAccessible(true);
                return this.unwrap((InputStream)$in.get(i));
            }
            catch (NoSuchFieldException e) {
                this.warn(e);
                return null;
            }
            catch (IllegalAccessException e) {
                this.warn(e);
                return null;
            }
        }
        if (i instanceof FileInputStream) {
            return (FileInputStream)i;
        }
        return null;
    }

    @CheckForNull
    protected FileOutputStream unwrap(OutputStream i) {
        if (i instanceof BufferedOutputStream) {
            try {
                Field $in = FilterOutputStream.class.getDeclaredField("out");
                $in.setAccessible(true);
                return this.unwrap((OutputStream)$in.get(i));
            }
            catch (NoSuchFieldException e) {
                this.warn(e);
                return null;
            }
            catch (IllegalAccessException e) {
                this.warn(e);
                return null;
            }
        }
        if (i instanceof FileOutputStream) {
            return (FileOutputStream)i;
        }
        return null;
    }

    @CheckForNull
    public SocketChannel create(InputStream in) throws IOException {
        return this.create(this.unwrap(in));
    }

    @CheckForNull
    public SocketChannel create(OutputStream out) throws IOException {
        return this.create(this.unwrap(out));
    }

    @CheckForNull
    public SocketChannel create(FileInputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return this.create(in.getFD());
    }

    @CheckForNull
    public SocketChannel create(FileOutputStream out) throws IOException {
        if (out == null) {
            return null;
        }
        return this.create(out.getFD());
    }

    @CheckForNull
    public SocketChannel create(FileDescriptor fd) {
        if (File.pathSeparatorChar == ';') {
            return null;
        }
        try {
            Constructor<?> $c = Class.forName("sun.nio.ch.SocketChannelImpl").getDeclaredConstructor(SelectorProvider.class, FileDescriptor.class, InetSocketAddress.class);
            $c.setAccessible(true);
            Method $m = fd.getClass().getDeclaredMethod("incrementAndGetUseCount", new Class[0]);
            $m.setAccessible(true);
            $m.invoke((Object)fd, new Object[0]);
            return (SocketChannel)$c.newInstance(SelectorProvider.provider(), fd, null);
        }
        catch (NoSuchMethodException e) {
            this.warn(e);
            return null;
        }
        catch (SecurityException e) {
            this.warn(e);
            return null;
        }
        catch (ClassNotFoundException e) {
            this.warn(e);
            return null;
        }
        catch (IllegalAccessException e) {
            this.warn(e);
            return null;
        }
        catch (InvocationTargetException e) {
            this.warn(e);
            return null;
        }
        catch (InstantiationException e) {
            this.warn(e);
            return null;
        }
    }

    private void warn(Exception e) {
        if (!warned) {
            warned = true;
            LOGGER.log(Level.WARNING, "Failed to wrap aFileDescriptor into SocketChannel", e);
        }
    }
}

