/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.internal.json;

import com.taskadapter.redmineapi.internal.json.JsonObjectWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONWriter;

public class JsonOutput {
    public static void addIfNotNull(JSONWriter writer, String field, String value) throws JSONException {
        if (value == null) {
            return;
        }
        writer.key(field);
        writer.value((Object)value);
    }

    public static void addIfNotNull(JSONWriter writer, String field, Integer value) throws JSONException {
        if (value == null) {
            return;
        }
        writer.key(field);
        writer.value((Object)value);
    }

    public static void addIfNotNull(JSONWriter writer, String field, Float value) throws JSONException {
        if (value == null) {
            return;
        }
        writer.key(field);
        writer.value((Object)value);
    }

    public static void addIfNotNull(JSONWriter writer, String field, Date value, SimpleDateFormat format) throws JSONException {
        if (value == null) {
            return;
        }
        writer.key(field);
        writer.value((Object)format.format(value));
    }

    public static void add(JSONWriter writer, String field, Date value, SimpleDateFormat format) throws JSONException {
        writer.key(field);
        if (value == null) {
            writer.value(null);
        } else {
            writer.value((Object)format.format(value));
        }
    }

    public static <T> void addIfNotNull(JSONWriter writer, String field, T value, JsonObjectWriter<T> objWriter) throws JSONException {
        if (value == null) {
            return;
        }
        writer.key(field);
        writer.object();
        objWriter.write(writer, value);
        writer.endObject();
    }

    public static <T> void addArrayIfNotNull(JSONWriter writer, String field, Collection<T> items, JsonObjectWriter<T> objWriter) throws JSONException {
        if (items == null) {
            return;
        }
        JsonOutput.addCollection(writer, field, items, objWriter);
    }

    public static <T> void addArrayIfNotEmpty(JSONWriter writer, String field, Collection<T> items, JsonObjectWriter<T> objWriter) throws JSONException {
        if (items == null || items.size() == 0) {
            return;
        }
        JsonOutput.addCollection(writer, field, items, objWriter);
    }

    private static <T> void addCollection(JSONWriter writer, String field, Collection<T> items, JsonObjectWriter<T> objWriter) throws JSONException {
        writer.key(field);
        writer.array();
        for (T item : items) {
            writer.object();
            objWriter.write(writer, item);
            writer.endObject();
        }
        writer.endArray();
    }
}

