/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support;

import com.thoughtworks.xstream.XStream;
import hudson.XmlFile;
import hudson.util.XStream2;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nonnull;

public class PipelineIOUtils {
    public static void writeByXStream(@Nonnull Object toWrite, @Nonnull File location, @Nonnull XStream2 xstream, boolean atomicWrite) throws IOException {
        if (atomicWrite) {
            XmlFile file = new XmlFile((XStream)xstream, location);
            file.write(toWrite);
        } else {
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(location.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
                xstream.toXMLUTF8(toWrite, (OutputStream)os);
            }
            catch (InvalidPathException ipe) {
                throw new IOException(ipe);
            }
        }
    }
}

