/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.actions;

import com.google.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.AnnotatedLargeText;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.plugins.workflow.actions.FlowNodeAction;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.actions.PersistentAction;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.framework.io.ByteBuffer;

public class LogActionImpl
extends LogAction
implements FlowNodeAction,
PersistentAction {
    private static final Logger LOGGER = Logger.getLogger(LogActionImpl.class.getName());
    private transient FlowNode parent;
    private volatile transient File log;
    private String charset;

    @Nonnull
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION_EXCEPTION_EDGE"})
    public static TaskListener stream(final @Nonnull FlowNode node, @CheckForNull ConsoleLogFilter filter) throws IOException, InterruptedException {
        LogActionImpl la = (LogActionImpl)node.getAction(LogActionImpl.class);
        if (la == null) {
            la = new LogActionImpl(node, Charset.defaultCharset());
            node.addAction((Action)la);
        }
        OutputStream os = new FileOutputStream(la.getLogFile(), true);
        if (filter != null) {
            os = filter.decorateLogger((AbstractBuild)null, os);
        }
        final StreamTaskListener result = new StreamTaskListener(os);
        final AtomicReference<1> graphListener = new AtomicReference<1>();
        LOGGER.log(Level.FINE, "opened log for {0}", node.getDisplayFunctionName());
        graphListener.set(new GraphListener.Synchronous(){

            public void onNewHead(FlowNode newNode) {
                if (!node.isActive()) {
                    node.getExecution().removeListener((GraphListener)graphListener.get());
                    result.getLogger().close();
                    LOGGER.log(Level.FINE, "closed log for {0}", node.getDisplayFunctionName());
                }
            }
        });
        node.getExecution().addListener((GraphListener)graphListener.get());
        return result;
    }

    private LogActionImpl(FlowNode parent, Charset charset) throws IOException {
        if (!parent.isActive()) {
            throw new IOException("cannot start writing logs to a finished node " + parent + " " + parent.getDisplayFunctionName() + " in " + parent.getExecution());
        }
        this.parent = parent;
        this.charset = charset.name();
    }

    @Restricted(value={DoNotUse.class})
    public FlowNode getParent() {
        return this.parent;
    }

    public AnnotatedLargeText<? extends FlowNode> getLogText() {
        try {
            this.getLogFile();
            if (!this.log.exists()) {
                return new AnnotatedLargeText(new ByteBuffer(), this.getCharset(), !this.parent.isActive(), (Object)this.parent);
            }
            return new AnnotatedLargeText(this.log, this.getCharset(), !this.parent.isActive(), (Object)this.parent);
        }
        catch (IOException e) {
            PrintStream ps;
            ByteBuffer buf = new ByteBuffer();
            try {
                ps = new PrintStream((OutputStream)buf, false, "UTF-8");
            }
            catch (UnsupportedEncodingException x) {
                throw new AssertionError((Object)x);
            }
            ps.println("Failed to find log file for id=" + this.parent.getId());
            e.printStackTrace(ps);
            ps.close();
            return new AnnotatedLargeText(buf, Charsets.UTF_8, true, (Object)this.parent);
        }
    }

    private File getLogFile() throws IOException {
        if (this.log == null) {
            this.log = new File(this.parent.getExecution().getOwner().getRootDir(), this.parent.getId() + ".log");
        }
        return this.log;
    }

    @Restricted(value={DoNotUse.class})
    public void writeLogTo(long offset, XMLOutput out) throws IOException {
        AnnotatedLargeText<? extends FlowNode> l = this.getLogText();
        if (l != null) {
            l.writeHtmlTo(offset, out.asWriter());
        }
    }

    public void onLoad(FlowNode parent) {
        this.parent = parent;
    }

    private Charset getCharset() {
        if (this.charset == null) {
            return Charset.defaultCharset();
        }
        return Charset.forName(this.charset);
    }

    public String toString() {
        return "LogActionImpl[" + this.log + "]";
    }
}

