/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.actions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.model.Queue;
import hudson.model.labels.LabelAtom;
import hudson.security.AccessControlled;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.FilePathUtils;
import org.jenkinsci.plugins.workflow.actions.FlowNodeAction;
import org.jenkinsci.plugins.workflow.actions.WorkspaceAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public final class WorkspaceActionImpl
extends WorkspaceAction
implements FlowNodeAction {
    private static final long serialVersionUID = 1L;
    private final String node;
    private final String path;
    private final Set<LabelAtom> labels;
    private transient FlowNode parent;

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="TODO 1.653+ switch to Jenkins.getInstanceOrNull")
    public WorkspaceActionImpl(FilePath workspace, FlowNode parent) {
        this.node = FilePathUtils.getNodeName((FilePath)workspace);
        Jenkins j = Jenkins.getInstance();
        Jenkins n = j == null ? null : (this.node.isEmpty() ? j : j.getNode(this.node));
        this.labels = new TreeSet<LabelAtom>();
        if (n != null) {
            this.labels.addAll(n.getAssignedLabels());
            this.labels.remove(n.getSelfLabel());
        }
        this.path = workspace.getRemote();
        this.parent = parent;
    }

    public String getNode() {
        return this.node;
    }

    public String getPath() {
        return this.path;
    }

    public Set<LabelAtom> getLabels() {
        return this.labels;
    }

    public FlowNode getParent() {
        return this.parent;
    }

    public void onLoad(FlowNode parent) {
        this.parent = parent;
    }

    public String getIconFileName() {
        return "folder.png";
    }

    public String getDisplayName() {
        return "Workspace";
    }

    public String getUrlName() {
        return "ws";
    }

    public DirectoryBrowserSupport doDynamic() throws IOException {
        FilePath ws;
        Queue.Executable executable = this.parent.getExecution().getOwner().getExecutable();
        if (executable instanceof AccessControlled) {
            ((AccessControlled)executable).checkPermission(Item.WORKSPACE);
        }
        if ((ws = this.getWorkspace()) == null) {
            throw new FileNotFoundException();
        }
        return new DirectoryBrowserSupport((ModelObject)this, ws, "Workspace", "folder.png", true);
    }
}

