/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.concurrent;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

class ListFuture<V>
extends AbstractFuture<List<V>> {
    ImmutableList<? extends ListenableFuture<? extends V>> futures;
    final boolean allMustSucceed;
    final AtomicInteger remaining;
    List<V> values;

    ListFuture(ImmutableList<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed, Executor listenerExecutor) {
        this.futures = futures;
        this.values = Lists.newArrayListWithCapacity((int)futures.size());
        this.allMustSucceed = allMustSucceed;
        this.remaining = new AtomicInteger(futures.size());
        this.init(listenerExecutor);
    }

    private void init(Executor listenerExecutor) {
        this.addListener(new Runnable(){

            @Override
            public void run() {
                ListFuture.this.values = null;
                ListFuture.this.futures = null;
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        if (this.futures.isEmpty()) {
            this.set(Lists.newArrayList(this.values));
            return;
        }
        for (int i = 0; i < this.futures.size(); ++i) {
            this.values.add(null);
        }
        ImmutableList<? extends ListenableFuture<? extends V>> localFutures = this.futures;
        int i = 0;
        while (i < localFutures.size()) {
            final ListenableFuture listenable = (ListenableFuture)localFutures.get(i);
            final int index = i++;
            listenable.addListener(new Runnable(){

                @Override
                public void run() {
                    ListFuture.this.setOneValue(index, (Future)listenable);
                }
            }, listenerExecutor);
        }
    }

    /*
     * Exception decompiling
     */
    private void setOneValue(int index, Future<? extends V> future) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<V> get() throws InterruptedException, ExecutionException {
        this.callAllGets();
        return (List)super.get();
    }

    private void callAllGets() throws InterruptedException {
        ImmutableList<ListenableFuture<V>> oldFutures = this.futures;
        if (oldFutures != null && !this.isDone()) {
            for (ListenableFuture future : oldFutures) {
                while (!future.isDone()) {
                    try {
                        future.get();
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        if (!this.allMustSucceed) continue;
                        return;
                    }
                }
            }
        }
    }
}

