/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.concurrent;

import hudson.Util;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Timeout
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(Timeout.class.getName());
    private static final ScheduledExecutorService interruptions = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamingThreadFactory((ThreadFactory)((Object)new ClassloaderSanityDaemonThreadFactory()), "Timeout.interruptions"));
    private final Thread thread = Thread.currentThread();
    private volatile boolean completed;
    private long endTime;

    private Timeout(long time, TimeUnit unit) {
        LOGGER.log(Level.FINER, "Might interrupt {0} after {1} {2}", new Object[]{this.thread.getName(), time, unit});
        this.ping(time, unit);
    }

    @Override
    public void close() {
        this.completed = true;
        LOGGER.log(Level.FINER, "completed {0}", this.thread.getName());
    }

    private void ping(long time, TimeUnit unit) {
        interruptions.schedule(() -> {
            if (this.completed) {
                LOGGER.log(Level.FINER, "{0} already finished, no need to interrupt", this.thread.getName());
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                Throwable t = new Throwable();
                t.setStackTrace(this.thread.getStackTrace());
                LOGGER.log(Level.FINE, "Interrupting " + this.thread.getName() + " after " + time + " " + (Object)((Object)unit), t);
            }
            this.thread.interrupt();
            if (this.endTime == 0L) {
                this.endTime = System.nanoTime();
            } else {
                String unresponsiveness = Util.getTimeSpanString((long)((System.nanoTime() - this.endTime) / 1000000L));
                LOGGER.log(Level.INFO, "{0} unresponsive for {1}", new Object[]{this.thread.getName(), unresponsiveness});
            }
            this.ping(5L, TimeUnit.SECONDS);
        }, time, unit);
    }

    public static Timeout limit(long time, TimeUnit unit) {
        return new Timeout(time, unit);
    }

    static class ClassloaderSanityDaemonThreadFactory
    extends DaemonThreadFactory {
        ClassloaderSanityDaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = super.newThread(r);
            t.setContextClassLoader(Timeout.class.getClassLoader());
            return t;
        }
    }
}

