/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.pickles;

import com.google.common.util.concurrent.ListenableFuture;
import hudson.Extension;
import hudson.Functions;
import hudson.remoting.ProxyException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.output.NullOutputStream;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.pickles.PickleFactory;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class ThrowablePickle
extends Pickle {
    private static final Logger LOGGER = Logger.getLogger(ThrowablePickle.class.getName());
    private static final long serialVersionUID = 1L;
    private final ProxyException t;
    private final String clazz;
    private final String error;

    private ThrowablePickle(Throwable t, Exception x) {
        LOGGER.log(Level.FINE, "Sanitizing {0} due to {1}", new Object[]{t, x});
        this.t = new ProxyException(t);
        this.clazz = t.getClass().getName();
        this.error = Functions.printThrowable((Throwable)x);
    }

    public ListenableFuture<?> rehydrate(FlowExecutionOwner owner) {
        try {
            owner.getListener().getLogger().println(this.error.trim());
            owner.getListener().getLogger().println("Loading unserializable exception; result will no longer be assignable to class " + this.clazz);
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        return Futures.immediateFuture(this.t);
    }

    @Extension
    public static final class Factory
    extends PickleFactory {
        public Pickle writeReplace(Object o) {
            if (o instanceof Throwable) {
                Throwable t = (Throwable)o;
                try (NullOutputStream ignore = new NullOutputStream();
                     Marshaller marshaller = new RiverMarshallerFactory().createMarshaller(new MarshallingConfiguration());){
                    GroovySandbox.runInSandbox(() -> Factory.lambda$writeReplace$0(marshaller, (OutputStream)ignore, t), (Whitelist)Whitelist.all());
                }
                catch (Exception x) {
                    return new ThrowablePickle(t, x);
                }
            }
            return null;
        }

        private static /* synthetic */ Object lambda$writeReplace$0(Marshaller marshaller, OutputStream ignore, Throwable t) throws Exception {
            marshaller.start(Marshalling.createByteOutput((OutputStream)ignore));
            marshaller.writeObject((Object)t);
            return null;
        }
    }
}

