/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.pickles;

import com.google.common.util.concurrent.AbstractFuture;
import hudson.Functions;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;

public abstract class TryRepeatedly<V>
extends AbstractFuture<V> {
    private static final Logger LOGGER = Logger.getLogger(TryRepeatedly.class.getName());
    private final int delay;
    private ScheduledFuture<?> next;
    private float backoff = 1.0f;
    private static final float BACKOFF_EXPONENT = 1.42f;
    private int retriesRemaining;

    protected TryRepeatedly(int delay) {
        this(delay, delay);
    }

    protected TryRepeatedly(int delay, int initialDelay) {
        this.delay = delay;
        this.tryLater(initialDelay);
    }

    @Nonnull
    protected FlowExecutionOwner getOwner() {
        return FlowExecutionOwner.dummyOwner();
    }

    protected void printWaitingMessage(@Nonnull TaskListener listener) {
        listener.getLogger().println("Still trying to load " + (Object)((Object)this));
    }

    private void tryLater(int currentDelay) {
        if (this.isCancelled()) {
            return;
        }
        this.next = Timer.get().schedule(new Runnable(){

            @Override
            public void run() {
                block9: {
                    try {
                        Object v = TryRepeatedly.this.tryResolve();
                        if (v == null) {
                            if (TryRepeatedly.this.retriesRemaining == 0) {
                                try {
                                    TaskListener listener = TryRepeatedly.this.getOwner().getListener();
                                    try {
                                        TryRepeatedly.this.printWaitingMessage(listener);
                                    }
                                    catch (Exception x) {
                                        listener.getLogger().println(Functions.printThrowable((Throwable)x).trim());
                                    }
                                }
                                catch (IOException x) {
                                    LOGGER.log(Level.WARNING, null, x);
                                }
                                TryRepeatedly.this.backoff = TryRepeatedly.this.backoff * 1.42f;
                                TryRepeatedly.this.retriesRemaining = (int)TryRepeatedly.this.backoff;
                            } else {
                                TryRepeatedly.this.retriesRemaining--;
                            }
                            TryRepeatedly.this.tryLater(TryRepeatedly.this.delay);
                            break block9;
                        }
                        TryRepeatedly.this.set(v);
                    }
                    catch (Throwable t) {
                        TryRepeatedly.this.setException(t);
                    }
                }
            }
        }, (long)currentDelay, TimeUnit.SECONDS);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.next != null) {
            this.next.cancel(mayInterruptIfRunning);
        }
        LOGGER.log(Level.FINE, "Cancelling {0} in {1}", new Object[]{this, this.getOwner()});
        return super.cancel(mayInterruptIfRunning);
    }

    @CheckForNull
    protected abstract V tryResolve() throws Exception;
}

