/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.pickles.serialization;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.marshalling.ObjectResolver;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.DryCapsule;

public class PickleResolver
implements ObjectResolver {
    private final List<? extends Pickle> pickles;
    private List<Object> values;
    private final FlowExecutionOwner owner;

    @Deprecated
    public PickleResolver(List<? extends Pickle> pickles) {
        this(pickles, FlowExecutionOwner.dummyOwner());
    }

    public PickleResolver(List<? extends Pickle> pickles, FlowExecutionOwner owner) {
        this.pickles = pickles;
        this.owner = owner;
    }

    public Object get(int id) {
        return this.values.get(id);
    }

    @Deprecated
    public ListenableFuture<PickleResolver> rehydrate() {
        return this.rehydrate(new ArrayList());
    }

    public ListenableFuture<PickleResolver> rehydrate(Collection<ListenableFuture<?>> pickleFutures) {
        if (this.pickles.isEmpty()) {
            return Futures.immediateFuture(this);
        }
        ArrayList<ListenableFuture<Object>> members = new ArrayList<ListenableFuture<Object>>();
        for (Pickle pickle : this.pickles) {
            ListenableFuture future;
            try {
                future = pickle.rehydrate(this.owner);
            }
            catch (RuntimeException x) {
                future = Futures.immediateFailedFuture(x);
            }
            pickleFutures.add(future);
            members.add(Futures.transform(future, new Function<Object, Object>(){

                public Object apply(Object input) {
                    return input;
                }
            }));
        }
        ListenableFuture all = Futures.allAsList(members);
        return Futures.transform(all, new Function<List<Object>, PickleResolver>(){

            public PickleResolver apply(List<Object> input) {
                PickleResolver.this.values = input;
                return PickleResolver.this;
            }
        });
    }

    public Object readResolve(Object o) {
        if (o instanceof DryCapsule) {
            DryCapsule cap = (DryCapsule)o;
            return this.get(cap.id);
        }
        return o;
    }

    public Object writeReplace(Object original) {
        throw new IllegalStateException();
    }
}

