/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import hudson.AbortException;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.scm.RunWithSCM;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.support.actions.EnvironmentAction;

public final class RunWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String externalizableId;
    private final boolean currentBuild;

    public RunWrapper(Run<?, ?> build, boolean currentBuild) {
        this.externalizableId = build.getExternalizableId();
        this.currentBuild = currentBuild;
    }

    @CheckForNull
    public Run<?, ?> getRawBuild() {
        return Run.fromExternalizableId((String)this.externalizableId);
    }

    @Nonnull
    private Run<?, ?> build() throws AbortException {
        Run<?, ?> r = this.getRawBuild();
        if (r == null) {
            throw new AbortException("No build record " + this.externalizableId + " could be located.");
        }
        return r;
    }

    @Whitelisted
    public void setResult(String result) throws AbortException {
        if (!this.currentBuild) {
            throw new SecurityException("can only set the result property on the current build");
        }
        this.build().setResult(Result.fromString((String)result));
    }

    @Whitelisted
    public void setDescription(String d) throws IOException {
        if (!this.currentBuild) {
            throw new SecurityException("can only set the description property on the current build");
        }
        try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
            this.build().setDescription(d);
        }
    }

    @Whitelisted
    public void setDisplayName(String n) throws IOException {
        if (!this.currentBuild) {
            throw new SecurityException("can only set the displayName property on the current build");
        }
        try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
            this.build().setDisplayName(n);
        }
    }

    @Whitelisted
    public void setKeepLog(boolean b) throws IOException {
        if (!this.currentBuild) {
            throw new SecurityException("can only set the keepLog property on the current build");
        }
        try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
            this.build().keepLog(b);
        }
    }

    @Whitelisted
    public int getNumber() throws AbortException {
        return this.build().getNumber();
    }

    @Whitelisted
    @CheckForNull
    public String getResult() throws AbortException {
        Result result = this.build().getResult();
        return result != null ? result.toString() : null;
    }

    @Whitelisted
    @Nonnull
    public String getCurrentResult() throws AbortException {
        Result result = this.build().getResult();
        return result != null ? result.toString() : Result.SUCCESS.toString();
    }

    @Whitelisted
    public boolean resultIsBetterOrEqualTo(String other) throws AbortException {
        Result result = this.build().getResult();
        if (result == null) {
            result = Result.SUCCESS;
        }
        Result otherResult = Result.fromString((String)other);
        return result.isBetterOrEqualTo(otherResult);
    }

    @Whitelisted
    public boolean resultIsWorseOrEqualTo(String other) throws AbortException {
        Result result = this.build().getResult();
        if (result == null) {
            result = Result.SUCCESS;
        }
        Result otherResult = Result.fromString((String)other);
        return result.isWorseOrEqualTo(otherResult);
    }

    @Whitelisted
    public long getTimeInMillis() throws AbortException {
        return this.build().getTimeInMillis();
    }

    @Whitelisted
    public long getStartTimeInMillis() throws AbortException {
        return this.build().getStartTimeInMillis();
    }

    @Whitelisted
    public long getDuration() throws AbortException {
        return this.build().getDuration() != 0L ? this.build().getDuration() : System.currentTimeMillis() - this.build().getStartTimeInMillis();
    }

    @Whitelisted
    public String getDurationString() throws AbortException {
        return this.build().getDurationString();
    }

    @Whitelisted
    public String getDescription() throws AbortException {
        return this.build().getDescription();
    }

    @Whitelisted
    public String getDisplayName() throws AbortException {
        return this.build().getDisplayName();
    }

    @Whitelisted
    public String getFullDisplayName() throws AbortException {
        return this.build().getFullDisplayName();
    }

    @Whitelisted
    public boolean isKeepLog() throws AbortException {
        return this.build().isKeepLog();
    }

    @Whitelisted
    public String getProjectName() throws AbortException {
        return this.build().getParent().getName();
    }

    @Whitelisted
    public String getFullProjectName() throws AbortException {
        return this.build().getParent().getFullName();
    }

    @Whitelisted
    @CheckForNull
    public RunWrapper getPreviousBuild() throws AbortException {
        Run previousBuild = this.build().getPreviousBuild();
        return previousBuild != null ? new RunWrapper(previousBuild, false) : null;
    }

    @Whitelisted
    @CheckForNull
    public RunWrapper getNextBuild() throws AbortException {
        Run nextBuild = this.build().getNextBuild();
        return nextBuild != null ? new RunWrapper(nextBuild, false) : null;
    }

    @Whitelisted
    public String getId() throws AbortException {
        return this.build().getId();
    }

    @Whitelisted
    @Nonnull
    public Map<String, String> getBuildVariables() throws AbortException {
        Run<?, ?> build = this.build();
        if (build instanceof AbstractBuild) {
            HashMap buildVars = new HashMap();
            try {
                buildVars.putAll(build.getEnvironment(TaskListener.NULL));
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
            buildVars.putAll(((AbstractBuild)build).getBuildVariables());
            return Collections.unmodifiableMap(buildVars);
        }
        EnvironmentAction.IncludingOverrides env = (EnvironmentAction.IncludingOverrides)build.getAction(EnvironmentAction.IncludingOverrides.class);
        if (env != null) {
            return env.getOverriddenEnvironment();
        }
        return Collections.emptyMap();
    }

    @Whitelisted
    @Nonnull
    public List<RunWrapper> getUpstreamBuilds() throws AbortException {
        ArrayList<RunWrapper> upstreams = new ArrayList<RunWrapper>();
        Run<?, ?> build = this.build();
        for (Cause c : build.getCauses()) {
            if (!(c instanceof Cause.UpstreamCause)) continue;
            upstreams.addAll(this.upstreamCauseToRunWrappers((Cause.UpstreamCause)c));
        }
        return upstreams;
    }

    @Nonnull
    private List<RunWrapper> upstreamCauseToRunWrappers(@Nonnull Cause.UpstreamCause cause) {
        ArrayList<RunWrapper> upstreams = new ArrayList<RunWrapper>();
        Run r = cause.getUpstreamRun();
        if (r != null) {
            upstreams.add(new RunWrapper(r, false));
            for (Cause c : cause.getUpstreamCauses()) {
                if (!(c instanceof Cause.UpstreamCause)) continue;
                upstreams.addAll(this.upstreamCauseToRunWrappers((Cause.UpstreamCause)c));
            }
        }
        return upstreams;
    }

    @Whitelisted
    @Nonnull
    public String getAbsoluteUrl() throws AbortException {
        return this.build().getAbsoluteUrl();
    }

    @Whitelisted
    public List<ChangeLogSet<? extends ChangeLogSet.Entry>> getChangeSets() throws Exception {
        Run<?, ?> build = this.build();
        if (build instanceof RunWithSCM) {
            return ((RunWithSCM)build).getChangeSets();
        }
        try {
            return (List)build.getClass().getMethod("getChangeSets", new Class[0]).invoke(build, new Object[0]);
        }
        catch (NoSuchMethodException x) {
            return Collections.emptyList();
        }
    }
}

