/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.input;

import hudson.Extension;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.HyperlinkNote;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public final class POSTHyperlinkNote
extends HyperlinkNote {
    private static final Logger LOGGER = Logger.getLogger(POSTHyperlinkNote.class.getName());
    private final String url;

    public static String encodeTo(String url, String text) {
        try {
            return new POSTHyperlinkNote(url, text.length()).encode() + text;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to serialize " + POSTHyperlinkNote.class, e);
            return text;
        }
    }

    public POSTHyperlinkNote(String url, int length) {
        super("#", length);
        if (url.startsWith("/")) {
            StaplerRequest req = Stapler.getCurrentRequest();
            if (req != null) {
                url = req.getContextPath() + url;
            } else {
                Jenkins j = Jenkins.getInstance();
                if (j != null) {
                    String rootUrl = j.getRootUrl();
                    if (rootUrl != null) {
                        url = rootUrl + url.substring(1);
                    } else {
                        LOGGER.warning("You need to define the root URL of Jenkins");
                    }
                }
            }
        }
        this.url = url;
    }

    protected String extraAttributes() {
        return " onclick=\"new Ajax.Request('" + this.url + "'); return false\"";
    }

    @Extension
    public static final class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
        public String getDisplayName() {
            return "POST Hyperlinks";
        }
    }
}

