/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.storage;

import hudson.Util;
import hudson.model.Action;
import hudson.util.IOUtils;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.actions.FlowNodeAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.support.PipelineIOUtils;
import org.jenkinsci.plugins.workflow.support.storage.FlowNodeStorage;

public class BulkFlowNodeStorage
extends FlowNodeStorage {
    private final File dir;
    private final FlowExecution exec;
    private transient HashMap<String, Tag> nodes = null;
    private boolean isModified = false;
    public static final XStream2 XSTREAM = new XStream2();
    private static final Field FlowNode$exec;
    private static final Method FlowNode_setActions;

    File getStoreFile() throws IOException {
        return new File(this.dir, "flowNodeStore.xml");
    }

    public BulkFlowNodeStorage(FlowExecution exec, File dir) {
        this.exec = exec;
        this.dir = dir;
        this.nodes = null;
        this.setAvoidAtomicWrite(true);
    }

    HashMap<String, Tag> getOrLoadNodes() throws IOException {
        if (this.nodes == null) {
            if (this.dir.exists()) {
                File storeFile = this.getStoreFile();
                if (storeFile.exists()) {
                    HashMap roughNodes = null;
                    try {
                        roughNodes = (HashMap)XSTREAM.fromXML(this.getStoreFile());
                    }
                    catch (Exception ex) {
                        this.nodes = new HashMap();
                        throw new IOException("Failed to read nodes", ex);
                    }
                    if (roughNodes == null) {
                        this.nodes = new HashMap();
                        throw new IOException("Unable to load nodes, invalid data");
                    }
                    for (Tag t : roughNodes.values()) {
                        FlowNode fn = t.node;
                        try {
                            FlowNode$exec.set(fn, this.exec);
                        }
                        catch (IllegalAccessException e) {
                            throw (IllegalAccessError)new IllegalAccessError("Failed to set owner").initCause(e);
                        }
                        t.storeActions();
                        for (FlowNodeAction a : Util.filter(t.actions(), FlowNodeAction.class)) {
                            a.onLoad(fn);
                        }
                    }
                    this.nodes = roughNodes;
                } else {
                    this.nodes = new HashMap();
                }
            } else {
                IOUtils.mkdirs((File)this.dir);
                this.nodes = new HashMap();
            }
        }
        return this.nodes;
    }

    @Override
    @CheckForNull
    public FlowNode getNode(@Nonnull String id) throws IOException {
        Tag t = this.getOrLoadNodes().get(id);
        return t != null ? t.node : null;
    }

    @Override
    public void storeNode(@Nonnull FlowNode n, boolean delayWritingActions) throws IOException {
        Tag t = this.getOrLoadNodes().get(n.getId());
        if (t != null) {
            t.node = n;
            List act = n.getActions();
            Tag.access$102(t, act.toArray(new Action[act.size()]));
        } else {
            this.getOrLoadNodes().put(n.getId(), new Tag(n, n.getActions()));
        }
        this.isModified = true;
        if (!delayWritingActions) {
            this.flush();
        }
    }

    @Override
    public void storeNode(FlowNode n) throws IOException {
        this.flushNode(n);
    }

    @Override
    public void flushNode(@Nonnull FlowNode n) throws IOException {
        this.storeNode(n, false);
    }

    @Override
    public void flush() throws IOException {
        if (this.nodes != null && this.isModified) {
            if (!this.dir.exists()) {
                IOUtils.mkdirs((File)this.dir);
            }
            PipelineIOUtils.writeByXStream(this.nodes, this.getStoreFile(), XSTREAM, !this.isAvoidAtomicWrite());
            this.isModified = false;
        }
    }

    public List<Action> loadActions(@Nonnull FlowNode node) throws IOException {
        Tag t = this.getOrLoadNodes().get(node.getId());
        return t != null ? t.actions() : Collections.emptyList();
    }

    public void saveActions(@Nonnull FlowNode node, @Nonnull List<Action> actions) throws IOException {
        HashMap<String, Tag> map = this.getOrLoadNodes();
        Tag t = map.get(node.getId());
        if (t != null) {
            t.node = node;
            List act = node.getActions();
            Tag.access$102(t, act.toArray(new Action[act.size()]));
        } else {
            map.put(node.getId(), new Tag(node, actions));
        }
        this.isModified = true;
    }

    @Override
    public boolean isPersistedFully() {
        return !this.isModified;
    }

    static {
        XSTREAM.alias("Tag", Tag.class);
        XSTREAM.aliasPackage("cps.n", "org.jenkinsci.plugins.workflow.cps.nodes");
        XSTREAM.aliasPackage("wf.a", "org.jenkinsci.plugins.workflow.actions");
        XSTREAM.aliasPackage("s.a", "org.jenkinsci.plugins.workflow.support.actions");
        XSTREAM.aliasPackage("cps.a", "org.jenkinsci.plugins.workflow.cps.actions");
        try {
            FlowNode$exec = FlowNode.class.getDeclaredField("exec");
            FlowNode$exec.setAccessible(true);
            FlowNode_setActions = FlowNode.class.getDeclaredMethod("setActions", List.class);
            FlowNode_setActions.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    private static class Tag {
        FlowNode node;
        @CheckForNull
        private Action[] actions;

        private Tag(@Nonnull FlowNode node, @Nonnull List<Action> actions) {
            this.node = node;
            this.actions = actions.isEmpty() ? null : actions.toArray(new Action[actions.size()]);
        }

        private void storeActions() {
            try {
                FlowNode_setActions.invoke((Object)this.node, this.actions());
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Nonnull
        public List<Action> actions() {
            return this.actions != null ? Arrays.asList(this.actions) : Collections.emptyList();
        }

        static /* synthetic */ Action[] access$102(Tag x0, Action[] x1) {
            x0.actions = x1;
            return x1;
        }
    }
}

