/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.visualization.table;

import hudson.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.actions.NotExecutedNodeAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.visualization.table.FlowNodeViewColumn;
import org.jenkinsci.plugins.workflow.visualization.table.FlowNodeViewColumnDescriptor;

public class FlowGraphTable {
    private final FlowExecution execution;
    private List<FlowNode> heads;
    private List<Row> rows;
    private List<FlowNodeViewColumn> columns;

    public FlowGraphTable(@Nullable FlowExecution execution) {
        this.execution = execution;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public List<FlowNodeViewColumn> getColumns() {
        return this.columns;
    }

    public void build() {
        if (this.execution != null) {
            Map<FlowNode, Row> rows = this.createAllRows();
            Row firstRow = this.buildForwardReferences(rows);
            this.buildTreeFromGraph(rows);
            this.buildTreeDepth(firstRow);
            this.rows = Collections.unmodifiableList(this.order(firstRow));
        } else {
            this.rows = Collections.emptyList();
        }
        this.columns = Collections.unmodifiableList(FlowNodeViewColumnDescriptor.getDefaultInstances());
    }

    private Map<FlowNode, Row> createAllRows() {
        this.heads = this.execution.getCurrentHeads();
        DepthFirstScanner scanner = new DepthFirstScanner();
        scanner.setup(this.heads);
        LinkedHashMap<FlowNode, Row> rows = new LinkedHashMap<FlowNode, Row>();
        for (FlowNode n : scanner) {
            Row row = new Row(n);
            rows.put(n, row);
        }
        return rows;
    }

    private Row buildForwardReferences(Map<FlowNode, Row> rows) {
        Row firstRow = null;
        for (Row r : rows.values()) {
            FlowNode n = r.node;
            for (FlowNode p : n.getParents()) {
                rows.get(p).addGraphChild(r);
            }
            if (n.getParents().isEmpty()) {
                if (firstRow == null) {
                    firstRow = r;
                } else {
                    firstRow.addGraphSibling(r);
                }
            }
            if (!r.isEnd()) continue;
            BlockEndNode en = (BlockEndNode)r.node;
            Row sr = rows.get(en.getStartNode());
            if (r.hasStartTime && sr.hasStartTime) {
                sr.durationMillis = r.startTimeMillis - sr.startTimeMillis;
                sr.hasTiming = true;
            }
            assert (sr.endNode == null) : "start/end mapping should be 1:1";
            sr.endNode = en;
        }
        assert (firstRow != null);
        return firstRow;
    }

    private void buildTreeFromGraph(Map<FlowNode, Row> rows) {
        for (Row r : rows.values()) {
            Row c;
            if (r.isStart()) {
                c = r.firstGraphChild;
                while (c != null) {
                    r.addTreeChild(c);
                    c = c.nextGraphSibling;
                }
                continue;
            }
            if (r.isEnd()) {
                BlockEndNode en = (BlockEndNode)r.node;
                Row sr = rows.get(en.getStartNode());
                Row c2 = r.firstGraphChild;
                while (c2 != null) {
                    sr.addTreeSibling(c2);
                    c2 = c2.nextGraphSibling;
                }
                continue;
            }
            c = r.firstGraphChild;
            while (c != null) {
                r.addTreeSibling(c);
                c = c.nextGraphSibling;
            }
        }
    }

    private void buildTreeDepth(Row r) {
        r.treeDepth = 0;
        Stack<Row> q = new Stack<Row>();
        q.add(r);
        while (!q.isEmpty()) {
            r = (Row)q.pop();
            if (r.firstTreeChild != null) {
                q.add(r.firstTreeChild);
                r.firstTreeChild.treeDepth = r.treeDepth + 1;
            }
            if (r.nextTreeSibling == null) continue;
            q.add(r.nextTreeSibling);
            r.nextTreeSibling.treeDepth = r.treeDepth;
        }
    }

    private List<Row> order(Row r) {
        ArrayList<Row> rows = new ArrayList<Row>();
        Stack<Row> ancestors = new Stack<Row>();
        while (true) {
            rows.add(r);
            if (r.firstTreeChild != null) {
                if (r.nextTreeSibling != null) {
                    ancestors.push(r.nextTreeSibling);
                }
                r = r.firstTreeChild;
                continue;
            }
            if (r.nextTreeSibling != null) {
                r = r.nextTreeSibling;
                continue;
            }
            if (ancestors.isEmpty()) break;
            r = (Row)ancestors.pop();
        }
        for (int i = 0; i < rows.size(); ++i) {
            Row newRow = (Row)rows.get(i);
            if (newRow.durationMillis != 0L || !newRow.hasStartTime) continue;
            if (newRow.node instanceof BlockStartNode && newRow.endNode == null) {
                newRow.durationMillis = System.currentTimeMillis() - newRow.startTimeMillis;
                newRow.hasTiming = true;
                continue;
            }
            Row nextRow = newRow.firstGraphChild;
            if (!nextRow.hasStartTime) continue;
            newRow.durationMillis = nextRow.startTimeMillis - newRow.startTimeMillis;
            newRow.hasTiming = true;
        }
        return rows;
    }

    public static class Row {
        private final FlowNode node;
        private long durationMillis = 0L;
        private final long startTimeMillis;
        private final boolean hasStartTime;
        private boolean hasTiming = false;
        private BlockEndNode endNode;
        private Row firstGraphChild;
        private Row nextGraphSibling;
        private Row firstTreeChild;
        private Row nextTreeSibling;
        private int treeDepth = -1;

        private Row(FlowNode node) {
            this.node = node;
            TimingAction act = (TimingAction)node.getAction(TimingAction.class);
            if (act != null) {
                this.startTimeMillis = act.getStartTime();
                this.hasStartTime = true;
                if (node.isActive()) {
                    this.durationMillis = System.currentTimeMillis() - this.startTimeMillis;
                    this.hasTiming = true;
                }
            } else {
                this.startTimeMillis = 0L;
                this.hasStartTime = false;
            }
        }

        public FlowNode getNode() {
            return this.node;
        }

        public int getTreeDepth() {
            return this.treeDepth;
        }

        public String getDisplayName() {
            return this.node.getDisplayName();
        }

        public boolean isHasStartTime() {
            return this.hasStartTime;
        }

        public long getStartTimeMillis() {
            return this.startTimeMillis;
        }

        public long getDurationMillis() {
            return this.durationMillis;
        }

        public String getDurationString() {
            if (!this.hasTiming) {
                return "no timing";
            }
            if (this.durationMillis == 0L) {
                return "<1 ms";
            }
            return Util.getTimeSpanString((long)this.durationMillis);
        }

        public boolean isStart() {
            return this.node instanceof BlockStartNode;
        }

        boolean isEnd() {
            return this.node instanceof BlockEndNode;
        }

        public boolean isExecuted() {
            return NotExecutedNodeAction.isExecuted((FlowNode)this.node);
        }

        void addGraphChild(Row r) {
            if (this.firstGraphChild == null) {
                this.firstGraphChild = r;
            } else {
                this.firstGraphChild.addGraphSibling(r);
            }
        }

        void addGraphSibling(Row r) {
            Row s = this;
            while (s.nextGraphSibling != null) {
                s = s.nextGraphSibling;
            }
            s.nextGraphSibling = r;
            if (s.hasStartTime && r.hasStartTime) {
                s.durationMillis = r.startTimeMillis - s.startTimeMillis;
                s.hasTiming = true;
            }
        }

        void addTreeChild(Row r) {
            if (r.isEnd()) {
                return;
            }
            if (this.firstTreeChild == null) {
                this.firstTreeChild = r;
            } else {
                this.firstTreeChild.addTreeSibling(r);
            }
        }

        void addTreeSibling(Row r) {
            if (r.isEnd()) {
                return;
            }
            Row s = this;
            while (s.nextTreeSibling != null) {
                s = s.nextTreeSibling;
            }
            s.nextTreeSibling = r;
            if (s.hasStartTime && r.hasStartTime) {
                s.durationMillis = r.startTimeMillis - s.startTimeMillis;
                s.hasTiming = true;
            }
        }
    }
}

