/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.maven.InternalErrorException;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.cli.MavenExecutionRequestBuilder;
import org.apache.maven.cli.MavenExecutionRequestsBuilderException;
import org.apache.maven.cli.event.DefaultEventSpyContext;
import org.apache.maven.cli.event.ExecutionEventLogger;
import org.apache.maven.cli.logging.Slf4jConfiguration;
import org.apache.maven.cli.logging.Slf4jConfigurationFactory;
import org.apache.maven.cli.logging.Slf4jLoggerManager;
import org.apache.maven.cli.logging.Slf4jStdoutLogger;
import org.apache.maven.cli.transfer.ConsoleMavenTransferListener;
import org.apache.maven.cli.transfer.QuietMavenTransferListener;
import org.apache.maven.cli.transfer.Slf4jMavenTransferListener;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.building.SettingsSource;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.transfer.TransferListener;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

@Component(role=MavenExecutionRequestBuilder.class)
public class DefaultMavenExecutionRequestBuilder
implements MavenExecutionRequestBuilder,
Initializable {
    @Requirement
    private SettingsBuilder settingsBuilder;
    @Requirement
    private MavenExecutionRequestPopulator executionRequestPopulator;
    @Requirement
    private Logger plexusLogger;
    @Requirement
    private ModelProcessor modelProcessor;
    @Requirement
    private PlexusContainer plexusContainer;
    private DefaultSecDispatcher dispatcher;
    private LoggerManager plexusLoggerManager;
    private Logger slf4jLogger;
    private ILoggerFactory slf4jLoggerFactory;
    private EventSpyDispatcher eventSpyDispatcher;
    private static final String EXT_CLASS_PATH = "maven.ext.class.path";
    static final String DEFAULT_BUILD_TIMESTAMP_FORMAT = "yyyyMMdd-HHmm";

    public void initialize() throws InitializationException {
        try {
            this.dispatcher = (DefaultSecDispatcher)this.plexusContainer.lookup(SecDispatcher.class, "maven");
            this.eventSpyDispatcher = (EventSpyDispatcher)this.plexusContainer.lookup(EventSpyDispatcher.class);
            this.modelProcessor = (ModelProcessor)this.plexusContainer.lookup(ModelProcessor.class);
            this.executionRequestPopulator = (MavenExecutionRequestPopulator)this.plexusContainer.lookup(MavenExecutionRequestPopulator.class);
            this.settingsBuilder = (SettingsBuilder)this.plexusContainer.lookup(SettingsBuilder.class);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException(e.getMessage(), (Throwable)e);
        }
    }

    public MavenExecutionRequest getMavenExecutionRequest(String[] args, PrintStream printStream) throws MavenExecutionRequestPopulationException, SettingsBuildingException, MavenExecutionRequestsBuilderException {
        try {
            CliRequest cliRequest = new CliRequest(args, null);
            this.initialize(cliRequest);
            this.cli(cliRequest);
            this.logging(cliRequest);
            this.version(cliRequest);
            this.properties(cliRequest);
            this.commands(cliRequest);
            this.settings(cliRequest);
            this.populateRequest(cliRequest);
            this.encryption(cliRequest);
            this.repository(cliRequest);
            MavenExecutionRequest request = this.executionRequestPopulator.populateDefaults(cliRequest.request);
            DefaultEventSpyContext eventSpyContext = new DefaultEventSpyContext();
            Map data = eventSpyContext.getData();
            data.put("plexus", this.plexusContainer);
            data.put("workingDirectory", cliRequest.workingDirectory);
            data.put("systemProperties", cliRequest.systemProperties);
            data.put("userProperties", cliRequest.userProperties);
            data.put("versionProperties", CLIReportingUtils.getBuildProperties());
            this.eventSpyDispatcher.init((EventSpy.Context)eventSpyContext);
            return request;
        }
        catch (Exception e) {
            throw new MavenExecutionRequestsBuilderException(e.getMessage(), (Throwable)e);
        }
    }

    private void initialize(CliRequest cliRequest) {
        String mavenHome;
        if (cliRequest.workingDirectory == null) {
            cliRequest.workingDirectory = System.getProperty("user.dir");
        }
        if ((mavenHome = System.getProperty("maven.home")) != null) {
            System.setProperty("maven.home", new File(mavenHome).getAbsolutePath());
        }
    }

    private void cli(CliRequest cliRequest) throws Exception {
        this.slf4jLogger = new Slf4jStdoutLogger();
        CLIManager cliManager = new CLIManager();
        try {
            cliRequest.commandLine = cliManager.parse(cliRequest.args);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            cliManager.displayHelp(System.out);
            throw e;
        }
        if (cliRequest.commandLine.hasOption('h')) {
            cliManager.displayHelp(System.out);
            throw new ExitException(0);
        }
        if (cliRequest.commandLine.hasOption('v')) {
            System.out.println(CLIReportingUtils.showVersion());
            throw new ExitException(0);
        }
    }

    private void logging(CliRequest cliRequest) {
        cliRequest.debug = cliRequest.commandLine.hasOption('X');
        cliRequest.quiet = !cliRequest.debug && cliRequest.commandLine.hasOption('q');
        cliRequest.showErrors = cliRequest.debug || cliRequest.commandLine.hasOption('e');
        this.slf4jLoggerFactory = LoggerFactory.getILoggerFactory();
        Slf4jConfiguration slf4jConfiguration = Slf4jConfigurationFactory.getConfiguration((ILoggerFactory)this.slf4jLoggerFactory);
        if (cliRequest.debug) {
            cliRequest.request.setLoggingLevel(0);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.DEBUG);
        } else if (cliRequest.quiet) {
            cliRequest.request.setLoggingLevel(3);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.ERROR);
        } else {
            cliRequest.request.setLoggingLevel(1);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.INFO);
        }
        if (cliRequest.commandLine.hasOption("l")) {
            File logFile = new File(cliRequest.commandLine.getOptionValue("l"));
            logFile = DefaultMavenExecutionRequestBuilder.resolveFile(logFile, cliRequest.workingDirectory);
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(logFile));
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        slf4jConfiguration.activate();
        this.plexusLoggerManager = new Slf4jLoggerManager();
        this.slf4jLogger = this.slf4jLoggerFactory.getLogger(this.getClass().getName());
    }

    private void version(CliRequest cliRequest) {
        if (cliRequest.debug || cliRequest.commandLine.hasOption('V')) {
            System.out.println(CLIReportingUtils.showVersion());
        }
    }

    private void commands(CliRequest cliRequest) {
        if (cliRequest.showErrors) {
            this.slf4jLogger.info("Error stacktraces are turned on.");
        }
        if ("warn".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Disabling strict checksum verification on all artifact downloads.");
        } else if ("fail".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Enabling strict checksum verification on all artifact downloads.");
        }
    }

    private void properties(CliRequest cliRequest) {
        DefaultMavenExecutionRequestBuilder.populateProperties(cliRequest.commandLine, cliRequest.systemProperties, cliRequest.userProperties);
    }

    private ClassRealm setupContainerRealm(CliRequest cliRequest) throws Exception {
        String[] jars;
        ClassRealm containerRealm = null;
        String extClassPath = cliRequest.userProperties.getProperty(EXT_CLASS_PATH);
        if (extClassPath == null) {
            extClassPath = cliRequest.systemProperties.getProperty(EXT_CLASS_PATH);
        }
        if (StringUtils.isNotEmpty((String)extClassPath) && (jars = StringUtils.split((String)extClassPath, (String)File.pathSeparator)).length > 0) {
            ClassRealm coreRealm = cliRequest.classWorld.getClassRealm("plexus.core");
            if (coreRealm == null) {
                coreRealm = (ClassRealm)cliRequest.classWorld.getRealms().iterator().next();
            }
            ClassRealm extRealm = cliRequest.classWorld.newRealm("maven.ext", null);
            this.slf4jLogger.debug("Populating class realm " + extRealm.getId());
            for (String jar : jars) {
                File file = DefaultMavenExecutionRequestBuilder.resolveFile(new File(jar), cliRequest.workingDirectory);
                this.slf4jLogger.debug("  Included " + file);
                extRealm.addURL(file.toURI().toURL());
            }
            extRealm.setParentRealm(coreRealm);
            containerRealm = extRealm;
        }
        return containerRealm;
    }

    private void encryption(CliRequest cliRequest) throws Exception {
        if (cliRequest.commandLine.hasOption("emp")) {
            String passwd = cliRequest.commandLine.getOptionValue("emp");
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            System.out.println(cipher.encryptAndDecorate(passwd, "settings.security"));
            throw new ExitException(0);
        }
        if (cliRequest.commandLine.hasOption("ep")) {
            String passwd = cliRequest.commandLine.getOptionValue("ep");
            String configurationFile = this.dispatcher.getConfigurationFile();
            if (configurationFile.startsWith("~")) {
                configurationFile = System.getProperty("user.home") + configurationFile.substring(1);
            }
            String file = System.getProperty("settings.security", configurationFile);
            String master = null;
            SettingsSecurity sec = SecUtil.read((String)file, (boolean)true);
            if (sec != null) {
                master = sec.getMaster();
            }
            if (master == null) {
                throw new IllegalStateException("Master password is not set in the setting security file: " + file);
            }
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            String masterPasswd = cipher.decryptDecorated(master, "settings.security");
            System.out.println(cipher.encryptAndDecorate(passwd, masterPasswd));
            throw new ExitException(0);
        }
    }

    private void repository(CliRequest cliRequest) throws Exception {
        if (cliRequest.commandLine.hasOption("llr") || Boolean.getBoolean("maven.legacyLocalRepo")) {
            cliRequest.request.setUseLegacyLocalRepository(true);
        }
    }

    private void logSummary(ExceptionSummary summary, Map<String, String> references, String indent, boolean showErrors) {
        String referenceKey = "";
        if (StringUtils.isNotEmpty((String)summary.getReference()) && (referenceKey = references.get(summary.getReference())) == null) {
            referenceKey = "[Help " + (references.size() + 1) + "]";
            references.put(summary.getReference(), referenceKey);
        }
        String msg = summary.getMessage();
        if (StringUtils.isNotEmpty((String)referenceKey)) {
            msg = msg.indexOf(10) < 0 ? msg + " -> " + referenceKey : msg + "\n-> " + referenceKey;
        }
        String[] lines = msg.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < lines.length; ++i) {
            String line = indent + lines[i].trim();
            if (i == lines.length - 1 && (showErrors || summary.getException() instanceof InternalErrorException)) {
                this.slf4jLogger.error(line, summary.getException());
                continue;
            }
            this.slf4jLogger.error(line);
        }
        indent = indent + "  ";
        for (ExceptionSummary child : summary.getChildren()) {
            this.logSummary(child, references, indent, showErrors);
        }
    }

    private void settings(CliRequest cliRequest) throws Exception {
        File globalSettingsFile;
        File userSettingsFile;
        if (cliRequest.commandLine.hasOption('s')) {
            userSettingsFile = new File(cliRequest.commandLine.getOptionValue('s'));
            if (!(userSettingsFile = DefaultMavenExecutionRequestBuilder.resolveFile(userSettingsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified user settings file does not exist: " + userSettingsFile);
            }
        } else {
            userSettingsFile = MavenCli.DEFAULT_USER_SETTINGS_FILE;
        }
        if (cliRequest.commandLine.hasOption("gs")) {
            globalSettingsFile = new File(cliRequest.commandLine.getOptionValue("gs"));
            if (!(globalSettingsFile = DefaultMavenExecutionRequestBuilder.resolveFile(globalSettingsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified global settings file does not exist: " + globalSettingsFile);
            }
        } else {
            globalSettingsFile = MavenCli.DEFAULT_GLOBAL_SETTINGS_FILE;
        }
        cliRequest.request.setGlobalSettingsFile(globalSettingsFile);
        cliRequest.request.setUserSettingsFile(userSettingsFile);
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        settingsRequest.setGlobalSettingsFile(globalSettingsFile);
        settingsRequest.setUserSettingsFile(userSettingsFile);
        settingsRequest.setSystemProperties(cliRequest.systemProperties);
        settingsRequest.setUserProperties(cliRequest.userProperties);
        this.eventSpyDispatcher.onEvent((Object)settingsRequest);
        this.slf4jLogger.debug("Reading global settings from " + this.getSettingsLocation(settingsRequest.getGlobalSettingsSource(), settingsRequest.getGlobalSettingsFile()));
        this.slf4jLogger.debug("Reading user settings from " + this.getSettingsLocation(settingsRequest.getUserSettingsSource(), settingsRequest.getUserSettingsFile()));
        SettingsBuildingResult settingsResult = this.settingsBuilder.build((SettingsBuildingRequest)settingsRequest);
        this.eventSpyDispatcher.onEvent((Object)settingsResult);
        this.executionRequestPopulator.populateFromSettings(cliRequest.request, settingsResult.getEffectiveSettings());
        if (!settingsResult.getProblems().isEmpty() && this.slf4jLogger.isWarnEnabled()) {
            this.slf4jLogger.warn("");
            this.slf4jLogger.warn("Some problems were encountered while building the effective settings");
            for (SettingsProblem problem : settingsResult.getProblems()) {
                this.slf4jLogger.warn(problem.getMessage() + " @ " + problem.getLocation());
            }
            this.slf4jLogger.warn("");
        }
    }

    private Object getSettingsLocation(SettingsSource source, File file) {
        if (source != null) {
            return source.getLocation();
        }
        return file;
    }

    private MavenExecutionRequest populateRequest(CliRequest cliRequest) {
        String threadConfiguration;
        File pom;
        File userToolchainsFile;
        String[] profileOptionValues;
        String[] deprecatedOptions;
        MavenExecutionRequest request = cliRequest.request;
        CommandLine commandLine = cliRequest.commandLine;
        String workingDirectory = cliRequest.workingDirectory;
        boolean quiet = cliRequest.quiet;
        boolean showErrors = cliRequest.showErrors;
        for (String deprecatedOption : deprecatedOptions = new String[]{"up", "npu", "cpu", "npr"}) {
            if (!commandLine.hasOption(deprecatedOption)) continue;
            this.slf4jLogger.warn("Command line option -" + deprecatedOption + " is deprecated and will be removed in future Maven versions.");
        }
        if (commandLine.hasOption('B')) {
            request.setInteractiveMode(false);
        }
        boolean noSnapshotUpdates = false;
        if (commandLine.hasOption("nsu")) {
            noSnapshotUpdates = true;
        }
        List goals = commandLine.getArgList();
        boolean recursive = true;
        String reactorFailureBehaviour = "FAIL_FAST";
        if (commandLine.hasOption('N')) {
            recursive = false;
        }
        if (commandLine.hasOption("ff")) {
            reactorFailureBehaviour = "FAIL_FAST";
        } else if (commandLine.hasOption("fae")) {
            reactorFailureBehaviour = "FAIL_AT_END";
        } else if (commandLine.hasOption("fn")) {
            reactorFailureBehaviour = "FAIL_NEVER";
        }
        if (commandLine.hasOption('o')) {
            request.setOffline(true);
        }
        boolean updateSnapshots = false;
        if (commandLine.hasOption('U')) {
            updateSnapshots = true;
        }
        String globalChecksumPolicy = null;
        if (commandLine.hasOption('C')) {
            globalChecksumPolicy = "fail";
        } else if (commandLine.hasOption('c')) {
            globalChecksumPolicy = "warn";
        }
        File baseDirectory = new File(workingDirectory, "").getAbsoluteFile();
        ArrayList<String> activeProfiles = new ArrayList<String>();
        ArrayList<String> inactiveProfiles = new ArrayList<String>();
        if (commandLine.hasOption('P') && (profileOptionValues = commandLine.getOptionValues('P')) != null) {
            for (String profileOptionValue : profileOptionValues) {
                StringTokenizer profileTokens = new StringTokenizer(profileOptionValue, ",");
                while (profileTokens.hasMoreTokens()) {
                    String profileAction = profileTokens.nextToken().trim();
                    if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                        inactiveProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    if (profileAction.startsWith("+")) {
                        activeProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    activeProfiles.add(profileAction);
                }
            }
        }
        Object transferListener = quiet ? new QuietMavenTransferListener() : (request.isInteractiveMode() && !cliRequest.commandLine.hasOption("l") ? this.getConsoleTransferListener() : this.getBatchTransferListener());
        ExecutionEventLogger executionListener = new ExecutionEventLogger();
        executionListener = this.eventSpyDispatcher.chainListener((ExecutionListener)executionListener);
        String alternatePomFile = null;
        if (commandLine.hasOption('f')) {
            alternatePomFile = commandLine.getOptionValue('f');
        }
        if (commandLine.hasOption('t')) {
            userToolchainsFile = new File(commandLine.getOptionValue('t'));
            userToolchainsFile = DefaultMavenExecutionRequestBuilder.resolveFile(userToolchainsFile, workingDirectory);
        } else {
            userToolchainsFile = MavenCli.DEFAULT_USER_TOOLCHAINS_FILE;
        }
        request.setBaseDirectory(baseDirectory).setGoals(goals).setSystemProperties(cliRequest.systemProperties).setUserProperties(cliRequest.userProperties).setReactorFailureBehavior(reactorFailureBehaviour).setRecursive(recursive).setShowErrors(showErrors).addActiveProfiles(activeProfiles).addInactiveProfiles(inactiveProfiles).setExecutionListener((ExecutionListener)executionListener).setTransferListener((TransferListener)transferListener).setUpdateSnapshots(updateSnapshots).setNoSnapshotUpdates(noSnapshotUpdates).setGlobalChecksumPolicy(globalChecksumPolicy).setUserToolchainsFile(userToolchainsFile);
        if (alternatePomFile != null) {
            pom = DefaultMavenExecutionRequestBuilder.resolveFile(new File(alternatePomFile), workingDirectory);
            if (pom.isDirectory()) {
                pom = new File(pom, "pom.xml");
            }
            request.setPom(pom);
        } else {
            pom = this.modelProcessor.locatePom(baseDirectory);
            if (pom.isFile()) {
                request.setPom(pom);
            }
        }
        if (request.getPom() != null && request.getPom().getParentFile() != null) {
            request.setBaseDirectory(request.getPom().getParentFile());
        }
        if (commandLine.hasOption("rf")) {
            request.setResumeFrom(commandLine.getOptionValue("rf"));
        }
        if (commandLine.hasOption("pl")) {
            String[] values = commandLine.getOptionValues("pl");
            ArrayList<String> projects = new ArrayList<String>();
            ArrayList<String> excludedProjects = new ArrayList<String>();
            for (String value : values) {
                String[] tmp;
                for (String project : tmp = StringUtils.split((String)value, (String)",")) {
                    if (project.startsWith("!")) {
                        excludedProjects.add(project.substring(1));
                        continue;
                    }
                    projects.add(project);
                }
            }
            request.setSelectedProjects(projects);
            request.setExcludedProjects(excludedProjects);
        }
        if (commandLine.hasOption("am") && !commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-upstream");
        } else if (!commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-downstream");
        } else if (commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-both");
        }
        String localRepoProperty = request.getUserProperties().getProperty("maven.repo.local");
        if (localRepoProperty == null) {
            localRepoProperty = request.getSystemProperties().getProperty("maven.repo.local");
        }
        if (localRepoProperty != null) {
            request.setLocalRepositoryPath(localRepoProperty);
        }
        String string = threadConfiguration = commandLine.hasOption("T") ? commandLine.getOptionValue("T") : request.getSystemProperties().getProperty("maven.threads.experimental");
        if (threadConfiguration != null) {
            int threadCount = 1;
            try {
                threadCount = Integer.parseInt(threadConfiguration.replace("C", "").replace("W", "").replace("auto", ""));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Must provide a thread count for -T");
            }
            if (threadConfiguration.contains("C")) {
                threadCount *= Runtime.getRuntime().availableProcessors();
            }
            if (threadCount > 1) {
                request.setDegreeOfConcurrency(threadCount);
                request.setBuilderId("multithreaded");
            }
        }
        request.setCacheNotFound(true);
        request.setCacheTransferError(false);
        return request;
    }

    static File resolveFile(File file, String workingDirectory) {
        if (file == null) {
            return null;
        }
        if (file.isAbsolute()) {
            return file;
        }
        if (file.getPath().startsWith(File.separator)) {
            return file.getAbsoluteFile();
        }
        return new File(workingDirectory, file.getPath()).getAbsoluteFile();
    }

    static void populateProperties(CommandLine commandLine, Properties systemProperties, Properties userProperties) {
        String[] defStrs;
        EnvironmentUtils.addEnvVars((Properties)systemProperties);
        if (commandLine.hasOption('D') && (defStrs = commandLine.getOptionValues('D')) != null) {
            for (String defStr : defStrs) {
                DefaultMavenExecutionRequestBuilder.setCliProperty(defStr, userProperties);
            }
        }
        systemProperties.putAll((Map<?, ?>)System.getProperties());
        Properties buildProperties = CLIReportingUtils.getBuildProperties();
        String mavenVersion = buildProperties.getProperty("version");
        systemProperties.setProperty("maven.version", mavenVersion);
        String mavenBuildVersion = CLIReportingUtils.createMavenVersionString((Properties)buildProperties);
        systemProperties.setProperty("maven.build.version", mavenBuildVersion);
    }

    private static void setCliProperty(String property, Properties properties) {
        String value;
        String name;
        int i = property.indexOf("=");
        if (i <= 0) {
            name = property.trim();
            value = "true";
        } else {
            name = property.substring(0, i).trim();
            value = property.substring(i + 1);
        }
        properties.setProperty(name, value);
        System.setProperty(name, value);
    }

    protected TransferListener getConsoleTransferListener() {
        return new ConsoleMavenTransferListener(System.out);
    }

    protected TransferListener getBatchTransferListener() {
        return new Slf4jMavenTransferListener();
    }

    protected void customizeContainer(PlexusContainer container) {
    }

    protected ModelProcessor createModelProcessor(PlexusContainer container) throws ComponentLookupException {
        return (ModelProcessor)container.lookup(ModelProcessor.class);
    }

    static class ExitException
    extends Exception {
        public int exitCode;

        public ExitException(int exitCode) {
            this.exitCode = exitCode;
        }
    }

    static class CliRequest {
        String[] args;
        CommandLine commandLine;
        ClassWorld classWorld;
        String workingDirectory;
        boolean debug;
        boolean quiet;
        boolean showErrors = true;
        Properties userProperties = new Properties();
        Properties systemProperties = new Properties();
        MavenExecutionRequest request;

        CliRequest(String[] args, ClassWorld classWorld) {
            this.args = args;
            this.classWorld = classWorld;
            this.request = new DefaultMavenExecutionRequest();
        }
    }
}

