/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.agent;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Stack;

abstract class ComponentInterceptor<T>
implements InvocationHandler {
    protected T delegate;

    ComponentInterceptor() {
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public T wrap(T o) {
        if (this.delegate != null) {
            throw new IllegalStateException();
        }
        this.delegate = o;
        return (T)Proxy.newProxyInstance(o.getClass().getClassLoader(), ComponentInterceptor.getImplementedInterfaces(o), (InvocationHandler)this);
    }

    private static Class[] getImplementedInterfaces(Object o) {
        Stack s = new Stack();
        s.push(o.getClass());
        HashSet interfaces = new HashSet();
        while (!s.isEmpty()) {
            Class c = (Class)s.pop();
            for (Class<?> intf : c.getInterfaces()) {
                interfaces.add(intf);
                s.push(intf);
            }
            Class sc = c.getSuperclass();
            if (sc == null) continue;
            s.push(sc);
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }
}

