/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.cli.FlightRecorderInputStream;
import hudson.cli.HexDump;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadPendingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;

class PlainCLIProtocol {
    static final Logger LOGGER = Logger.getLogger(PlainCLIProtocol.class.getName());

    private PlainCLIProtocol() {
    }

    static abstract class ClientSide
    extends EitherSide {
        ClientSide(InputStream is, OutputStream os) {
            super(is, os);
        }

        @Override
        protected boolean handle(Op op, int framelen) throws IOException {
            assert (Thread.currentThread() instanceof EitherSide.Reader);
            assert (!op.clientSide);
            switch (op) {
                case EXIT: {
                    this.onExit(this.dis.readInt());
                    return true;
                }
                case STDOUT: {
                    this.onStdout(this.readChunk(framelen));
                    return true;
                }
                case STDERR: {
                    this.onStderr(this.readChunk(framelen));
                    return true;
                }
            }
            return false;
        }

        protected abstract void onExit(int var1);

        protected abstract void onStdout(byte[] var1) throws IOException;

        protected abstract void onStderr(byte[] var1) throws IOException;

        public final void sendArg(String text) throws IOException {
            this.send(Op.ARG, text);
        }

        public final void sendLocale(String text) throws IOException {
            this.send(Op.LOCALE, text);
        }

        public final void sendEncoding(String text) throws IOException {
            this.send(Op.ENCODING, text);
        }

        public final void sendStart() throws IOException {
            this.send(Op.START);
        }

        public final OutputStream streamStdin() {
            return this.stream(Op.STDIN);
        }

        public final void sendEndStdin() throws IOException {
            this.send(Op.END_STDIN);
        }
    }

    static abstract class ServerSide
    extends EitherSide {
        ServerSide(InputStream is, OutputStream os) {
            super(is, os);
        }

        @Override
        protected final boolean handle(Op op, int framelen) throws IOException {
            assert (Thread.currentThread() instanceof EitherSide.Reader);
            assert (op.clientSide);
            switch (op) {
                case ARG: {
                    this.onArg(this.dis.readUTF());
                    return true;
                }
                case LOCALE: {
                    this.onLocale(this.dis.readUTF());
                    return true;
                }
                case ENCODING: {
                    this.onEncoding(this.dis.readUTF());
                    return true;
                }
                case START: {
                    this.onStart();
                    return true;
                }
                case STDIN: {
                    this.onStdin(this.readChunk(framelen));
                    return true;
                }
                case END_STDIN: {
                    this.onEndStdin();
                    return true;
                }
            }
            return false;
        }

        protected abstract void onArg(String var1);

        protected abstract void onLocale(String var1);

        protected abstract void onEncoding(String var1);

        protected abstract void onStart();

        protected abstract void onStdin(byte[] var1) throws IOException;

        protected abstract void onEndStdin() throws IOException;

        public final void sendExit(int code) throws IOException {
            this.send(Op.EXIT, code);
        }

        public final OutputStream streamStdout() {
            return this.stream(Op.STDOUT);
        }

        public final OutputStream streamStderr() {
            return this.stream(Op.STDERR);
        }
    }

    static abstract class EitherSide
    implements Closeable {
        private final CountingInputStream cis;
        private final FlightRecorderInputStream flightRecorder;
        final DataInputStream dis;
        final DataOutputStream dos;

        protected EitherSide(InputStream is, OutputStream os) {
            this.cis = new CountingInputStream(is);
            this.flightRecorder = new FlightRecorderInputStream(this.cis);
            this.dis = new DataInputStream(this.flightRecorder);
            this.dos = new DataOutputStream(os);
        }

        final void begin() {
            new Reader().start();
        }

        protected abstract void handleClose();

        protected abstract boolean handle(Op var1, int var2) throws IOException;

        private void writeOp(Op op) throws IOException {
            this.dos.writeByte((byte)op.ordinal());
        }

        protected final synchronized void send(Op op) throws IOException {
            this.dos.writeInt(0);
            this.writeOp(op);
            this.dos.flush();
        }

        protected final synchronized void send(Op op, int number) throws IOException {
            this.dos.writeInt(4);
            this.writeOp(op);
            this.dos.writeInt(number);
            this.dos.flush();
        }

        protected final synchronized void send(Op op, byte[] chunk, int off, int len) throws IOException {
            this.dos.writeInt(len);
            this.writeOp(op);
            this.dos.write(chunk, off, len);
            this.dos.flush();
        }

        protected final void send(Op op, byte[] chunk) throws IOException {
            this.send(op, chunk, 0, chunk.length);
        }

        protected final void send(Op op, String text) throws IOException {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            new DataOutputStream(buf).writeUTF(text);
            this.send(op, buf.toByteArray());
        }

        protected final byte[] readChunk(int framelen) throws IOException {
            assert (Thread.currentThread() instanceof Reader);
            byte[] buf = new byte[framelen];
            this.dis.readFully(buf);
            return buf;
        }

        protected final OutputStream stream(final Op op) {
            return new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    this.send(op, new byte[]{(byte)b});
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    this.send(op, b, off, len);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.send(op, b);
                }
            };
        }

        @Override
        public synchronized void close() throws IOException {
            this.dos.close();
        }

        private class Reader
        extends Thread {
            Reader() {
                super("PlainCLIProtocol");
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        int framelen;
                        LOGGER.finest("reading frame");
                        try {
                            framelen = EitherSide.this.dis.readInt();
                        }
                        catch (EOFException x) {
                            EitherSide.this.handleClose();
                            break;
                        }
                        if (framelen < 0) {
                            throw new IOException("corrupt stream: negative frame length");
                        }
                        byte b = EitherSide.this.dis.readByte();
                        if (b < 0) {
                            throw new IOException("corrupt stream: negative operation code");
                        }
                        if (b >= Op.values().length) {
                            LOGGER.log(Level.WARNING, "unknown operation #{0}: {1}", new Object[]{b, HexDump.toHex(EitherSide.this.flightRecorder.getRecord())});
                            IOUtils.skipFully(EitherSide.this.dis, (long)framelen);
                            continue;
                        }
                        Op op = Op.values()[b];
                        long start = EitherSide.this.cis.getByteCount();
                        LOGGER.log(Level.FINEST, "handling frame with {0} of length {1}", new Object[]{op, framelen});
                        boolean handled = EitherSide.this.handle(op, framelen);
                        if (handled) {
                            long actuallyRead = EitherSide.this.cis.getByteCount() - start;
                            if (actuallyRead == (long)framelen) continue;
                            throw new IOException("corrupt stream: expected to read " + framelen + " bytes from " + (Object)((Object)op) + " but read " + actuallyRead);
                        }
                        LOGGER.log(Level.WARNING, "unexpected {0}: {1}", new Object[]{op, HexDump.toHex(EitherSide.this.flightRecorder.getRecord())});
                        IOUtils.skipFully(EitherSide.this.dis, (long)framelen);
                    }
                }
                catch (ClosedChannelException x) {
                    LOGGER.log(Level.FINE, null, x);
                    EitherSide.this.handleClose();
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, null, EitherSide.this.flightRecorder.analyzeCrash(x, "broken stream"));
                }
                catch (ReadPendingException x) {
                    LOGGER.log(Level.FINE, null, x);
                    EitherSide.this.handleClose();
                }
                catch (RuntimeException x) {
                    LOGGER.log(Level.WARNING, null, x);
                    EitherSide.this.handleClose();
                }
            }
        }
    }

    private static enum Op {
        ARG(true),
        LOCALE(true),
        ENCODING(true),
        START(true),
        EXIT(false),
        STDIN(true),
        END_STDIN(true),
        STDOUT(false),
        STDERR(false);

        final boolean clientSide;

        private Op(boolean clientSide) {
            this.clientSide = clientSide;
        }
    }
}

