/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.io.Closeable;
import java.io.IOException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Iterator;
import java.util.List;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyIterator;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class UserAuthPublicKey
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "publickey";
    protected Iterator<PublicKeyIdentity> keys;
    protected PublicKeyIdentity current;
    protected List<NamedFactory<Signature>> factories;

    public UserAuthPublicKey() {
        this((List<NamedFactory<Signature>>)null);
    }

    public UserAuthPublicKey(List<NamedFactory<Signature>> factories) {
        super(NAME);
        this.factories = factories;
    }

    @Override
    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    @Override
    public void init(ClientSession session, String service) throws Exception {
        super.init(session, service);
        this.releaseKeys();
        try {
            this.keys = new UserAuthPublicKeyIterator(session, this);
        }
        catch (Error e) {
            this.log.warn("init({})[{}] failed ({}) to initialize session keys: {}", session, service, e.getClass().getSimpleName(), e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("init(" + session + ")[" + service + "] session keys initialization failure details", e);
            }
            throw new RuntimeSshException(e);
        }
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        PublicKey key;
        try {
            if (this.keys == null || !this.keys.hasNext()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("sendAuthDataRequest({})[{}] no more keys to send", (Object)session, (Object)service);
                }
                return false;
            }
            this.current = this.keys.next();
        }
        catch (Error e) {
            this.log.warn("sendAuthDataRequest({})[{}] failed ({}) to get next key: {}", session, service, e.getClass().getSimpleName(), e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendAuthDataRequest(" + session + ")[" + service + "] next key fetch failure details", e);
            }
            throw new RuntimeSshException(e);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendAuthDataRequest({})[{}] current key details: {}", session, service, this.current);
        }
        try {
            key = this.current.getPublicKey();
        }
        catch (Error e) {
            this.log.warn("sendAuthDataRequest({})[{}] failed ({}) to retrieve public key: {}", session, service, e.getClass().getSimpleName(), e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendAuthDataRequest(" + session + ")[" + service + "] public key retrieval failure details", e);
            }
            throw new RuntimeSshException(e);
        }
        String algo = KeyUtils.getKeyType(key);
        String name = this.getName();
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendAuthDataRequest({})[{}] send SSH_MSG_USERAUTH_REQUEST request {} type={} - fingerprint={}", session, service, name, algo, KeyUtils.getFingerPrint(key));
        }
        Buffer buffer = session.createBuffer((byte)50);
        buffer.putString(session.getUsername());
        buffer.putString(service);
        buffer.putString(name);
        buffer.putBoolean(false);
        buffer.putString(algo);
        buffer.putPublicKey(key);
        session.writePacket(buffer);
        return true;
    }

    @Override
    protected boolean processAuthDataRequest(ClientSession session, String service, Buffer buffer) throws Exception {
        PublicKey key;
        String name = this.getName();
        int cmd = buffer.getUByte();
        if (cmd != 60) {
            throw new IllegalStateException("processAuthDataRequest(" + session + ")[" + service + "][" + name + "] received unknown packet: cmd=" + SshConstants.getCommandMessageName(cmd));
        }
        try {
            key = this.current.getPublicKey();
        }
        catch (Error e) {
            this.log.warn("processAuthDataRequest({})[{}][{}] failed ({}) to retrieve public key: {}", session, service, name, e.getClass().getSimpleName(), e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("processAuthDataRequest(" + session + ")[" + service + "][" + name + "] public key retrieval failure details", e);
            }
            throw new RuntimeSshException(e);
        }
        String algo = KeyUtils.getKeyType(key);
        String rspKeyType = buffer.getString();
        if (!rspKeyType.equals(algo)) {
            throw new InvalidKeySpecException("processAuthDataRequest(" + session + ")[" + service + "][" + name + "] mismatched key types: expected=" + algo + ", actual=" + rspKeyType);
        }
        PublicKey rspKey = buffer.getPublicKey();
        if (!KeyUtils.compareKeys(rspKey, key)) {
            throw new InvalidKeySpecException("processAuthDataRequest(" + session + ")[" + service + "][" + name + "] mismatched " + algo + " keys: expected=" + KeyUtils.getFingerPrint(key) + ", actual=" + KeyUtils.getFingerPrint(rspKey));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("processAuthDataRequest({})[{}][{}] SSH_MSG_USERAUTH_PK_OK type={}, fingerprint={}", session, service, name, rspKeyType, KeyUtils.getFingerPrint(rspKey));
        }
        String username = session.getUsername();
        buffer = session.createBuffer((byte)50, GenericUtils.length(username) + GenericUtils.length(service) + GenericUtils.length(name) + GenericUtils.length(algo) + 256 + 64);
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString(name);
        buffer.putBoolean(true);
        buffer.putString(algo);
        buffer.putPublicKey(key);
        this.appendSignature(session, service, name, username, algo, key, buffer);
        session.writePacket(buffer);
        return true;
    }

    protected void appendSignature(ClientSession session, String service, String name, String username, String algo, PublicKey key, Buffer buffer) throws Exception {
        byte[] sig;
        byte[] id = session.getSessionId();
        ByteArrayBuffer bs = new ByteArrayBuffer(id.length + username.length() + service.length() + name.length() + algo.length() + 256 + 64, false);
        bs.putBytes(id);
        ((Buffer)bs).putByte((byte)50);
        bs.putString(username);
        bs.putString(service);
        bs.putString(name);
        bs.putBoolean(true);
        bs.putString(algo);
        bs.putPublicKey(key);
        byte[] contents = bs.getCompactData();
        try {
            sig = this.current.sign(contents);
        }
        catch (Error e) {
            this.log.warn("appendSignature({})[{}][{}] failed ({}) to sign contents: {}", session, service, name, e.getClass().getSimpleName(), e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("appendSignature(" + session + ")[" + service + "][" + name + "] signing failure details", e);
            }
            throw new RuntimeSshException(e);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("appendSignature({})[{}] name={}, key type={}, fingerprint={} - verification data={}", session, service, name, algo, KeyUtils.getFingerPrint(key), BufferUtils.toHex(contents));
            this.log.trace("appendSignature({})[{}] name={}, key type={}, fingerprint={} - generated signature={}", session, service, name, algo, KeyUtils.getFingerPrint(key), BufferUtils.toHex(sig));
        }
        bs.clear();
        bs.putString(algo);
        bs.putBytes(sig);
        buffer.putBytes(((Buffer)bs).array(), ((Buffer)bs).rpos(), bs.available());
    }

    @Override
    public void destroy() {
        try {
            this.releaseKeys();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed (" + e.getClass().getSimpleName() + ") to close agent: " + e.getMessage(), e);
        }
        super.destroy();
    }

    protected void releaseKeys() throws IOException {
        try {
            if (this.keys instanceof Closeable) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("releaseKeys({}) closing {}", (Object)this.getClientSession(), (Object)this.keys);
                }
                ((Closeable)((Object)this.keys)).close();
            }
        }
        finally {
            this.keys = null;
        }
    }
}

