/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.file.FileSystem;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.channel.ChannelDirectTcpip;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.scp.DefaultScpClient;
import org.apache.sshd.client.scp.ScpClient;
import org.apache.sshd.client.session.ClientProxyConnector;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientUserAuthService;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpClientFactory;
import org.apache.sshd.client.subsystem.sftp.SftpVersionSelector;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.CipherNone;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.forward.ForwardingFilter;
import org.apache.sshd.common.future.DefaultKeyExchangeFuture;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.scp.ScpFileOpener;
import org.apache.sshd.common.scp.ScpTransferEventListener;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.helpers.AbstractConnectionService;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public abstract class AbstractClientSession
extends AbstractSession
implements ClientSession {
    private final List<Object> identities = new CopyOnWriteArrayList<Object>();
    private final AuthenticationIdentitiesProvider identitiesProvider = AuthenticationIdentitiesProvider.wrap(this.identities);
    private ServerKeyVerifier serverKeyVerifier;
    private UserInteraction userInteraction;
    private PasswordIdentityProvider passwordIdentityProvider;
    private List<NamedFactory<UserAuth>> userAuthFactories;
    private ScpTransferEventListener scpListener;
    private ScpFileOpener scpOpener;
    private SocketAddress connectAddress;
    private ClientProxyConnector proxyConnector;
    private SftpClientFactory sftpClientFactory;

    protected AbstractClientSession(ClientFactoryManager factoryManager, IoSession ioSession) {
        super(false, factoryManager, ioSession);
    }

    @Override
    public ClientFactoryManager getFactoryManager() {
        return (ClientFactoryManager)super.getFactoryManager();
    }

    @Override
    public SocketAddress getConnectAddress() {
        return this.resolvePeerAddress(this.connectAddress);
    }

    public void setConnectAddress(SocketAddress connectAddress) {
        this.connectAddress = connectAddress;
    }

    @Override
    public ServerKeyVerifier getServerKeyVerifier() {
        return this.resolveEffectiveProvider(ServerKeyVerifier.class, this.serverKeyVerifier, this.getFactoryManager().getServerKeyVerifier());
    }

    @Override
    public void setServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = serverKeyVerifier;
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.resolveEffectiveProvider(UserInteraction.class, this.userInteraction, this.getFactoryManager().getUserInteraction());
    }

    @Override
    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    @Override
    public List<NamedFactory<UserAuth>> getUserAuthFactories() {
        return this.resolveEffectiveFactories(UserAuth.class, this.userAuthFactories, this.getFactoryManager().getUserAuthFactories());
    }

    @Override
    public void setUserAuthFactories(List<NamedFactory<UserAuth>> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    @Override
    public AuthenticationIdentitiesProvider getRegisteredIdentities() {
        return this.identitiesProvider;
    }

    @Override
    public PasswordIdentityProvider getPasswordIdentityProvider() {
        return this.resolveEffectiveProvider(PasswordIdentityProvider.class, this.passwordIdentityProvider, this.getFactoryManager().getPasswordIdentityProvider());
    }

    @Override
    public void setPasswordIdentityProvider(PasswordIdentityProvider provider) {
        this.passwordIdentityProvider = provider;
    }

    @Override
    public ClientProxyConnector getClientProxyConnector() {
        return this.resolveEffectiveProvider(ClientProxyConnector.class, this.proxyConnector, this.getFactoryManager().getClientProxyConnector());
    }

    @Override
    public void setClientProxyConnector(ClientProxyConnector proxyConnector) {
        this.proxyConnector = proxyConnector;
    }

    @Override
    public SftpClientFactory getSftpClientFactory() {
        return this.resolveEffectiveProvider(SftpClientFactory.class, this.sftpClientFactory, this.getFactoryManager().getSftpClientFactory());
    }

    @Override
    public void setSftpClientFactory(SftpClientFactory sftpClientFactory) {
        this.sftpClientFactory = sftpClientFactory;
    }

    @Override
    public void addPasswordIdentity(String password) {
        ValidateUtils.checkTrue(password != null && !password.isEmpty(), "No password provided");
        this.identities.add(password);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPasswordIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(password));
        }
    }

    @Override
    public String removePasswordIdentity(String password) {
        if (GenericUtils.isEmpty(password)) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.PASSWORD_IDENTITY_COMPARATOR, password);
        if (index >= 0) {
            return (String)this.identities.remove(index);
        }
        return null;
    }

    @Override
    public void addPublicKeyIdentity(KeyPair kp) {
        Objects.requireNonNull(kp, "No key-pair to add");
        Objects.requireNonNull(kp.getPublic(), "No public key");
        Objects.requireNonNull(kp.getPrivate(), "No private key");
        this.identities.add(kp);
        if (this.log.isDebugEnabled()) {
            PublicKey key = kp.getPublic();
            this.log.debug("addPublicKeyIdentity({}) {}-{}", this, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
        }
    }

    @Override
    public KeyPair removePublicKeyIdentity(KeyPair kp) {
        if (kp == null) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.KEYPAIR_IDENTITY_COMPARATOR, kp);
        if (index >= 0) {
            return (KeyPair)this.identities.remove(index);
        }
        return null;
    }

    protected IoWriteFuture sendClientIdentification() throws Exception {
        this.clientVersion = this.resolveIdentificationString("client-identification");
        ClientProxyConnector proxyConnector = this.getClientProxyConnector();
        if (proxyConnector != null) {
            try {
                proxyConnector.sendClientProxyMetadata(this);
            }
            catch (Throwable t) {
                this.log.warn("sendClientIdentification({}) failed ({}) to send proxy metadata: {}", this, t.getClass().getSimpleName(), t.getMessage());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("sendClientIdentification(" + this + ") proxy metadata send failure details", t);
                }
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new RuntimeSshException(t);
            }
        }
        return this.sendIdentification(this.clientVersion);
    }

    @Override
    public ClientChannel createChannel(String type) throws IOException {
        return this.createChannel(type, null);
    }

    @Override
    public ClientChannel createChannel(String type, String subType) throws IOException {
        if ("shell".equals(type)) {
            return this.createShellChannel();
        }
        if ("exec".equals(type)) {
            return this.createExecChannel(subType);
        }
        if ("subsystem".equals(type)) {
            return this.createSubsystemChannel(subType);
        }
        throw new IllegalArgumentException("Unsupported channel type " + type);
    }

    @Override
    public ChannelExec createExecChannel(String command) throws IOException {
        ChannelExec channel = new ChannelExec(command);
        ConnectionService service = this.getConnectionService();
        int id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createExecChannel({})[{}] created id={}", this, command, id);
        }
        return channel;
    }

    @Override
    public ChannelSubsystem createSubsystemChannel(String subsystem) throws IOException {
        ChannelSubsystem channel = new ChannelSubsystem(subsystem);
        ConnectionService service = this.getConnectionService();
        int id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createSubsystemChannel({})[{}] created id={}", this, subsystem, id);
        }
        return channel;
    }

    @Override
    public ChannelDirectTcpip createDirectTcpipChannel(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        ChannelDirectTcpip channel = new ChannelDirectTcpip(local, remote);
        ConnectionService service = this.getConnectionService();
        int id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createDirectTcpipChannel({})[{} => {}] created id={}", this, local, remote, id);
        }
        return channel;
    }

    protected ClientUserAuthService getUserAuthService() {
        return this.getService(ClientUserAuthService.class);
    }

    protected ConnectionService getConnectionService() {
        return this.getService(ConnectionService.class);
    }

    @Override
    public ScpFileOpener getScpFileOpener() {
        return this.resolveEffectiveProvider(ScpFileOpener.class, this.scpOpener, this.getFactoryManager().getScpFileOpener());
    }

    @Override
    public void setScpFileOpener(ScpFileOpener opener) {
        this.scpOpener = opener;
    }

    @Override
    public ScpTransferEventListener getScpTransferEventListener() {
        return this.scpListener;
    }

    @Override
    public void setScpTransferEventListener(ScpTransferEventListener listener) {
        this.scpListener = listener;
    }

    @Override
    public ScpClient createScpClient(ScpFileOpener opener, ScpTransferEventListener listener) {
        return new DefaultScpClient(this, opener, listener);
    }

    @Override
    public SftpClient createSftpClient(SftpVersionSelector selector) throws IOException {
        SftpClientFactory factory = this.getSftpClientFactory();
        return factory.createSftpClient(this, selector);
    }

    @Override
    public FileSystem createSftpFileSystem(SftpVersionSelector selector, int readBufferSize, int writeBufferSize) throws IOException {
        SftpClientFactory factory = this.getSftpClientFactory();
        return factory.createSftpFileSystem(this, selector, readBufferSize, writeBufferSize);
    }

    @Override
    public SshdSocketAddress startLocalPortForwarding(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        ForwardingFilter filter = this.getForwardingFilter();
        return filter.startLocalPortForwarding(local, remote);
    }

    @Override
    public void stopLocalPortForwarding(SshdSocketAddress local) throws IOException {
        ForwardingFilter filter = this.getForwardingFilter();
        filter.stopLocalPortForwarding(local);
    }

    @Override
    public SshdSocketAddress startRemotePortForwarding(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        ForwardingFilter filter = this.getForwardingFilter();
        return filter.startRemotePortForwarding(remote, local);
    }

    @Override
    public void stopRemotePortForwarding(SshdSocketAddress remote) throws IOException {
        ForwardingFilter filter = this.getForwardingFilter();
        filter.stopRemotePortForwarding(remote);
    }

    @Override
    public SshdSocketAddress startDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        ForwardingFilter filter = this.getForwardingFilter();
        return filter.startDynamicPortForwarding(local);
    }

    @Override
    public void stopDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        ForwardingFilter filter = this.getForwardingFilter();
        filter.stopDynamicPortForwarding(local);
    }

    protected ForwardingFilter getForwardingFilter() {
        ConnectionService service = Objects.requireNonNull(this.getConnectionService(), "No connection service");
        return Objects.requireNonNull(service.getForwardingFilter(), "No forwarder");
    }

    @Override
    protected String resolveAvailableSignaturesProposal(FactoryManager manager) {
        ValidateUtils.checkTrue(manager == this.getFactoryManager(), "Mismatched factory manager instances");
        return NamedResource.getNames(this.getSignatureFactories());
    }

    @Override
    public void startService(String name) throws Exception {
        throw new IllegalStateException("Starting services is not supported on the client side: " + name);
    }

    @Override
    public ChannelShell createShellChannel() throws IOException {
        if (this.inCipher instanceof CipherNone || this.outCipher instanceof CipherNone) {
            throw new IllegalStateException("Interactive channels are not supported with none cipher");
        }
        ChannelShell channel = new ChannelShell();
        ConnectionService service = this.getConnectionService();
        int id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createShellChannel({}) created id={}", (Object)this, (Object)id);
        }
        return channel;
    }

    @Override
    protected boolean readIdentification(Buffer buffer) throws IOException {
        List<String> ident = this.doReadIdentification(buffer, false);
        int numLines = GenericUtils.size(ident);
        String string = this.serverVersion = numLines <= 0 ? null : ident.remove(numLines - 1);
        if (this.serverVersion == null) {
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("readIdentification({}) Server version string: {}", (Object)this, (Object)this.serverVersion);
        }
        if (!Session.isValidVersionPrefix(this.serverVersion)) {
            throw new SshException(8, "Unsupported protocol version: " + this.serverVersion);
        }
        this.signalExtraServerVersionInfo(ident);
        return true;
    }

    protected void signalExtraServerVersionInfo(List<String> lines) throws IOException {
        if (GenericUtils.isEmpty(lines)) {
            return;
        }
        UserInteraction ui = this.getUserInteraction();
        try {
            if (ui != null && ui.isInteractionAllowed(this)) {
                ui.serverVersionInfo(this, lines);
            }
        }
        catch (Error e) {
            this.log.warn("signalExtraServerVersionInfo({}) failed ({}) to consult interaction: {}", this, e.getClass().getSimpleName(), e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("signalExtraServerVersionInfo(" + this + ") interaction consultation failure details", e);
            }
            throw new RuntimeSshException(e);
        }
    }

    @Override
    protected byte[] sendKexInit(Map<KexProposalOption, String> proposal) throws IOException {
        this.mergeProposals(this.clientProposal, proposal);
        return super.sendKexInit(proposal);
    }

    @Override
    protected void setKexSeed(byte ... seed) {
        this.i_c = ValidateUtils.checkNotNullAndNotEmpty(seed, "No KEX seed");
    }

    @Override
    protected void receiveKexInit(Map<KexProposalOption, String> proposal, byte[] seed) throws IOException {
        this.mergeProposals(this.serverProposal, proposal);
        this.i_s = seed;
    }

    @Override
    protected void checkKeys() throws SshException {
        ServerKeyVerifier serverKeyVerifier = Objects.requireNonNull(this.getServerKeyVerifier(), "No server key verifier");
        SocketAddress remoteAddress = this.ioSession.getRemoteAddress();
        PublicKey serverKey = this.kex.getServerKey();
        boolean verified = serverKeyVerifier.verifyServerKey(this, remoteAddress, serverKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("checkKeys({}) key={}-{}, verified={}", this, KeyUtils.getKeyType(serverKey), KeyUtils.getFingerPrint(serverKey), verified);
        }
        if (!verified) {
            throw new SshException(9, "Server key did not validate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyExchangeFuture switchToNoneCipher() throws IOException {
        if (!(this.currentService instanceof AbstractConnectionService) || !GenericUtils.isEmpty(((AbstractConnectionService)this.currentService).getChannels())) {
            throw new IllegalStateException("The switch to the none cipher must be done immediately after authentication");
        }
        if (this.kexState.compareAndSet(KexState.DONE, KexState.INIT)) {
            String s2cEncClient;
            String c2sEncClient;
            String s2cEncServer;
            String c2sEncServer;
            DefaultKeyExchangeFuture kexFuture = new DefaultKeyExchangeFuture(this.toString(), null);
            DefaultKeyExchangeFuture prev = this.kexFutureHolder.getAndSet(kexFuture);
            if (prev != null) {
                DefaultKeyExchangeFuture defaultKeyExchangeFuture = prev;
                synchronized (defaultKeyExchangeFuture) {
                    Object value = prev.getValue();
                    if (value == null) {
                        prev.setValue(new SshException("Switch to none cipher while previous KEX is ongoing"));
                    }
                }
            }
            Map map = this.serverProposal;
            synchronized (map) {
                c2sEncServer = (String)this.serverProposal.get((Object)KexProposalOption.C2SENC);
                s2cEncServer = (String)this.serverProposal.get((Object)KexProposalOption.S2CENC);
            }
            boolean c2sEncServerNone = BuiltinCiphers.Constants.isNoneCipherIncluded(c2sEncServer);
            boolean s2cEncServerNone = BuiltinCiphers.Constants.isNoneCipherIncluded(s2cEncServer);
            Map map2 = this.clientProposal;
            synchronized (map2) {
                c2sEncClient = (String)this.clientProposal.get((Object)KexProposalOption.C2SENC);
                s2cEncClient = (String)this.clientProposal.get((Object)KexProposalOption.S2CENC);
            }
            boolean c2sEncClientNone = BuiltinCiphers.Constants.isNoneCipherIncluded(c2sEncClient);
            boolean s2cEncClientNone = BuiltinCiphers.Constants.isNoneCipherIncluded(s2cEncClient);
            if (!c2sEncServerNone || !s2cEncServerNone) {
                kexFuture.setValue(new SshException("Server does not support none cipher"));
            } else if (!c2sEncClientNone || !s2cEncClientNone) {
                kexFuture.setValue(new SshException("Client does not support none cipher"));
            } else {
                this.log.info("switchToNoneCipher({}) switching", (Object)this);
                EnumMap<KexProposalOption, String> proposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
                Map map3 = this.clientProposal;
                synchronized (map3) {
                    proposal.putAll(this.clientProposal);
                }
                proposal.put(KexProposalOption.C2SENC, "none");
                proposal.put(KexProposalOption.S2CENC, "none");
                byte[] seed = this.sendKexInit(proposal);
                this.setKexSeed(seed);
            }
            return (KeyExchangeFuture)Objects.requireNonNull(this.kexFutureHolder.get(), "No current KEX future");
        }
        throw new SshException("In flight key exchange");
    }
}

