/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StreamCorruptedException;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractSshFuture<T extends SshFuture>
extends AbstractLoggingBean
implements SshFuture<T> {
    protected static final Object CANCELED = new Object();
    private final Object id;

    protected AbstractSshFuture(Object id) {
        this.id = id;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public boolean await(long timeoutMillis) throws IOException {
        return this.await0(timeoutMillis, true) != null;
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(timeoutMillis, false) != null;
        }
        catch (InterruptedIOException e) {
            throw new InternalError("Unexpected interrupted exception wile awaitUninterruptibly " + timeoutMillis + " msec.: " + e.getMessage(), e);
        }
    }

    protected <R> R verifyResult(Class<? extends R> expectedType, long timeout) throws IOException {
        Object value = this.await0(timeout, true);
        if (value == null) {
            throw new SshException("Failed to get operation result within specified timeout: " + timeout);
        }
        Class<?> actualType = value.getClass();
        if (expectedType.isAssignableFrom(actualType)) {
            return expectedType.cast(value);
        }
        if (Throwable.class.isAssignableFrom(actualType)) {
            Throwable t = GenericUtils.peelException((Throwable)value);
            if (t != value) {
                value = t;
                actualType = value.getClass();
            }
            if (IOException.class.isAssignableFrom(actualType)) {
                throw (IOException)value;
            }
            throw new SshException("Failed (" + t.getClass().getSimpleName() + ") to execute: " + t.getMessage(), GenericUtils.resolveExceptionCause(t));
        }
        throw new StreamCorruptedException("Unknown result type: " + actualType.getName());
    }

    protected abstract Object await0(long var1, boolean var3) throws InterruptedIOException;

    protected SshFutureListener<T> asListener(Object o) {
        return (SshFutureListener)o;
    }

    protected void notifyListener(SshFutureListener<T> l) {
        block2: {
            try {
                l.operationComplete(this.asT());
            }
            catch (Throwable t) {
                this.log.warn("notifyListener({}) failed ({}) to invoke {}: {}", this, t.getClass().getSimpleName(), l, t.getMessage());
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug("notifyListener(" + this + ")[" + l + "] invocation failure details", t);
            }
        }
    }

    protected T asT() {
        return (T)this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + "]";
    }
}

