/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class AbstractResourceKeyPairProvider<R>
extends AbstractKeyPairProvider {
    private FilePasswordProvider passwordFinder;
    private final Map<String, KeyPair> cacheMap = new TreeMap<String, KeyPair>(String.CASE_INSENSITIVE_ORDER);

    protected AbstractResourceKeyPairProvider() {
    }

    public FilePasswordProvider getPasswordFinder() {
        return this.passwordFinder;
    }

    public void setPasswordFinder(FilePasswordProvider passwordFinder) {
        this.passwordFinder = passwordFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetCacheMap(Collection<?> resources) {
        Set<String> toDelete = Collections.emptySet();
        Map<String, KeyPair> map = this.cacheMap;
        synchronized (map) {
            if (this.cacheMap.size() <= 0) {
                return;
            }
            if (GenericUtils.isEmpty(resources)) {
                this.cacheMap.clear();
                return;
            }
            for (Object r : resources) {
                String resourceKey = ValidateUtils.checkNotNullAndNotEmpty(Objects.toString(r, null), "No resource key value");
                if (this.cacheMap.containsKey(resourceKey)) continue;
                if (toDelete.isEmpty()) {
                    toDelete = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                }
                if (toDelete.add(resourceKey)) continue;
            }
            if (GenericUtils.size(toDelete) > 0) {
                toDelete.forEach(this.cacheMap::remove);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resetCacheMap(" + resources + ") removed previous cached keys for " + toDelete);
        }
    }

    protected Iterable<KeyPair> loadKeys(Collection<? extends R> resources) {
        if (GenericUtils.isEmpty(resources)) {
            return Collections.emptyList();
        }
        return () -> new KeyPairIterator(resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyPair doLoadKey(R resource) throws IOException, GeneralSecurityException {
        KeyPair kp;
        String resourceKey = ValidateUtils.checkNotNullAndNotEmpty(Objects.toString(resource, null), "No resource string value");
        Map<String, KeyPair> map = this.cacheMap;
        synchronized (map) {
            kp = this.cacheMap.get(resourceKey);
        }
        if (kp != null) {
            if (this.log.isTraceEnabled()) {
                PublicKey key = kp.getPublic();
                this.log.trace("doLoadKey({}) use cached key {}-{}", resourceKey, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
            }
            return kp;
        }
        kp = this.doLoadKey(resourceKey, resource, this.getPasswordFinder());
        if (kp != null) {
            boolean reusedKey;
            Map<String, KeyPair> map2 = this.cacheMap;
            synchronized (map2) {
                reusedKey = this.cacheMap.containsKey(resourceKey);
                if (reusedKey) {
                    kp = this.cacheMap.get(resourceKey);
                } else {
                    this.cacheMap.put(resourceKey, kp);
                }
            }
            if (this.log.isDebugEnabled()) {
                PublicKey key = kp.getPublic();
                this.log.debug("doLoadKey({}) {} {}-{}", resourceKey, reusedKey ? "re-loaded" : "loaded", KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("doLoadKey({}) no key loaded", (Object)resourceKey);
        }
        return kp;
    }

    protected KeyPair doLoadKey(String resourceKey, R resource, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
        try (InputStream inputStream = this.openKeyPairResource(resourceKey, resource);){
            KeyPair keyPair = this.doLoadKey(resourceKey, inputStream, provider);
            return keyPair;
        }
    }

    protected abstract InputStream openKeyPairResource(String var1, R var2) throws IOException;

    protected KeyPair doLoadKey(String resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
        return SecurityUtils.loadKeyPairIdentity(resourceKey, inputStream, provider);
    }

    protected class KeyPairIterator
    implements Iterator<KeyPair> {
        private final Iterator<? extends R> iterator;
        private KeyPair nextKeyPair;
        private boolean nextKeyPairSet;

        protected KeyPairIterator(Collection<? extends R> resources) {
            this.iterator = resources.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.nextKeyPairSet || this.setNextObject();
        }

        @Override
        public KeyPair next() {
            if (!this.nextKeyPairSet && !this.setNextObject()) {
                throw new NoSuchElementException("Out of files to try");
            }
            this.nextKeyPairSet = false;
            return this.nextKeyPair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("loadKeys(files) Iterator#remove() N/A");
        }

        private boolean setNextObject() {
            while (this.iterator.hasNext()) {
                Object r = this.iterator.next();
                try {
                    this.nextKeyPair = AbstractResourceKeyPairProvider.this.doLoadKey(r);
                }
                catch (Throwable e) {
                    AbstractResourceKeyPairProvider.this.log.warn("Failed (" + e.getClass().getSimpleName() + ") to load key resource=" + r + ": " + e.getMessage());
                    if (AbstractResourceKeyPairProvider.this.log.isDebugEnabled()) {
                        AbstractResourceKeyPairProvider.this.log.debug("Key resource=" + r + " load failure details", e);
                    }
                    this.nextKeyPair = null;
                    continue;
                }
                if (this.nextKeyPair == null) continue;
                this.nextKeyPairSet = true;
                return true;
            }
            return false;
        }
    }
}

