/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.subsystem.sftp.SftpConstants;
import org.apache.sshd.common.subsystem.sftp.SftpHelper;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.AbstractSftpSubsystemHelper;
import org.apache.sshd.server.subsystem.sftp.DirectoryHandle;
import org.apache.sshd.server.subsystem.sftp.FileHandle;
import org.apache.sshd.server.subsystem.sftp.Handle;
import org.apache.sshd.server.subsystem.sftp.SftpErrorStatusDataHandler;
import org.apache.sshd.server.subsystem.sftp.SftpEventListener;
import org.apache.sshd.server.subsystem.sftp.SftpFileSystemAccessor;
import org.apache.sshd.server.subsystem.sftp.UnsupportedAttributePolicy;

public class SftpSubsystem
extends AbstractSftpSubsystemHelper
implements Command,
Runnable,
SessionAware,
FileSystemAware {
    public static final String MAX_OPEN_HANDLES_PER_SESSION = "max-open-handles-per-session";
    public static final int DEFAULT_MAX_OPEN_HANDLES = Integer.MAX_VALUE;
    public static final String FILE_HANDLE_SIZE = "sftp-handle-size";
    public static final int MIN_FILE_HANDLE_SIZE = 4;
    public static final int DEFAULT_FILE_HANDLE_SIZE = 16;
    public static final int MAX_FILE_HANDLE_SIZE = 64;
    public static final String MAX_FILE_HANDLE_RAND_ROUNDS = "sftp-handle-rand-max-rounds";
    public static final int MIN_FILE_HANDLE_ROUNDS = 1;
    public static final int DEFAULT_FILE_HANDLE_ROUNDS = 4;
    public static final int MAX_FILE_HANDLE_ROUNDS = 64;
    public static final String MAX_READDIR_DATA_SIZE_PROP = "sftp-max-readdir-data-size";
    public static final int DEFAULT_MAX_READDIR_DATA_SIZE = 16384;
    protected ExitCallback callback;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream err;
    protected Environment env;
    protected Random randomizer;
    protected int fileHandleSize = 16;
    protected int maxFileHandleRounds = 4;
    protected ExecutorService executors;
    protected boolean shutdownExecutor;
    protected Future<?> pendingFuture;
    protected byte[] workBuf = new byte[Math.max(16, 4)];
    protected FileSystem fileSystem = FileSystems.getDefault();
    protected Path defaultDir = this.fileSystem.getPath(System.getProperty("user.dir"), new String[0]);
    protected long requestsCount;
    protected int version;
    protected final Map<String, byte[]> extensions = new TreeMap(Comparator.naturalOrder());
    protected final Map<String, Handle> handles = new HashMap<String, Handle>();
    private ServerSession serverSession;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public SftpSubsystem(ExecutorService executorService, boolean shutdownOnExit, UnsupportedAttributePolicy policy, SftpFileSystemAccessor accessor, SftpErrorStatusDataHandler errorStatusDataHandler) {
        super(policy, accessor, errorStatusDataHandler);
        if (executorService == null) {
            this.executors = ThreadUtils.newSingleThreadExecutor(this.getClass().getSimpleName());
            this.shutdownExecutor = true;
        } else {
            this.executors = executorService;
            this.shutdownExecutor = shutdownOnExit;
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public Path getDefaultDirectory() {
        return this.defaultDir;
    }

    @Override
    public void setSession(ServerSession session) {
        this.serverSession = Objects.requireNonNull(session, "No session");
        ServerFactoryManager manager = session.getFactoryManager();
        Factory<Random> factory = manager.getRandomFactory();
        this.randomizer = factory.create();
        this.fileHandleSize = session.getIntProperty(FILE_HANDLE_SIZE, 16);
        ValidateUtils.checkTrue(this.fileHandleSize >= 4, "File handle size too small: %d", this.fileHandleSize);
        ValidateUtils.checkTrue(this.fileHandleSize <= 64, "File handle size too big: %d", this.fileHandleSize);
        this.maxFileHandleRounds = session.getIntProperty(MAX_FILE_HANDLE_RAND_ROUNDS, 4);
        ValidateUtils.checkTrue(this.maxFileHandleRounds >= 1, "File handle rounds too small: %d", this.maxFileHandleRounds);
        ValidateUtils.checkTrue(this.maxFileHandleRounds <= 64, "File handle rounds too big: %d", this.maxFileHandleRounds);
        if (this.workBuf.length < this.fileHandleSize) {
            this.workBuf = new byte[this.fileHandleSize];
        }
    }

    @Override
    public ServerSession getServerSession() {
        return this.serverSession;
    }

    @Override
    public void setFileSystem(FileSystem fileSystem) {
        if (fileSystem != this.fileSystem) {
            this.fileSystem = fileSystem;
            Iterable<Path> roots = Objects.requireNonNull(fileSystem.getRootDirectories(), "No root directories");
            Iterator<Path> available = Objects.requireNonNull(roots.iterator(), "No roots iterator");
            ValidateUtils.checkTrue(available.hasNext(), "No available root");
            this.defaultDir = available.next();
        }
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    @Override
    public void start(Environment env) throws IOException {
        this.env = env;
        try {
            this.pendingFuture = this.executors.submit(this);
        }
        catch (RuntimeException e) {
            this.log.error("Failed (" + e.getClass().getSimpleName() + ") to start command: " + e.toString(), e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                long count = 1L;
                while (true) {
                    int l;
                    int length;
                    ValidateUtils.checkTrue((length = BufferUtils.readInt(this.in, this.workBuf, 0, this.workBuf.length)) >= 5, "Bad length to read: %d", length);
                    ByteArrayBuffer buffer = new ByteArrayBuffer(length + 4 + 64, false);
                    buffer.putInt(length);
                    for (int remainLen = length; remainLen > 0; remainLen -= l) {
                        l = this.in.read(((Buffer)buffer).array(), ((Buffer)buffer).wpos(), remainLen);
                        if (l < 0) {
                            throw new IllegalArgumentException("Premature EOF at buffer #" + count + " while read length=" + length + " and remain=" + remainLen);
                        }
                        ((Buffer)buffer).wpos(((Buffer)buffer).wpos() + l);
                    }
                    this.process(buffer);
                    ++count;
                }
            }
            catch (Throwable t) {
                if (!this.closed.get() && !(t instanceof EOFException)) {
                    this.log.error("run({}) {} caught in SFTP subsystem: {}", this.getServerSession(), t.getClass().getSimpleName(), t.getMessage());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("run(" + this.getServerSession() + ") caught exception details", t);
                    }
                }
                this.handles.forEach((id, handle) -> {
                    try {
                        handle.close();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("run({}) closed pending handle {} [{}]", this.getServerSession(), id, handle);
                        }
                    }
                    catch (IOException ioe) {
                        this.log.error("run({}) failed ({}) to close handle={}[{}]: {}", this.getServerSession(), ioe.getClass().getSimpleName(), id, handle, ioe.getMessage());
                    }
                });
                this.callback.onExit(0);
            }
        }
        catch (Throwable throwable) {
            this.handles.forEach((id, handle) -> {
                try {
                    handle.close();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("run({}) closed pending handle {} [{}]", this.getServerSession(), id, handle);
                    }
                }
                catch (IOException ioe) {
                    this.log.error("run({}) failed ({}) to close handle={}[{}]: {}", this.getServerSession(), ioe.getClass().getSimpleName(), id, handle, ioe.getMessage());
                }
            });
            this.callback.onExit(0);
            throw throwable;
        }
    }

    @Override
    protected void process(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("process({})[length={}, type={}, id={}] processing", this.getServerSession(), length, SftpConstants.getCommandMessageName(type), id);
        }
        switch (type) {
            case 1: {
                this.doInit(buffer, id);
                break;
            }
            case 3: {
                this.doOpen(buffer, id);
                break;
            }
            case 4: {
                this.doClose(buffer, id);
                break;
            }
            case 5: {
                this.doRead(buffer, id);
                break;
            }
            case 6: {
                this.doWrite(buffer, id);
                break;
            }
            case 7: {
                this.doLStat(buffer, id);
                break;
            }
            case 8: {
                this.doFStat(buffer, id);
                break;
            }
            case 9: {
                this.doSetStat(buffer, id);
                break;
            }
            case 10: {
                this.doFSetStat(buffer, id);
                break;
            }
            case 11: {
                this.doOpenDir(buffer, id);
                break;
            }
            case 12: {
                this.doReadDir(buffer, id);
                break;
            }
            case 13: {
                this.doRemove(buffer, id);
                break;
            }
            case 14: {
                this.doMakeDirectory(buffer, id);
                break;
            }
            case 15: {
                this.doRemoveDirectory(buffer, id);
                break;
            }
            case 16: {
                this.doRealPath(buffer, id);
                break;
            }
            case 17: {
                this.doStat(buffer, id);
                break;
            }
            case 18: {
                this.doRename(buffer, id);
                break;
            }
            case 19: {
                this.doReadLink(buffer, id);
                break;
            }
            case 20: {
                this.doSymLink(buffer, id);
                break;
            }
            case 21: {
                this.doLink(buffer, id);
                break;
            }
            case 22: {
                this.doBlock(buffer, id);
                break;
            }
            case 23: {
                this.doUnblock(buffer, id);
                break;
            }
            case 200: {
                this.doExtended(buffer, id);
                break;
            }
            default: {
                String name = SftpConstants.getCommandMessageName(type);
                this.log.warn("process({})[length={}, type={}, id={}] unknown command", this.getServerSession(), length, name, id);
                this.sendStatus(BufferUtils.clear(buffer), id, 8, "Command " + name + " is unsupported or not implemented");
            }
        }
        if (type != 1) {
            ++this.requestsCount;
        }
    }

    @Override
    protected void executeExtendedCommand(Buffer buffer, int id, String extension) throws IOException {
        switch (extension) {
            case "text-seek": {
                this.doTextSeek(buffer, id);
                break;
            }
            case "version-select": {
                this.doVersionSelect(buffer, id);
                break;
            }
            case "copy-file": {
                this.doCopyFile(buffer, id);
                break;
            }
            case "copy-data": {
                this.doCopyData(buffer, id);
                break;
            }
            case "md5-hash": 
            case "md5-hash-handle": {
                this.doMD5Hash(buffer, id, extension);
                break;
            }
            case "check-file-handle": 
            case "check-file-name": {
                this.doCheckFileHash(buffer, id, extension);
                break;
            }
            case "fsync@openssh.com": {
                this.doOpenSSHFsync(buffer, id);
                break;
            }
            case "space-available": {
                this.doSpaceAvailable(buffer, id);
                break;
            }
            case "hardlink@openssh.com": {
                this.doOpenSSHHardLink(buffer, id);
                break;
            }
            default: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("executeExtendedCommand({}) received unsupported SSH_FXP_EXTENDED({})", (Object)this.getServerSession(), (Object)extension);
                }
                this.sendStatus(BufferUtils.clear(buffer), id, 8, "Command SSH_FXP_EXTENDED(" + extension + ") is unsupported or not implemented");
            }
        }
    }

    @Override
    protected void createLink(int id, String existingPath, String linkPath, boolean symLink) throws IOException {
        Path link = this.resolveFile(linkPath);
        Path existing = this.fileSystem.getPath(existingPath, new String[0]);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createLink({})[id={}], existing={}[{}], link={}[{}], symlink={})", this.getServerSession(), id, linkPath, link, existingPath, existing, symLink);
        }
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session = this.getServerSession();
        listener.linking(session, link, existing, symLink);
        try {
            if (symLink) {
                Files.createSymbolicLink(link, existing, new FileAttribute[0]);
            } else {
                Files.createLink(link, existing);
            }
        }
        catch (IOException | RuntimeException e) {
            listener.linked(session, link, existing, symLink, e);
            throw e;
        }
        listener.linked(session, link, existing, symLink, null);
    }

    @Override
    protected void doTextSeek(int id, String handle, long line) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doTextSeek({})[id={}] SSH_FXP_EXTENDED(text-seek) (handle={}[{}], line={})", this.getServerSession(), id, handle, h, line);
        }
        FileHandle fileHandle = this.validateHandle(handle, h, FileHandle.class);
        throw new UnknownServiceException("doTextSeek(" + fileHandle + ")");
    }

    @Override
    protected void doOpenSSHFsync(int id, String handle) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpenSSHFsync({})[id={}] {}[{}]", this.getServerSession(), id, handle, h);
        }
        FileHandle fileHandle = this.validateHandle(handle, h, FileHandle.class);
        SftpFileSystemAccessor accessor = this.getFileSystemAccessor();
        ServerSession session = this.getServerSession();
        accessor.syncFileData(session, this, fileHandle.getFile(), fileHandle.getFileHandle(), fileHandle.getFileChannel());
    }

    @Override
    protected void doCheckFileHash(int id, String targetType, String target, Collection<String> algos, long startOffset, long length, int blockSize, Buffer buffer) throws Exception {
        String a;
        Path path;
        if ("check-file-handle".equalsIgnoreCase(targetType)) {
            Handle h = this.handles.get(target);
            FileHandle fileHandle = this.validateHandle(target, h, FileHandle.class);
            path = fileHandle.getFile();
            int access = fileHandle.getAccessMask();
            if ((access & 1) == 0) {
                throw new AccessDeniedException(path.toString(), path.toString(), "File not opened for read");
            }
        } else {
            path = this.resolveFile(target);
            for (int index = 0; Files.isSymbolicLink(path) && index < 127; ++index) {
                path = Files.readSymbolicLink(path);
            }
            if (Files.isSymbolicLink(path)) {
                throw new FileSystemLoopException(target);
            }
            if (Files.isDirectory(path, IoUtils.getLinkOptions(false))) {
                throw new NotDirectoryException(path.toString());
            }
        }
        ValidateUtils.checkNotNullAndNotEmpty(algos, "No hash algorithms specified", new Object[0]);
        BuiltinDigests factory = null;
        Iterator<String> iterator = algos.iterator();
        while (iterator.hasNext() && ((factory = BuiltinDigests.fromFactoryName(a = iterator.next())) == null || !factory.isSupported())) {
        }
        ValidateUtils.checkNotNull(factory, "No matching digest factory found for %s", algos);
        this.doCheckFileHash(id, path, factory, startOffset, length, blockSize, buffer);
    }

    @Override
    protected byte[] doMD5Hash(int id, String targetType, String target, long startOffset, long length, byte[] quickCheckHash) throws Exception {
        Path path;
        if (this.log.isDebugEnabled()) {
            this.log.debug("doMD5Hash({})({})[{}] offset={}, length={}, quick-hash={}", this.getServerSession(), targetType, target, startOffset, length, BufferUtils.toHex(':', quickCheckHash));
        }
        if ("md5-hash-handle".equalsIgnoreCase(targetType)) {
            Handle h = this.handles.get(target);
            FileHandle fileHandle = this.validateHandle(target, h, FileHandle.class);
            path = fileHandle.getFile();
            int access = fileHandle.getAccessMask();
            if ((access & 1) == 0) {
                throw new AccessDeniedException(path.toString(), path.toString(), "File not opened for read");
            }
        } else {
            path = this.resolveFile(target);
            if (Files.isDirectory(path, IoUtils.getLinkOptions(true))) {
                throw new NotDirectoryException(path.toString());
            }
        }
        long effectiveLength = length;
        long totalSize = Files.size(path);
        if (startOffset == 0L && length == 0L) {
            effectiveLength = totalSize;
        } else {
            long maxRead = startOffset + effectiveLength;
            if (maxRead > totalSize) {
                effectiveLength = totalSize - startOffset;
            }
        }
        return this.doMD5Hash(id, path, startOffset, effectiveLength, quickCheckHash);
    }

    protected void doVersionSelect(Buffer buffer, int id) throws IOException {
        String proposed = buffer.getString();
        ServerSession session = this.getServerSession();
        if (this.requestsCount > 0L) {
            this.sendStatus(BufferUtils.clear(buffer), id, 4, "Version selection not the 1st request for proposal = " + proposed);
            session.close(true);
            return;
        }
        Boolean result = this.validateProposedVersion(buffer, id, proposed);
        if (result == null) {
            session.close(true);
            return;
        }
        if (result.booleanValue()) {
            this.version = Integer.parseInt(proposed);
            this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
        } else {
            this.sendStatus(BufferUtils.clear(buffer), id, 4, "Unsupported version " + proposed);
            session.close(true);
        }
    }

    @Override
    protected void doBlock(int id, String handle, long offset, long length, int mask) throws IOException {
        Handle p = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doBlock({})[id={}] SSH_FXP_BLOCK (handle={}[{}], offset={}, length={}, mask=0x{})", this.getServerSession(), id, handle, p, offset, length, Integer.toHexString(mask));
        }
        FileHandle fileHandle = this.validateHandle(handle, p, FileHandle.class);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session = this.getServerSession();
        listener.blocking(session, handle, fileHandle, offset, length, mask);
        try {
            fileHandle.lock(offset, length, mask);
        }
        catch (IOException | RuntimeException e) {
            listener.blocked(session, handle, fileHandle, offset, length, mask, e);
            throw e;
        }
        listener.blocked(session, handle, fileHandle, offset, length, mask, null);
    }

    @Override
    protected void doUnblock(int id, String handle, long offset, long length) throws IOException {
        Handle p = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doUnblock({})[id={}] SSH_FXP_UNBLOCK (handle={}[{}], offset={}, length={})", this.getServerSession(), id, handle, p, offset, length);
        }
        FileHandle fileHandle = this.validateHandle(handle, p, FileHandle.class);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession session = this.getServerSession();
        listener.unblocking(session, handle, fileHandle, offset, length);
        try {
            fileHandle.unlock(offset, length);
        }
        catch (IOException | RuntimeException e) {
            listener.unblocked(session, handle, fileHandle, offset, length, e);
            throw e;
        }
        listener.unblocked(session, handle, fileHandle, offset, length, null);
    }

    @Override
    protected void doCopyData(int id, String readHandle, long readOffset, long readLength, String writeHandle, long writeOffset) throws IOException {
        Handle wh;
        boolean inPlaceCopy = readHandle.equals(writeHandle);
        Handle rh = this.handles.get(readHandle);
        Handle handle = wh = inPlaceCopy ? rh : this.handles.get(writeHandle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doCopyData({})[id={}] SSH_FXP_EXTENDED[{}] read={}[{}], read-offset={}, read-length={}, write={}[{}], write-offset={})", this.getServerSession(), id, "copy-data", readHandle, rh, readOffset, readLength, writeHandle, wh, writeOffset);
        }
        FileHandle srcHandle = this.validateHandle(readHandle, rh, FileHandle.class);
        Path srcPath = srcHandle.getFile();
        int srcAccess = srcHandle.getAccessMask();
        if ((srcAccess & 1) != 1) {
            throw new AccessDeniedException(srcPath.toString(), srcPath.toString(), "Source file not opened for read");
        }
        ValidateUtils.checkTrue(readLength >= 0L, "Invalid read length: %d", readLength);
        ValidateUtils.checkTrue(readOffset >= 0L, "Invalid read offset: %d", readOffset);
        long totalSize = Files.size(srcHandle.getFile());
        long effectiveLength = readLength;
        if (effectiveLength == 0L) {
            effectiveLength = totalSize - readOffset;
        } else {
            long maxRead = readOffset + effectiveLength;
            if (maxRead > totalSize) {
                effectiveLength = totalSize - readOffset;
            }
        }
        ValidateUtils.checkTrue(effectiveLength > 0L, "Non-positive effective copy data length: %d", effectiveLength);
        FileHandle dstHandle = inPlaceCopy ? srcHandle : this.validateHandle(writeHandle, wh, FileHandle.class);
        int dstAccess = dstHandle.getAccessMask();
        if ((dstAccess & 2) != 2) {
            throw new AccessDeniedException(srcHandle.toString(), srcHandle.toString(), "Source handle not opened for write");
        }
        ValidateUtils.checkTrue(writeOffset >= 0L, "Invalid write offset: %d", writeOffset);
        if (inPlaceCopy) {
            long maxWrite;
            long maxRead = readOffset + effectiveLength;
            if (maxRead > totalSize) {
                maxRead = totalSize;
            }
            if ((maxWrite = writeOffset + effectiveLength) > readOffset) {
                throw new IllegalArgumentException("Write range end [" + writeOffset + "-" + maxWrite + "] overlaps with read range [" + readOffset + "-" + maxRead + "]");
            }
            if (maxRead > writeOffset) {
                throw new IllegalArgumentException("Read range end [" + readOffset + "-" + maxRead + "] overlaps with write range [" + writeOffset + "-" + maxWrite + "]");
            }
        }
        byte[] copyBuf = new byte[Math.min(8192, (int)effectiveLength)];
        while (effectiveLength > 0L) {
            int remainLength = Math.min(copyBuf.length, (int)effectiveLength);
            int readLen = srcHandle.read(copyBuf, 0, remainLength, readOffset);
            if (readLen < 0) {
                throw new EOFException("Premature EOF while still remaining " + effectiveLength + " bytes");
            }
            dstHandle.write(copyBuf, 0, readLen, writeOffset);
            effectiveLength -= (long)readLen;
            readOffset += (long)readLen;
            writeOffset += (long)readLen;
        }
    }

    @Override
    protected void doReadDir(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doReadDir({})[id={}] SSH_FXP_READDIR (handle={}[{}])", this.getServerSession(), id, handle, h);
        }
        Buffer reply = null;
        try {
            LinkOption[] options;
            DirectoryHandle dh = this.validateHandle(handle, h, DirectoryHandle.class);
            if (dh.isDone()) {
                this.sendStatus(BufferUtils.clear(buffer), id, 1, "Directory reading is done");
                return;
            }
            Path file = dh.getFile();
            Boolean status = IoUtils.checkFileExists(file, options = this.getPathResolutionLinkOption(12, "", file));
            if (status == null) {
                throw new AccessDeniedException(file.toString(), file.toString(), "Cannot determine existence of read-dir");
            }
            if (!status.booleanValue()) {
                throw new NoSuchFileException(file.toString(), file.toString(), "Non-existant directory");
            }
            if (!Files.isDirectory(file, options)) {
                throw new NotDirectoryException(file.toString());
            }
            if (!Files.isReadable(file)) {
                throw new AccessDeniedException(file.toString(), file.toString(), "Not readable");
            }
            if (dh.isSendDot() || dh.isSendDotDot() || dh.hasNext()) {
                reply = BufferUtils.clear(buffer);
                reply.putByte((byte)104);
                reply.putInt(id);
                int lenPos = reply.wpos();
                reply.putInt(0L);
                ServerSession session = this.getServerSession();
                int maxDataSize = session.getIntProperty(MAX_READDIR_DATA_SIZE_PROP, 16384);
                int count = this.doReadDir(id, handle, dh, reply, maxDataSize, IoUtils.getLinkOptions(false));
                BufferUtils.updateLengthPlaceholder(reply, lenPos, count);
                if (!(dh.isSendDot() || dh.isSendDotDot() || dh.hasNext())) {
                    dh.markDone();
                }
                Boolean indicator = SftpHelper.indicateEndOfNamesList(reply, this.getVersion(), session, dh.isDone());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("doReadDir({})({})[{}] - seding {} entries - eol={}", session, handle, h, count, indicator);
                }
            } else {
                dh.markDone();
                this.sendStatus(BufferUtils.clear(buffer), id, 1, "Empty directory");
                return;
            }
            Objects.requireNonNull(reply, "No reply buffer created");
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e, 12, handle);
            return;
        }
        this.send(reply);
    }

    @Override
    protected String doOpenDir(int id, String path, Path p, LinkOption ... options) throws IOException {
        Boolean status = IoUtils.checkFileExists(p, options);
        if (status == null) {
            throw new AccessDeniedException(p.toString(), p.toString(), "Cannot determine open-dir existence");
        }
        if (!status.booleanValue()) {
            throw new NoSuchFileException(path, path, "Referenced target directory N/A");
        }
        if (!Files.isDirectory(p, options)) {
            throw new NotDirectoryException(path);
        }
        if (!Files.isReadable(p)) {
            throw new AccessDeniedException(p.toString(), p.toString(), "Not readable");
        }
        String handle = this.generateFileHandle(p);
        DirectoryHandle dirHandle = new DirectoryHandle(this, p, handle);
        this.handles.put(handle, dirHandle);
        return handle;
    }

    @Override
    protected void doFSetStat(int id, String handle, Map<String, ?> attrs) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doFsetStat({})[id={}] SSH_FXP_FSETSTAT (handle={}[{}], attrs={})", this.getServerSession(), id, handle, h, attrs);
        }
        this.doSetAttributes(this.validateHandle(handle, h, Handle.class).getFile(), attrs);
    }

    @Override
    protected Map<String, Object> doFStat(int id, String handle, int flags) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doFStat({})[id={}] SSH_FXP_FSTAT (handle={}[{}], flags=0x{})", this.getServerSession(), id, handle, h, Integer.toHexString(flags));
        }
        Handle fileHandle = this.validateHandle(handle, h, Handle.class);
        return this.resolveFileAttributes(fileHandle.getFile(), flags, IoUtils.getLinkOptions(true));
    }

    @Override
    protected void doWrite(int id, String handle, long offset, int length, byte[] data, int doff, int remaining) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doWrite({})[id={}] SSH_FXP_WRITE (handle={}[{}], offset={}, data=byte[{}])", this.getServerSession(), id, handle, h, offset, length);
        }
        FileHandle fh = this.validateHandle(handle, h, FileHandle.class);
        if (length < 0) {
            throw new IllegalStateException("Bad length (" + length + ") for writing to " + fh);
        }
        if (remaining < length) {
            throw new IllegalStateException("Not enough buffer data for writing to " + fh + ": required=" + length + ", available=" + remaining);
        }
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.writing(this.getServerSession(), handle, fh, offset, data, doff, length);
        try {
            if (fh.isOpenAppend()) {
                fh.append(data, doff, length);
            } else {
                fh.write(data, doff, length, offset);
            }
        }
        catch (IOException | RuntimeException e) {
            listener.written(this.getServerSession(), handle, fh, offset, data, doff, length, e);
            throw e;
        }
        listener.written(this.getServerSession(), handle, fh, offset, data, doff, length, null);
    }

    @Override
    protected int doRead(int id, String handle, long offset, int length, byte[] data, int doff) throws IOException {
        int readLen;
        Handle h = this.handles.get(handle);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doRead({})[id={}] SSH_FXP_READ (handle={}[{}], offset={}, length={})", this.getServerSession(), id, handle, h, offset, length);
        }
        ValidateUtils.checkTrue((long)length > 0L, "Invalid read length: %d", length);
        FileHandle fh = this.validateHandle(handle, h, FileHandle.class);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        ServerSession serverSession = this.getServerSession();
        listener.reading(serverSession, handle, fh, offset, data, doff, length);
        try {
            readLen = fh.read(data, doff, length, offset);
        }
        catch (IOException | RuntimeException e) {
            listener.read(serverSession, handle, fh, offset, data, doff, length, -1, e);
            throw e;
        }
        listener.read(serverSession, handle, fh, offset, data, doff, length, readLen, null);
        return readLen;
    }

    @Override
    protected void doClose(int id, String handle) throws IOException {
        Handle h = this.handles.remove(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doClose({})[id={}] SSH_FXP_CLOSE (handle={}[{}])", this.getServerSession(), id, handle, h);
        }
        this.validateHandle(handle, h, Handle.class).close();
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.close(this.getServerSession(), handle, h);
    }

    @Override
    protected String doOpen(int id, String path, int pflags, int access, Map<String, Object> attrs) throws IOException {
        int maxHandleCount;
        int curHandleCount;
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpen({})[id={}] SSH_FXP_OPEN (path={}, access=0x{}, pflags=0x{}, attrs={})", this.getServerSession(), id, path, Integer.toHexString(access), Integer.toHexString(pflags), attrs);
        }
        if ((curHandleCount = this.handles.size()) > (maxHandleCount = this.getServerSession().getIntProperty(MAX_OPEN_HANDLES_PER_SESSION, Integer.MAX_VALUE))) {
            throw new IllegalStateException("Too many open handles: current=" + curHandleCount + ", max.=" + maxHandleCount);
        }
        Path file = this.resolveFile(path);
        String handle = this.generateFileHandle(file);
        FileHandle fileHandle = new FileHandle(this, file, handle, pflags, access, attrs);
        this.handles.put(handle, fileHandle);
        return handle;
    }

    protected String generateFileHandle(Path file) {
        for (int index = 0; index < this.maxFileHandleRounds; ++index) {
            this.randomizer.fill(this.workBuf, 0, this.fileHandleSize);
            String handle = BufferUtils.toHex(this.workBuf, 0, this.fileHandleSize, '\u0000');
            if (this.handles.containsKey(handle)) {
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("generateFileHandle({})[{}] handle={} in use at round {}", this.getServerSession(), file, handle, index);
                continue;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("generateFileHandle({})[{}] {}", this.getServerSession(), file, handle);
            }
            return handle;
        }
        throw new IllegalStateException("Failed to generate a unique file handle for " + file);
    }

    protected void doInit(Buffer buffer, int id) throws IOException {
        String all;
        if (this.log.isDebugEnabled()) {
            this.log.debug("doInit({})[id={}] SSH_FXP_INIT (version={})", this.getServerSession(), id, id);
        }
        if (GenericUtils.isEmpty(all = this.checkVersionCompatibility(buffer, id, id, 8))) {
            return;
        }
        this.version = id;
        while (buffer.available() > 0) {
            String name = buffer.getString();
            byte[] data = buffer.getBytes();
            this.extensions.put(name, data);
        }
        buffer.clear();
        buffer.putByte((byte)2);
        buffer.putInt(this.version);
        this.appendExtensions(buffer, all);
        SftpEventListener listener = this.getSftpEventListenerProxy();
        listener.initialized(this.getServerSession(), this.version);
        this.send(buffer);
    }

    @Override
    protected void send(Buffer buffer) throws IOException {
        int len = buffer.available();
        BufferUtils.writeInt(this.out, len, this.workBuf, 0, this.workBuf.length);
        this.out.write(buffer.array(), buffer.rpos(), len);
        this.out.flush();
    }

    @Override
    public void destroy() {
        block13: {
            ServerSession session;
            block12: {
                if (this.closed.getAndSet(true)) {
                    return;
                }
                session = this.getServerSession();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("destroy({}) - mark as closed", (Object)session);
                }
                try {
                    SftpEventListener listener = this.getSftpEventListenerProxy();
                    listener.destroying(session);
                }
                catch (Exception e) {
                    this.log.warn("destroy({}) Failed ({}) to announce destruction event: {}", session, e.getClass().getSimpleName(), e.getMessage());
                    if (!this.log.isDebugEnabled()) break block12;
                    this.log.debug("destroy(" + session + ") destruction announcement failure details", e);
                }
            }
            if (this.pendingFuture != null && !this.pendingFuture.isDone()) {
                boolean result = this.pendingFuture.cancel(true);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("destroy(" + session + ") - cancel pending future=" + result);
                }
            }
            this.pendingFuture = null;
            if (this.executors != null && !this.executors.isShutdown() && this.shutdownExecutor) {
                List<Runnable> runners = this.executors.shutdownNow();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("destroy(" + session + ") - shutdown executor service - runners count=" + runners.size());
                }
            }
            this.executors = null;
            try {
                this.fileSystem.close();
            }
            catch (UnsupportedOperationException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("destroy(" + session + ") closing the file system is not supported");
                }
            }
            catch (IOException e) {
                if (!this.log.isDebugEnabled()) break block13;
                this.log.debug("destroy(" + session + ") failed (" + e.getClass().getSimpleName() + ") to close file system: " + e.getMessage(), e);
            }
        }
    }
}

