/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPrivateKeySpec;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import javax.net.ssl.KeyManagerFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import winstone.ConnectorFactory;
import winstone.Logger;
import winstone.WinstoneException;
import winstone.WinstoneResourceBundle;
import winstone.cmdline.Option;

public abstract class AbstractSecuredConnectorFactory
implements ConnectorFactory {
    protected static final WinstoneResourceBundle SSL_RESOURCES = new WinstoneResourceBundle("winstone.LocalStrings");
    protected KeyStore keystore;
    protected String keystorePassword;

    protected void configureSsl(Map args, Server server) throws IOException {
        block11: {
            try {
                X509Certificate cert;
                PrivateKey privKey;
                File opensslCert = Option.HTTPS_CERTIFICATE.get(args);
                File opensslKey = Option.HTTPS_PRIVATE_KEY.get(args);
                File keyStore = Option.HTTPS_KEY_STORE.get(args);
                String pwd = Option.HTTPS_KEY_STORE_PASSWORD.get(args);
                if (opensslCert != null ^ opensslKey != null) {
                    throw new WinstoneException(MessageFormat.format("--{0} and --{1} need to be used together", Option.HTTPS_CERTIFICATE, Option.HTTPS_PRIVATE_KEY));
                }
                if (keyStore != null && opensslKey != null) {
                    throw new WinstoneException(MessageFormat.format("--{0} and --{1} are mutually exclusive", Option.HTTPS_KEY_STORE, Option.HTTPS_PRIVATE_KEY));
                }
                if (keyStore != null) {
                    if (!keyStore.exists() || !keyStore.isFile()) {
                        throw new WinstoneException(SSL_RESOURCES.getString("HttpsListener.KeyStoreNotFound", keyStore.getPath()));
                    }
                    this.keystorePassword = pwd;
                    this.keystore = KeyStore.getInstance("JKS");
                    this.keystore.load(new FileInputStream(keyStore), this.keystorePassword.toCharArray());
                    break block11;
                }
                if (opensslCert != null) {
                    CertificateFactory cf = CertificateFactory.getInstance("X509");
                    Certificate cert2 = cf.generateCertificate(new FileInputStream(opensslCert));
                    PrivateKey key = AbstractSecuredConnectorFactory.readPEMRSAPrivateKey(new FileReader(opensslKey));
                    this.keystorePassword = "changeit";
                    this.keystore = KeyStore.getInstance("JKS");
                    this.keystore.load(null);
                    this.keystore.setKeyEntry("hudson", key, this.keystorePassword.toCharArray(), new Certificate[]{cert2});
                    break block11;
                }
                this.keystorePassword = "changeit";
                System.out.println("Using one-time self-signed certificate");
                try {
                    Object ckg;
                    try {
                        ckg = Class.forName("sun.security.x509.CertAndKeyGen").getDeclaredConstructor(String.class, String.class, String.class).newInstance("RSA", "SHA1WithRSA", null);
                    }
                    catch (ClassNotFoundException cnfe) {
                        ckg = Class.forName("sun.security.tools.keytool.CertAndKeyGen").getDeclaredConstructor(String.class, String.class, String.class).newInstance("RSA", "SHA1WithRSA", null);
                    }
                    ckg.getClass().getDeclaredMethod("generate", Integer.TYPE).invoke(ckg, 1024);
                    privKey = (PrivateKey)ckg.getClass().getMethod("getPrivateKey", new Class[0]).invoke(ckg, new Object[0]);
                    Class<?> x500Name = Class.forName("sun.security.x509.X500Name");
                    Object xn = x500Name.getConstructor(String.class, String.class, String.class, String.class).newInstance("Test site", "Unknown", "Unknown", "Unknown");
                    cert = (X509Certificate)ckg.getClass().getMethod("getSelfCertificate", x500Name, Long.TYPE).invoke(ckg, xn, 315360000L);
                }
                catch (Exception x) {
                    throw new WinstoneException(SSL_RESOURCES.getString("HttpsConnectorFactory.SelfSignedError"), x);
                }
                Logger.log(Level.WARNING, SSL_RESOURCES, "HttpsConnectorFactory.SelfSigned");
                this.keystore = KeyStore.getInstance("JKS");
                this.keystore.load(null);
                this.keystore.setKeyEntry("hudson", privKey, this.keystorePassword.toCharArray(), new Certificate[]{cert});
            }
            catch (GeneralSecurityException e) {
                throw (IOException)new IOException("Failed to handle keys").initCause(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPEMRSAPrivateKey(Reader reader) throws IOException, GeneralSecurityException {
        BigInteger privExpo;
        BigInteger mod;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            String line;
            BufferedReader r = new BufferedReader(reader);
            boolean in = false;
            while ((line = r.readLine()) != null) {
                if (line.startsWith("-----")) {
                    in = !in;
                    continue;
                }
                if (!in) continue;
                baos.write(B64Code.decode(line));
            }
        }
        finally {
            reader.close();
        }
        try {
            Class<?> disC = Class.forName("sun.security.util.DerInputStream");
            Object dis = disC.getConstructor(byte[].class).newInstance(new Object[]{baos.toByteArray()});
            Object[] seq = (Object[])disC.getMethod("getSequence", Integer.TYPE).invoke(dis, 0);
            Method getBigInteger = seq[0].getClass().getMethod("getBigInteger", new Class[0]);
            mod = (BigInteger)getBigInteger.invoke(seq[1], new Object[0]);
            privExpo = (BigInteger)getBigInteger.invoke(seq[3], new Object[0]);
        }
        catch (Exception x) {
            throw new WinstoneException(SSL_RESOURCES.getString("HttpsConnectorFactory.LoadPrivateKeyError"), x);
        }
        Logger.log(Level.WARNING, SSL_RESOURCES, "HttpsConnectorFactory.LoadPrivateKey");
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(new RSAPrivateKeySpec(mod, privExpo));
    }

    protected SslContextFactory getSSLContext(Map args) {
        try {
            String privateKeyPassword = Option.HTTPS_PRIVATE_KEY_PASSWORD.get(args, this.keystorePassword);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(Option.HTTPS_KEY_MANAGER_TYPE.get(args));
            kmf.init(this.keystore, this.keystorePassword.toCharArray());
            Logger.log(Logger.FULL_DEBUG, SSL_RESOURCES, "HttpsListener.KeyCount", (Object)(this.keystore.size() + ""));
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Logger.log(Logger.FULL_DEBUG, SSL_RESOURCES, "HttpsListener.KeyFound", alias, this.keystore.getCertificate(alias) + "");
            }
            SslContextFactory ssl = new SslContextFactory();
            ssl.setKeyStore(this.keystore);
            ssl.setKeyStorePassword(this.keystorePassword);
            ssl.setKeyManagerPassword(privateKeyPassword);
            ssl.setKeyManagerFactoryAlgorithm(Option.HTTPS_KEY_MANAGER_TYPE.get(args));
            ssl.setCertAlias(Option.HTTPS_CERTIFICATE_ALIAS.get(args));
            ssl.setExcludeProtocols("SSLv3", "SSLv2", "SSLv2Hello");
            ssl.setNeedClientAuth(Option.HTTPS_VERIFY_CLIENT.get(args));
            return ssl;
        }
        catch (Throwable err) {
            throw new WinstoneException(SSL_RESOURCES.getString("HttpsListener.ErrorGettingContext"), err);
        }
    }
}

