/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.alpn.ALPN;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import winstone.AbstractSecuredConnectorFactory;
import winstone.ConnectorFactory;
import winstone.Launcher;
import winstone.Logger;
import winstone.cmdline.Option;

public class Http2ConnectorFactory
extends AbstractSecuredConnectorFactory
implements ConnectorFactory {
    @Override
    public boolean start(Map args, Server server) throws IOException {
        int listenPort = Option.HTTP2_PORT.get(args);
        String listenAddress = Option.HTTP2_LISTEN_ADDRESS.get(args);
        if (listenPort < 0) {
            return false;
        }
        try {
            this.configureSsl(args, server);
            SslContextFactory sslContextFactory = this.getSSLContext(args);
            sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
            HttpConfiguration https_config = new HttpConfiguration();
            https_config.setSecureScheme("https");
            https_config.setSecurePort(listenPort);
            https_config.addCustomizer(new SecureRequestCustomizer());
            HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(https_config);
            ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
            alpn.setDefaultProtocol("h2");
            SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, alpn.getProtocol());
            ServerConnector http2Connector = new ServerConnector(server, ssl, alpn, h2, new HttpConnectionFactory(https_config));
            http2Connector.setPort(listenPort);
            http2Connector.setHost(listenAddress);
            server.addConnector(http2Connector);
            server.setDumpAfterStart(Boolean.getBoolean("dumpAfterStart"));
            ALPN.debug = Boolean.getBoolean("alpnDebug");
            return true;
        }
        catch (IllegalStateException e) {
            Logger.log(Logger.WARNING, Launcher.RESOURCES, "Http2ConnectorFactory.FailedStart.ALPN", e);
            return false;
        }
    }
}

