/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import hudson.model.Saveable;
import java.io.Closeable;
import java.io.IOException;

public class BulkChange
implements Closeable {
    private final Saveable saveable;
    public final Exception allocator;
    private final BulkChange parent = BulkChange.current();
    private boolean completed;
    private static final ThreadLocal<BulkChange> INSCOPE = new ThreadLocal();
    public static final Saveable ALL = new Saveable(){

        @Override
        public void save() {
        }
    };

    public BulkChange(Saveable saveable) {
        this.saveable = saveable;
        this.allocator = new Exception();
        INSCOPE.set(this);
    }

    public void commit() throws IOException {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.pop();
        this.saveable.save();
    }

    @Override
    public void close() {
        this.abort();
    }

    public void abort() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.pop();
    }

    private void pop() {
        if (BulkChange.current() != this) {
            throw new AssertionError((Object)"Trying to save BulkChange that's not in scope");
        }
        INSCOPE.set(this.parent);
    }

    public static BulkChange current() {
        return INSCOPE.get();
    }

    public static boolean contains(Saveable s) {
        BulkChange b = BulkChange.current();
        while (b != null) {
            if (b.saveable == s || b.saveable == ALL) {
                return true;
            }
            b = b.parent;
        }
        return false;
    }
}

