/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import hudson.TcpSlaveAgentListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;

public class DNSMultiCast
implements Closeable {
    private JmDNS jmdns;
    private static final Logger LOGGER = Logger.getLogger(DNSMultiCast.class.getName());
    public static boolean disabled = SystemProperties.getBoolean(DNSMultiCast.class.getName() + ".disabled");

    public DNSMultiCast(final Jenkins jenkins) {
        if (disabled) {
            return;
        }
        Jenkins.MasterComputer.threadPoolForRemoting.submit(new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    DNSMultiCast.this.jmdns = JmDNS.create();
                    HashMap<String, String> props = new HashMap<String, String>();
                    String rootURL = jenkins.getRootUrl();
                    if (rootURL == null) {
                        return null;
                    }
                    props.put("url", rootURL);
                    try {
                        props.put("version", String.valueOf(Jenkins.getVersion()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    TcpSlaveAgentListener tal = jenkins.getTcpSlaveAgentListener();
                    if (tal != null) {
                        props.put("slave-port", String.valueOf(tal.getPort()));
                    }
                    props.put("server-id", jenkins.getLegacyInstanceId());
                    URL jenkins_url = new URL(rootURL);
                    int jenkins_port = jenkins_url.getPort();
                    if (jenkins_port == -1) {
                        jenkins_port = 80;
                    }
                    if (jenkins_url.getPath().length() > 0) {
                        props.put("path", jenkins_url.getPath());
                    }
                    DNSMultiCast.this.jmdns.registerService(ServiceInfo.create((String)"_hudson._tcp.local.", (String)"jenkins", (int)jenkins_port, (int)0, (int)0, props));
                    DNSMultiCast.this.jmdns.registerService(ServiceInfo.create((String)"_jenkins._tcp.local.", (String)"jenkins", (int)jenkins_port, (int)0, (int)0, props));
                    DNSMultiCast.this.jmdns.registerService(ServiceInfo.create((String)"_http._tcp.local.", (String)"Jenkins", (int)jenkins_port, (int)0, (int)0, props));
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Cannot advertise service to DNS multi-cast, skipping: {0}", e);
                    LOGGER.log(Level.FINE, null, e);
                }
                return null;
            }
        });
    }

    @Override
    public void close() {
        if (this.jmdns != null) {
            this.jmdns.abort();
            this.jmdns = null;
        }
    }
}

