/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.google.common.annotations.VisibleForTesting;
import com.jcraft.jzlib.GZIPOutputStream;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.Launcher;
import hudson.Messages;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.os.PosixAPI;
import hudson.os.PosixException;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.Future;
import hudson.remoting.LocalChannel;
import hudson.remoting.Pipe;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import hudson.remoting.Which;
import hudson.security.AccessControlled;
import hudson.util.DaemonThreadFactory;
import hudson.util.DirScanner;
import hudson.util.ExceptionCatchingThreadFactory;
import hudson.util.FileVisitor;
import hudson.util.FormValidation;
import hudson.util.HeadBufferingStream;
import hudson.util.IOUtils;
import hudson.util.NamingThreadFactory;
import hudson.util.io.Archiver;
import hudson.util.io.ArchiverFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.FilePathFilter;
import jenkins.MasterToSlaveFileCallable;
import jenkins.SlaveToMasterFileCallable;
import jenkins.SoloFilePathFilter;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.ContextResettingExecutorService;
import jenkins.util.VirtualFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;

public final class FilePath
implements Serializable {
    private static final int MAX_REDIRECTS = 20;
    private transient VirtualChannel channel;
    private String remote;
    @Nullable
    private transient SoloFilePathFilter filter;
    private static final Pattern DRIVE_PATTERN = Pattern.compile("[A-Za-z]:[\\\\/].*");
    private static final Pattern UNC_PATTERN = Pattern.compile("^\\\\\\\\.*");
    private static final Pattern ABSOLUTE_PREFIX_PATTERN = Pattern.compile("^(\\\\\\\\|(?:[A-Za-z]:)?[\\\\/])[\\\\/]*");
    private static boolean CHMOD_WARNED = false;
    public static int VALIDATE_ANT_FILE_MASK_BOUND = Integer.getInteger(FilePath.class.getName() + ".VALIDATE_ANT_FILE_MASK_BOUND", 10000);
    private static final UrlFactory DEFAULT_URL_FACTORY = new UrlFactory();
    private UrlFactory urlFactory;
    private static final long serialVersionUID = 1L;
    public static int SIDE_BUFFER_SIZE = 1024;
    private static final Logger LOGGER = Logger.getLogger(FilePath.class.getName());
    private static final Comparator<String> SHORTER_STRING_FIRST = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.length() - o2.length();
        }
    };
    private static final ExecutorService threadPoolForRemoting = new ContextResettingExecutorService(Executors.newCachedThreadPool(new ExceptionCatchingThreadFactory(new NamingThreadFactory(new DaemonThreadFactory(), "FilePath.localPool"))));
    @Nonnull
    public static final LocalChannel localChannel = new LocalChannel(threadPoolForRemoting);
    private static final SoloFilePathFilter UNRESTRICTED = SoloFilePathFilter.wrap(FilePathFilter.UNRESTRICTED);

    public FilePath(@CheckForNull VirtualChannel channel, @Nonnull String remote) {
        this.channel = channel instanceof LocalChannel ? null : channel;
        this.remote = FilePath.normalize(remote);
    }

    public FilePath(@Nonnull File localPath) {
        this.channel = null;
        this.remote = FilePath.normalize(localPath.getPath());
    }

    public FilePath(@Nonnull FilePath base, @Nonnull String rel) {
        this.channel = base.channel;
        this.remote = FilePath.normalize(this.resolvePathIfRelative(base, rel));
    }

    private Object readResolve() {
        this.remote = FilePath.normalize(this.remote);
        return this;
    }

    private String resolvePathIfRelative(@Nonnull FilePath base, @Nonnull String rel) {
        if (FilePath.isAbsolute(rel)) {
            return rel;
        }
        if (base.isUnix()) {
            return base.remote + '/' + rel.replace('\\', '/');
        }
        return base.remote + '\\' + rel.replace('/', '\\');
    }

    private static boolean isAbsolute(@Nonnull String rel) {
        return rel.startsWith("/") || DRIVE_PATTERN.matcher(rel).matches() || UNC_PATTERN.matcher(rel).matches();
    }

    @Restricted(value={NoExternalUse.class})
    public static String normalize(@Nonnull String path) {
        int i;
        StringBuilder buf = new StringBuilder();
        Matcher m = ABSOLUTE_PREFIX_PATTERN.matcher(path);
        if (m.find()) {
            buf.append(m.group(1));
            path = path.substring(m.end());
        }
        boolean isAbsolute = buf.length() > 0;
        ArrayList<String> tokens = new ArrayList<String>();
        int s = 0;
        int end = path.length();
        for (i = 0; i < end; ++i) {
            char c = path.charAt(i);
            if (c != '/' && c != '\\') continue;
            tokens.add(path.substring(s, i));
            s = i;
            while (++i < end && ((c = path.charAt(i)) == '/' || c == '\\')) {
            }
            if (i < end) {
                tokens.add(path.substring(s, s + 1));
            }
            s = i;
        }
        if (s < end) {
            tokens.add(path.substring(s));
        }
        i = 0;
        while (i < tokens.size()) {
            String token = (String)tokens.get(i);
            if (token.equals(".")) {
                tokens.remove(i);
                if (tokens.size() <= 0) continue;
                tokens.remove(i > 0 ? i - 1 : i);
                continue;
            }
            if (token.equals("..")) {
                if (i == 0) {
                    tokens.remove(0);
                    if (tokens.size() > 0) {
                        token = token + (String)tokens.remove(0);
                    }
                    if (isAbsolute) continue;
                    buf.append(token);
                    continue;
                }
                i -= 2;
                for (int j = 0; j < 3; ++j) {
                    tokens.remove(i);
                }
                if (i > 0) {
                    tokens.remove(i - 1);
                    continue;
                }
                if (tokens.size() <= 0) continue;
                tokens.remove(0);
                continue;
            }
            i += 2;
        }
        for (String token : tokens) {
            buf.append(token);
        }
        if (buf.length() == 0) {
            buf.append('.');
        }
        return buf.toString();
    }

    boolean isUnix() {
        if (!this.isRemote()) {
            return File.pathSeparatorChar != ';';
        }
        if (this.remote.length() > 3 && this.remote.charAt(1) == ':' && this.remote.charAt(2) == '\\') {
            return false;
        }
        return this.remote.indexOf("\\") == -1;
    }

    public String getRemote() {
        return this.remote;
    }

    @Deprecated
    public void createZipArchive(OutputStream os) throws IOException, InterruptedException {
        this.zip(os);
    }

    public void zip(OutputStream os) throws IOException, InterruptedException {
        this.zip(os, (FileFilter)null);
    }

    public void zip(FilePath dst) throws IOException, InterruptedException {
        try (OutputStream os = dst.write();){
            this.zip(os);
        }
    }

    public void zip(OutputStream os, FileFilter filter) throws IOException, InterruptedException {
        this.archive(ArchiverFactory.ZIP, os, filter);
    }

    @Deprecated
    public void createZipArchive(OutputStream os, String glob) throws IOException, InterruptedException {
        this.archive(ArchiverFactory.ZIP, os, glob);
    }

    public void zip(OutputStream os, String glob) throws IOException, InterruptedException {
        this.archive(ArchiverFactory.ZIP, os, glob);
    }

    public int zip(OutputStream out, DirScanner scanner) throws IOException, InterruptedException {
        return this.archive(ArchiverFactory.ZIP, out, scanner);
    }

    public int archive(final ArchiverFactory factory, OutputStream os, final DirScanner scanner) throws IOException, InterruptedException {
        final OutputStream out = this.channel != null ? new RemoteOutputStream(os) : os;
        return this.act(new SecureFileCallable<Integer>(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer invoke(File f, VirtualChannel channel) throws IOException {
                try (Archiver a = factory.create(out);){
                    scanner.scan(f, FilePath.this.reading(a));
                }
                return a.countEntries();
            }
        });
    }

    public int archive(ArchiverFactory factory, OutputStream os, FileFilter filter) throws IOException, InterruptedException {
        return this.archive(factory, os, new DirScanner.Filter(filter));
    }

    public int archive(ArchiverFactory factory, OutputStream os, String glob) throws IOException, InterruptedException {
        return this.archive(factory, os, new DirScanner.Glob(glob, null));
    }

    public void unzip(FilePath target) throws IOException, InterruptedException {
        if (this.channel != target.channel) {
            final RemoteInputStream in = new RemoteInputStream(this.read(), RemoteInputStream.Flag.GREEDY);
            target.act(new SecureFileCallable<Void>(){
                private static final long serialVersionUID = 1L;

                @Override
                public Void invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
                    FilePath.this.unzip(dir, in);
                    return null;
                }
            });
        } else {
            target.act(new SecureFileCallable<Void>(){
                private static final long serialVersionUID = 1L;

                @Override
                public Void invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
                    assert (!FilePath.this.isRemote());
                    FilePath.this.unzip(dir, FilePath.this.reading(new File(FilePath.this.getRemote())));
                    return null;
                }
            });
        }
    }

    public void untar(FilePath target, final TarCompression compression) throws IOException, InterruptedException {
        if (this.channel != target.channel) {
            final RemoteInputStream in = new RemoteInputStream(this.read(), RemoteInputStream.Flag.GREEDY);
            target.act(new SecureFileCallable<Void>(){
                private static final long serialVersionUID = 1L;

                @Override
                public Void invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
                    FilePath.this.readFromTar(FilePath.this.getName(), dir, compression.extract(in));
                    return null;
                }
            });
        } else {
            target.act(new SecureFileCallable<Void>(){
                private static final long serialVersionUID = 1L;

                @Override
                public Void invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
                    FilePath.this.readFromTar(FilePath.this.getName(), dir, compression.extract(FilePath.this.read()));
                    return null;
                }
            });
        }
    }

    public void unzipFrom(InputStream _in) throws IOException, InterruptedException {
        final RemoteInputStream in = new RemoteInputStream(_in, RemoteInputStream.Flag.GREEDY);
        this.act(new SecureFileCallable<Void>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Void invoke(File dir, VirtualChannel channel) throws IOException {
                FilePath.this.unzip(dir, in);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzip(File dir, InputStream in) throws IOException {
        File tmpFile = File.createTempFile("tmpzip", null);
        try {
            IOUtils.copy(in, tmpFile);
            this.unzip(dir, tmpFile);
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzip(File dir, File zipFile) throws IOException {
        dir = dir.getAbsoluteFile();
        ZipFile zip = new ZipFile(zipFile);
        Enumeration entries = zip.getEntries();
        try {
            while (entries.hasMoreElements()) {
                ZipEntry e = (ZipEntry)entries.nextElement();
                File f = new File(dir, e.getName());
                if (!f.toPath().normalize().startsWith(dir.toPath())) {
                    throw new IOException("Zip " + zipFile.getPath() + " contains illegal file name that breaks out of the target directory: " + e.getName());
                }
                if (e.isDirectory()) {
                    this.mkdirs(f);
                    continue;
                }
                File p = f.getParentFile();
                if (p != null) {
                    this.mkdirs(p);
                }
                try (InputStream input = zip.getInputStream(e);){
                    IOUtils.copy(input, this.writing(f));
                }
                try {
                    FilePath target = new FilePath(f);
                    int mode = e.getUnixMode();
                    if (mode != 0) {
                        target.chmod(mode);
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.WARNING, "unable to set permissions", ex);
                }
                f.setLastModified(e.getTime());
            }
        }
        finally {
            zip.close();
        }
    }

    public FilePath absolutize() throws IOException, InterruptedException {
        return new FilePath(this.channel, this.act(new SecureFileCallable<String>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String invoke(File f, VirtualChannel channel) throws IOException {
                return f.getAbsolutePath();
            }
        }));
    }

    public void symlinkTo(final String target, final TaskListener listener) throws IOException, InterruptedException {
        this.act(new SecureFileCallable<Void>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                FilePath.this.symlinking(f);
                Util.createSymlink(f.getParentFile(), target, f.getName(), listener);
                return null;
            }
        });
    }

    public String readLink() throws IOException, InterruptedException {
        return this.act(new SecureFileCallable<String>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                return Util.resolveSymlink(FilePath.this.reading(f));
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePath that = (FilePath)o;
        if (this.channel != null ? !this.channel.equals(that.channel) : that.channel != null) {
            return false;
        }
        return this.remote.equals(that.remote);
    }

    public int hashCode() {
        return 31 * (this.channel != null ? this.channel.hashCode() : 0) + this.remote.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void untarFrom(InputStream _in, final TarCompression compression) throws IOException, InterruptedException {
        try {
            final RemoteInputStream in = new RemoteInputStream(_in, RemoteInputStream.Flag.GREEDY);
            this.act(new SecureFileCallable<Void>(){
                private static final long serialVersionUID = 1L;

                @Override
                public Void invoke(File dir, VirtualChannel channel) throws IOException {
                    FilePath.this.readFromTar("input stream", dir, compression.extract(in));
                    return null;
                }
            });
        }
        finally {
            _in.close();
        }
    }

    public boolean installIfNecessaryFrom(@Nonnull URL archive, @CheckForNull TaskListener listener, @Nonnull String message) throws IOException, InterruptedException {
        return this.installIfNecessaryFrom(archive, listener, message, 20);
    }

    private boolean installIfNecessaryFrom(@Nonnull URL archive, @CheckForNull TaskListener listener, @Nonnull String message, int maxRedirects) throws InterruptedException, IOException {
        try {
            long sourceTimestamp;
            URLConnection con;
            FilePath timestamp;
            block24: {
                timestamp = this.child(".timestamp");
                long lastModified = timestamp.lastModified();
                try {
                    con = ProxyConfiguration.open(archive);
                    if (lastModified != 0L) {
                        con.setIfModifiedSince(lastModified);
                    }
                    con.connect();
                }
                catch (IOException x) {
                    if (this.exists()) {
                        if (listener != null) {
                            listener.getLogger().println("Skipping installation of " + archive + " to " + this.remote + ": " + x);
                        }
                        return false;
                    }
                    throw x;
                }
                if (con instanceof HttpURLConnection) {
                    HttpURLConnection httpCon = (HttpURLConnection)con;
                    int responseCode = httpCon.getResponseCode();
                    if (responseCode == 301 || responseCode == 302) {
                        if (maxRedirects > 0) {
                            String location = httpCon.getHeaderField("Location");
                            listener.getLogger().println("Following redirect " + archive.toExternalForm() + " -> " + location);
                            return this.installIfNecessaryFrom(this.getUrlFactory().newURL(location), listener, message, maxRedirects - 1);
                        }
                        listener.getLogger().println("Skipping installation of " + archive + " to " + this.remote + " due to too many redirects.");
                        return false;
                    }
                    if (lastModified != 0L) {
                        if (responseCode == 304) {
                            return false;
                        }
                        if (responseCode != 200) {
                            listener.getLogger().println("Skipping installation of " + archive + " to " + this.remote + " due to server error: " + responseCode + " " + httpCon.getResponseMessage());
                            return false;
                        }
                    }
                }
                sourceTimestamp = con.getLastModified();
                if (this.exists()) {
                    if (lastModified != 0L && sourceTimestamp == lastModified) {
                        return false;
                    }
                    this.deleteContents();
                } else {
                    this.mkdirs();
                }
                if (listener != null) {
                    listener.getLogger().println(message);
                }
                if (this.isRemote()) {
                    try {
                        this.act(new Unpack(archive));
                        timestamp.touch(sourceTimestamp);
                        return true;
                    }
                    catch (IOException x) {
                        if (listener == null) break block24;
                        Functions.printStackTrace((Throwable)x, listener.error("Failed to download " + archive + " from agent; will retry from master"));
                    }
                }
            }
            InputStream in = archive.getProtocol().startsWith("http") ? ProxyConfiguration.getInputStream(archive) : con.getInputStream();
            CountingInputStream cis = new CountingInputStream(in);
            try {
                if (archive.toExternalForm().endsWith(".zip")) {
                    this.unzipFrom((InputStream)cis);
                } else {
                    this.untarFrom((InputStream)cis, TarCompression.GZIP);
                }
            }
            catch (IOException e) {
                throw new IOException(String.format("Failed to unpack %s (%d bytes read of total %d)", archive, cis.getByteCount(), con.getContentLength()), e);
            }
            timestamp.touch(sourceTimestamp);
            return true;
        }
        catch (IOException e) {
            throw new IOException("Failed to install " + archive + " to " + this.remote, e);
        }
    }

    public void copyFrom(URL url) throws IOException, InterruptedException {
        try (InputStream in = url.openStream();){
            this.copyFrom(in);
        }
    }

    @Restricted(value={Beta.class})
    public void copyFromRemotely(URL url) throws IOException, InterruptedException {
        this.act(new CopyFromRemotely(url));
    }

    public void copyFrom(InputStream in) throws IOException, InterruptedException {
        try (OutputStream os = this.write();){
            org.apache.commons.io.IOUtils.copy((InputStream)in, (OutputStream)os);
        }
    }

    public void copyFrom(FilePath src) throws IOException, InterruptedException {
        src.copyTo(this);
    }

    public void copyFrom(FileItem file) throws IOException, InterruptedException {
        if (this.channel == null) {
            try {
                file.write(this.writing(new File(this.remote)));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        try (InputStream i = file.getInputStream();
             OutputStream o = this.write();){
            org.apache.commons.io.IOUtils.copy((InputStream)i, (OutputStream)o);
        }
    }

    public <T> T act(FileCallable<T> callable) throws IOException, InterruptedException {
        return this.act(callable, callable.getClass().getClassLoader());
    }

    private <T> T act(FileCallable<T> callable, ClassLoader cl) throws IOException, InterruptedException {
        if (this.channel != null) {
            try {
                DelegatingCallable wrapper = new FileCallableWrapper(callable, cl);
                for (FileCallableWrapperFactory factory : ExtensionList.lookup(FileCallableWrapperFactory.class)) {
                    wrapper = factory.wrap(wrapper);
                }
                return (T)this.channel.call(wrapper);
            }
            catch (TunneledInterruptedException e) {
                throw (InterruptedException)new InterruptedException(e.getMessage()).initCause(e);
            }
        }
        return callable.invoke(new File(this.remote), localChannel);
    }

    public <T> Future<T> actAsync(FileCallable<T> callable) throws IOException, InterruptedException {
        try {
            DelegatingCallable wrapper = new FileCallableWrapper<T>(callable);
            for (FileCallableWrapperFactory factory : ExtensionList.lookup(FileCallableWrapperFactory.class)) {
                wrapper = factory.wrap(wrapper);
            }
            return (this.channel != null ? this.channel : localChannel).callAsync(wrapper);
        }
        catch (IOException e) {
            throw new IOException("remote file operation failed", e);
        }
    }

    public <V, E extends Throwable> V act(Callable<V, E> callable) throws IOException, InterruptedException, E {
        if (this.channel != null) {
            return this.channel.call(callable);
        }
        return callable.call();
    }

    public <V> Callable<V, IOException> asCallableWith(FileCallable<V> task) {
        return new CallableWith<V>(task);
    }

    public URI toURI() throws IOException, InterruptedException {
        return this.act(new SecureFileCallable<URI>(){
            private static final long serialVersionUID = 1L;

            @Override
            public URI invoke(File f, VirtualChannel channel) {
                return f.toURI();
            }
        });
    }

    public VirtualFile toVirtualFile() {
        return VirtualFile.forFilePath(this);
    }

    @CheckForNull
    public Computer toComputer() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j != null) {
            for (Computer c : j.getComputers()) {
                if (this.getChannel() != c.getChannel()) continue;
                return c;
            }
        }
        return null;
    }

    public void mkdirs() throws IOException, InterruptedException {
        if (!this.act(new Mkdirs()).booleanValue()) {
            throw new IOException("Failed to mkdirs: " + this.remote);
        }
    }

    public void deleteRecursive() throws IOException, InterruptedException {
        this.act(new DeleteRecursive());
    }

    public void deleteContents() throws IOException, InterruptedException {
        this.act(new SecureFileCallable<Void>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Void invoke(File f, VirtualChannel channel) throws IOException {
                FilePath.this.deleteContentsRecursive(f);
                return null;
            }
        });
    }

    private void deleteRecursive(File dir) throws IOException {
        if (!Util.isSymlink(dir)) {
            this.deleteContentsRecursive(dir);
        }
        try {
            Util.deleteFile(this.deleting(dir));
        }
        catch (IOException e) {
            if (!Util.isSymlink(dir)) {
                this.deleteContentsRecursive(dir);
            }
            Util.deleteFile(this.deleting(dir));
        }
    }

    private void deleteContentsRecursive(File file) throws IOException {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File child : files) {
            this.deleteRecursive(child);
        }
    }

    public String getBaseName() {
        String n = this.getName();
        int idx = n.lastIndexOf(46);
        if (idx < 0) {
            return n;
        }
        return n.substring(0, idx);
    }

    public String getName() {
        char ch;
        int len;
        String r = this.remote;
        if (r.endsWith("\\") || r.endsWith("/")) {
            r = r.substring(0, r.length() - 1);
        }
        for (len = r.length() - 1; len >= 0 && (ch = r.charAt(len)) != '\\' && ch != '/'; --len) {
        }
        return r.substring(len + 1);
    }

    public FilePath sibling(String rel) {
        return this.getParent().child(rel);
    }

    public FilePath withSuffix(String suffix) {
        return new FilePath(this.channel, this.remote + suffix);
    }

    @Nonnull
    public FilePath child(String relOrAbsolute) {
        return new FilePath(this, relOrAbsolute);
    }

    public FilePath getParent() {
        char ch;
        int i;
        for (i = this.remote.length() - 2; i >= 0 && (ch = this.remote.charAt(i)) != '\\' && ch != '/'; --i) {
        }
        return i >= 0 ? new FilePath(this.channel, this.remote.substring(0, i + 1)) : null;
    }

    public FilePath createTempFile(final String prefix, final String suffix) throws IOException, InterruptedException {
        try {
            return new FilePath(this, this.act(new SecureFileCallable<String>(){
                private static final long serialVersionUID = 1L;

                @Override
                public String invoke(File dir, VirtualChannel channel) throws IOException {
                    File f = FilePath.this.writing(File.createTempFile(prefix, suffix, dir));
                    return f.getName();
                }
            }));
        }
        catch (IOException e) {
            throw new IOException("Failed to create a temp file on " + this.remote, e);
        }
    }

    public FilePath createTextTempFile(String prefix, String suffix, String contents) throws IOException, InterruptedException {
        return this.createTextTempFile(prefix, suffix, contents, true);
    }

    public FilePath createTextTempFile(String prefix, String suffix, String contents, boolean inThisDirectory) throws IOException, InterruptedException {
        try {
            return new FilePath(this.channel, this.act(new CreateTextTempFile(inThisDirectory, prefix, suffix, contents)));
        }
        catch (IOException e) {
            throw new IOException("Failed to create a temp file on " + this.remote, e);
        }
    }

    public FilePath createTempDir(String prefix, String suffix) throws IOException, InterruptedException {
        try {
            Object[] s = StringUtils.isBlank((String)suffix) ? new String[]{prefix, "tmp"} : new String[]{prefix, suffix};
            final String name = StringUtils.join((Object[])s, (String)".");
            return new FilePath(this, this.act(new SecureFileCallable<String>(){
                private static final long serialVersionUID = 1L;

                @Override
                public String invoke(File dir, VirtualChannel channel) throws IOException {
                    boolean isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
                    Path tempPath = isPosix ? Files.createTempDirectory(Util.fileToPath(dir), name, PosixFilePermissions.asFileAttribute(EnumSet.allOf(PosixFilePermission.class))) : Files.createTempDirectory(Util.fileToPath(dir), name, new FileAttribute[0]);
                    if (tempPath.toFile() == null) {
                        throw new IOException("Failed to obtain file from path " + dir + " on " + FilePath.this.remote);
                    }
                    return tempPath.toFile().getName();
                }
            }));
        }
        catch (IOException e) {
            throw new IOException("Failed to create a temp directory on " + this.remote, e);
        }
    }

    public boolean delete() throws IOException, InterruptedException {
        this.act(new Delete());
        return true;
    }

    public boolean exists() throws IOException, InterruptedException {
        return this.act(new Exists());
    }

    public long lastModified() throws IOException, InterruptedException {
        return this.act(new LastModified());
    }

    public void touch(final long timestamp) throws IOException, InterruptedException {
        this.act(new SecureFileCallable<Void>(){
            private static final long serialVersionUID = -5094638816500738429L;

            @Override
            public Void invoke(File f, VirtualChannel channel) throws IOException {
                if (!f.exists()) {
                    try {
                        Files.newOutputStream(FilePath.this.creating(f).toPath(), new OpenOption[0]).close();
                    }
                    catch (InvalidPathException e) {
                        throw new IOException(e);
                    }
                }
                if (!FilePath.this.stating(f).setLastModified(timestamp)) {
                    throw new IOException("Failed to set the timestamp of " + f + " to " + timestamp);
                }
                return null;
            }
        });
    }

    private void setLastModifiedIfPossible(final long timestamp) throws IOException, InterruptedException {
        String message = this.act(new SecureFileCallable<String>(){
            private static final long serialVersionUID = -828220335793641630L;

            @Override
            public String invoke(File f, VirtualChannel channel) throws IOException {
                if (!FilePath.this.writing(f).setLastModified(timestamp)) {
                    if (Functions.isWindows()) {
                        return "Failed to set the timestamp of " + f + " to " + timestamp;
                    }
                    throw new IOException("Failed to set the timestamp of " + f + " to " + timestamp);
                }
                return null;
            }
        });
        if (message != null) {
            LOGGER.warning(message);
        }
    }

    public boolean isDirectory() throws IOException, InterruptedException {
        return this.act(new IsDirectory());
    }

    public long length() throws IOException, InterruptedException {
        return this.act(new SecureFileCallable<Long>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Long invoke(File f, VirtualChannel channel) throws IOException {
                return FilePath.this.stating(f).length();
            }
        });
    }

    public long getFreeDiskSpace() throws IOException, InterruptedException {
        return this.act(new SecureFileCallable<Long>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Long invoke(File f, VirtualChannel channel) throws IOException {
                return f.getFreeSpace();
            }
        });
    }

    public long getTotalDiskSpace() throws IOException, InterruptedException {
        return this.act(new SecureFileCallable<Long>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Long invoke(File f, VirtualChannel channel) throws IOException {
                return f.getTotalSpace();
            }
        });
    }

    public long getUsableDiskSpace() throws IOException, InterruptedException {
        return this.act(new SecureFileCallable<Long>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Long invoke(File f, VirtualChannel channel) throws IOException {
                return f.getUsableSpace();
            }
        });
    }

    public void chmod(int mask) throws IOException, InterruptedException {
        if (!this.isUnix() || mask == -1) {
            return;
        }
        this.act(new Chmod(mask));
    }

    private static void _chmod(File f, int mask) throws IOException {
        if (File.pathSeparatorChar == ';') {
            return;
        }
        if (Util.NATIVE_CHMOD_MODE) {
            PosixAPI.jnr().chmod(f.getAbsolutePath(), mask);
        } else {
            Files.setPosixFilePermissions(Util.fileToPath(f), Util.modeToPermissions(mask));
        }
    }

    public int mode() throws IOException, InterruptedException, PosixException {
        if (!this.isUnix()) {
            return -1;
        }
        return this.act(new SecureFileCallable<Integer>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Integer invoke(File f, VirtualChannel channel) throws IOException {
                return IOUtils.mode(FilePath.this.stating(f));
            }
        });
    }

    @Nonnull
    public List<FilePath> list() throws IOException, InterruptedException {
        return this.list((FileFilter)null);
    }

    @Nonnull
    public List<FilePath> listDirectories() throws IOException, InterruptedException {
        return this.list(new DirectoryFilter());
    }

    @Nonnull
    public List<FilePath> list(final FileFilter filter) throws IOException, InterruptedException {
        if (filter != null && !(filter instanceof Serializable)) {
            throw new IllegalArgumentException("Non-serializable filter of " + filter.getClass());
        }
        return this.act(new SecureFileCallable<List<FilePath>>(){
            private static final long serialVersionUID = 1L;

            @Override
            public List<FilePath> invoke(File f, VirtualChannel channel) throws IOException {
                File[] children = FilePath.this.reading(f).listFiles(filter);
                if (children == null) {
                    return Collections.emptyList();
                }
                ArrayList<FilePath> r = new ArrayList<FilePath>(children.length);
                for (File child : children) {
                    r.add(new FilePath(child));
                }
                return r;
            }
        }, (filter != null ? filter : this).getClass().getClassLoader());
    }

    @Nonnull
    public FilePath[] list(String includes) throws IOException, InterruptedException {
        return this.list(includes, null);
    }

    @Nonnull
    public FilePath[] list(String includes, String excludes) throws IOException, InterruptedException {
        return this.list(includes, excludes, true);
    }

    @Nonnull
    public FilePath[] list(final String includes, final String excludes, final boolean defaultExcludes) throws IOException, InterruptedException {
        return this.act(new SecureFileCallable<FilePath[]>(){
            private static final long serialVersionUID = 1L;

            @Override
            public FilePath[] invoke(File f, VirtualChannel channel) throws IOException {
                String[] files = FilePath.glob(FilePath.this.reading(f), includes, excludes, defaultExcludes);
                FilePath[] r = new FilePath[files.length];
                for (int i = 0; i < r.length; ++i) {
                    r[i] = new FilePath(new File(f, files[i]));
                }
                return r;
            }
        });
    }

    @Nonnull
    private static String[] glob(File dir, String includes, String excludes, boolean defaultExcludes) throws IOException {
        DirectoryScanner ds;
        if (FilePath.isAbsolute(includes)) {
            throw new IOException("Expecting Ant GLOB pattern, but saw '" + includes + "'. See http://ant.apache.org/manual/Types/fileset.html for syntax");
        }
        FileSet fs = Util.createFileSet(dir, includes, excludes);
        fs.setDefaultexcludes(defaultExcludes);
        try {
            ds = fs.getDirectoryScanner(new Project());
        }
        catch (BuildException x) {
            throw new IOException(x.getMessage());
        }
        String[] files = ds.getIncludedFiles();
        return files;
    }

    public InputStream read() throws IOException, InterruptedException {
        if (this.channel == null) {
            try {
                return Files.newInputStream(this.reading(new File(this.remote)).toPath(), new OpenOption[0]);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
        }
        Pipe p = Pipe.createRemoteToLocal();
        this.actAsync(new Read(p));
        return p.getIn();
    }

    public InputStream readFromOffset(final long offset) throws IOException, InterruptedException {
        if (this.channel == null) {
            final RandomAccessFile raf = new RandomAccessFile(new File(this.remote), "r");
            try {
                raf.seek(offset);
            }
            catch (IOException e) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return raf.read();
                }

                @Override
                public void close() throws IOException {
                    raf.close();
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return raf.read(b, off, len);
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return raf.read(b);
                }
            };
        }
        final Pipe p = Pipe.createRemoteToLocal();
        this.actAsync(new SecureFileCallable<Void>(){
            private static final long serialVersionUID = 1L;

            /*
             * Exception decompiling
             */
            @Override
            public Void invoke(File f, VirtualChannel channel) throws IOException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        return new GZIPInputStream(p.getIn());
    }

    public String readToString() throws IOException, InterruptedException {
        try (InputStream in = this.read();){
            String string = org.apache.commons.io.IOUtils.toString((InputStream)in);
            return string;
        }
    }

    public OutputStream write() throws IOException, InterruptedException {
        if (this.channel == null) {
            File f = new File(this.remote).getAbsoluteFile();
            this.mkdirs(f.getParentFile());
            try {
                return Files.newOutputStream(this.writing(f).toPath(), new OpenOption[0]);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
        }
        return this.act(new SecureFileCallable<OutputStream>(){
            private static final long serialVersionUID = 1L;

            @Override
            public OutputStream invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                f = f.getAbsoluteFile();
                FilePath.this.mkdirs(f.getParentFile());
                try {
                    OutputStream fos = Files.newOutputStream(FilePath.this.writing(f).toPath(), new OpenOption[0]);
                    return new RemoteOutputStream(fos);
                }
                catch (InvalidPathException e) {
                    throw new IOException(e);
                }
            }
        });
    }

    public void write(String content, String encoding) throws IOException, InterruptedException {
        this.act(new Write(encoding, content));
    }

    public String digest() throws IOException, InterruptedException {
        return this.act(new SecureFileCallable<String>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String invoke(File f, VirtualChannel channel) throws IOException {
                return Util.getDigestOf(FilePath.this.reading(f));
            }
        });
    }

    public void renameTo(final FilePath target) throws IOException, InterruptedException {
        if (this.channel != target.channel) {
            throw new IOException("renameTo target must be on the same host");
        }
        this.act(new SecureFileCallable<Void>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Void invoke(File f, VirtualChannel channel) throws IOException {
                Files.move(Util.fileToPath(FilePath.this.reading(f)), Util.fileToPath(FilePath.this.creating(new File(target.remote))), LinkOption.NOFOLLOW_LINKS);
                return null;
            }
        });
    }

    public void moveAllChildrenTo(final FilePath target) throws IOException, InterruptedException {
        if (this.channel != target.channel) {
            throw new IOException("pullUpTo target must be on the same host");
        }
        this.act(new SecureFileCallable<Void>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Void invoke(File f, VirtualChannel channel) throws IOException {
                File tmp = new File(f.getAbsolutePath() + ".__rename");
                if (!f.renameTo(tmp)) {
                    throw new IOException("Failed to rename " + f + " to " + tmp);
                }
                File t = new File(target.getRemote());
                for (File child : FilePath.this.reading(tmp).listFiles()) {
                    File target2 = new File(t, child.getName());
                    if (FilePath.this.stating(child).renameTo(FilePath.this.creating(target2))) continue;
                    throw new IOException("Failed to rename " + child + " to " + target2);
                }
                FilePath.this.deleting(tmp).delete();
                return null;
            }
        });
    }

    public void copyTo(FilePath target) throws IOException, InterruptedException {
        try (OutputStream out = target.write();){
            this.copyTo(out);
        }
        catch (IOException e) {
            throw new IOException("Failed to copy " + this + " to " + target, e);
        }
    }

    public void copyToWithPermission(final FilePath target) throws IOException, InterruptedException {
        if (this.channel == target.channel) {
            this.act(new SecureFileCallable<Void>(){

                @Override
                public Void invoke(File f, VirtualChannel channel) throws IOException {
                    File targetFile = new File(target.remote);
                    File targetDir = targetFile.getParentFile();
                    FilePath.this.filterNonNull().mkdirs(targetDir);
                    Files.createDirectories(Util.fileToPath(targetDir), new FileAttribute[0]);
                    Files.copy(Util.fileToPath(FilePath.this.reading(f)), Util.fileToPath(FilePath.this.writing(targetFile)), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    return null;
                }
            });
            return;
        }
        this.copyTo(target);
        target.chmod(this.mode());
        target.setLastModifiedIfPossible(this.lastModified());
    }

    public void copyTo(OutputStream os) throws IOException, InterruptedException {
        RemoteOutputStream out = new RemoteOutputStream(os);
        this.act(new CopyTo(out));
        this.syncIO();
    }

    private void syncIO() throws InterruptedException {
        try {
            if (this.channel != null) {
                this.channel.syncLocalIO();
            }
        }
        catch (AbstractMethodError e) {
            try {
                LOGGER.log(Level.WARNING, "Looks like an old agent.jar. Please update " + Which.jarFile(Channel.class) + " to the new version", e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void _syncIO() throws InterruptedException {
        this.channel.syncLocalIO();
    }

    public int copyRecursiveTo(FilePath target) throws IOException, InterruptedException {
        return this.copyRecursiveTo("**/*", target);
    }

    public int copyRecursiveTo(String fileMask, FilePath target) throws IOException, InterruptedException {
        return this.copyRecursiveTo(fileMask, null, target);
    }

    public int copyRecursiveTo(String fileMask, String excludes, FilePath target) throws IOException, InterruptedException {
        return this.copyRecursiveTo(new DirScanner.Glob(fileMask, excludes), target, fileMask);
    }

    public int copyRecursiveTo(final DirScanner scanner, final FilePath target, final String description) throws IOException, InterruptedException {
        if (this.channel == target.channel) {
            return this.act(new SecureFileCallable<Integer>(){
                private static final long serialVersionUID = 1L;

                @Override
                public Integer invoke(File base, VirtualChannel channel) throws IOException {
                    if (!base.exists()) {
                        return 0;
                    }
                    assert (target.channel == null);
                    final File dest = new File(target.remote);
                    final AtomicInteger count = new AtomicInteger();
                    scanner.scan(base, FilePath.this.reading(new FileVisitor(){

                        @Override
                        public void visit(File f, String relativePath) throws IOException {
                            if (f.isFile()) {
                                File target = new File(dest, relativePath);
                                FilePath.this.mkdirsE(target.getParentFile());
                                Files.copy(Util.fileToPath(f), Util.fileToPath(FilePath.this.writing(target)), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                                count.incrementAndGet();
                            }
                        }

                        @Override
                        public boolean understandsSymlink() {
                            return true;
                        }

                        @Override
                        public void visitSymlink(File link, String target, String relativePath) throws IOException {
                            try {
                                FilePath.this.mkdirsE(new File(dest, relativePath).getParentFile());
                                FilePath.this.writing(new File(dest, target));
                                Util.createSymlink(dest, target, relativePath, TaskListener.NULL);
                            }
                            catch (InterruptedException x) {
                                throw new IOException(x);
                            }
                            count.incrementAndGet();
                        }
                    }));
                    return count.get();
                }
            });
        }
        if (this.channel == null) {
            final Pipe pipe = Pipe.createLocalToRemote();
            Future<Void> future = target.actAsync(new SecureFileCallable<Void>(){
                private static final long serialVersionUID = 1L;

                @Override
                public Void invoke(File f, VirtualChannel channel) throws IOException {
                    try (InputStream in = pipe.getIn();){
                        FilePath.this.readFromTar(FilePath.this.remote + '/' + description, f, TarCompression.GZIP.extract(in));
                        Void void_ = null;
                        return void_;
                    }
                }
            });
            Future<Integer> future2 = this.actAsync(new SecureFileCallable<Integer>(){
                private static final long serialVersionUID = 1L;

                @Override
                public Integer invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                    return FilePath.this.writeToTar(new File(FilePath.this.remote), scanner, TarCompression.GZIP.compress(pipe.getOut()));
                }
            });
            try {
                future.get();
                return (Integer)future2.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                throw cause instanceof IOException ? (IOException)cause : new IOException(cause);
            }
        }
        Pipe pipe = Pipe.createRemoteToLocal();
        Future<Integer> future = this.actAsync(new CopyRecursiveRemoteToLocal(pipe, scanner));
        try {
            this.readFromTar(this.remote + '/' + description, new File(target.remote), TarCompression.GZIP.extract(pipe.getIn()));
        }
        catch (IOException e) {
            try {
                future.get(3L, TimeUnit.SECONDS);
                throw e;
            }
            catch (ExecutionException x) {
                e.addSuppressed(x);
                throw e;
            }
            catch (TimeoutException _) {
                throw e;
            }
        }
        try {
            return (Integer)future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw cause instanceof IOException ? (IOException)cause : new IOException(cause);
        }
    }

    public int tar(OutputStream out, String glob) throws IOException, InterruptedException {
        return this.archive(ArchiverFactory.TAR, out, glob);
    }

    public int tar(OutputStream out, FileFilter filter) throws IOException, InterruptedException {
        return this.archive(ArchiverFactory.TAR, out, filter);
    }

    public int tar(OutputStream out, DirScanner scanner) throws IOException, InterruptedException {
        return this.archive(ArchiverFactory.TAR, out, scanner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer writeToTar(File baseDir, DirScanner scanner, OutputStream out) throws IOException {
        try (Archiver tw = ArchiverFactory.TAR.create(out);){
            scanner.scan(baseDir, this.reading(tw));
        }
        return tw.countEntries();
    }

    private void readFromTar(String name, File baseDir, InputStream in) throws IOException {
        try (TarArchiveInputStream t = new TarArchiveInputStream(in);){
            TarArchiveEntry te;
            while ((te = t.getNextTarEntry()) != null) {
                File f = new File(baseDir, te.getName());
                if (te.isDirectory()) {
                    this.mkdirs(f);
                    continue;
                }
                File parent = f.getParentFile();
                if (parent != null) {
                    this.mkdirs(parent);
                }
                this.writing(f);
                if (te.isSymbolicLink()) {
                    new FilePath(f).symlinkTo(te.getLinkName(), TaskListener.NULL);
                    continue;
                }
                IOUtils.copy((InputStream)t, f);
                f.setLastModified(te.getModTime().getTime());
                int mode = te.getMode() & 0x1FF;
                if (mode == 0 || Functions.isWindows()) continue;
                FilePath._chmod(f, mode);
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to extract " + name, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Failed to extract " + name, e);
        }
    }

    public Launcher createLauncher(TaskListener listener) throws IOException, InterruptedException {
        if (this.channel == null) {
            return new Launcher.LocalLauncher(listener);
        }
        return new Launcher.RemoteLauncher(listener, this.channel, this.channel.call(new IsUnix()));
    }

    @Deprecated
    public String validateAntFileMask(String fileMasks) throws IOException, InterruptedException {
        return this.validateAntFileMask(fileMasks, Integer.MAX_VALUE);
    }

    public String validateAntFileMask(String fileMasks, int bound) throws IOException, InterruptedException {
        return this.validateAntFileMask(fileMasks, bound, true);
    }

    @CheckForNull
    public String validateAntFileMask(final String fileMasks, final int bound, final boolean caseSensitive) throws IOException, InterruptedException {
        return this.act(new MasterToSlaveFileCallable<String>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
                if (fileMasks.startsWith("~")) {
                    return Messages.FilePath_TildaDoesntWork();
                }
                StringTokenizer tokens = new StringTokenizer(fileMasks, ",");
                while (tokens.hasMoreTokens()) {
                    int idx;
                    String fileMask = tokens.nextToken().trim();
                    if (this.hasMatch(dir, fileMask, caseSensitive)) continue;
                    if (caseSensitive && this.hasMatch(dir, fileMask, false)) {
                        return Messages.FilePath_validateAntFileMask_matchWithCaseInsensitive(fileMask);
                    }
                    if (fileMask.contains(" ")) {
                        boolean matched = true;
                        for (String token : Util.tokenize(fileMask)) {
                            matched &= this.hasMatch(dir, token, caseSensitive);
                        }
                        if (matched) {
                            return Messages.FilePath_validateAntFileMask_whitespaceSeparator();
                        }
                    }
                    String f = fileMask;
                    while ((idx = this.findSeparator(f)) != -1) {
                        if (!this.hasMatch(dir, f = f.substring(idx + 1), caseSensitive)) continue;
                        return Messages.FilePath_validateAntFileMask_doesntMatchAndSuggest(fileMask, f);
                    }
                    FileSet fs = Util.createFileSet(FilePath.this.reading(dir), "**/" + fileMask);
                    fs.setCaseSensitive(caseSensitive);
                    DirectoryScanner ds = fs.getDirectoryScanner(new Project());
                    if (ds.getIncludedFilesCount() != 0) {
                        String[] names = ds.getIncludedFiles();
                        Arrays.sort(names, SHORTER_STRING_FIRST);
                        for (String f2 : names) {
                            int idx2;
                            String prefix = "";
                            while ((idx2 = this.findSeparator(f2)) != -1) {
                                prefix = prefix + f2.substring(0, idx2) + '/';
                                f2 = f2.substring(idx2 + 1);
                                if (!this.hasMatch(dir, prefix + fileMask, caseSensitive)) continue;
                                return Messages.FilePath_validateAntFileMask_doesntMatchAndSuggest(fileMask, prefix + fileMask);
                            }
                        }
                    }
                    String previous = null;
                    String pattern = fileMask;
                    while (true) {
                        if (this.hasMatch(dir, pattern, caseSensitive)) {
                            if (previous == null) {
                                return Messages.FilePath_validateAntFileMask_portionMatchAndSuggest(fileMask, pattern);
                            }
                            return Messages.FilePath_validateAntFileMask_portionMatchButPreviousNotMatchAndSuggest(fileMask, pattern, previous);
                        }
                        int idx3 = this.findSeparator(pattern);
                        if (idx3 < 0) {
                            if (pattern.equals(fileMask)) {
                                return Messages.FilePath_validateAntFileMask_doesntMatchAnything(fileMask);
                            }
                            return Messages.FilePath_validateAntFileMask_doesntMatchAnythingAndSuggest(fileMask, pattern);
                        }
                        previous = pattern;
                        pattern = pattern.substring(0, idx3);
                    }
                }
                return null;
            }

            private boolean hasMatch(File dir, String pattern, boolean bCaseSensitive) throws InterruptedException {
                class Cancel
                extends RuntimeException {
                    Cancel() {
                    }
                }
                DirectoryScanner ds = bound == Integer.MAX_VALUE ? new DirectoryScanner() : new DirectoryScanner(){
                    int ticks;
                    long start = System.currentTimeMillis();

                    public synchronized boolean isCaseSensitive() {
                        if (!this.filesIncluded.isEmpty() || !this.dirsIncluded.isEmpty() || this.ticks++ > bound || System.currentTimeMillis() - this.start > 5000L) {
                            throw new Cancel();
                        }
                        this.filesNotIncluded.clear();
                        this.dirsNotIncluded.clear();
                        return super.isCaseSensitive();
                    }
                };
                ds.setBasedir(FilePath.this.reading(dir));
                ds.setIncludes(new String[]{pattern});
                ds.setCaseSensitive(bCaseSensitive);
                try {
                    ds.scan();
                }
                catch (Cancel c) {
                    if (ds.getIncludedFilesCount() != 0 || ds.getIncludedDirsCount() != 0) {
                        return true;
                    }
                    throw new InterruptedException("no matches found within " + bound);
                }
                return ds.getIncludedFilesCount() != 0 || ds.getIncludedDirsCount() != 0;
            }

            private int findSeparator(String pattern) {
                int idx1 = pattern.indexOf(92);
                int idx2 = pattern.indexOf(47);
                if (idx1 == -1) {
                    return idx2;
                }
                if (idx2 == -1) {
                    return idx1;
                }
                return Math.min(idx1, idx2);
            }
        });
    }

    @Restricted(value={NoExternalUse.class})
    @VisibleForTesting
    void setUrlFactory(UrlFactory urlFactory) {
        this.urlFactory = urlFactory;
    }

    private UrlFactory getUrlFactory() {
        if (this.urlFactory != null) {
            return this.urlFactory;
        }
        return DEFAULT_URL_FACTORY;
    }

    public static FormValidation validateFileMask(@CheckForNull FilePath path, String value) throws IOException {
        return FilePath.validateFileMask(path, value, true);
    }

    public static FormValidation validateFileMask(@CheckForNull FilePath path, String value, boolean caseSensitive) throws IOException {
        if (path == null) {
            return FormValidation.ok();
        }
        return path.validateFileMask(value, true, caseSensitive);
    }

    public FormValidation validateFileMask(String value) throws IOException {
        return this.validateFileMask(value, true, true);
    }

    public FormValidation validateFileMask(String value, boolean errorIfNotExist) throws IOException {
        return this.validateFileMask(value, errorIfNotExist, true);
    }

    public FormValidation validateFileMask(String value, boolean errorIfNotExist, boolean caseSensitive) throws IOException {
        FilePath.checkPermissionForValidate();
        value = Util.fixEmpty(value);
        if (value == null) {
            return FormValidation.ok();
        }
        try {
            if (!this.exists()) {
                return FormValidation.ok();
            }
            String msg = this.validateAntFileMask(value, VALIDATE_ANT_FILE_MASK_BOUND, caseSensitive);
            if (errorIfNotExist) {
                return FormValidation.error(msg);
            }
            return FormValidation.warning(msg);
        }
        catch (InterruptedException e) {
            return FormValidation.ok(Messages.FilePath_did_not_manage_to_validate_may_be_too_sl(value));
        }
    }

    public FormValidation validateRelativePath(String value, boolean errorIfNotExist, boolean expectingFile) throws IOException {
        FilePath.checkPermissionForValidate();
        value = Util.fixEmpty(value);
        if (value == null) {
            return FormValidation.ok();
        }
        if (value.contains("*")) {
            return FormValidation.error(Messages.FilePath_validateRelativePath_wildcardNotAllowed());
        }
        try {
            String msg;
            if (!this.exists()) {
                return FormValidation.ok();
            }
            FilePath path = this.child(value);
            if (path.exists()) {
                if (expectingFile) {
                    if (!path.isDirectory()) {
                        return FormValidation.ok();
                    }
                    return FormValidation.error(Messages.FilePath_validateRelativePath_notFile(value));
                }
                if (path.isDirectory()) {
                    return FormValidation.ok();
                }
                return FormValidation.error(Messages.FilePath_validateRelativePath_notDirectory(value));
            }
            String string = msg = expectingFile ? Messages.FilePath_validateRelativePath_noSuchFile(value) : Messages.FilePath_validateRelativePath_noSuchDirectory(value);
            if (errorIfNotExist) {
                return FormValidation.error(msg);
            }
            return FormValidation.warning(msg);
        }
        catch (InterruptedException e) {
            return FormValidation.ok();
        }
    }

    private static void checkPermissionForValidate() {
        AccessControlled subject = (AccessControlled)Stapler.getCurrentRequest().findAncestorObject(AbstractProject.class);
        if (subject == null) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        } else {
            subject.checkPermission(Item.CONFIGURE);
        }
    }

    public FormValidation validateRelativeDirectory(String value, boolean errorIfNotExist) throws IOException {
        return this.validateRelativePath(value, errorIfNotExist, false);
    }

    public FormValidation validateRelativeDirectory(String value) throws IOException {
        return this.validateRelativeDirectory(value, true);
    }

    @Deprecated
    public String toString() {
        return this.remote;
    }

    public VirtualChannel getChannel() {
        if (this.channel != null) {
            return this.channel;
        }
        return localChannel;
    }

    public boolean isRemote() {
        return this.channel != null;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Channel target = Channel.current();
        if (this.channel != null && this.channel != target) {
            throw new IllegalStateException("Can't send a remote FilePath to a different remote channel");
        }
        oos.defaultWriteObject();
        oos.writeBoolean(this.channel == null);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Channel channel = Channel.current();
        assert (channel != null);
        ois.defaultReadObject();
        if (ois.readBoolean()) {
            this.channel = channel;
            this.filter = null;
        } else {
            this.channel = null;
            this.filter = SoloFilePathFilter.wrap(FilePathFilter.current());
        }
    }

    public static FilePath getHomeDirectory(VirtualChannel ch) throws InterruptedException, IOException {
        return ch.call(new MasterToSlaveCallable<FilePath, IOException>(){

            @Override
            public FilePath call() throws IOException {
                return new FilePath(new File(System.getProperty("user.home")));
            }
        });
    }

    @Nonnull
    private SoloFilePathFilter filterNonNull() {
        return this.filter != null ? this.filter : UNRESTRICTED;
    }

    private FileVisitor reading(final FileVisitor v) {
        final FilePathFilter filter = FilePathFilter.current();
        if (filter == null) {
            return v;
        }
        return new FileVisitor(){

            @Override
            public void visit(File f, String relativePath) throws IOException {
                filter.read(f);
                v.visit(f, relativePath);
            }

            @Override
            public void visitSymlink(File link, String target, String relativePath) throws IOException {
                filter.read(link);
                v.visitSymlink(link, target, relativePath);
            }

            @Override
            public boolean understandsSymlink() {
                return v.understandsSymlink();
            }
        };
    }

    private File reading(File f) {
        this.filterNonNull().read(f);
        return f;
    }

    private File stating(File f) {
        this.filterNonNull().stat(f);
        return f;
    }

    private File creating(File f) {
        this.filterNonNull().create(f);
        return f;
    }

    private File writing(File f) {
        SoloFilePathFilter filter = this.filterNonNull();
        if (!f.exists()) {
            ((FilePathFilter)filter).create(f);
        }
        ((FilePathFilter)filter).write(f);
        return f;
    }

    private File symlinking(File f) {
        SoloFilePathFilter filter = this.filterNonNull();
        if (!f.exists()) {
            ((FilePathFilter)filter).create(f);
        }
        ((FilePathFilter)filter).symlink(f);
        return f;
    }

    private File deleting(File f) {
        this.filterNonNull().delete(f);
        return f;
    }

    private boolean mkdirs(File dir) throws IOException {
        if (dir.exists()) {
            return false;
        }
        this.filterNonNull().mkdirs(dir);
        Files.createDirectories(Util.fileToPath(dir), new FileAttribute[0]);
        return true;
    }

    private File mkdirsE(File dir) throws IOException {
        if (dir.exists()) {
            return dir;
        }
        this.filterNonNull().mkdirs(dir);
        return IOUtils.mkdirs(dir);
    }

    public static final class ExplicitlySpecifiedDirScanner
    extends DirScanner {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> files;

        public ExplicitlySpecifiedDirScanner(Map<String, String> files) {
            this.files = files;
        }

        @Override
        public void scan(File dir, FileVisitor visitor) throws IOException {
            for (Map.Entry<String, String> entry : this.files.entrySet()) {
                String archivedPath = entry.getKey();
                assert (archivedPath.indexOf(92) == -1);
                String workspacePath = entry.getValue();
                assert (workspacePath.indexOf(92) == -1);
                this.scanSingle(new File(dir, workspacePath), archivedPath, visitor);
            }
        }
    }

    private static class TunneledInterruptedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        private TunneledInterruptedException(InterruptedException cause) {
            super(cause);
        }
    }

    private class FileCallableWrapper<T>
    implements DelegatingCallable<T, IOException> {
        private final FileCallable<T> callable;
        private transient ClassLoader classLoader;
        private static final long serialVersionUID = 1L;

        public FileCallableWrapper(FileCallable<T> callable) {
            this.callable = callable;
            this.classLoader = callable.getClass().getClassLoader();
        }

        private FileCallableWrapper(FileCallable<T> callable, ClassLoader classLoader) {
            this.callable = callable;
            this.classLoader = classLoader;
        }

        @Override
        public T call() throws IOException {
            try {
                return this.callable.invoke(new File(FilePath.this.remote), Channel.current());
            }
            catch (InterruptedException e) {
                throw new TunneledInterruptedException(e);
            }
        }

        @Override
        public void checkRoles(RoleChecker checker) throws SecurityException {
            this.callable.checkRoles(checker);
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public String toString() {
            return this.callable.toString();
        }
    }

    @Restricted(value={NoExternalUse.class})
    static class UrlFactory {
        UrlFactory() {
        }

        public URL newURL(String location) throws MalformedURLException {
            return new URL(location);
        }
    }

    private static final class IsUnix
    extends MasterToSlaveCallable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;

        private IsUnix() {
        }

        @Override
        @Nonnull
        public Boolean call() throws IOException {
            return File.pathSeparatorChar == ':';
        }
    }

    private class CopyRecursiveRemoteToLocal
    extends SecureFileCallable<Integer> {
        private static final long serialVersionUID = 1L;
        private final Pipe pipe;
        private final DirScanner scanner;

        CopyRecursiveRemoteToLocal(Pipe pipe, DirScanner scanner) {
            this.pipe = pipe;
            this.scanner = scanner;
        }

        @Override
        public Integer invoke(File f, VirtualChannel channel) throws IOException {
            try (OutputStream out = this.pipe.getOut();){
                Integer n = FilePath.this.writeToTar(f, this.scanner, TarCompression.GZIP.compress(out));
                return n;
            }
        }
    }

    static interface RemoteCopier {
        public void open(String var1) throws IOException;

        public void write(byte[] var1, int var2) throws IOException;

        public void close() throws IOException;
    }

    private class CopyTo
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 4088559042349254141L;
        private final OutputStream out;

        CopyTo(OutputStream out) {
            this.out = out;
        }

        /*
         * Exception decompiling
         */
        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class Write
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final String encoding;
        private final String content;

        Write(String encoding, String content) {
            this.encoding = encoding;
            this.content = content;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            FilePath.this.mkdirs(f.getParentFile());
            try (OutputStream fos = Files.newOutputStream(FilePath.this.writing(f).toPath(), new OpenOption[0]);
                 OutputStreamWriter w = this.encoding != null ? new OutputStreamWriter(fos, this.encoding) : new OutputStreamWriter(fos);){
                w.write(this.content);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            return null;
        }
    }

    private class Read
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final Pipe p;

        Read(Pipe p) {
            this.p = p;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            try (InputStream fis = Files.newInputStream(FilePath.this.reading(f).toPath(), new OpenOption[0]);
                 OutputStream out = this.p.getOut();){
                org.apache.commons.io.IOUtils.copy((InputStream)fis, (OutputStream)out);
            }
            catch (InvalidPathException e) {
                this.p.error(new IOException(e));
            }
            catch (Exception x) {
                this.p.error(x);
            }
            return null;
        }
    }

    private static final class DirectoryFilter
    implements FileFilter,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DirectoryFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }
    }

    private class Chmod
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final int mask;

        Chmod(int mask) {
            this.mask = mask;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            FilePath._chmod(FilePath.this.writing(f), this.mask);
            return null;
        }
    }

    private final class IsDirectory
    extends SecureFileCallable<Boolean> {
        private static final long serialVersionUID = 1L;

        private IsDirectory() {
        }

        @Override
        public Boolean invoke(File f, VirtualChannel channel) throws IOException {
            return FilePath.this.stating(f).isDirectory();
        }
    }

    private class LastModified
    extends SecureFileCallable<Long> {
        private static final long serialVersionUID = 1L;

        private LastModified() {
        }

        @Override
        public Long invoke(File f, VirtualChannel channel) throws IOException {
            return FilePath.this.stating(f).lastModified();
        }
    }

    private class Exists
    extends SecureFileCallable<Boolean> {
        private static final long serialVersionUID = 1L;

        private Exists() {
        }

        @Override
        public Boolean invoke(File f, VirtualChannel channel) throws IOException {
            return FilePath.this.stating(f).exists();
        }
    }

    private class Delete
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 1L;

        private Delete() {
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            Util.deleteFile(FilePath.this.deleting(f));
            return null;
        }
    }

    private final class CreateTextTempFile
    extends SecureFileCallable<String> {
        private static final long serialVersionUID = 1L;
        private final boolean inThisDirectory;
        private final String prefix;
        private final String suffix;
        private final String contents;

        CreateTextTempFile(boolean inThisDirectory, String prefix, String suffix, String contents) {
            this.inThisDirectory = inThisDirectory;
            this.prefix = prefix;
            this.suffix = suffix;
            this.contents = contents;
        }

        @Override
        public String invoke(File dir, VirtualChannel channel) throws IOException {
            File f;
            if (!this.inThisDirectory) {
                dir = new File(System.getProperty("java.io.tmpdir"));
            } else {
                FilePath.this.mkdirs(dir);
            }
            try {
                f = FilePath.this.creating(File.createTempFile(this.prefix, this.suffix, dir));
            }
            catch (IOException e) {
                throw new IOException("Failed to create a temporary directory in " + dir, e);
            }
            try (FileWriter w = new FileWriter(FilePath.this.writing(f));){
                w.write(this.contents);
            }
            return f.getAbsolutePath();
        }
    }

    private class DeleteRecursive
    extends SecureFileCallable<Void> {
        private static final long serialVersionUID = 1L;

        private DeleteRecursive() {
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException {
            FilePath.this.deleteRecursive(FilePath.this.deleting(f));
            return null;
        }
    }

    private class Mkdirs
    extends SecureFileCallable<Boolean> {
        private static final long serialVersionUID = 1L;

        private Mkdirs() {
        }

        @Override
        public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            if (FilePath.this.mkdirs(f) || f.exists()) {
                return true;
            }
            Thread.sleep(10L);
            return FilePath.this.mkdirs(f) || f.exists();
        }
    }

    private class CallableWith<V>
    implements Callable<V, IOException> {
        private final FileCallable<V> task;
        private static final long serialVersionUID = 1L;

        CallableWith(FileCallable<V> task) {
            this.task = task;
        }

        @Override
        public V call() throws IOException {
            try {
                return FilePath.this.act(this.task);
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }

        @Override
        public void checkRoles(RoleChecker checker) throws SecurityException {
            this.task.checkRoles(checker);
        }
    }

    public static abstract class AbstractInterceptorCallableWrapper<T>
    implements DelegatingCallable<T, IOException> {
        private static final long serialVersionUID = 1L;
        private final DelegatingCallable<T, IOException> callable;

        public AbstractInterceptorCallableWrapper(DelegatingCallable<T, IOException> callable) {
            this.callable = callable;
        }

        @Override
        public final ClassLoader getClassLoader() {
            return this.callable.getClassLoader();
        }

        @Override
        public final T call() throws IOException {
            this.before();
            try {
                Object v = this.callable.call();
                return (T)v;
            }
            finally {
                this.after();
            }
        }

        protected void before() {
        }

        protected void after() {
        }
    }

    public static abstract class FileCallableWrapperFactory
    implements ExtensionPoint {
        public abstract <T> DelegatingCallable<T, IOException> wrap(DelegatingCallable<T, IOException> var1);
    }

    static abstract class SecureFileCallable<T>
    extends SlaveToMasterFileCallable<T> {
        SecureFileCallable() {
        }
    }

    public static interface FileCallable<T>
    extends Serializable,
    RoleSensitive {
        public T invoke(File var1, VirtualChannel var2) throws IOException, InterruptedException;
    }

    private final class CopyFromRemotely
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final URL url;

        CopyFromRemotely(URL url) {
            this.url = url;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            FilePath.this.copyFrom(this.url);
            return null;
        }
    }

    private final class Unpack
    extends MasterToSlaveFileCallable<Void> {
        private final URL archive;

        Unpack(URL archive) {
            this.archive = archive;
        }

        @Override
        public Void invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
            try (InputStream in = this.archive.openStream();){
                CountingInputStream cis = new CountingInputStream(in);
                try {
                    if (this.archive.toExternalForm().endsWith(".zip")) {
                        FilePath.this.unzip(dir, (InputStream)cis);
                    } else {
                        FilePath.this.readFromTar("input stream", dir, TarCompression.GZIP.extract((InputStream)cis));
                    }
                }
                catch (IOException x) {
                    throw new IOException(String.format("Failed to unpack %s (%d bytes read)", this.archive, cis.getByteCount()), x);
                }
            }
            return null;
        }
    }

    public static enum TarCompression {
        NONE{

            @Override
            public InputStream extract(InputStream in) {
                return in;
            }

            @Override
            public OutputStream compress(OutputStream out) {
                return out;
            }
        }
        ,
        GZIP{

            @Override
            public InputStream extract(InputStream _in) throws IOException {
                HeadBufferingStream in = new HeadBufferingStream(_in, SIDE_BUFFER_SIZE);
                try {
                    return new com.jcraft.jzlib.GZIPInputStream((InputStream)in, 8192, true);
                }
                catch (IOException e) {
                    in.fillSide();
                    throw new IOException(e.getMessage() + "\nstream=" + Util.toHexString(in.getSideBuffer()), e);
                }
            }

            @Override
            public OutputStream compress(OutputStream out) throws IOException {
                return new GZIPOutputStream((OutputStream)new BufferedOutputStream(out));
            }
        };


        public abstract InputStream extract(InputStream var1) throws IOException;

        public abstract OutputStream compress(OutputStream var1) throws IOException;
    }
}

