/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.Messages;
import hudson.Plugin;
import hudson.PluginManager;
import hudson.model.AdministrativeMonitor;
import hudson.model.Api;
import hudson.model.ModelObject;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import hudson.util.VersionNumber;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class PluginWrapper
implements Comparable<PluginWrapper>,
ModelObject {
    private static final boolean ENABLE_PLUGIN_DEPENDENCIES_VERSION_CHECK = Boolean.parseBoolean(System.getProperty(PluginWrapper.class.getName() + ".dependenciesVersionCheck.enabled", "true"));
    public final PluginManager parent;
    private final Manifest manifest;
    public final ClassLoader classLoader;
    public final URL baseResourceURL;
    private final File disableFile;
    private final File archive;
    private final String shortName;
    private final boolean active;
    private boolean hasCycleDependency = false;
    private final List<Dependency> dependencies;
    private final List<Dependency> optionalDependencies;
    private final transient Map<String, Boolean> dependencyErrors = new HashMap<String, Boolean>();
    boolean isBundled;
    private Set<String> dependants = Collections.emptySet();
    private static Set<String> CORE_ONLY_DEPENDANT = ImmutableSet.copyOf(Arrays.asList("jenkins-core"));
    @Extension
    public static final PluginWrapperAdministrativeMonitor NOTICE = new PluginWrapperAdministrativeMonitor();
    private static final Logger LOGGER = Logger.getLogger(PluginWrapper.class.getName());
    public static final String MANIFEST_FILENAME = "META-INF/MANIFEST.MF";

    public List<String> getDependencyErrors() {
        return Collections.unmodifiableList(new ArrayList<String>(this.dependencyErrors.keySet()));
    }

    @Restricted(value={NoExternalUse.class})
    public List<String> getOriginalDependencyErrors() {
        Predicate<Map.Entry> p = Map.Entry::getValue;
        return this.dependencyErrors.entrySet().stream().filter(p.negate()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasOriginalDependencyErrors() {
        return !this.getOriginalDependencyErrors().isEmpty();
    }

    @Restricted(value={NoExternalUse.class})
    public List<String> getDerivedDependencyErrors() {
        return this.dependencyErrors.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasDerivedDependencyErrors() {
        return !this.getDerivedDependencyErrors().isEmpty();
    }

    public void setDependants(@Nonnull Set<String> dependants) {
        this.dependants = dependants;
    }

    @Nonnull
    public Set<String> getDependants() {
        if (this.isBundled && this.dependants.isEmpty()) {
            return CORE_ONLY_DEPENDANT;
        }
        return this.dependants;
    }

    public boolean hasDependants() {
        return this.isBundled || !this.dependants.isEmpty();
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public PluginWrapper(PluginManager parent, File archive, Manifest manifest, URL baseResourceURL, ClassLoader classLoader, File disableFile, List<Dependency> dependencies, List<Dependency> optionalDependencies) {
        this.parent = parent;
        this.manifest = manifest;
        this.shortName = PluginWrapper.computeShortName(manifest, archive.getName());
        this.baseResourceURL = baseResourceURL;
        this.classLoader = classLoader;
        this.disableFile = disableFile;
        this.active = !disableFile.exists();
        this.dependencies = dependencies;
        this.optionalDependencies = optionalDependencies;
        this.archive = archive;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.removeStart((String)this.getLongName(), (String)"Jenkins ");
    }

    public Api getApi() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        return new Api(this);
    }

    public URL getIndexPage() {
        URL idx = null;
        try {
            Enumeration<URL> en = this.classLoader.getResources("index.jelly");
            while (en.hasMoreElements()) {
                idx = en.nextElement();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return idx != null && idx.toString().contains(this.shortName) ? idx : null;
    }

    static String computeShortName(Manifest manifest, String fileName) {
        String n = manifest.getMainAttributes().getValue("Short-Name");
        if (n != null) {
            return n;
        }
        n = manifest.getMainAttributes().getValue("Extension-Name");
        if (n != null) {
            return n;
        }
        return FilenameUtils.getBaseName((String)fileName);
    }

    @Exported
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<Dependency> getOptionalDependencies() {
        return this.optionalDependencies;
    }

    @Exported
    public String getShortName() {
        return this.shortName;
    }

    @CheckForNull
    public Plugin getPlugin() {
        PluginManager.PluginInstanceStore pis = Jenkins.lookup(PluginManager.PluginInstanceStore.class);
        return pis != null ? pis.store.get(this) : null;
    }

    @Exported
    public String getUrl() {
        String url = this.manifest.getMainAttributes().getValue("Url");
        if (url != null) {
            return url;
        }
        UpdateSite.Plugin ui = this.getInfo();
        if (ui != null) {
            return ui.wiki;
        }
        return null;
    }

    public String toString() {
        return "Plugin:" + this.getShortName();
    }

    @Exported
    public String getLongName() {
        String name = this.manifest.getMainAttributes().getValue("Long-Name");
        if (name != null) {
            return name;
        }
        return this.shortName;
    }

    @Exported
    public YesNoMaybe supportsDynamicLoad() {
        String v = this.manifest.getMainAttributes().getValue("Support-Dynamic-Loading");
        if (v == null) {
            return YesNoMaybe.MAYBE;
        }
        return Boolean.parseBoolean(v) ? YesNoMaybe.YES : YesNoMaybe.NO;
    }

    @Exported
    public String getVersion() {
        return this.getVersionOf(this.manifest);
    }

    private String getVersionOf(Manifest manifest) {
        String v = manifest.getMainAttributes().getValue("Plugin-Version");
        if (v != null) {
            return v;
        }
        v = manifest.getMainAttributes().getValue("Implementation-Version");
        if (v != null) {
            return v;
        }
        return "???";
    }

    @Exported
    @CheckForNull
    public String getRequiredCoreVersion() {
        String v = this.manifest.getMainAttributes().getValue("Jenkins-Version");
        if (v != null) {
            return v;
        }
        v = this.manifest.getMainAttributes().getValue("Hudson-Version");
        if (v != null) {
            return v;
        }
        return null;
    }

    public VersionNumber getVersionNumber() {
        return new VersionNumber(this.getVersion());
    }

    public boolean isOlderThan(VersionNumber v) {
        try {
            return this.getVersionNumber().compareTo(v) < 0;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    public void stop() {
        Plugin plugin = this.getPlugin();
        if (plugin != null) {
            try {
                LOGGER.log(Level.FINE, "Stopping {0}", this.shortName);
                plugin.stop();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Failed to shut down " + this.shortName, t);
            }
        } else {
            LOGGER.log(Level.FINE, "Could not find Plugin instance to stop for {0}", this.shortName);
        }
        LogFactory.release((ClassLoader)this.classLoader);
    }

    public void releaseClassLoader() {
        if (this.classLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)this.classLoader)).close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to shut down classloader", e);
            }
        }
    }

    public void enable() throws IOException {
        if (!this.disableFile.exists()) {
            LOGGER.log(Level.FINEST, "Plugin {0} has been already enabled. Skipping the enable() operation", this.getShortName());
            return;
        }
        if (!this.disableFile.delete()) {
            throw new IOException("Failed to delete " + this.disableFile);
        }
    }

    public void disable() throws IOException {
        try (OutputStream os = Files.newOutputStream(this.disableFile.toPath(), new OpenOption[0]);){
            os.close();
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    @Exported
    public boolean isActive() {
        return this.active && !this.hasCycleDependency();
    }

    public boolean hasCycleDependency() {
        return this.hasCycleDependency;
    }

    public void setHasCycleDependency(boolean hasCycle) {
        this.hasCycleDependency = hasCycle;
    }

    @Exported
    public boolean isBundled() {
        return this.isBundled;
    }

    @Exported
    public boolean isEnabled() {
        return !this.disableFile.exists();
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setPlugin(Plugin plugin) {
        Jenkins.lookup(PluginManager.PluginInstanceStore.class).store.put(this, plugin);
        plugin.wrapper = this;
    }

    public String getPluginClass() {
        return this.manifest.getMainAttributes().getValue("Plugin-Class");
    }

    public boolean hasLicensesXml() {
        try {
            new URL(this.baseResourceURL, "WEB-INF/licenses.xml").openStream().close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    void resolvePluginDependencies() throws IOException {
        PluginWrapper dependency;
        if (ENABLE_PLUGIN_DEPENDENCIES_VERSION_CHECK) {
            String requiredCoreVersion = this.getRequiredCoreVersion();
            if (requiredCoreVersion == null) {
                LOGGER.warning(this.shortName + " doesn't declare required core version.");
            } else {
                VersionNumber actualVersion = Jenkins.getVersion();
                if (actualVersion.isOlderThan(new VersionNumber(requiredCoreVersion))) {
                    this.dependencyErrors.put(Messages.PluginWrapper_obsoleteCore(Jenkins.getVersion().toString(), requiredCoreVersion), false);
                }
            }
        }
        for (Dependency d : this.dependencies) {
            dependency = this.parent.getPlugin(d.shortName);
            if (dependency == null) {
                PluginWrapper failedDependency = NOTICE.getPlugin(d.shortName);
                if (failedDependency != null) {
                    this.dependencyErrors.put(Messages.PluginWrapper_failed_to_load_dependency(failedDependency.getLongName(), failedDependency.getVersion()), true);
                    break;
                }
                this.dependencyErrors.put(Messages.PluginWrapper_missing(d.shortName, d.version), false);
                continue;
            }
            if (dependency.isActive()) {
                if (!this.isDependencyObsolete(d, dependency)) continue;
                this.dependencyErrors.put(Messages.PluginWrapper_obsolete(dependency.getLongName(), dependency.getVersion(), d.version), false);
                continue;
            }
            if (this.isDependencyObsolete(d, dependency)) {
                this.dependencyErrors.put(Messages.PluginWrapper_disabledAndObsolete(dependency.getLongName(), dependency.getVersion(), d.version), false);
                continue;
            }
            this.dependencyErrors.put(Messages.PluginWrapper_disabled(dependency.getLongName()), false);
        }
        for (Dependency d : this.optionalDependencies) {
            dependency = this.parent.getPlugin(d.shortName);
            if (dependency == null || !dependency.isActive()) continue;
            if (this.isDependencyObsolete(d, dependency)) {
                this.dependencyErrors.put(Messages.PluginWrapper_obsolete(dependency.getLongName(), dependency.getVersion(), d.version), false);
                continue;
            }
            this.dependencies.add(d);
        }
        if (!this.dependencyErrors.isEmpty()) {
            NOTICE.addPlugin(this);
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append(Messages.PluginWrapper_failed_to_load_plugin(this.getLongName(), this.getVersion())).append(System.lineSeparator());
            Iterator<String> iterator = this.dependencyErrors.keySet().iterator();
            while (iterator.hasNext()) {
                String dependencyError = iterator.next();
                messageBuilder.append(" - ").append(dependencyError);
                if (!iterator.hasNext()) continue;
                messageBuilder.append(System.lineSeparator());
            }
            throw new IOException(messageBuilder.toString());
        }
    }

    private boolean isDependencyObsolete(Dependency d, PluginWrapper dependency) {
        return ENABLE_PLUGIN_DEPENDENCIES_VERSION_CHECK && dependency.getVersionNumber().isOlderThan(new VersionNumber(d.version));
    }

    public UpdateSite.Plugin getUpdateInfo() {
        UpdateCenter uc = Jenkins.getInstance().getUpdateCenter();
        UpdateSite.Plugin p = uc.getPlugin(this.getShortName());
        if (p != null && p.isNewerThan(this.getVersion())) {
            return p;
        }
        return null;
    }

    public UpdateSite.Plugin getInfo() {
        UpdateCenter uc = Jenkins.getInstance().getUpdateCenter();
        return uc.getPlugin(this.getShortName());
    }

    @Exported
    public boolean hasUpdate() {
        return this.getUpdateInfo() != null;
    }

    @Exported
    @Deprecated
    public boolean isPinned() {
        return false;
    }

    @Exported
    public boolean isDeleted() {
        return !this.archive.exists();
    }

    @Override
    public int compareTo(PluginWrapper pw) {
        return this.shortName.compareToIgnoreCase(pw.shortName);
    }

    @Exported
    public boolean isDowngradable() {
        return this.getBackupFile().exists();
    }

    public File getBackupFile() {
        return new File(Jenkins.getInstance().getRootDir(), "plugins/" + this.getShortName() + ".bak");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Exported
    public String getBackupVersion() {
        File backup = this.getBackupFile();
        if (!backup.exists()) return null;
        try (JarFile backupPlugin = new JarFile(backup);){
            String string = backupPlugin.getManifest().getMainAttributes().getValue("Plugin-Version");
            return string;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to get backup version from " + backup, e);
            return null;
        }
    }

    @Deprecated
    public boolean isPinningForcingOldVersion() {
        return false;
    }

    @RequirePOST
    public HttpResponse doMakeEnabled() throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        this.enable();
        return HttpResponses.ok();
    }

    @RequirePOST
    public HttpResponse doMakeDisabled() throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        this.disable();
        return HttpResponses.ok();
    }

    @RequirePOST
    @Deprecated
    public HttpResponse doPin() throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        LOGGER.log(Level.WARNING, "Call to pin plugin has been ignored. Plugin name: " + this.shortName);
        return HttpResponses.ok();
    }

    @RequirePOST
    @Deprecated
    public HttpResponse doUnpin() throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        LOGGER.log(Level.WARNING, "Call to unpin plugin has been ignored. Plugin name: " + this.shortName);
        return HttpResponses.ok();
    }

    @RequirePOST
    public HttpResponse doDoUninstall() throws IOException {
        Jenkins jenkins = Jenkins.getActiveInstance();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        this.archive.delete();
        jenkins.getPluginManager().resolveDependantPlugins();
        return HttpResponses.redirectViaContextPath((String)"/pluginManager/installed");
    }

    public static final class PluginWrapperAdministrativeMonitor
    extends AdministrativeMonitor {
        private final Map<String, PluginWrapper> plugins = new HashMap<String, PluginWrapper>();

        void addPlugin(PluginWrapper plugin) {
            this.plugins.put(plugin.shortName, plugin);
        }

        @Override
        public boolean isActivated() {
            return !this.plugins.isEmpty();
        }

        @Restricted(value={DoNotUse.class})
        public boolean hasAnyDerivedDependencyErrors() {
            return this.plugins.values().stream().anyMatch(PluginWrapper::hasDerivedDependencyErrors);
        }

        @Override
        public String getDisplayName() {
            return Messages.PluginWrapper_PluginWrapperAdministrativeMonitor_DisplayName();
        }

        public Collection<PluginWrapper> getPlugins() {
            return this.plugins.values();
        }

        public PluginWrapper getPlugin(String shortName) {
            return this.plugins.get(shortName);
        }

        public void doAct(StaplerRequest req, StaplerResponse rsp) throws IOException {
            if (req.hasParameter("correct")) {
                rsp.sendRedirect(req.getContextPath() + "/pluginManager");
            }
        }

        public static PluginWrapperAdministrativeMonitor get() {
            return AdministrativeMonitor.all().get(PluginWrapperAdministrativeMonitor.class);
        }
    }

    @ExportedBean
    public static final class Dependency {
        @Exported
        public final String shortName;
        @Exported
        public final String version;
        @Exported
        public final boolean optional;

        public Dependency(String s) {
            int idx = s.indexOf(58);
            if (idx == -1) {
                throw new IllegalArgumentException("Illegal dependency specifier " + s);
            }
            this.shortName = s.substring(0, idx);
            String version = s.substring(idx + 1);
            boolean isOptional = false;
            String[] osgiProperties = version.split("[;]");
            for (int i = 1; i < osgiProperties.length; ++i) {
                String osgiProperty = osgiProperties[i].trim();
                if (!osgiProperty.equalsIgnoreCase("resolution:=optional")) continue;
                isOptional = true;
            }
            this.optional = isOptional;
            this.version = isOptional ? osgiProperties[0] : version;
        }

        public String toString() {
            return this.shortName + " (" + this.version + ")" + (this.optional ? " optional" : "");
        }
    }
}

