/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import hudson.Util;
import hudson.util.AtomicFileWriter;
import hudson.util.XStream2;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlFile {
    private final XStream xs;
    private final File file;
    private static final Map<Object, Void> beingWritten = Collections.synchronizedMap(new IdentityHashMap());
    private static final ThreadLocal<File> writing = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(XmlFile.class.getName());
    private static final SAXParserFactory JAXP = SAXParserFactory.newInstance();
    private static final HierarchicalStreamDriver DEFAULT_DRIVER = XStream2.getDefaultDriver();
    private static final XStream DEFAULT_XSTREAM = new XStream2(DEFAULT_DRIVER);

    public XmlFile(File file) {
        this(DEFAULT_XSTREAM, file);
    }

    public XmlFile(XStream xs, File file) {
        this.xs = xs;
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public XStream getXStream() {
        return this.xs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object read() throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reading " + this.file);
        }
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0]));){
            Object object = this.xs.fromXML((InputStream)in);
            return object;
        }
        catch (Error | RuntimeException e) {
            throw new IOException("Unable to read " + this.file, e);
        }
    }

    public Object unmarshal(Object o) throws IOException {
        return this.unmarshal(o, false);
    }

    public Object unmarshalNullingOut(Object o) throws IOException {
        return this.unmarshal(o, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object unmarshal(Object o, boolean nullOut) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0]));){
            if (nullOut) {
                Object object = ((XStream2)this.xs).unmarshal(DEFAULT_DRIVER.createReader((InputStream)in), o, null, true);
                return object;
            }
            Object object = this.xs.unmarshal(DEFAULT_DRIVER.createReader((InputStream)in), o);
            return object;
        }
        catch (Error | RuntimeException e) {
            throw new IOException("Unable to read " + this.file, e);
        }
    }

    public void write(Object o) throws IOException {
        this.mkdirs();
        AtomicFileWriter w = new AtomicFileWriter(this.file);
        try {
            w.write("<?xml version='1.1' encoding='UTF-8'?>\n");
            beingWritten.put(o, null);
            writing.set(this.file);
            try {
                this.xs.toXML(o, (Writer)w);
            }
            finally {
                beingWritten.remove(o);
                writing.set(null);
            }
            w.commit();
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
        finally {
            w.abort();
        }
    }

    public static Object replaceIfNotAtTopLevel(Object o, Supplier<Object> replacement) {
        File currentlyWriting = writing.get();
        if (beingWritten.containsKey(o) || currentlyWriting == null) {
            return o;
        }
        LOGGER.log(Level.WARNING, "JENKINS-45892: reference to " + o + " being saved from unexpected " + currentlyWriting, new IllegalStateException());
        return replacement.get();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void delete() {
        this.file.delete();
    }

    public void mkdirs() {
        this.file.getParentFile().mkdirs();
    }

    public String toString() {
        return this.file.toString();
    }

    public Reader readRaw() throws IOException {
        try {
            InputStream fileInputStream = Files.newInputStream(this.file.toPath(), new OpenOption[0]);
            try {
                return new InputStreamReader(fileInputStream, this.sniffEncoding());
            }
            catch (IOException ex) {
                Util.closeAndLogFailures(fileInputStream, LOGGER, "FileInputStream", this.file.toString());
                throw ex;
            }
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    public String asString() throws IOException {
        StringWriter w = new StringWriter();
        this.writeRawTo(w);
        return w.toString();
    }

    public void writeRawTo(Writer w) throws IOException {
        try (Reader r = this.readRaw();){
            IOUtils.copy((Reader)r, (Writer)w);
        }
    }

    public String sniffEncoding() throws IOException {
        class Eureka
        extends SAXException {
            final String encoding;

            public Eureka(String encoding) {
                this.encoding = encoding;
            }
        }
        try {
            InputStream in = Files.newInputStream(this.file.toPath(), new OpenOption[0]);
            Throwable throwable = null;
            try {
                try {
                    InputSource input = new InputSource(this.file.toURI().toASCIIString());
                    input.setByteStream(in);
                    JAXP.newSAXParser().parse(input, new DefaultHandler(){
                        private Locator loc;

                        @Override
                        public void setDocumentLocator(Locator locator) {
                            this.loc = locator;
                        }

                        @Override
                        public void startDocument() throws SAXException {
                            this.attempt();
                        }

                        @Override
                        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                            this.attempt();
                            throw new Eureka(null);
                        }

                        private void attempt() throws Eureka {
                            Locator2 loc2;
                            String e;
                            if (this.loc == null) {
                                return;
                            }
                            if (this.loc instanceof Locator2 && (e = (loc2 = (Locator2)this.loc).getEncoding()) != null) {
                                throw new Eureka(e);
                            }
                        }
                    });
                    throw new AssertionError();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        in.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (Eureka e) {
            if (e.encoding != null) {
                return e.encoding;
            }
            return "UTF-8";
        }
        catch (SAXException e) {
            throw new IOException("Failed to detect encoding of " + this.file, e);
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        JAXP.setNamespaceAware(true);
    }
}

