/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.CliEntryPoint;
import hudson.cli.CliManagerImpl;
import hudson.cli.PlainCLIProtocol;
import hudson.model.FullDuplexHttpChannel;
import hudson.model.UnprotectedRootAction;
import hudson.remoting.Channel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.CLI;
import jenkins.model.Jenkins;
import jenkins.util.FullDuplexHttpService;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
@Symbol(value={"cli"})
@Restricted(value={NoExternalUse.class})
public class CLIAction
implements UnprotectedRootAction,
StaplerProxy {
    private static final Logger LOGGER = Logger.getLogger(CLIAction.class.getName());
    private final transient Map<UUID, FullDuplexHttpService> duplexServices = new HashMap<UUID, FullDuplexHttpService>();

    @Override
    public String getIconFileName() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Jenkins CLI";
    }

    @Override
    public String getUrlName() {
        return "cli";
    }

    public void doCommand(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        Jenkins jenkins = Jenkins.getActiveInstance();
        jenkins.checkPermission(Jenkins.READ);
        String commandName = req.getRestOfPath().substring(1);
        CLICommand command = CLICommand.clone(commandName);
        if (command == null) {
            rsp.sendError(404, "No such command");
            return;
        }
        req.setAttribute("command", (Object)command);
        req.getView((Object)this, "command.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public Object getTarget() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req.getRestOfPath().length() == 0 && "POST".equals(req.getMethod())) {
            if ("false".equals(req.getParameter("remoting"))) {
                throw new PlainCliEndpointResponse();
            }
            if (CLI.get().isEnabled()) {
                throw new RemotingCliEndpointResponse();
            }
            throw HttpResponses.forbidden();
        }
        return this;
    }

    private class RemotingCliEndpointResponse
    extends FullDuplexHttpService.Response {
        RemotingCliEndpointResponse() {
            super(CLIAction.this.duplexServices);
        }

        @Override
        protected FullDuplexHttpService createService(StaplerRequest req, UUID uuid) throws IOException {
            return new FullDuplexHttpChannel(uuid, !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)){

                @Override
                protected void main(Channel channel) throws IOException, InterruptedException {
                    channel.setProperty(CLICommand.TRANSPORT_AUTHENTICATION, Jenkins.getAuthentication());
                    channel.setProperty(CliEntryPoint.class.getName(), new CliManagerImpl(channel));
                }
            };
        }
    }

    private class PlainCliEndpointResponse
    extends FullDuplexHttpService.Response {
        PlainCliEndpointResponse() {
            super(CLIAction.this.duplexServices);
        }

        @Override
        protected FullDuplexHttpService createService(StaplerRequest req, UUID uuid) throws IOException {
            return new FullDuplexHttpService(uuid){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void run(InputStream upload, OutputStream download) throws IOException, InterruptedException {
                    final AtomicReference<Thread> runningThread = new AtomicReference<Thread>();
                    class ServerSideImpl
                    extends PlainCLIProtocol.ServerSide {
                        boolean ready;
                        List<String> args;
                        Locale locale;
                        Charset encoding;
                        final PipedInputStream stdin;
                        final PipedOutputStream stdinMatch;

                        ServerSideImpl(InputStream is, OutputStream os) throws IOException {
                            super(is, os);
                            this.args = new ArrayList<String>();
                            this.locale = Locale.getDefault();
                            this.encoding = Charset.defaultCharset();
                            this.stdin = new PipedInputStream();
                            this.stdinMatch = new PipedOutputStream();
                            this.stdinMatch.connect(this.stdin);
                        }

                        protected void onArg(String text) {
                            this.args.add(text);
                        }

                        protected void onLocale(String text) {
                            for (Locale _locale : Locale.getAvailableLocales()) {
                                if (!_locale.toString().equals(text)) continue;
                                this.locale = _locale;
                                return;
                            }
                            LOGGER.log(Level.WARNING, "unknown client locale {0}", text);
                        }

                        protected void onEncoding(String text) {
                            try {
                                this.encoding = Charset.forName(text);
                            }
                            catch (UnsupportedCharsetException x) {
                                LOGGER.log(Level.WARNING, "unknown client charset {0}", text);
                            }
                        }

                        protected void onStart() {
                            this.ready();
                        }

                        protected void onStdin(byte[] chunk) throws IOException {
                            this.stdinMatch.write(chunk);
                        }

                        protected void onEndStdin() throws IOException {
                            this.stdinMatch.close();
                        }

                        protected void handleClose() {
                            this.ready();
                            Thread t = (Thread)runningThread.get();
                            if (t != null) {
                                t.interrupt();
                            }
                        }

                        private synchronized void ready() {
                            this.ready = true;
                            ((Object)((Object)this)).notifyAll();
                        }
                    }
                    try (ServerSideImpl connection = new ServerSideImpl(upload, download);){
                        connection.begin();
                        ServerSideImpl serverSideImpl = connection;
                        synchronized (serverSideImpl) {
                            while (!connection.ready) {
                                ((Object)((Object)connection)).wait();
                            }
                        }
                        PrintStream stdout = new PrintStream(connection.streamStdout(), false, connection.encoding.name());
                        PrintStream stderr = new PrintStream(connection.streamStderr(), true, connection.encoding.name());
                        if (connection.args.isEmpty()) {
                            stderr.println("Connection closed before arguments received");
                            connection.sendExit(2);
                            return;
                        }
                        String commandName = connection.args.get(0);
                        CLICommand command = CLICommand.clone(commandName);
                        if (command == null) {
                            stderr.println("No such command " + commandName);
                            connection.sendExit(2);
                            return;
                        }
                        command.setTransportAuth(Jenkins.getAuthentication());
                        command.setClientCharset(connection.encoding);
                        CLICommand orig = CLICommand.setCurrent(command);
                        try {
                            runningThread.set(Thread.currentThread());
                            int exit = command.main(connection.args.subList(1, connection.args.size()), connection.locale, connection.stdin, stdout, stderr);
                            stdout.flush();
                            connection.sendExit(exit);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        finally {
                            CLICommand.setCurrent(orig);
                            runningThread.set(null);
                        }
                    }
                }
            };
        }
    }
}

