/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.PluginManager;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.UpdateSite;
import hudson.util.EditDistance;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Extension
public class InstallPluginCommand
extends CLICommand {
    @Argument(metaVar="SOURCE", required=true, usage="If this points to a local file (\u2018-remoting\u2019 mode only), that file will be installed. If this is an URL, Jenkins downloads the URL and installs that as a plugin. If it is the string \u2018=\u2019, the file will be read from standard input of the command, and \u2018-name\u2019 must be specified. Otherwise the name is assumed to be the short name of the plugin in the existing update center (like \u2018findbugs\u2019), and the plugin will be installed from the update center.")
    public List<String> sources = new ArrayList<String>();
    @Option(name="-name", usage="If specified, the plugin will be installed as this short name (whereas normally the name is inferred from the source name automatically).")
    public String name;
    @Option(name="-restart", usage="Restart Jenkins upon successful installation.")
    public boolean restart;
    @Option(name="-deploy", usage="Deploy plugins right away without postponing them until the reboot.")
    public boolean dynamicLoad;

    @Override
    public String getShortDescription() {
        return Messages.InstallPluginCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        Jenkins h = Jenkins.getActiveInstance();
        h.checkPermission(PluginManager.UPLOAD_PLUGINS);
        PluginManager pm = h.getPluginManager();
        if (this.sources.size() > 1 && this.name != null) {
            throw new IllegalArgumentException("-name is incompatible with multiple sources");
        }
        for (String source : this.sources) {
            String n;
            Serializable f;
            if (source.equals("=")) {
                if (this.name == null) {
                    throw new IllegalArgumentException("-name required when using -source -");
                }
                this.stdout.println(Messages.InstallPluginCommand_InstallingPluginFromStdin());
                f = InstallPluginCommand.getTargetFile(this.name);
                FileUtils.copyInputStreamToFile((InputStream)this.stdin, (File)f);
                if (!this.dynamicLoad) continue;
                pm.dynamicLoad((File)f);
                continue;
            }
            if (this.channel != null && ((FilePath)(f = new FilePath(this.channel, source))).exists()) {
                this.stdout.println(Messages.InstallPluginCommand_InstallingPluginFromLocalFile(f));
                n = this.name != null ? this.name : ((FilePath)f).getBaseName();
                ((FilePath)f).copyTo(InstallPluginCommand.getTargetFilePath(n));
                if (!this.dynamicLoad) continue;
                pm.dynamicLoad(InstallPluginCommand.getTargetFile(n));
                continue;
            }
            try {
                URL u = new URL(source);
                this.stdout.println(Messages.InstallPluginCommand_InstallingPluginFromUrl(u));
                if (this.name != null) {
                    n = this.name;
                } else {
                    n = u.getPath();
                    n = n.substring(n.lastIndexOf(47) + 1);
                    int idx = (n = n.substring(n.lastIndexOf(92) + 1)).lastIndexOf(46);
                    if (idx > 0) {
                        n = n.substring(0, idx);
                    }
                }
                InstallPluginCommand.getTargetFilePath(n).copyFrom(u);
                if (!this.dynamicLoad) continue;
                pm.dynamicLoad(InstallPluginCommand.getTargetFile(n));
            }
            catch (MalformedURLException u) {
                UpdateSite.Plugin p = h.getUpdateCenter().getPlugin(source);
                if (p != null) {
                    this.stdout.println(Messages.InstallPluginCommand_InstallingFromUpdateCenter(source));
                    Throwable e = p.deploy(this.dynamicLoad).get().getError();
                    if (e == null) continue;
                    AbortException myException = new AbortException("Failed to install plugin " + source);
                    myException.initCause(e);
                    throw myException;
                }
                this.stdout.println(Messages.InstallPluginCommand_NotAValidSourceName(source));
                if (!(source.contains(".") || source.contains(":") || source.contains("/") || source.contains("\\"))) {
                    if (h.getUpdateCenter().getSites().isEmpty()) {
                        this.stdout.println(Messages.InstallPluginCommand_NoUpdateCenterDefined());
                    } else {
                        HashSet<String> candidates = new HashSet<String>();
                        for (UpdateSite s : h.getUpdateCenter().getSites()) {
                            UpdateSite.Data dt = s.getData();
                            if (dt == null) {
                                this.stdout.println(Messages.InstallPluginCommand_NoUpdateDataRetrieved(s.getUrl()));
                                continue;
                            }
                            candidates.addAll(dt.plugins.keySet());
                        }
                        this.stdout.println(Messages.InstallPluginCommand_DidYouMean(source, EditDistance.findNearest(source, candidates)));
                    }
                }
                throw new AbortException("Error occurred, see previous output.");
            }
        }
        if (this.restart) {
            h.safeRestart();
        }
        return 0;
    }

    private static FilePath getTargetFilePath(String name) {
        return new FilePath(InstallPluginCommand.getTargetFile(name));
    }

    private static File getTargetFile(String name) {
        return new File(Jenkins.getActiveInstance().getPluginManager().rootDir, name + ".jpi");
    }
}

