/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.model.View;
import java.util.Collection;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.kohsuke.args4j.Argument;

@Extension
public class ListJobsCommand
extends CLICommand {
    @Argument(metaVar="NAME", usage="Name of the view", required=false)
    public String name;

    @Override
    public String getShortDescription() {
        return Messages.ListJobsCommand_ShortDescription();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int run() throws Exception {
        Collection<TopLevelItem> jobs;
        Jenkins h = Jenkins.getActiveInstance();
        if (this.name != null) {
            View view = h.getView(this.name);
            if (view != null) {
                jobs = view.getAllItems();
            } else {
                Item item = h.getItemByFullName(this.name);
                if (!(item instanceof ModifiableTopLevelItemGroup)) throw new IllegalArgumentException("No view or item group with the given name '" + this.name + "' found.");
                jobs = ((ModifiableTopLevelItemGroup)((Object)item)).getAllItems(TopLevelItem.class);
            }
        } else {
            jobs = h.getItems();
        }
        for (TopLevelItem topLevelItem : jobs) {
            this.stdout.println(topLevelItem.getName());
        }
        return 0;
    }
}

