/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import hudson.Extension;
import hudson.console.HyperlinkNote;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.User;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;

public class ModelHyperlinkNote
extends HyperlinkNote {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ModelHyperlinkNote.class.getName());

    public ModelHyperlinkNote(String url, int length) {
        super(url, length);
    }

    @Override
    protected String extraAttributes() {
        return " class='model-link'";
    }

    public static String encodeTo(@Nonnull User u) {
        return ModelHyperlinkNote.encodeTo(u, u.getDisplayName());
    }

    public static String encodeTo(User u, String text) {
        return ModelHyperlinkNote.encodeTo('/' + u.getUrl(), text);
    }

    public static String encodeTo(Item item) {
        return ModelHyperlinkNote.encodeTo(item, item.getFullDisplayName());
    }

    public static String encodeTo(Item item, String text) {
        return ModelHyperlinkNote.encodeTo('/' + item.getUrl(), text);
    }

    public static String encodeTo(Run r) {
        return ModelHyperlinkNote.encodeTo('/' + r.getUrl(), r.getDisplayName());
    }

    public static String encodeTo(Node node) {
        Computer c = node.toComputer();
        if (c != null) {
            return ModelHyperlinkNote.encodeTo("/" + c.getUrl(), node.getDisplayName());
        }
        String nodePath = node == Jenkins.getInstance() ? "(master)" : node.getNodeName();
        return ModelHyperlinkNote.encodeTo("/computer/" + nodePath, node.getDisplayName());
    }

    public static String encodeTo(String url, String text) {
        try {
            return new ModelHyperlinkNote(url, text.length()).encode() + text;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to serialize " + ModelHyperlinkNote.class, e);
            return text;
        }
    }

    @Extension
    @Symbol(value={"hyperlinkToModels"})
    public static class DescriptorImpl
    extends HyperlinkNote.DescriptorImpl {
        @Override
        public String getDisplayName() {
            return "Hyperlinks to models";
        }
    }
}

