/*
 * Decompiled with CFR 0.152.
 */
package hudson.diagnosis;

import hudson.Extension;
import hudson.diagnosis.HudsonHomeDiskUsageMonitor;
import hudson.model.PeriodicWork;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;

@Extension
@Symbol(value={"diskUsageCheck"})
public class HudsonHomeDiskUsageChecker
extends PeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(HudsonHomeDiskUsageChecker.class.getName());
    public static long FREE_SPACE_THRESHOLD = Long.getLong(HudsonHomeDiskUsageChecker.class.getName() + ".freeSpaceThreshold", 0x280000000L);

    @Override
    public long getRecurrencePeriod() {
        return 3600000L;
    }

    @Override
    protected void doRun() {
        long free = Jenkins.getInstance().getRootDir().getUsableSpace();
        long total = Jenkins.getInstance().getRootDir().getTotalSpace();
        if (free <= 0L || total <= 0L) {
            LOGGER.info("JENKINS_HOME disk usage information isn't available. aborting to monitor");
            this.cancel();
            return;
        }
        LOGGER.fine("Monitoring disk usage of JENKINS_HOME. total=" + total + " free=" + free);
        HudsonHomeDiskUsageMonitor.get().activated = total / free > 10L && free < FREE_SPACE_THRESHOLD;
    }
}

