/*
 * Decompiled with CFR 0.152.
 */
package hudson.diagnosis;

import hudson.Extension;
import hudson.Util;
import hudson.diagnosis.Messages;
import hudson.model.AdministrativeMonitor;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Symbol(value={"reverseProxy"})
public class ReverseProxySetupMonitor
extends AdministrativeMonitor {
    private static final Logger LOGGER = Logger.getLogger(ReverseProxySetupMonitor.class.getName());

    @Override
    public boolean isActivated() {
        return true;
    }

    public HttpResponse doTest() {
        String referer = Stapler.getCurrentRequest().getReferer();
        Jenkins j = Jenkins.getInstance();
        String redirect = j.getRootUrl() + "administrativeMonitor/" + this.id + "/testForReverseProxySetup/" + (referer != null ? Util.rawEncode(referer) : "NO-REFERER") + "/";
        LOGGER.log(Level.FINE, "coming from {0} and redirecting to {1}", new Object[]{referer, redirect});
        return new HttpRedirect(redirect);
    }

    public void getTestForReverseProxySetup(String rest) {
        Jenkins j = Jenkins.getInstance();
        String inferred = j.getRootUrlFromRequest() + "manage";
        if (rest.startsWith(inferred)) {
            throw HttpResponses.ok();
        }
        LOGGER.log(Level.WARNING, "{0} vs. {1}", new Object[]{inferred, rest});
        throw HttpResponses.errorWithoutStack((int)404, (String)(inferred + " vs. " + rest));
    }

    @RequirePOST
    public HttpResponse doAct(@QueryParameter String no) throws IOException {
        if (no != null) {
            this.disable(true);
            return HttpResponses.redirectViaContextPath((String)"/manage");
        }
        return new HttpRedirect("https://wiki.jenkins-ci.org/display/JENKINS/Jenkins+says+my+reverse+proxy+setup+is+broken");
    }

    @Override
    public String getDisplayName() {
        return Messages.ReverseProxySetupMonitor_DisplayName();
    }
}

