/*
 * Decompiled with CFR 0.152.
 */
package hudson.lifecycle;

import hudson.Extension;
import hudson.lifecycle.Lifecycle;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Configuration;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
public class ExitLifecycle
extends Lifecycle {
    private static final Logger LOGGER = Logger.getLogger(ExitLifecycle.class.getName());
    private static final String EXIT_CODE_ON_RESTART = "exitCodeOnRestart";
    private static final String DEFAULT_EXIT_CODE = "5";
    private Integer exitOnRestart = Integer.parseInt(Configuration.getStringConfigParameter("exitCodeOnRestart", "5"));

    @Override
    public void restart() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        try {
            if (jenkins != null) {
                jenkins.cleanUp();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to clean up. Restart will continue.", e);
        }
        System.exit(this.exitOnRestart);
    }
}

