/*
 * Decompiled with CFR 0.152.
 */
package hudson.logging;

import com.google.common.annotations.VisibleForTesting;
import com.thoughtworks.xstream.XStream;
import hudson.BulkChange;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.XmlFile;
import hudson.logging.LogRecorderManager;
import hudson.logging.WeakLogHandler;
import hudson.model.AbstractModelObject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Computer;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.listeners.SaveableListener;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import hudson.util.CopyOnWriteList;
import hudson.util.HttpResponses;
import hudson.util.RingBufferLogHandler;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class LogRecorder
extends AbstractModelObject
implements Saveable {
    private volatile String name;
    public final CopyOnWriteList<Target> targets = new CopyOnWriteList();
    private static final TargetComparator TARGET_COMPARATOR = new TargetComparator();
    @Restricted(value={NoExternalUse.class})
    transient RingBufferLogHandler handler = new RingBufferLogHandler(){

        @Override
        public void publish(LogRecord record) {
            for (Target t : LogRecorder.this.orderedTargets()) {
                Boolean match = t.matches(record);
                if (match == null) continue;
                if (match.booleanValue()) {
                    super.publish(record);
                }
                return;
            }
        }
    };
    public static final XStream XSTREAM = new XStream2();
    public static List<Level> LEVELS;

    @Restricted(value={NoExternalUse.class})
    Target[] orderedTargets() {
        Target[] ts = this.targets.toArray((Target[])new Target[0]);
        Arrays.sort(ts, TARGET_COMPARATOR);
        return ts;
    }

    @Restricted(value={NoExternalUse.class})
    @VisibleForTesting
    public static Set<String> getAutoCompletionCandidates(List<String> loggerNamesList) {
        HashSet<String> loggerNames = new HashSet<String>(loggerNamesList);
        HashMap<String, Integer> seenPrefixes = new HashMap<String, Integer>();
        TreeSet<String> relevantPrefixes = new TreeSet<String>();
        for (String loggerName : loggerNames) {
            String[] loggerNameParts = loggerName.split("[.]");
            String longerPrefix = null;
            for (int i = loggerNameParts.length; i > 0; --i) {
                String loggerNamePrefix = StringUtils.join((Object[])Arrays.copyOf(loggerNameParts, i), (String)".");
                seenPrefixes.put(loggerNamePrefix, seenPrefixes.getOrDefault(loggerNamePrefix, 0) + 1);
                if (longerPrefix == null) {
                    relevantPrefixes.add(loggerNamePrefix);
                    longerPrefix = loggerNamePrefix;
                    continue;
                }
                if ((Integer)seenPrefixes.get(loggerNamePrefix) > (Integer)seenPrefixes.get(longerPrefix)) {
                    relevantPrefixes.add(loggerNamePrefix);
                }
                longerPrefix = loggerNamePrefix;
            }
        }
        return relevantPrefixes;
    }

    @Restricted(value={NoExternalUse.class})
    public AutoCompletionCandidates doAutoCompleteLoggerName(@QueryParameter String value) {
        if (value == null) {
            return new AutoCompletionCandidates();
        }
        LinkedHashSet<String> candidateNames = new LinkedHashSet<String>(LogRecorder.getAutoCompletionCandidates(Collections.list(LogManager.getLogManager().getLoggerNames())));
        for (String part : value.split("[ ]+")) {
            HashSet<String> partCandidates = new HashSet<String>();
            String lowercaseValue = part.toLowerCase(Locale.ENGLISH);
            for (String loggerName : candidateNames) {
                if (!loggerName.toLowerCase(Locale.ENGLISH).contains(lowercaseValue)) continue;
                partCandidates.add(loggerName);
            }
            candidateNames.retainAll(partCandidates);
        }
        AutoCompletionCandidates candidates = new AutoCompletionCandidates();
        candidates.add(candidateNames.toArray(new String[0]));
        return candidates;
    }

    public LogRecorder(String name) {
        this.name = name;
        new WeakLogHandler(this.handler, Logger.getLogger(""));
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String getSearchUrl() {
        return Util.rawEncode(this.name);
    }

    public String getName() {
        return this.name;
    }

    public LogRecorderManager getParent() {
        return Jenkins.getInstance().getLog();
    }

    @RequirePOST
    public synchronized void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        JSONObject src = req.getSubmittedForm();
        String newName = src.getString("name");
        String redirect = ".";
        XmlFile oldFile = null;
        if (!this.name.equals(newName)) {
            Jenkins.checkGoodName(newName);
            oldFile = this.getConfigFile();
            this.getParent().logRecorders.remove(this.name);
            this.name = newName;
            this.getParent().logRecorders.put(this.name, this);
            redirect = "../" + Util.rawEncode(newName) + '/';
        }
        List newTargets = req.bindJSONToList(Target.class, src.get("targets"));
        for (Target t : newTargets) {
            t.enable();
        }
        this.targets.replaceBy(newTargets);
        this.save();
        if (oldFile != null) {
            oldFile.delete();
        }
        rsp.sendRedirect2(redirect);
    }

    @RequirePOST
    public HttpResponse doClear() throws IOException {
        this.handler.clear();
        return HttpResponses.redirectToDot();
    }

    public synchronized void load() throws IOException {
        this.getConfigFile().unmarshal(this);
        for (Target t : this.targets) {
            t.enable();
        }
    }

    @Override
    public synchronized void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        this.getConfigFile().write(this);
        SaveableListener.fireOnChange(this, this.getConfigFile());
    }

    @RequirePOST
    public synchronized void doDoDelete(StaplerResponse rsp) throws IOException, ServletException {
        this.getConfigFile().delete();
        this.getParent().logRecorders.remove(this.name);
        for (Target t : this.targets) {
            t.disable();
        }
        for (LogRecorder log : this.getParent().logRecorders.values()) {
            for (Target t : log.targets) {
                t.enable();
            }
        }
        rsp.sendRedirect2("..");
    }

    public void doRss(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        LogRecorderManager.doRss(req, rsp, this.getLogRecords());
    }

    private XmlFile getConfigFile() {
        return new XmlFile(XSTREAM, new File(LogRecorderManager.configDir(), this.name + ".xml"));
    }

    public List<LogRecord> getLogRecords() {
        return this.handler.getView();
    }

    public Map<Computer, List<LogRecord>> getSlaveLogRecords() {
        TreeMap<Computer, List<LogRecord>> result = new TreeMap<Computer, List<LogRecord>>(new Comparator<Computer>(){
            final Collator COLL = Collator.getInstance();

            @Override
            public int compare(Computer c1, Computer c2) {
                return this.COLL.compare(c1.getDisplayName(), c2.getDisplayName());
            }
        });
        for (Computer c : Jenkins.getInstance().getComputers()) {
            if (c.getName().length() == 0) continue;
            ArrayList<LogRecord> recs = new ArrayList<LogRecord>();
            try {
                block4: for (LogRecord rec : c.getLogRecords()) {
                    for (Target t : this.targets) {
                        if (!t.includes(rec)) continue;
                        recs.add(rec);
                        continue block4;
                    }
                }
            }
            catch (IOException x) {
                continue;
            }
            catch (InterruptedException x) {
                continue;
            }
            if (recs.isEmpty()) continue;
            result.put(c, recs);
        }
        return result;
    }

    static {
        XSTREAM.alias("log", LogRecorder.class);
        XSTREAM.alias("target", Target.class);
        LEVELS = Arrays.asList(Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE);
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static final class ComputerLogInitializer
    extends ComputerListener {
        @Override
        public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
            for (LogRecorder recorder : Jenkins.getInstance().getLog().logRecorders.values()) {
                for (Target t : recorder.targets) {
                    channel.call(new SetLevel(t.name, t.getLevel()));
                }
            }
        }
    }

    private static final class SetLevel
    extends MasterToSlaveCallable<Void, Error> {
        private static final Set<Logger> loggers = new HashSet<Logger>();
        private final String name;
        private final Level level;

        SetLevel(String name, Level level) {
            this.name = name;
            this.level = level;
        }

        @Override
        public Void call() throws Error {
            Logger logger = Logger.getLogger(this.name);
            loggers.add(logger);
            logger.setLevel(this.level);
            return null;
        }

        void broadcast() {
            for (Computer c : Jenkins.getInstance().getComputers()) {
                VirtualChannel ch;
                if (c.getName().length() <= 0 || (ch = c.getChannel()) == null) continue;
                try {
                    ch.call(this);
                }
                catch (Exception x) {
                    Logger.getLogger(LogRecorder.class.getName()).log(Level.WARNING, "could not set up logging on " + c, x);
                }
            }
        }
    }

    private static class TargetComparator
    implements Comparator<Target> {
        private TargetComparator() {
        }

        @Override
        public int compare(Target left, Target right) {
            return right.getName().length() - left.getName().length();
        }
    }

    public static final class Target {
        public final String name;
        private final int level;
        private transient Logger logger;

        public Target(String name, Level level) {
            this(name, level.intValue());
        }

        public Target(String name, int level) {
            this.name = name;
            this.level = level;
        }

        @DataBoundConstructor
        public Target(String name, String level) {
            this(name, Level.parse(level));
        }

        public Level getLevel() {
            return Level.parse(String.valueOf(this.level));
        }

        public String getName() {
            return this.name;
        }

        @Deprecated
        public boolean includes(LogRecord r) {
            if (r.getLevel().intValue() < this.level) {
                return false;
            }
            if (this.name.length() == 0) {
                return true;
            }
            String logName = r.getLoggerName();
            if (logName == null || !logName.startsWith(this.name)) {
                return false;
            }
            String rest = logName.substring(this.name.length());
            return rest.startsWith(".") || rest.length() == 0;
        }

        public Boolean matches(LogRecord r) {
            boolean levelSufficient;
            boolean bl = levelSufficient = r.getLevel().intValue() >= this.level;
            if (this.name.length() == 0) {
                return levelSufficient;
            }
            String logName = r.getLoggerName();
            if (logName == null || !logName.startsWith(this.name)) {
                return null;
            }
            String rest = logName.substring(this.name.length());
            if (rest.startsWith(".") || rest.length() == 0) {
                return levelSufficient;
            }
            return null;
        }

        public Logger getLogger() {
            if (this.logger == null) {
                this.logger = Logger.getLogger(this.name);
            }
            return this.logger;
        }

        public void enable() {
            Logger l = this.getLogger();
            if (!l.isLoggable(this.getLevel())) {
                l.setLevel(this.getLevel());
            }
            new SetLevel(this.name, this.getLevel()).broadcast();
        }

        public void disable() {
            this.getLogger().setLevel(null);
            new SetLevel(this.name, null).broadcast();
        }
    }
}

