/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.model.Computer;
import hudson.model.DescriptorByNameOwner;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.model.ViewJob;
import hudson.security.AccessControlled;
import hudson.slaves.ComputerListener;
import hudson.slaves.RetentionStrategy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Configuration;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerProxy;

public abstract class AbstractCIBase
extends Node
implements ItemGroup<TopLevelItem>,
StaplerProxy,
StaplerFallback,
ViewGroup,
AccessControlled,
DescriptorByNameOwner {
    public static boolean LOG_STARTUP_PERFORMANCE = Configuration.getBooleanConfigParameter("logStartupPerformance", false);
    private static final Logger LOGGER = Logger.getLogger(AbstractCIBase.class.getName());
    final CopyOnWriteArraySet<String> disabledAdministrativeMonitors = new CopyOnWriteArraySet();

    @Override
    @Deprecated
    public String getNodeName() {
        return "";
    }

    @Override
    @Deprecated
    public String getUrl() {
        return "";
    }

    protected void resetLabel(Label l) {
        l.reset();
    }

    protected void setViewOwner(View v) {
        v.owner = this;
    }

    protected void interruptReloadThread() {
        ViewJob.interruptReloadThread();
    }

    protected void killComputer(Computer c) {
        c.kill();
    }

    public abstract List<Node> getNodes();

    public abstract Queue getQueue();

    protected abstract Map<Node, Computer> getComputerMap();

    private void updateComputer(Node n, Map<String, Computer> byNameMap, Set<Computer> used, boolean automaticSlaveLaunch) {
        Map<Node, Computer> computers = this.getComputerMap();
        Computer c = byNameMap.get(n.getNodeName());
        if (c != null) {
            try {
                c.setNode(n);
                used.add(c);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Error updating node " + n.getNodeName() + ", continuing", e);
            }
        } else if (n.getNumExecutors() > 0 || n == Jenkins.getInstance()) {
            try {
                c = n.createComputer();
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.WARNING, "Error retrieving computer for node " + n.getNodeName() + ", continuing", ex);
            }
            if (c == null) {
                LOGGER.log(Level.WARNING, "Cannot create computer for node {0}, the {1}#createComputer() method returned null. Skipping this node", new Object[]{n.getNodeName(), n.getClass().getName()});
                return;
            }
            computers.put(n, c);
            if (!n.isHoldOffLaunchUntilSave() && automaticSlaveLaunch) {
                RetentionStrategy retentionStrategy = c.getRetentionStrategy();
                if (retentionStrategy != null) {
                    retentionStrategy.start(c);
                } else {
                    c.connect(true);
                }
            }
            used.add(c);
        } else {
            LOGGER.log(Level.WARNING, "Node {0} has no executors. Cannot update the Computer instance of it", n.getNodeName());
        }
    }

    void removeComputer(final Computer computer) {
        Queue.withLock(new Runnable(){

            @Override
            public void run() {
                Map<Node, Computer> computers = AbstractCIBase.this.getComputerMap();
                for (Map.Entry<Node, Computer> e : computers.entrySet()) {
                    if (e.getValue() != computer) continue;
                    computers.remove(e.getKey());
                    computer.onRemoved();
                    return;
                }
            }
        });
    }

    @CheckForNull
    Computer getComputer(Node n) {
        Map<Node, Computer> computers = this.getComputerMap();
        return computers.get(n);
    }

    protected void updateComputerList(final boolean automaticSlaveLaunch) {
        final Map<Node, Computer> computers = this.getComputerMap();
        final HashSet old = new HashSet(computers.size());
        Queue.withLock(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Computer> byName = new HashMap<String, Computer>();
                for (Computer c : computers.values()) {
                    old.add(c);
                    Node node = c.getNode();
                    if (node == null) continue;
                    byName.put(node.getNodeName(), c);
                }
                HashSet used = new HashSet(old.size());
                AbstractCIBase.this.updateComputer(AbstractCIBase.this, byName, used, automaticSlaveLaunch);
                for (Node s : AbstractCIBase.this.getNodes()) {
                    long start = System.currentTimeMillis();
                    AbstractCIBase.this.updateComputer(s, byName, used, automaticSlaveLaunch);
                    if (!LOG_STARTUP_PERFORMANCE || !LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine(String.format("Took %dms to update node %s", System.currentTimeMillis() - start, s.getNodeName()));
                }
                old.removeAll(used);
                for (Computer c : old) {
                    c.inflictMortalWound();
                }
            }
        });
        for (Computer c : old) {
            this.killComputer(c);
        }
        this.getQueue().scheduleMaintenance();
        for (ComputerListener cl : ComputerListener.all()) {
            try {
                cl.onConfigurationChange();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, null, t);
            }
        }
    }
}

